#ifndef HelpIncluded
#define HelpIncluded

#include <WW.h>

const HH=3;   // pass this to HLE Hilight to highlight first two chars
const HHH=7;  // pass this to HLE Hilight to highlight first three chars
const H_H=5;  // pass this to HLE Hilight to highlight first and third chars
const HHHHH=31;  // pass this to HLE Hilight to highlight first five chars

class HLE
  {
      int H;
      char* Text;
      void Disp(int X);
      friend class HelpLine;
    public:
      HLE(const char* Text,int Hilight=HH);
      ~HLE(){free(Text);}
  };

extern HLE F1_Help;          //  "F1-Help"       already established HLE's
extern HLE F2_Save;          //  "F2-Save"
extern HLE F2_SaveAndExit;   //  "F2-Save and exit"
extern HLE ESC_Exit;         //  "ESC-Exit"
extern HLE ESC_ExitNoSave;   //  "ESC-Exit (no save)"
extern HLE PlusMinus_Change; //  "+---Change" H_H
extern HLE F3_SelectionMenu; //  "F3-Selection Menu"
extern HLE AltP_Print;       //  "Alt-P-Print"
extern HLE AltP_PrintReport; //  "Alt-P-Print report"
extern HLE AltC_CopyFile;    //  "Alt-C-Copy file"
extern HLE AltC_CopyReportToAFile; // "Alt-C-Copy report to a file"

class HelpLine
  {
      HLE* H[14];  // each char represents an HLE
    public:
      HelpLine(HLE&);
      HelpLine(HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      HelpLine(HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&,HLE&);
      ~HelpLine();
      void Show() const;
  };

void InitHelpLine(RootWindow& W,VideoAtt TextAtt=UseDefaultAtt,
                  VideoAtt HilightAtt=UseDefaultAtt,int Line=25);

extern HelpLine RegularHL;
  //(F1_Help,F2_SaveAndExit,ESC_ExitNoSave);
extern HelpLine SelectHL;
  //(F1_Help,F2_SaveAndExit,PlusMinus_Change,F3_SelectionMenu,ESC_ExitNoSave);
extern HelpLine PlusMinusHL;
  //(F1_Help,F2_SaveAndExit,PlusMinus_Change,ESC_ExitNoSave);
extern HelpLine PrintReportHL;
  //(F1_Help,ESC_Exit,AltP_PrintReport,AltC_CopyReportToAFile);

class HelpLinePreserver
  {
      const HelpLine* OrigHL;
    public:
      HelpLinePreserver();
      ~HelpLinePreserver();
  };

#define PreserveHelpLine() HelpLinePreserver HelpLineVar

Bool HelpLineActivated(); // is the HelpLine stuff activated?

void ClearHelpLine();

#endif
