#ifndef WWEditIncluded
#define WWEditIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WBits.h>
#include <WStr.h>
#include <WFile.h>
#include <WLink.h>
#include <WWLowLev.h>
#include <WWHelp.h>
//#include <WWTools.h>

const NullKey       =  0;
const EscKey        =257;  const BackspaceKey  =270;
const TabKey        =271;  const EnterKey      =284;
const F1Key         =315;  const F2Key         =316;
const F3Key         =317;  const F4Key         =318;
const F5Key         =319;  const F6Key         =320;
const F7Key         =321;  const F8Key         =322;
const F9Key         =323;  const F10Key        =324;
const HomeKey       =327;  const ArrowUpKey    =328;
const PageUpKey     =329;  const ArrowLeftKey  =331;
const ArrowRightKey =333;  const EndKey        =335;
const ArrowDownKey  =336;  const PageDownKey   =337;
const InsKey        =338;  const DelKey        =339;

const CtrlDelKey       =403;  const ShiftEscKey      =457;
const CtrlEscKey       =458;  const ShiftBackspaceKey=459;
const CtrlBackspaceKey =460;  const ShiftTabKey      =461;
const FullStringExit   =462;  const CtrlHomeKey      =375;
const CtrlEndKey       =420;  const CtrlArrowRightKey=372;
const CtrlArrowLeftKey =371;  const CtrlArrowUpKey   =416;
const CtrlArrowDownKey =420;  const CtrlPageUpKey    =388;
const CtrlPageDownKey  =374;  const ShiftF3Key       =342;
const CtrlF3Key        =352;  const AltF3Key         =362;
const CtrlPlus1        =433;  const CtrlMinus1       =31;
const CtrlMinus2       =398;  const CtrlPlus2        =400;

const CtrlAKey= 1;  const CtrlBKey= 2;  const CtrlCKey= 3;
const CtrlDKey= 4;  const CtrlEKey= 5;  const CtrlFKey= 6;
const CtrlGKey= 7;  const CtrlHKey= 8;  const CtrlIKey= 9;
const CtrlJKey=10;  const CtrlKKey=11;  const CtrlLKey=12;
const CtrlMKey=13;  const CtrlNKey=14;  const CtrlOKey=15;
const CtrlPKey=16;  const CtrlQKey=17;  const CtrlRKey=18;
const CtrlSKey=19;  const CtrlTKey=20;  const CtrlUKey=21;
const CtrlVKey=22;  const CtrlWKey=23;  const CtrlXKey=24;
const CtrlYKey=25;  const CtrlZKey=26;

const AltAKey=286;  const AltBKey=304;  const AltCKey=302;
const AltDKey=288;  const AltEKey=274;  const AltFKey=289;
const AltGKey=290;  const AltHKey=291;  const AltIKey=279;
const AltJKey=292;  const AltKKey=293;  const AltLKey=294;
const AltMKey=306;  const AltNKey=305;  const AltOKey=280;
const AltPKey=281;  const AltQKey=272;  const AltRKey=275;
const AltSKey=287;  const AltTKey=276;  const AltUKey=278;
const AltVKey=303;  const AltWKey=273;  const AltXKey=301;
const AltYKey=277;  const AltZKey=300;

#ifdef UseMouse
  const LeftMouseButtonDown=463;
  const LeftMouseButtonUp=464;
  const RightMouseButtonDown=465;
  const RightMouseButtonUp=466;
#endif

class KeyType
  {
      int Code;  // 1..127 are ascii keystrokes, else special keys
      #ifdef UseMouse
        // with mouse comes event handler
        Word Status;    // 16 bits of booleans.  See "State" at end of this file
        Point M; // mouse pos
        Word Tick;  // each system may store a different time type here
        KeyType(const event& E);  // meta window event type
      #else
        KeyType(int ASCII,int Scan);
      #endif
      friend KeyType WaitForKeypress();
        // sit around and wait until a key's been pressed
        // will return the key that was pressed
      friend KeyType GetKey(); // returns next key in buf. NullKey if buf empty
      friend Bool KeyPressed(); //  True if key in buff
      #ifdef UseMouse
        friend void ExtractMouseButtons(KeyType& Key,Bool FromKeyPressed=No);
      #endif
      friend void EatAKey();
    public:
      KeyType(const KeyType &K);
      KeyType(int I);
      KeyType();
      void operator=(KeyType K);
      void operator=(int I); // clears all other variables
      void SetCode(int C){Code=C;} // will not change other variables
      Bool operator==(KeyType K);
      Bool operator==(int I);
      friend Bool operator==(int I, KeyType K);
      friend Bool operator!=(int I, KeyType K);
      Bool operator!=(KeyType K);
      Bool operator!=(int I);
      operator int(){return Code;}  // for switch/case statements
      #ifdef UseMouse
        Bool ShiftKey();
        Bool CtrlKey();
        Bool AltKey();
        Bool Mouse(); // is this key a mouse key?
        int MouseX(){return M.X();}
        int MouseY(){return M.Y();}
        Point MousePos(){return M;}
        Bool LeftMouseButtonDown();
        Bool RightMouseButtonDown();
        Bool BothMouseButtonsDown();
      #endif
  };

#ifdef UseMouse
  void WaitForMouseClear();
  void TestForWindowMove(KeyType& K,Bool FromKeyPressed=No);
#endif

typedef BitVector KeySetType;  // I might change this to a BitSet512 type

KeyType FilterKey(const KeySetType& KS);

/*
   State
              bit    meaning if set
                0    righthand shift key depressed
                1    lefthand shift key depressed
                2    control key depressed
                3    alt key depressed
                4    Scroll-lock active
                5    num-lock active
                6    caps-lock active
                7    insert active
                8    right mouse button depressed
                9    middle mouse button depressed
               10    left mouse button depressed
               11    (currently not used) (secondary key?)
               12    (currently not used)
               13    (currently not used)
               14    (currently not used)
               15    (currently not used)
         */

Bool ValidMaskToken(char MaskToken);
  // True if this is a valid Mask Token (see bottom of file)

String DefaultMask(int MaskLen);
  // returns a mask like "}#####".  Accepts any char cept the first char will never be a lower case letter

KeySetType TokenKeys(char MaskToken);
  // will return the acceptable keys for that token

void SetMask(char Token, String M);
  /* "M" will be interpretted into a KeySet.  All chars of the string will
  be put directly into the keyset except for periods.  A period represents
  a series, e.g. "A.F" is the same as "ABCDEF".  Two periods in a row will
  not represent a series, but will represent a period.  Series are
  considered in how they appear on the ASCII table.  " .~" represents all
  95 acceptable characters for a mask token */

/*

Mask stuff:

  There are 95 characters that are allowed in any of the edit routines.
  Their ascii values are 32 (for a space) to 126 (tilde).  With the mask
  stuff you can filter out unwanted keys from certain fields as they are
  typed.  126 bits will fit into 16 bytes.

  There are 20 mask tokens you may reference.  18 mask tokens are
  modifiable ("!#&*+/<=>?@[]^{|}~").  11 of them have preset KeySets
  ("!#&*+/<>@{}") that you shouldn't change.  7 you may change as you like
  ("=?[]^|~"). The two fixed mask tokens are '\0' and '\0xFF'.

  Table of possible characters:

     Token  chars

     '\0'   nothing (generally for internal use)
    '\0xFF' all 95 characters (generally for intrnal use)
      '#'   all 95 characters
      '<'   lower case letters only
      '>'   upper case letters only
      '{'   all characters EXCEPT upper case letters
      '}'   all characters EXCEPT lower case letters
      '!'   letters only
      '&'   numbers only
      '+'   numbers and spaces
      '@'   upper case letters and numbers
      '*'   valid file path characters
      '/'   same as above but without wild cards

*/

class ScreenForm;

class FormRec
  {
    public:
      LogicalWindow* W;
      VoidFuncPtr InFunc;  // in case user wants to massage data before entry
      BoolFuncPtr OutFunc; // func must return true if data okay
      int HelpNum;
      const HelpLine* HL;
      Bool EditField; // is this a field where "Activate()" has meaning?
      virtual void FEDShow()          =0 ;  // FED use only
      virtual void WriteOn(File& F)   =0 ;  // FED use only
      virtual Bool Modify()           =0 ;  // FED use only
      virtual FormRec& Ditto(Point P) =0 ;  // FED use only
      virtual void MoveTo(Point P)    =0 ;  // FED use only
      virtual Rect GridRect()         =0 ;  // FED use only
      virtual String Desc()           =0 ;  // FED use only
      virtual void AdjustDataPointer(void**) =0 ;  // used to move pointers to values passed on a parm list
      virtual void Restore() =0 ; // used in the edit routines when ESC pressed
      FormRec(LogicalWindow& PW);
      virtual ~FormRec(){}
      virtual int Size() =0 ; // for writing to a file
      virtual void Show() =0;
      virtual KeyType Activate() =0;   // only used for edit functions
      virtual Bool LocatedOnCell(Point P) =0 ;
  };

CreateLinkedListClass(PreScreenForm,FormRec);

class ScreenForm: public PreScreenForm
  {
      LogicalWindow* W;
      int CF; // the current field number
      KeyType OKey; // so that edit function "OutFunc"s can know
      KeySetType EKeys;
      void ReadFromDisk(const char* FileName,Word FormNum);
    public:
      ScreenForm(LogicalWindow& PW){CF=0; W=&PW;} // used to dynamically create a form
      ScreenForm(LogicalWindow&,const char* FileName,Word FormNum);// used by FED or non edit forms
      ScreenForm(LogicalWindow&,const char* FileName,Word FormNum,void* ...);
        // used to execute edit forms
      ~ScreenForm(); // deletes all objects in form
      void Show();
      KeyType Activate();
      void WriteOn(const char *FileName,Word FormNum);
        // write all this out to a Token file
      Bool PointOnObj(Point P);
        // "Cur()" holds the resulting topmost object at P.
        // Returns False if no object found at P
      Bool SelectObjectFromScreen();
      #ifdef FED
        void FEDDisplay();  // FED use only
        Bool CopyCur();     // FED use only
      #endif
      int HighParm();  // the number of extra parameters needed
      FormRec& Ref(int I){return operator[](I);}
      KeyType Key(){return OKey;}
      KeySetType& ExitKeys(){return EKeys;}
  };

class FixedTextRec: public FormRec
  {
    public:
      Point Pt;
      VideoAtt Att;
      char* Text;
      FixedTextRec(LogicalWindow&,File& F);
      FixedTextRec(LogicalWindow&,char* S,Point P,VideoAtt A=UseDefaultAtt);
      ~FixedTextRec();
      virtual void FEDShow()            ;  // FED use only
      virtual void WriteOn(File& F)     ;  // FED use only
      virtual Bool Modify()             ;  // FED use only
      virtual FormRec& Ditto(Point P)   ;  // FED use only
      virtual void MoveTo(Point P)      ;  // FED use only
      virtual Rect GridRect()           ;  // FED use only
      virtual String Desc()             ;  // FED use only
      virtual int Size()               ;  // FED use only
      virtual void AdjustDataPointer(void**) ;  // ScreenForm use only
      virtual Bool LocatedOnCell(Point P)    ;  // ScreenForm use only
      virtual void Restore()                 ;  // ScreenForm use only
      virtual void Show()                    ;
      virtual KeyType Activate()             ;
      Bool EditWindow(LogicalWindow& LW,String S);
      //friend class PassType;
      //friend class ScreenForm;
      //friend Bool CreateFixedTextRec(ScreenForm& SF);
  };

Bool CreateFixedTextRec(ScreenForm& SF);

class ColorBoxRec: public FormRec
  {
      Rect R;
      int Color;
      ColorBoxRec(LogicalWindow&,File& F);
      ColorBoxRec(LogicalWindow&,Rect GridR,int Color);
      ~ColorBoxRec();
      virtual void FEDShow()                 ;  // FED use only
      virtual void WriteOn(File& F)          ;  // FED use only
      virtual Bool Modify()                  ;  // FED use only
      virtual FormRec& Ditto(Point P)        ;  // FED use only
      virtual void MoveTo(Point P)           ;  // FED use only
      virtual Rect GridRect()                ;  // FED use only
      virtual String Desc()                  ;  // FED use only
      virtual int Size()                    ;  // FED use only
      virtual void AdjustDataPointer(void**) ;  // ScreenForm use only
      virtual Bool LocatedOnCell(Point P)    ;  // ScreenForm use only
      virtual void Restore()                 ;  // ScreenForm use only
      virtual void Show()                    ;
      virtual KeyType Activate()             ;
      Bool EditWindow(LogicalWindow&,String);
      friend class ScreenForm;
      friend Bool CreateColorBoxRec(ScreenForm& SF);
  };

const int NoHelp=0;

class EditRec: public FormRec
  {
      Point Pt;  // where on the screen editing will be (in grid coords)
      BitSet16 Toggles;  // see "Toggles" at end of file
      VideoAtt LiveAtt,DeadAtt,NeutralAtt,CursorAtt;
      KeySetType KeySet;
      int CPos; // Cursor Position: where the cursor currently is on this object
      int Parm;  // See "Parm" at the bottom of this file
      int Offset;  // the offset from where Parm points to
      //KeyType OutKey;  // used for OutFunc
      #ifdef UseGraphics
        int TickMarkSpacing;
      #endif
      void InternalInit(int Pm,int Of);
      EditRec(LogicalWindow&,Point P,int Pm=0,int Of=0); // from FED
      EditRec(LogicalWindow&,File&,const KeySetType&);     // from file
      virtual void FEDShow()                 =0;  // FED use only
      virtual void WriteOn(File& F)          =0;  // FED use only
      virtual Bool Modify()                  =0;  // FED use only
      virtual FormRec& Ditto(Point P)        =0;  // FED use only
      virtual void MoveTo(Point P)           =0;  // FED use only
      virtual Rect GridRect()                =0;  // FED use only
      virtual String Desc()                  =0;  // FED use only
      virtual int Size()                    =0;  // FED use only
      virtual void AdjustDataPointer(void**) =0;  // ScreenForm use only
      virtual Bool LocatedOnCell(Point P)    =0;  // ScreenForm use only
      virtual void Restore()                 =0;  // ScreenForm use only
      virtual void Show()                    =0;
      virtual KeyType Activate()             =0;
      Bool AutoClearMode(){return Toggles(0);}
      Bool HomeCPosMode (){return Toggles(2);}
      Bool InsertMode   (){return Toggles(4);}
      friend class EditStringRec;
      friend class ActiveEditString;
      friend class EditNumRec;
      friend class ActiveEditNum;
      friend class EditSelectRec;
      friend class ScreenForm;
    public:
      void SetAutoClearMode(Bool OnOrOff=On);
      void SetHomeCPosMode (Bool OnOrOff=On);
      void SetInsertMode   (Bool OnOrOff=On);
      void AddExitKeys(const KeySetType& KS){KeySet|=KS;}
      void AddExitKey(Word K){KeySet[K]=On;}
      void SetCPos(int X) {CPos=X;}
      void AddEntranceFunction(VoidFuncPtr FP){InFunc=FP;}
      void AddExitFunction(BoolFuncPtr FP){OutFunc=FP;}
      void AddHelpLine(const HelpLine& H){HL=&H;}
      void AddHelpLine(const HelpLine* H){HL=H;}
  };

class EditStringRec: public EditRec
  {
      String* ZZZ;  // where in memory the string is stored
      String OrigZ;  // what Z was when this record was created
      String Mask;
      int MaxLen;      // max length that the string can get
      EditStringRec(LogicalWindow&,File& F,const KeySetType&);
      EditStringRec(LogicalWindow&,int Parm, int ParmOffset, int FieldLen,
          Point P); // FED use only
      virtual void FEDShow()                 ;  // FED use only
      virtual void WriteOn(File& F)          ;  // FED use only
      virtual Bool Modify()                  ;  // FED use only
      virtual FormRec& Ditto(Point P)        ;  // FED use only
      virtual void MoveTo(Point P)           ;  // FED use only
      virtual Rect GridRect()                ;  // FED use only
      virtual String Desc()                  ;  // FED use only
      virtual int Size()                    ;  // FED use only
      virtual void AdjustDataPointer(void**) ;  // ScreenForm use only
      virtual Bool LocatedOnCell(Point P)    ;  // ScreenForm use only
      virtual void Restore()                 ;  // ScreenForm use only
      String CurZ(); // what is currently stored in mem according to the AP
      void SetZ(const String& NewZ);  // set the AP's copy to NewZ
      Bool CharStarMode() {return Toggles(10);}
      Bool PassMode()     {return Toggles( 9);}
      #ifdef UseGraphics
        void DrawTicks(int I,int Len);
      #endif
      void Disp(const String& Z,Bool SkipMask=No, Bool Live=No);
      Bool EditWindow(LogicalWindow& LW,String S);
      void PreserveOrig();
      friend class ScreenForm;
      friend class ActiveEditString;
      friend Bool CreateEditStringRec(ScreenForm& SF);
    public:
      EditStringRec(LogicalWindow&,String& Str, int FieldLen, Point P);
      EditStringRec(LogicalWindow&,char* Str, int FieldLen, Point P);
      EditStringRec(LogicalWindow&,String& Str, const char* Mask, Point P);
      EditStringRec(LogicalWindow&,char* Str, const char* Mask, Point P);
      ~EditStringRec(){}
      virtual void Show()                    ;
      virtual KeyType Activate()             ;
      void SetPassMode     (Bool OnOrOff=On){Toggles[ 9]=OnOrOff;}
      void SetCharStarMode (Bool OnOrOff=On){Toggles[10]=OnOrOff;}
  };

class EditNumRec: public EditRec
  {
      void* Num;  // pointer to location in memory where number is stored
      Byte OrigNum[sizeof(double)];  // storage for value on entry
      Byte LastNum[sizeof(double)];  // storage for value on last exit
      String S; // string representation of number
        // may have leading spaces. Will have a '+' or '-' on end if negs allowed
      int ILen;  // the length of the integral part of the field
      int DLen;  // the length of the decimal part of the field
      Byte NumType;  // see NumType at bottom of file

      EditNumRec(LogicalWindow&,File& F,const KeySetType&);
      EditNumRec(LogicalWindow&,int Parm, int ParmOffset,
          Point P,int NumType=2, int IFL=4,int DFL=0); // FED use only
      virtual void FEDShow()                 ;  // FED use only
      virtual void WriteOn(File& F)          ;  // FED use only
      virtual Bool Modify()                  ;  // FED use only
      virtual FormRec& Ditto(Point P)        ;  // FED use only
      virtual void MoveTo(Point P)           ;  // FED use only
      virtual Rect GridRect()                ;  // FED use only
      virtual String Desc()                  ;  // FED use only
      virtual int Size()                    ;  // FED use only
      virtual void AdjustDataPointer(void**) ;  // ScreenForm use only
      virtual Bool LocatedOnCell(Point P)    ;  // ScreenForm use only
      virtual void Restore()                 ;  // ScreenForm use only
      int NumSize(){return (NumType&63);}  // bits 0 to 5
      Bool NegativesAllowed(){return ((NumType&Bit7)>0);}
      Bool NumIsReal(){return ((NumType&Bit6)>0);}
      int TotLen(); // the field len including the decimal point
      void Disp(const String& Z, Bool Live=No);
      Bool EditWindow(LogicalWindow& LW,String S);
      void PreserveOrig();
      void ConvertStringToNum();
      void ConvertNumToString();
      void Init(int IL, int DL, void* N, Byte NT);
      friend class ScreenForm;
      friend class ActiveEditNum;
      friend Bool CreateEditNumRec(ScreenForm& SF);
    public:
      EditNumRec(LogicalWindow&,Byte&,  Point,int IntLen=2,  int DecLen=0);
      EditNumRec(LogicalWindow&,SByte&,Point,int IntLen=2, int DecLen=0);
      EditNumRec(LogicalWindow&,Word&,  Point,int IntLen=4,  int DecLen=0);
      EditNumRec(LogicalWindow&,SWord&, Point,int IntLen=4,  int DecLen=0);
      EditNumRec(LogicalWindow&,int&,   Point,int IntLen=4,  int DecLen=0);
      EditNumRec(LogicalWindow&,UInt&,  Point,int IntLen=4,  int DecLen=0);
      EditNumRec(LogicalWindow&,Long&,  Point,int IntLen=9,  int DecLen=0);
      EditNumRec(LogicalWindow&,SLong&, Point,int IntLen=9,  int DecLen=0);
      EditNumRec(LogicalWindow&,float&, Point,int IntLen=10, int DecLen=0);
      EditNumRec(LogicalWindow&,double&,Point,int IntLen=10, int DecLen=0);
      ~EditNumRec(){}
      virtual void Show()                    ;
      virtual KeyType Activate()             ;
      void SetIncDecMode    (Bool OnOrOff=On){Toggles[8]=OnOrOff;}
      void SetAllowNegatives(Bool OnOrOff=On);
  };

class EditSelectRec: public EditRec
  {
      int* ZZZ;  // where in memory the selection index is stored
      int OrigZ;  // what Z was when this record was created
      char** S;  // not a local copy!
      int FLen;  // Field length
      const char* T;
      virtual void FEDShow()                 ;  // FED use only
      virtual void WriteOn(File& F)          ;  // FED use only
      virtual Bool Modify()                  ;  // FED use only
      virtual FormRec& Ditto(Point P)        ;  // FED use only
      virtual void MoveTo(Point P)           ;  // FED use only
      virtual Rect GridRect()                ;  // FED use only
      virtual String Desc()                  ;  // FED use only
      virtual int Size()                     ;  // FED use only
      virtual void AdjustDataPointer(void**) ;  // ScreenForm use only
      virtual Bool LocatedOnCell(Point P)    ;  // ScreenForm use only
      virtual void Restore()                 ;  // ScreenForm use only
      void Disp(Bool Live=No);
      void PreserveOrig();
      friend class ScreenForm;
    public:
      EditSelectRec(LogicalWindow&,int& Index,char** Selections,
                    int FieldLen, Point P,const char* Title=NULL);
      ~EditSelectRec(){}
      virtual void Show()                    ;
      virtual KeyType Activate()             ;
      char* CurSel(){return S[*ZZZ];}
      const char* Title(){return T;}
      void RePoint(char** Sel){S=Sel;}
        // if the list is changed...
      void SetZ(int NewZ){*ZZZ=NewZ;}
  };

/*

Parm:

  A number that tells which parameter, of the optional parameters, that
  will have a pointer that can be used to refer to a chunk of memory to be
  used in a ScreenForm.  This would be used only if a ScreenForm were
  created and then accessed with the proper call.  This must always be used
  for those ScreenForms that are stored on disk.  Most ScreenForms that are
  generated in memory don't use this feature.  0 means that this feature
  isn't used.

*/

/*
class ParmTextRec: public FormRec
  {
      Point Pt;
      VideoAtt Att;
      int     Parm;
      int     Offset;
    public:
      ParmTextRec(){}
      ParmTextRec(TokenFile &F){}
      int Size(){return 7;}
      void Show(LogicalWindow &W){}
      void FEDShow(){}
      //Bool LocatedOnCell(int X, int Y){X+=Y; return False;}
      Bool LocatedOnCell(Point P){P=P; return False;}
      Bool Modify(){return False;}
      void WriteOn(TokenFile &F);
      String Desc();
  };

class ColorBoxRec: public FormRec
  {
      Rect R; // stored in grid cell coords
      VideoAtt     Att;
    public:
      ColorBoxRec(){}
      ColorBoxRec(TokenFile &F){}
      int Size(){return 6;}
      void Show(LogicalWindow &W){}
      void FEDShow(){}
      //Bool LocatedOnCell(int X, int Y){X+=Y; return False;}
      Bool LocatedOnCell(Point P){P=P; return False;}
      Bool Modify(){return False;}
      void WriteOn(TokenFile &F);
      String Desc();
  };

class DrawBoxRec: public FormRec
  {
      Rect R; // stored in grid cell coords
      VideoAtt Att;
    public:
      DrawBoxRec(){}
      DrawBoxRec(TokenFile &F){}
      int Size() {return 6;}
      void Show(LogicalWindow &W){}
      void FEDShow(){}
      //Bool LocatedOnCell(int X, int Y){X+=Y; return False;}
      Bool LocatedOnCell(Point P){P=P; return False;}
      Bool Modify(){return False;}
      void WriteOn(TokenFile &F);
      String Desc();
  };
*/
/*  The codes are stored as bytes.
       If bit 7 is set, the record is an edit record.
       Bits 0 though 6 are for storing a unique value.        */

const Byte ParmTextCode   = 0;
const Byte FixedTextCode  = 1;
const Byte ColorBoxCode   = 2;
const Byte DrawBoxCode    = 3;
const Byte EditStringCode = Bit7+0;
const Byte EditNumCode    = Bit7+1;

Bool MoveObject(FormRec& F,Point ClickPos);
void DrawGridRect(Rect R);

// for internal use...

#define MacroToMoveParmsToFields                                \
  {                                                             \
    int I;                                                      \
    int HP=SF.HighParm();                                       \
    void* Pointers[100];                                        \
    Pointers[0]=Parm0;                                          \
    if (HP>1)                                                   \
      {                                                         \
        va_list Args;                                           \
        va_start(Args,Parm0);                                   \
        for(I=1;I<HP;I++) Pointers[I]=va_arg(Args,void*);       \
        va_end(Args);                                           \
      }                                                         \
    For(I,SF.Size()) SF.Next().AdjustDataPointer(Pointers);     \
  }

#endif
