#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

void LogicalWindow::DrawBeveledRect(Rect &R,VideoAtt A,Bool UpDown)
    /* R is in local device coords and represents where the outermost edge
    of the rectangle will be drawn.  On exit, R will be the value of the
    rect just inside the border.  To clear that rect, call Fill(R); */
  {
    if (A==UseDefaultAtt) A=Att();
    #ifdef UseGraphics
      PreserveMouseHideStatus(Off);
      PreservePenState();
      if (RootWin().FullColor())
        {
          int TopColor, BottomColor;
          GetColors(A,TopColor,BottomColor);
          if (UpDown==Down)
            {
              int Temp=TopColor;
              TopColor=BottomColor;
              BottomColor=Temp;
            }
          PenColor(TopColor);
          DrawLine(R.BottomLeft(),R.TopLeft());
          DrawLineTo(R.TopRight());
          R.Shrink();
          DrawLine(R.BottomLeft(),R.TopLeft());
          DrawLineTo(R.TopRight());
          R.Adjust(0,0,1,1);  //  move the whole rect to the right one and down 1
          PenColor(BottomColor);
          DrawLine(R.BottomLeft(),R.BottomRight());
          DrawLineTo(R.TopRight());
          R.Shrink();
          DrawLine(R.BottomLeft(),R.BottomRight());
          DrawLineTo(R.TopRight());
          R.Adjust(0,0,-1,-1);
        }
      else
        {
          PenColor(0);
          Draw(R);
          R.Shrink();
          PenColor(1);
          Draw(R);
          R.Shrink();
        }
    #else
      DrawBox(R,A);
      R.Shrink(1);
      UpDown=UpDown; // xxx gets rid of BC++ warning message.
    #endif
  }

//.parse

void WindowRec::Init(LogicalWindow &LW, int X, int Y, int Wide, int High,
    VideoAtt Att,const char *Title)
  {
    DefAtt=NULL;
    Closed=False;
    Visible=False;
    Drawn=False;
    MyImage=NULL;
    if ((Title!=NULL)&&(Title[0]!=0))
      {
        int TLen=strlen(Title);
        TitleStr=new char[TLen+1];
        strcpy(TitleStr,Title);
        Wide=Max(Wide,TLen+2);
        High+=2;
      }
    else TitleStr=NULL;
    #ifdef UseGraphics
      GCW=LW.GCW;
      GCH=LW.GCH;
      Font=LW.Font;
    #endif
    Root=LW.Root;
    Parent=&LW;
    Root->Touch();
    #ifdef UseGraphics
      PreDispClear=LW.PreDispClear;
    #endif
    if ( (TitleStr) && (strlen(TitleStr)+1>Wide) ) TitleStr[Wide-1]=0;
    if (High>=Root->High()) High=Root->High()-2;
    LogicalWindow NLW(LW,X,Y,Wide,High);
    WR=NLW.WR;
    TCP=NLW.TCP;
    BR=WR;
    #ifdef UseGraphics
      const SwellVal=4;
    #else
      const SwellVal=1;
    #endif
    BR.Swell(SwellVal);
    AlignWinBoundry(BR,Root->WR);
    WR=BR;
    WR.Shrink(SwellVal);
    if (TitleStr)
      {
        // shift the working window to under the title
        #ifdef UseGraphics
          int Adj=GridCellHigh()*2;
        #else
          int Adj=2;
        #endif
        WR.Adjust(0,Adj,0,-Adj);
      }
    IsAWindow=True;
    Parent->Children.Add(this);
    #ifdef UseGraphics
      PreDispClear=False;
    #endif
    if (Att) WAtt=Att;
    else WAtt=NLW.WAtt;
  }

//.parse

WindowRec::WindowRec(LogicalWindow &LW, int X, int Y, int Wide, int High,
    VideoAtt Att,const char* Title):LogicalWindow()
  {
    Init(LW,X,Y,Wide,High,Att,Title);
  }

//.parse

Window::Window(LogicalWindow &LW, int X, int Y, int Wide, int High,
    VideoAtt Att,const char* Title):WindowRec(LW,X,Y,Wide,High,Att,Title)
  {
    Show();
  }

//.parse

LinkedList* WinList=NULL;

void RemoveWinFromList(WindowRec* W)
  {
    if (WinList!=NULL)
      {
        if (WinList->Size())
          {
            WinList->Last();
            while ((WinList->Cur()!=W) && (WinList->Num()!=0)) WinList->Prev();
            if (WinList->Cur()==W) WinList->DelCur();
          }
      }
  }

void AddWinToList(WindowRec* W)
  {
    if (WinList==NULL) WinList=new LinkedList;
    else if (WinList->Size()>0)  // kill current copy if it exists
      {
        WinList->Root();
        while ((WinList->Cur()!=W) && (WinList->Num()!=WinList->Top())) WinList->Next();
        if (WinList->Cur()==W) WinList->DelCur();
      }
    WinList->Append(W);
  }

//.parse

void WindowRec::Close()
  {
    if (!Closed)
      {
        if ((!Visible)&&(MyImage!=NULL))
          {
            ((ScreenImage*)MyImage)->ThrowAway();
            delete((ScreenImage*)MyImage);
          }
        else if (Drawn)
          {
            delete((ScreenImage*)UnderImage);
            Drawn=False;
            Visible=False;
          }
        if (TitleStr) delete TitleStr;
        RemoveWinFromList(this);
        Closed=True;
      }
  }

//.parse

void WindowRec::Hide()
  {
    if (Visible)
      {
        Root->Touch();
        Rect R=BR;
        #ifdef UseMouse
          PreserveMouseHideStatus(Off);
        #endif
        RemoveWinFromList(this);
        MyImage=new ScreenImage(*Root,R);
        delete((ScreenImage*)UnderImage);
        UnderImage=NULL;
        Visible=False;
      }
  }

//.parse

void WindowRec::Show()
  {
    if (!Visible)
      {
        AddWinToList(this);
        Root->Touch();
        Rect R=BR;
        UnderImage=new ScreenImage(*Root,R);
        if (Drawn)
          {
            if (MyImage!=NULL)
              {
                ((ScreenImage*)MyImage)->Restore(BR);
                delete ((ScreenImage*)MyImage);
                MyImage=NULL;
              }
          }
        else
          {
            Root->DrawBeveledRect(R,WAtt);
            #ifdef UseGraphics
              BackColor(WAtt.Background());
            #endif
            #ifdef UseMouse
              PreserveMouseHideStatus(Off);
            #endif
            Root->ColorBox(R,WAtt);
            if (TitleStr!=NULL)
              {
                #ifdef UseGraphics
                  LogicalWindow TitleWin(*this,1,-1,Wide(),2);
                  TitleWin.Display(TitleStr,Center,Center);
                  Rect TitleRect=Rect(0,0,TitleWin.DeviceWide(),GridCellHigh());
                  TitleRect.Adjust(GridCellWide()/2,GridCellHigh()/2,-GridCellWide());
                  TitleRect.Swell(3);
                  PenColor(ForeColor(WAtt));
                  TitleWin.Draw(TitleRect);
                #else
                  Display(TitleStr,Center,-1);
                  DrawLine(1,0,Wide(),0);
                  Display("\x0c3",0,0);
                  Display("\x0b4",Wide()+1,0);
                #endif
              }
            Drawn=True;
          }
        Visible=True;
      }
  }

#ifdef UseGraphics
  void LogicalWindow::AdjustLogicalWindowCoords(Point P)
    {
      int I;
      For (I,Children.Size())
        {
          LogicalWindow* W=(LogicalWindow*)Children.Next();
          if (!(W->IsAWindow)) W->AdjustLogicalWindowCoords(P);
        }
      WR.Adjust(P.X(),P.Y());
    }

  void WindowRec::AdjustWindowCoords(Point P)
    // this Window & all offspring non-Window LogicalWindows are shifted by P
    {
      BR.Adjust(P.X(),P.Y());
      AdjustLogicalWindowCoords(P);
    }

  // called by the keyboard stuff only
  void TestForWindowMove(KeyType& K,Bool FromKeyPressed)
    {
      if (K==LeftMouseButtonDown && !(K.RightMouseButtonDown()) && (WinList!=NULL) && WinList->Size())
        {
          Window& W=*(Window*)WinList->Last();
          W.Touch();
          if ( W.Vis()
               && (PointOnRect(K.MousePos(),W.DeviceBRectA()))
               && (!(PointOnRect(K.MousePos(),W.DeviceRectA()))))
            {
              PreserveMouseHideStatus(Off);
              W.Hide();
              PreservePenState();
              PenMode(2);
              PenColor(White);
              Rect R=W.DeviceBRectA();
              LimitMouse(0,0,W.RootWin().DeviceRectA().Wide()-R.Wide(),
                             W.RootWin().DeviceRectA().High()-R.High());
              int MXDif=K.MousePos().X()-R.X();
              int MYDif=K.MousePos().Y()-R.Y();
              Point P=R;
              MoveCursor(P.X(),P.Y());
              CurVideoDevice->Draw(R);
              Point LastPos=R;
              if (FromKeyPressed) EatAKey();
              Bool Done=False;
              while (!Done)
                {
                  if (GetKey()==LeftMouseButtonUp) Done=True;
                  else
                    {
                      Point NewPos=CurVideoDevice->DeviceMousePos();
                      if (LastPos!=NewPos)
                        {
                          CurVideoDevice->Draw(R);
                          R=NewPos;
                          CurVideoDevice->Draw(R);
                          LastPos=NewPos;
                        }
                    }
                }
              CurVideoDevice->Draw(R);
              PenMode(0);
              W.AdjustWindowCoords(Point(R)-P);
              P=R;
              P.Adjust(MXDif,MYDif);
              MoveCursor(P.X(),P.Y());
              W.Show();
              K=NullKey;
              LimitMouse(0,0,W.RootWin().DeviceRectA().Wide(),
                             W.RootWin().DeviceRectA().High());
            }
        }
    }

#endif

//.parse

#ifdef MSC
  #define OutPort outpw
#else
  #define OutPort outport
#endif

char* ClientName=NULL;

RootWindow* VideoDevice1=NULL;
RootWindow* VideoDevice2=NULL;
RootWindow* CurVideoDevice=NULL;
#ifdef UseMouse
  RootWindow* CurMouseVideoDevice=NULL;
#endif
#ifdef UseGraphics

  int GrafixCard;
  int CommPort;
  fontRec* PrimaryFont;
  fontRec* SecondaryFont;

#else

  int TextVideoMode()
    {
      Registers Regs;
      Regs.AH()=0x0f;
      CallBIOS(0x10,Regs);
      int M=int(Regs.AL());
      if (M==2) M=3;  // 2 is a mode similar to 3 - treat as the same
      if (!((M==ColorTextMode)||(M==MonoTextMode))) M=BIOSTextMode;
      return(M);
    }

#endif

#ifndef UseGraphics

  Byte* OrigScreen1=NULL;
  Point OrigCursorPos1;
  //static Byte* OrigScreen2=NULL;
  //static Point OrigCursorPos2;

#endif

//.parse

void RootWindow::SlapScreen(const void* X)
  {
    memcpy(ScreenMemory,X,4000);
  }

//.parse

ScreenPreserver::ScreenPreserver()
  {
    RW=CurVideoDevice;
    Storage=malloc(4000);
    memcpy(Storage,RW->ScreenMemoryPos(),4000);
  }

ScreenPreserver::~ScreenPreserver()
  {
    memcpy(RW->ScreenMemoryPos(),Storage,4000);
    free(Storage);
  }

//.parse

void RootWindow::VideoInit(int ScreenType,VideoAtt Att)
  {
    BlinkOn=True;
    Running=True;
    TCP=Point(1,1);
    Root=this;
    Parent=this;
    if (VideoDevice1==NULL)
      {
        VideoDevice1=this;
        VideoDevice2=this;
        if (Att) WAtt=Att;
        else WAtt=VAtt(Black,Gray);
        #ifdef UseGraphics
          static char* Dummy[1]={"Questions?  Call Paul Wheaton at 543-1928"};
          int Status;
          if (ScreenType == AutoDetect)
            {
              MetQuery(1,Dummy);   // video card type & mouse?
              Status=InitGrafix(-GrafixCard);
              VideoType=GrafixCard;
            }
          else
            {
              Status=InitGrafix(-ScreenType);
              VideoType=ScreenType;
              CommPort=32;
            }
          if (Status!=0) FatalError("cannot init video");
          int C=QueryColors();
          if (C==15) VideoMode=0; // 16 colors
          else if (C==1) VideoMode=2; //  2 colors
          else FatalError("unsupported video");
          // this is where text mode will be decided on.  Some day.
          SetDisplay(GrafPg0);
          if (Att) WAtt=Att;
          else
            {
              if (FullColor()) WAtt=VAtt(Black,Gray);
              else WAtt=VAtt(0,1);
            }
          BackColor(BColor(WAtt));
          PenColor(FColor(WAtt));
          rect r;
          ScreenRect(&r);
          WR=r;
          GetPort(&P);
          Fill(WR);  // calls Touch()
          InitMouse(CommPort);
          LimitMouse(0,0,WR.Right(),WR.Bottom());
          MoveCursor (100,100);
          TrackCursor(True);
          Word FontToken;
          if (VideoType==ATI1024x768F)     FontToken=926;
          else if (WR==Rect(0,0,1024,768)) FontToken=924;
          else if (WR==Rect(0,0,800,600))  FontToken=923;
          else if (WR==Rect(0,0,640,480))  FontToken=922;
          else if (WR==Rect(0,0,720,348))  FontToken=925;
          else     /* 640x350 */           FontToken=921;
          if((PrimaryFont=FontAlloc(FontToken))==NULL)
              FatalError("not enough mem to load font");
          SecondaryFont=PrimaryFont;
          QueryError();              // clear error code
          Font=PrimaryFont;
          SetFont(Font);
          GCW=Font->chWidth;
          GCH=Font->chHeight;
          EventQueue(On);
          TextAlign(alignLeft,alignTop);
          static short Map[]={0,0,6,6,0,0,6,6};
          CursorMap(Map);
          Touch();
          Mouse();
        #else
          TextModeCursorOff();
          WR=Rect(1,1,80,25);
          if (ScreenType==AutoDetect) VideoType=TextVideoMode();
          else VideoType=ScreenType;
          VideoMode=1; // color text
          if (VideoType==ColorTextMode) Screen1=ScreenPtrType(0xB8000000L);
          else if (VideoType==MonoTextMode)
            {
              Screen1=ScreenPtrType(0xB0000000L);
              VideoMode=3;
            }
          else Screen1=ScreenPtrType(0);
          Screen2=Screen1;
          ScreenMemory=(Byte*)(Screen1);
          OrigScreen1=new Byte[4000];
          memcpy(OrigScreen1,ScreenMemory,4000);
          Registers Regs;
          Regs.AH()=3;
          Regs.BH()=0;
          CallBIOS(0x10,Regs);
          OrigCursorPos1.SetY(Regs.DH());
          OrigCursorPos1.SetX(Regs.DL());
          Paint(Rect(1,1,80,25),Att);
          BlinkAtt(Off);
        #endif
      }
    else
      {
        #ifdef UseGraphics
          // At this time, the secondary device must be a hercules card
          P=new metaPort;
          InitPort(P);
          bitmap* B=new bitmap;
          B->devClass=24;
          B->devType=0;
          B->rowBytes=90;
          B->pixWidth=720;
          B->pixHeight=348;
          B->pixResX=90;
          B->pixResY=64;
          B->pixBits=1;
          B->pixPlanes=1;
          char** RT=(char**)new long[348]; // there are 348 lines on a herc card.  A pointer for each line
          RT[0]=(char*)0xB0000000L;
          B->mapTable[0]=(map*)RT;
          InitRowTable(B,4,0,0x2000);
          PortBitmap(B);
          outp(0x3BF,0x03);
          outp(0x3B8,0x22);
          static short herc[16]=
            { 0x3500, 0x2d01, 0x2e02, 0x0703, 0x5b04, 0x0205, 0x5706, 0x5707,
              0x0208, 0x0309, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f };
          int i;
          For(i,16) OutPort(0x3b4,herc[i]);
          outp(0x3b8,0x2a);
          PortSize(B->pixWidth,B->pixHeight);
          rect HercRect;
          SetRect(&HercRect,0,0,719,347);
          ClipRect(&HercRect);
          VideoDevice2=this;
          VideoMode=2;
          WAtt=VAtt(0,1);
          BackColor(1);
          PenColor(0);
          rect r;
          ScreenRect(&r);
          WR=r;
          Fill(WR);
          LimitMouse(0,0,WR.Right(),WR.Bottom());
          MoveCursor (100,100);
          if((Font=FontAlloc(925))==NULL) FatalError("not enough mem to load herc font");
          SetFont(Font);
          GCW=Font->chWidth;
          GCH=Font->chHeight;
          TextAlign(alignLeft,alignTop);
          Touch();
          Mouse();
        #else
          if (ScreenType==AutoDetect) VideoType=TextVideoMode();
          else VideoType=ScreenType;
          VideoMode=5;
          if ((VideoType==ColorTextMode)||(VideoType==MonoTextMode))
            {
              Screen2=ScreenPtrType(0xB0000000L);
            }
          else Screen2=ScreenPtrType(0);
          ScreenMemory=(Byte*)Screen2;
          Touch();
          Clear();
        #endif
      }
  }

//.parse

void RootWindow::ShutDown()
  {
    if (Running)
      {
        Running=False;
        #ifdef UseMouse
          StopEvent();
          StopMouse();
        #endif
        #ifdef UseGraphics
          SetDisplay(TextPg0);
          ClearText();
        #else
          memcpy(ScreenMemory,OrigScreen1,4000);
          Registers Regs;
          Regs.AH()=2;
          Regs.BH()=0;
          Regs.DH()=OrigCursorPos1.Y();
          Regs.DL()=OrigCursorPos1.X();
          CallBIOS(0x10,Regs);
          TextModeCursorOn(True);
        #endif
      }
  }

#ifdef UseGraphics
void RootWindow::Restart()
  {
    if (!Running)
      {
        Running=True;
        if (InitGrafix(-VideoType)) FatalError("cannot re-init video");
        SetDisplay(GrafPg0);
        BackColor(WAtt.Background());
        PenColor(WAtt.Foreground());
        rect r;
        ScreenRect(&r);
        WR=r;
        Fill(WR);
        InitMouse(CommPort);
        LimitMouse(0,0,WR.Right(),WR.Bottom());
        MoveCursor (100,100);
        TrackCursor(True);
        SetFont(Font);
        EventQueue(On);
        TextAlign(alignLeft,alignTop);
        static int Map[]={0,0,6,6,0,0,6,6};
        CursorMap(Map);
      }
  }
#endif

//.parse

void RootWindow::Touch()
  {
    #ifdef UseGraphics
      SetPort(P);
    #endif
    CurVideoDevice=this;
  }

#ifdef UseMouse
  void RootWindow::Mouse()
    {
      CursorBitmap(P->portBMap);
      CurMouseVideoDevice=this;
    }
#endif

//.parse

BootRecType BootRec;

//.parse

RootWindow::RootWindow(DefaultAttRec& DA2)
  {
    DefAtt=&DA2;
    VideoInit(BootRec.Device2Num,BootRec.D2Att.Normal);
  }

//.parse

RootWindow::RootWindow(int ScreenType,VideoAtt Att)
  {
    ClientName=BootRec.ClientName;
    strcpy(ClientName,"test copy");
    VideoInit(ScreenType,Att);
    if (VideoDevice1!=VideoDevice2)
      {
        DefAtt=&BootRec.D2Att;
      }
    else
      {
        DefAtt=&BootRec.DAtt;
      }
    DefAtt->Normal=WAtt;
    if (FullColor())
      {
        DefAtt->Panic=VAtt(White,Red);
        DefAtt->Menu=VAtt(Black,Gray);
        DefAtt->Dialog=VAtt(White,BlueGreen);
        DefAtt->LiveEdit=NoBlink(VAtt(White,LtBlue));
        DefAtt->DeadEdit=VAtt(White,Blue);
        DefAtt->NeutralEdit=NoBlink(VAtt(Black,LtBlue));
        DefAtt->EditCursor=VAtt(Black,White);
      }
    else
      {
        DefAtt->Panic=1;
        DefAtt->Menu=1;
        DefAtt->Dialog=1;
        DefAtt->LiveEdit=0x10;
        DefAtt->DeadEdit=1;
        DefAtt->NeutralEdit=1;
        DefAtt->EditCursor=1;
      }
  }

//.parse

#ifdef Graphics
  penState WWPenState;
#endif

void FatalError(const char* Str)
  {
    if (VideoDevice1) VideoDevice1->ShutDown(); //  Goes to text mode
    puts("\nWW Fatal Error Encountered:  \""+String(Str)+"\"");
    exit(-1);
  }

//.parse

#pragma warn -stv

#ifdef UseGraphics

/*

Features to add:

  set the environment (or WW.DAT) with limits on how much memory may be
  eaten.

  if there isn't enough memory, check to see if there's another window's
  image that can be written to disk instead. This way, local window popping
  will be fast and there will be one slow pop when done.

    Make a function that will flush either all buffers to disk, or try to
    forfeit a certain amount of heap memory.

  set the environment (or WW.WW) with primary (ram drive) and secondary
  (big drive) disk storage devices.

  add ability to use EMS and high video memory

Note that in text mode it will either go into the heap or onto the disk.
There will be no linked list of fragmented pieces.

*/

static Rect AdjustedRect(void* Ptr,Point OP)
  {
    rect r;
    memcpy(&r,Ptr,sizeof(r));
    Rect R=r;
    R.Adjust(OP.X(),OP.Y());
    return R;
  }

const RSize=8;  // sizeof(rect);  choking in MSC ???

static long RectReduce(rect& R)
  {
    R.Ymax-=((R.Ymax-R.Ymin)/3);
    return (ImageSize(&R)+RSize);
  }

static void EmptyList(LinkedList& List)
  {
    while (List.Size())
      {
        delete(List.Cur());
        List.DelCur();
      }
  }

static void ReplaceList(LinkedList& List,Point OP)
  {
    while (List.Size())
      {
        rect R=AdjustedRect(List.Cur(),OP);
        WriteImage(&R,(image*)List.Cur()+RSize);
        delete(List.Cur());
        List.Pop();
      }
  }

static void ThrowAwayList(LinkedList& List)
  {
    while (List.Size())
      {
        delete(List.Cur());
        List.Pop();
      }
  }

static void ReadImage2(const rect& R,void* P)
  {
    EventQueue(Off);
    TrackCursor(Off);
    ReadImage(&R,(image*)P);
    TrackCursor(On);
    EventQueue(On);
  }

static Bool FillList(LinkedList& List,const Rect& r)
  {
    rect R=r;
    Bool Done=False;
    image* Image;
    while (!Done)  //  ... trying to pack into memory
      {
        int OrigBottom=R.Ymax;
        long Size=ImageSize(&R)+RSize;
        while (Size>MaxInt) Size=RectReduce(R);
        while ((!Done)&&(Image=(image*)new Byte[size_t(Size)])==NULL)
          {
            Size=RectReduce(R);
            if (Size<5000) Done=True;  //  memory is getting *too* tight
          }
        if (!Done)  // ... then memory was found for this piece
          {
            *(rect*)Image=R;
            ReadImage2(R,Image+RSize);
            List.Push(Image);
            if (OrigBottom==R.Ymax) Done=True;
            else
              {
                R.Ymin=R.Ymax+1;
                R.Ymax=OrigBottom;
                Size=ImageSize(&R)+RSize;
              }
          }
      }
    if (Image==NULL) EmptyList(List);
    return (Image!=NULL);
  }

#endif // UseGraphics

static Bool PlentyMemoryLeft()
  {
    Byte* TempPtr= new Byte[5000];
    if (TempPtr==NULL) return False;  //  don't wanna take up any more space
    delete(TempPtr);
    return True;
  }

#ifdef UseGraphics

  static LinkedList* MakeList(Bool& MinAvail,const rect& R)
    {
      if (!MinAvail) return NULL;
      LinkedList* List=new LinkedList;
      if (List!=NULL)
        {
          if (!FillList(*List,R))
            {
              delete (List);
              List=NULL;
            }
          else if (!(MinAvail=PlentyMemoryLeft()))
            {
              EmptyList(*List);
              delete List;
              List=NULL;
            }
        }
      return List;
    }

#endif

#ifndef UseGraphics

  static Byte* ScreenMemPos(Point P)
    {
      return (CurVideoDevice->ScreenMemoryPos())+(P.Y()-1)*160+(P.X()-1)*2;
    }

#endif

static void ReplaceFile(String FileName,
  #ifdef UseGraphics
    Point OP
  #else
    Rect R
  #endif
  )
  {
    if (FileExists(FileName))
      {
        File F(FileName,ReadOnly);
        long FSize=F.Size();
        #ifndef UseGraphics
          int Width=R.Wide()*2;
          Byte* S=ScreenMemPos(R);
        #endif
        while (F.CurPos()<FSize)
          {
            #ifdef UseGraphics
              rect R;
              F.ReadThing(R);
              long ISize=ImageSize(&R);
              Byte Image[1050];
              F.Read(Image,ISize);
              R=AdjustedRect(&R,OP);
              WriteImage(&R,Image);
            #else
              F.Read(S,Width);
              S+=160;
            #endif
          }
        F.Close();
        DeleteFile(FileName);
      }
    else FatalError("replace win from disk:  no such file");
  }

static String* MakeFile(const rect& R)
  {
    String* FileName=new String;
    if (FileName!=NULL)
      {
        static long FileNum=0;  // set to zero at program bootup
        FileNum++;
        *FileName='W'+Str(FileNum%10000000L)+".IMG";
        DeleteFile(*FileName);
        File F(*FileName);
        #ifdef UseGraphics
          rect R2=R;
          R2.Ymax=R2.Ymin;  // we want one line at a time
          long Size=ImageSize(&R2);
          Byte Image[1050]; // if Screen width is 1024 w/ 256 colors + image rec = ~1050
          while (R2.Ymax<=R.Ymax)
            {
              F.WriteThing(R2);
              ReadImage2(R2,Image);
              F.Write(Image,Size);
              R2.Ymax++;
              R2.Ymin++;
            }
        #else
          Rect RR(R);
          Byte Width=Byte(RR.Wide()*2);
          Byte* S=ScreenMemPos(RR);
          int I;
          For(I,RR.High())
            {
              F.Write(S,Width);
              S+=160;
            }
        #endif
      }
    return FileName;
  }

void* OneBigChunk(Bool& MinAvail,const Rect& R)
  {
    if (!MinAvail) return NULL;
    #ifdef UseGraphics
      rect rTemp=R;
      long Size=ImageSize(&rTemp)+RSize;  // memory needed to store image
    #else
      long Size=R.Wide()*R.High()*2;
    #endif
    if (Size>long(MaxInt)) return NULL;
    #ifdef UseGraphics
      image* TempPtr=(image*)new Byte[size_t(Size)];
    #else
      Byte* TempPtr=new Byte[size_t(Size)];
    #endif
    if (TempPtr==NULL) return NULL;
    if ((MinAvail=PlentyMemoryLeft())!=0)
      {
        #ifdef UseGraphics
          *(rect*)TempPtr=R;
          ReadImage2(R,TempPtr+RSize);
        #else
          Byte* Dest=TempPtr;
          int Width=R.Wide()*2;
          Byte* S=ScreenMemPos(R);
          int I;
          For(I,R.High())
            {
              memcpy(Dest,S,Width);
              S+=160;
              Dest+=Width;
            }
        #endif
        return TempPtr;
      }
    else
      {
        delete TempPtr;
        return NULL;
      }
  }

ScreenImage::ScreenImage(RootWindow& W, const Rect& R)
  {
    RW=&W;
    W.Touch();
    #ifdef UseMouse
      OrigPos=R;
    #endif
    Replaced=False;
    Bool MinAvail=PlentyMemoryLeft();
    #ifdef UseMouse
      PreserveMouseHideStatus(Off);
    #endif
    #ifndef UseGraphics
      this->R=R;
    #endif
    if ((Ptr=OneBigChunk(MinAvail,R))!=NULL) Where=0;
    #ifdef UseGraphics
      else if ((Ptr=MakeList(MinAvail,R))!=0) Where=1;
    #endif
    else if ((Ptr=MakeFile(R))!=0) Where=2;
    else
      {
        Where=255;
        FatalError("Screen Save:  cannot save in any method");
      }
  }

#ifndef UseGraphics

  static void ReplaceOneChunk(Byte* M,Rect R)
    {
      Byte* S=ScreenMemPos(R);
      int I;
      int Width=R.Wide()*2;
      For(I,R.High())
        {
          memcpy(S,M,Width);
          S+=160;
          M+=Width;
        }
    }

#endif

void ScreenImage::Restore()
  {
    if (!Replaced)
      {
        RW->Touch();
        #ifdef UseMouse
          PreserveMouseHideStatus(Off);
        #endif
        switch (Where)
          {
            case 0:
                #ifdef UseGraphics
                  rect R=AdjustedRect(Ptr,OP);
                  WriteImage(&R,(image*)Ptr+RSize);
                #else
                  ReplaceOneChunk((Byte*)Ptr,R);
                #endif
                break;
            #ifdef UseGraphics
              case 1:
                  ReplaceList(*(LinkedList*)Ptr,OP);
                  break;
            #endif
            case 2:
                #ifdef UseGraphics
                  ReplaceFile(*(String*)Ptr,OP);
                #else
                  ReplaceFile(*(String*)Ptr,R);
                #endif
                break;
          }
        delete(Ptr);
        Replaced=True;
      }
  }

#pragma warn -par

void ScreenImage::Restore(Point P)
  {
    #ifdef UseMouse
      OP=P-OrigPos;
    #else
      P=P;  //xxx
    #endif
    Restore();
  }

#pragma warn +par

void ScreenImage::ThrowAway()
  {
    if (!Replaced)
      {
        switch (Where)
          {
            case 0: break;
            #ifdef UseGraphics
              case 1: ThrowAwayList(*(LinkedList*)Ptr); break;
            #endif
            case 2: DeleteFile((*(String*)Ptr));     break;
          }
        delete(Ptr);
        Replaced=True;
      }
  }

