#ifndef WWIncluded
#define WWIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WWEdit.h>
  // stdlib, string, stdio, io, WBits, WVec, WMisc, WStr, WFile, WLink,
  // WWLowLev, WWTools

  // used to pass to RootWindow instead of a MetaWindow num
const ColorTextMode=3;
const MonoTextMode=7;
const BIOSTextMode=5113;
const AutoDetect=5114;

/* used for multiple functions in determining default parameters.  Used
   along with Left, Right and Center, found in MISC.H */
const Curs=(MinInt+4);  // use the current cursor location
const Auto=(MinInt+5);  // use the AutoX or AutoY functions
const Bottom=(MinInt+6);
const Top=(MinInt+7);

const Bool Beg=False;
const Bool End=True;
const Bool Up=True;
const Bool Down=False;
const Bool Innie=False;
const Bool Outtie=True;

class LogicalWindow
  {
      Rect WR;  //  the working rectangle in device coords
      VideoAtt WAtt; // the default video attribute for this window
      Point TCP;  //  Text Cursor Pos
      #ifdef UseGraphics
        Byte GCW; // Grid Cell Wide:  1 in text mode
        Byte GCH; // Grid Cell High:  1 in text mode
        fontRec* Font; // pointer to the font that works with the above grid size
        Bool PreDispClear;  // Clear the grid cell background before display?
      #endif
      DefaultAttRec* DefAtt; // generally null.  RootWindow definitely has this
      RootWindow* Root;  // since there may be different video devices...
      LogicalWindow* Parent;
      LinkedList Children; // child windows
      Point GrindPos;  // the current position of where the grind is happening
      Bool IsAWindow;  // as opposed to a LogicalWindow or RootWindow
      friend class WindowRec;
      friend class Window;
      friend class RootWindow;
      friend class MenuRec;
      friend class ScrollBar;
      LogicalWindow();  // to be used by RootWindow and WindowRec
      void InternalInit(LogicalWindow &LW, int X, int Y, int Wide,
                        int High, VideoAtt Att);  // do not call directly
      DefaultAttRec* ActiveDefAtt(); // returns a pointer to the nearest DefAtt rec
      void MakeDefAtt(); // makes sure that there's a DefAtt rec w/ proper vals
    public:
      LogicalWindow(LogicalWindow &LW, int X, int Y, int Wide=0,
                    int High=0, VideoAtt Att=UseDefaultAtt);
      ~LogicalWindow();
      void Display(const char* Str,int X=Curs, int Y=Curs,VideoAtt Att=UseDefaultAtt);
      void Display(const char* Str,Point P,               VideoAtt Att=UseDefaultAtt)
        {Display(Str,P.X(),P.Y(),Att);}
      #ifdef UseGraphics
        Rect  DeviceRectA() {return WR;}
        Rect  DeviceRect(); // rect relative to parent
        Rect  LocalDeviceRect();  // Rect(0,0,DeviceWide,DeviceHigh)
      #else
        Rect WRectA(){return WR;}
        void DisplayAtt(int Len,int X, int Y, VideoAtt Att=UseDefaultAtt);
          //  Displays just the VideoAtt - a text mode trick
      #endif
      Rect WRect();
      #ifdef UseGraphics
        void DrawLineTo(Point P);
      #endif
      void Paint(const Rect& R, VideoAtt A=UseDefaultAtt);
      void Fill(const Rect& R, char Ch=' ', VideoAtt A=UseDefaultAtt);
      void Clear(VideoAtt Att=UseDefaultAtt);
      void ClearFromX(int X, VideoAtt Att=UseDefaultAtt) {ClearBox(X,1,Wide()-X+1,High(),Att);}
      void ClearFromY(int Y, VideoAtt Att=UseDefaultAtt) {ClearBox(1,Y,Wide(),High()-Y+1,Att);}
      void ClearBottomLine(VideoAtt Att=UseDefaultAtt) {ClearBox(1,High(),Wide(),1,Att);}
      void ClearFromXY(int X, int Y, VideoAtt Att=UseDefaultAtt)
          {ClearBox(X,Y,Wide()-X+1,High()-Y+1,Att);}
      void ClearToX(int X, VideoAtt Att=UseDefaultAtt) {ClearBox(1,1,X,High(),Att);}
      void ClearToY(int Y, VideoAtt Att=UseDefaultAtt) {ClearBox(1,1,Wide(),Y,Att);}
      void ClearTopLine(VideoAtt Att=UseDefaultAtt) {ClearBox(1,1,Wide(),1,Att);}
      void ClearToXY(int X, int Y, VideoAtt Att=UseDefaultAtt) {ClearBox(1,1,X,Y,Att);}
      void ClearBox(int X, int Y, int Wide, int High, VideoAtt Att=UseDefaultAtt);
      #ifdef UseGraphics
        void DeviceClearBox(int X, int Y, int Wide, int High, VideoAtt Att=UseDefaultAtt);
        void DeviceClearBox(Rect R, VideoAtt Att=UseDefaultAtt);
      #endif

      void DrawBox( // draw the outline of a box
          int X, int Y, int Wide, int High, VideoAtt Att=UseDefaultAtt);
      void DrawBox(Rect R, VideoAtt Att=UseDefaultAtt);
            // will effect the box only, not the inside of the box
      #ifdef UseGraphics
        void DeviceColorBox(int X, int Y, int Wide, int High, VideoAtt Att=UseDefaultAtt);
        void DeviceColorBox(Rect R, VideoAtt Att=UseDefaultAtt);
      #endif
      void ColorBox(int X, int Y, int Wide, int High, VideoAtt Att=UseDefaultAtt);
      void ColorBox(Rect R, VideoAtt Att=UseDefaultAtt);
      void ColorLine(int Y, VideoAtt Att=UseDefaultAtt) {ColorBox(1,Y,Wide(),1,Att);}
      void ColorBottomLine(VideoAtt Att=UseDefaultAtt) {ColorLine(High(),Att);}

      int X();  // The X value relative to the parent window
      int Y();  // ditto for Y
      int  XA();  // the absolute X (based on the root screen);
      int  YA();  // ditto for Y
      Point XY() {return Point(X(),Y());}
      Point XYA() {return Point(WR);}
      int  Wide();  // the current width
      int  High();  // the current height
      #ifdef UseGraphics
        int DeviceX();  // The X value relative to the parent window
        int DeviceY();  // ditto for Y
        int  DeviceXA() {return WR.X();} // the absolute X (based on the root screen)
        int  DeviceYA() {return WR.Y();} // ditto for Y
        int  DeviceWide() {return WR.Wide();} // the current width
        int  DeviceHigh() {return WR.High();} // the current height
      #endif
      int   Type(); // the root video type: "MonoText", etc.
      VideoAtt Att() {return WAtt;}  // returns the current default att for this win

      void ScrollUp(int Lines=1);
      void ScrollDown(int Lines=1);

      Point TextCursorPos() {return TCP;}
      void Goto(Point P);
        // call only if you don't have a TextCursor object defined for this win
      int AutoX(int Wide);
        /* used to determine a good X for a new window.  Bases it's
           calculations on the width of the desired window, the width of
           the screen and the current cursor position */
      int AutoY(int High);
        /* similar to AutoX */

      #ifdef UseMouse
        int MouseX();
        int MouseY();
        Point MousePos();
          // tells what text cell the mouse is pointing at relative to this window
        void SetMousePos(Point);
        #ifdef UseGraphics
          Point DeviceMousePos(); // same as MousePos cept in device pixels
          void SetDeviceMousePos(Point);
        #endif
      #endif

      KeyType Edit(char* Str, int FieldLen, int X, int Y);
      KeyType Edit(String& S, int FieldLen, int X, int Y);
      KeyType Edit(char* S);  // a full screen edit
      KeyType Edit(String& S);
      KeyType Edit(float &Num,int X, int Y,
          int IntegerFieldLength=10, int DecimalFieldLength=0);
      KeyType Edit(double &Num,int X, int Y,
          int IntegerFieldLength=10, int DecimalFieldLength=0);
      KeyType Edit(Byte &Num,int X, int Y,
          int IntegerFieldLength=2, int DecimalFieldLength=0);
      KeyType Edit(SByte &Num,int X, int Y,
          int IntegerFieldLength=2, int DecimalFieldLength=0);
      KeyType Edit(Word &Num,int X, int Y,
          int IntegerFieldLength=4, int DecimalFieldLength=0);
      KeyType Edit(SWord &Num,int X, int Y,
          int IntegerFieldLength=4, int DecimalFieldLength=0);
      KeyType Edit(int &Num,int X, int Y,
          int IntegerFieldLength=4, int DecimalFieldLength=0);
      KeyType Edit(UInt &Num,int X, int Y,
          int IntegerFieldLength=4, int DecimalFieldLength=0);
      KeyType Edit(Long &Num,int X, int Y,
          int IntegerFieldLength=9, int DecimalFieldLength=0);
      KeyType Edit(SLong &Num,int X, int Y,
          int IntegerFieldLength=9, int DecimalFieldLength=0);
      KeyType EditAtt(VideoAtt& Att,int X=Center, int Y=Center,VideoAtt A=UseDefaultAtt);
      #ifdef UseGraphics
        KeyType PickPattern(const ByteVector& Patterns, Byte& PatternIndex,
            int& Color, int WinX=Center, int WinY=Center,
            VideoAtt WinAtt=UseDefaultAtt, const char* Title=NULL);
      #endif
      void DialogBox(const char* Str,int X=Center,int Y=Center,VideoAtt Att=UseDefaultAtt);
        /* a window is created, Str is put on it and the user is prompted
        to press any key when ready.  If Att is 0, DialogAtt() is used */
      void Warning(const char* Str,int X=Center,int Y=Center,VideoAtt Att=UseDefaultAtt);
        // like Dialog box, only beeps and has a red default color
      Bool YesNoBox(Bool &YN,const char* Str,int X=Center,int Y=Center,VideoAtt Att=UseDefaultAtt);
        /* creates a window, puts str on, prompts for yes or no.  Returns
        False if ESC was pressed, True otherwise */

      int Menu(int &Choice,const char* MenuList,const char* Title="",
          int X=Center,int Y=Center,int Wide=0,int High=0,
          VideoAtt Att=UseDefaultAtt);
      int Menu(int &Choice,char** MenuList,const char* Title="",
          int X=Center,int Y=Center,int Wide=0,int High=0,
          VideoAtt Att=UseDefaultAtt);
      int Menu(const char* MenuList,const char* Title="",
          int X=Center,int Y=Center,int Wide=0,int High=0,
          VideoAtt Att=UseDefaultAtt);
      int Menu(char** MenuList,const char* Title="",
          int X=Center,int Y=Center,int Wide=0,int High=0,
          VideoAtt Att=UseDefaultAtt);

      Bool MultiMenu(BitVector& Select,const char* MenuList,const char* Title="",
          int FirstChoice=1,int X=Center,int Y=Center,int Wide=0,
          int High=0,VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr="F2 - Confirm");
      Bool MultiMenu(BitVector& Select,char** MenuList,const char* Title="",
          int FirstChoice=1,int X=Center,int Y=Center,int Wide=0,
          int High=0,VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr="F2 - Confirm");

      Bool OrderedMenu(ByteVector& Select,const char* MenuList,const char* Title="",
          int FirstChoice=1,int X=Center,int Y=Center,int Wide=0,
          int High=0,VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr="F2 - Confirm");
      Bool OrderedMenu(ByteVector& Select,char** MenuList,const char* Title="",
          int FirstChoice=1,int X=Center,int Y=Center,int Wide=0,
          int High=0,VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr="F2 - Confirm");

      int BarMenu(int &Choice,const char* MenuList,int Y=1,
          VideoAtt Att=UseDefaultAtt);
      int BarMenu(int &Choice,char** MenuList,int Y=1,
          VideoAtt Att=UseDefaultAtt);

      int ColorMenu(int Color=White,const char* Heading=NULL,
          int X=Center, int Y=Center,VideoAtt Att=UseDefaultAtt);

      String FileMenu(const char* FileMask, const char* Heading=NULL,
          int X=Center, int Y=Center,VideoAtt Att=UseDefaultAtt);
        // FileName is "" if Esc was pressed

      KeyType ShowTextFile(const char* FileName,const KeySetType& ExitKeySet);
      void ShowTextFile(const char* FileName);

      void ShowScreenForm(const char* FileName, Word TokenNum);
      void ShowScreenForm(const char* FileName, Word TokenNum, void* ...);
      KeyType EditScreenForm(const char* FileName, Word TokenNum, void* ...);

      void Draw(const Rect& R,VideoAtt A=UseDefaultAtt);
      void DrawLine(Point P1, Point P2,VideoAtt A=UseDefaultAtt);
        // must be a straight line in test mode
      void DrawLine(int X1,int Y1,int X2,int Y2,VideoAtt A=UseDefaultAtt);
      #ifndef UseGraphics
        void SmartLine(Point P1, Point P2,VideoAtt A=UseDefaultAtt);
        void SmartLine(int X1,int Y1,int X2,int Y2,VideoAtt A=UseDefaultAtt)
            {SmartLine(Point(X1,Y1),Point(X2,Y2));}
          // A line that looks for other lines so that it will put the
          // appropriate line character in the right place
      #endif

      void DrawBeveledRect(Rect& R,VideoAtt Att=UseDefaultAtt,
          Bool InnieOrOuttie=Outtie);
        /* R is in local window device coords and represents where the
        outermost edge of the rectangle will be drawn.  On exit, R will be
        the value of the rect just inside the border.  To clear that rect,
        call Fill(R); Will draw a plain rectangle in text mode*/

      #ifdef UseGraphics

        void DrawArrowButton(Point P,int Direction);
          /* P is in device coords and represents the upper-lefthand corner
          of a rectangle surrounding the triangle Direction takes Top,
          Bottom, Left and Right.  Current video att is used */

        void DrawTickMark(int X, int Y);  // tip of tick mark

      #endif

      //void UseFont(int FontNum); // 0 is roughly 80x25, 1 is roughly 80x43
        // not implemented at this time (priority shift)

      // device x is the leftmost column of the grid cell
      // device y is the bottommost row of the grid cell
      #ifdef UseGraphics
        int GridCellWide(){return int(GCW);}
        int GridCellHigh(){return int(GCH);}
        int GridToDeviceX(int X);
        int DeviceToGridX(int X);
        int GridToDeviceY(int Y);
        int DeviceToGridY(int Y);
        int GridToDeviceWide(int Wide);
        int DeviceToGridWide(int Wide);
        int GridToDeviceHigh(int High);
        int DeviceToGridHigh(int High);
        Rect GridToDevice(Rect R);
        Rect DeviceToGrid(Rect R);
        Point GridToDevice(Point P);
        Point DeviceToGrid(Point P);

        void GridToDeviceX(int GivenX, int &NewX)
            {NewX=GridToDeviceX(GivenX);}
        void DeviceToGridX(int GivenX, int &NewX)
            {NewX=DeviceToGridX(GivenX);}
        void GridToDeviceY(int GivenY, int &NewY)
            {NewY=GridToDeviceY(GivenY);}
        void DeviceToGridY(int GivenY, int &NewY)
            {NewY=DeviceToGridY(GivenY);}

        void GridToDeviceWide(int GivenWide, int &NewWide)
            {NewWide=GridToDeviceWide(GivenWide);}
        void DeviceToGridWide(int GivenWide, int &NewWide)
            {NewWide=DeviceToGridWide(GivenWide);}

        void GridToDeviceHigh(int GivenHigh, int &NewHigh)
            {NewHigh=GridToDeviceHigh(GivenHigh);}
        void DeviceToGridHigh(int GivenHigh, int &NewHigh)
            {NewHigh=DeviceToGridHigh(GivenHigh);}
      #endif

      void Touch(); // see RootWindow
      #ifdef UseMouse
        void Mouse(); // see RootWindow
      #else
        void Mouse(){}
      #endif
      #ifdef UseGraphics
        VideoAtt NoBlink(VideoAtt A){return A;}
      #else
        VideoAtt NoBlink(VideoAtt A);
          //  removes the Blink part of the attribute if this device currently
          //  supports blinking
      #endif
      RootWindow& RootWin();
      VideoAtt MenuAtt()        {return (ActiveDefAtt()->Menu       );}
      VideoAtt DialogAtt()      {return (ActiveDefAtt()->Dialog     );}
      VideoAtt LiveEditAtt()    {return (ActiveDefAtt()->LiveEdit   );}
      VideoAtt DeadEditAtt()    {return (ActiveDefAtt()->DeadEdit   );}
      VideoAtt NeutralEditAtt() {return (ActiveDefAtt()->NeutralEdit);}
      VideoAtt EditCursorAtt()  {return (ActiveDefAtt()->EditCursor );}
      VideoAtt PanicAtt()       {return (ActiveDefAtt()->Panic      );}
      void SetMenuAtt(VideoAtt A)       {MakeDefAtt(); DefAtt->Menu       =A;}
      void SetDialogAtt(VideoAtt A)     {MakeDefAtt(); DefAtt->Dialog     =A;}
      void SetLiveEditAtt(VideoAtt A)   {MakeDefAtt(); DefAtt->LiveEdit   =A;}
      void SetDeadEditAtt(VideoAtt A)   {MakeDefAtt(); DefAtt->DeadEdit   =A;}
      void SetNeutralEditAtt(VideoAtt A){MakeDefAtt(); DefAtt->NeutralEdit=A;}
      void SetEditCursorAtt(VideoAtt A) {MakeDefAtt(); DefAtt->EditCursor =A;}
      void SetPanicAtt(VideoAtt A)      {MakeDefAtt(); DefAtt->Panic      =A;}

      void AdjustLogicalWindowCoords(Point P);  // not for casual use

      // the "Grind" stuff is for displaying |, /, -, \ so that the user
      // is made aware that the program is working.
      void InitGrind(int X,int Y){GrindPos.SetX(X); GrindPos.SetY(Y);}
      void Grind(const char* C=NULL);
        //  show next grind char
        //  call as W.Grind(); usually.
        //  Call as W.Grind("X"); if you want X to appear in grind pos
      void StepGrind();
        // display a marker to show that this task is completed
        // increment the Y and then start grinding on the next task

  };

void SetWWFileName(const char* NewName);
  // use this to tell RootWindow that fonts are not found in WW.DAT.
  // you needn't bother if you specify a file name in RootWindow

class RootWindow: public LogicalWindow
  {
      #ifdef UseGraphics
        metaPort* P; // each video device has its own port
      #else
        Byte* ScreenMemory;
        Bool BlinkOn;  //Is the ability to blink currently on
      #endif
      int VideoType;  // the MetaGraphics code
      Bool Running; // don't want to shut down twice
      Byte VideoMode;
        // bit 0:  clear=graphic mode   set=text mode
        // bit 1:  clear=16 colors      set=2 colors
      void VideoInit(int ScreenType,VideoAtt Att);
        // called by RootWin constructors
      RootWindow(DefaultAttRec&);
        // for booting a second device from a WW file
    public:
      RootWindow(const char* FileName=NULL,VideoAtt Att=UseDefaultAtt);
        // for booting from a WW file
      RootWindow(int ScreenType,  // from Metagraphics defs
                 VideoAtt Att=UseDefaultAtt);
      ~RootWindow(){ShutDown();}
      void ShutDown();
      void Restart();  // use after a shut down to get things going again
      int Type(){return VideoType;}
      Bool TextMode(){return ((VideoMode&1)==1);}
        // what the video device is currently set for.
        // True= 80x25 text mode, False= some graphics mode
      Bool FullColor(){return ((VideoMode&2)==0);}
        // what the video device is currently set for.
        // True= Full 16 colors, False= 2 color (monochrome)
      void Touch();
        // if you want to use this video device, you may need to touch it
        // first sometimes (like when you want to use a generic metawin call)
      void Mouse();
        // kinda like touch, but makes sure that the mouse is operating on this
        // device
      #ifndef UseGraphics
        Byte* ScreenMemoryPos() {return ScreenMemory;}
          // used internally.  could be NULL!
        void BlinkAtt(Bool State=On);
          // If On, this video device will have only 8 background colors and
          // attributes will be able to blink when bit 7 is on.
          // if off, there will be 16 background colors and no blinking.
        Bool BlinkAvail() {return BlinkOn;}
          // Is the blink option currently available?
        void SlapScreen(const void*);
          // does a memcpy of 4000 bytes to screen memory
      #else
        void BlinkAtt(Bool State=On){State=State;} // no blink in graphics mode
        Bool BlinkAvail(){return False;}
      #endif
  };

inline RootWindow& LogicalWindow::RootWin(){return *Root;}

extern char* ClientName;  // NULL if not initialized.

extern RootWindow* VideoDevice1;  // points to the first RootWindow declared
extern RootWindow* VideoDevice2;  // points to the second RootWindow declared
extern RootWindow* CurVideoDevice; // the RootWindow that was last used
#ifdef UseMouse
  extern RootWindow* CurMouseVideoDevice;
    // points to the RootWindow that the mouse is currently visable on
#endif

inline void LogicalWindow::Touch(){Root->Touch();}
#ifdef UseMouse
  inline void LogicalWindow::Mouse(){Root->Mouse();}
#endif

class ScreenImage;

class WindowRec: public LogicalWindow
  {
      ScreenImage* UnderImage;
      ScreenImage* MyImage;  // used for Hide()/Show() to preserve the window
      char* TitleStr; // points to a copy of the title text.  NULL if no title
      Rect BR;  // BorderRect: outside edge of border
      Bool Visible;  // is the window currently visable?
      Bool Drawn;  // has the window been drawn for the first time yet?
      Bool Closed;  // False at init.  True on Close.  Window can be closed only once
      void Init(LogicalWindow &LW, int X, int Y, int Wide, int High,
          VideoAtt Att,const char* Title);
      #ifdef UseMouse
        friend void TestForWindowMove(KeyType& K,Bool FromKeyPressed);
        void AdjustWindowCoords(Point P);
      #endif
    public:
      WindowRec(LogicalWindow &LW, int X, int Y, int Wide, int High,
          VideoAtt Att=UseDefaultAtt,const char* Title=NULL);
      ~WindowRec() {Close();}
      void Hide();
      void Show();
      Bool Vis(){return Visible;}
      void Close();  // once a win is closed it can't be opened again
      void AdjustWide(int Adj);
      void AdjustHigh(int Adj);
      #ifdef UseGraphics
        Rect DeviceBRectA(){return BR;}
      #endif
  };

class Window: public WindowRec
  {
    public:
        Window(LogicalWindow &LW, int X, int Y, int Wide, int High,
            VideoAtt Att=UseDefaultAtt,const char* Title=NULL);
  };

void FatalError(const char* Str);
  // shuts down the WW system and displays the given message

#ifdef UseGraphics
  void SmoothScrolling(Bool OnOrOff);
    // used in menus.  Gets slow in high res graphics modes or with huge menus

  void ResetDefaultFont();

  // these funcs are used to determine bevel colors
  void GetColors(VideoAtt Att, int& Back, int& Bright, int& Dark);
  void GetColors(VideoAtt Att, int& Bright, int& Dark);
  int BrightColor(VideoAtt Att);
  int DarkColor(VideoAtt Att);

#endif

class DevicePreserver
  {
      RootWindow* OrigDev;
      #ifdef UseMouse
        RootWindow* OrigMouseDev;
      #endif
    public:
      DevicePreserver()
        {
          OrigDev=CurVideoDevice;
          #ifdef UseMouse
            OrigMouseDev=CurMouseVideoDevice;
          #endif
        }
      ~DevicePreserver()
        {
          OrigDev->Touch();
          #ifdef UseMouse
            OrigMouseDev->Mouse();
          #endif
        }
  };

#define PreserveDevice() DevicePreserver PDVar

class ScreenPreserver
  {
      RootWindow* RW;
      void* Storage;
    public:
      ScreenPreserver();
      ~ScreenPreserver();
  };

#define PreserveScreen() ScreenPreserver PSVar

void InitHotKey(int Key,VoidFuncPtr FuncPtr);
  // if Key is already set up, the function called will now be FuncPtr
void InitHotKey(VoidFuncPtr FuncPtr,int Key);
  // if FuncPtr is already set up, the key to activate it will now be Key

#endif

