#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

class FileWin
  {
    public:
      LogicalWindow* W;
      VertScrollBar* VSBar;  // vertical scroll bar (NULL if there isn't one)
      HorzScrollBar* HSBar;  // vertical scroll bar (NULL if there isn't one)
      Long TotLines; // the number of lines in the file
      int MaxWidth; // the widest line
      BitVector ExitKeys;
      TextFile* F;  // the file
      LongVector LinePos; // all of the starting line positions in the file
      char TempStr[2000]; // temporary string storage
      FileWin(LogicalWindow& ParentWin, const char* FileName,const BitVector& ExitKeySet);
      ~FileWin();
      void Disp(int Y);
      void LoadLine(int L);
      void FillWin();
      void Show();
      void GoUp();
      void GoDown();
      void GoHome();
      void GoEnd();
      void GoLeft();
      void GoRight();
      int JumpDistance();
      void JumpLeft();
      void JumpRight();
      void DoPageUp();
      void DoPageDown();
      void ProcessLeftButton(KeyType Key);
      int TopLineNum();
      int MaxTopLineNum();
      void SetTopLineNum(int L);
      int LeftColNum();
      int MaxLeftColNum();
      void SetLeftColNum(int L);
      KeyType Activate();
  };

void FileWin::Disp(int Y)
  {
    char* S=TempStr;
    int Shift=LeftColNum();
    if (Shift>strlen(S)) S="";
    else S+=Shift;
    W->Display(LeftText(S,W->Wide()),1,Y);
  }

void FileWin::LoadLine(int L)
  {
    F->Seek(LinePos(L));
    F->Read(TempStr);
  }

void FileWin::FillWin()
  {
    F->Seek(LinePos(TopLineNum()));
    int I;
    For(I,W->High())
      {
        F->Read(TempStr);
        Disp(I+1);
      }
  }

void FileWin::Show()
  {
    if (VSBar) VSBar->Show();
    if (HSBar) HSBar->Show();
    FillWin();
  }

void FileWin::GoUp()
  {
    if (TopLineNum()==0) return;
    SetTopLineNum(TopLineNum()-1);
    W->ScrollDown();
    LoadLine(TopLineNum());
    Disp(1);
  }

void FileWin::GoDown()
  {
    if (TopLineNum()==MaxTopLineNum()) return;
    SetTopLineNum(TopLineNum()+1);
    W->ScrollUp();
    LoadLine(TopLineNum()+W->High()-1);
    Disp(W->High());
  }

void FileWin::GoLeft()
  {
    if (LeftColNum()==0) return;
    SetLeftColNum(LeftColNum()-1);
    FillWin();
  }

void FileWin::GoRight()
  {
    if (LeftColNum()==MaxLeftColNum()) return;
    SetLeftColNum(LeftColNum()+1);
    FillWin();
  }

int FileWin::JumpDistance()
  {
    int D=int(Round(double(W->Wide())*0.15));
    return D;
  }

void FileWin::JumpLeft()
  {
    if (LeftColNum()==0) return;
    int NewLeft=int(SLong(LeftColNum())-JumpDistance());
    if (NewLeft<0) NewLeft=0;
    SetLeftColNum(NewLeft);
    FillWin();
  }

void FileWin::JumpRight()
  {
    if (LeftColNum()==MaxLeftColNum()) return;
    int NewLeft=LeftColNum()+JumpDistance();
    if (NewLeft>MaxLeftColNum()) NewLeft=MaxLeftColNum();
    SetLeftColNum(NewLeft);
    FillWin();
  }

void FileWin::DoPageUp()
  {
    if (TopLineNum()==0) return;
    int NewTop=int(SLong(TopLineNum())-W->High()+1);
    if (NewTop<0) NewTop=0;
    SetTopLineNum(NewTop);
    FillWin();
  }

void FileWin::DoPageDown()
  {
    if (TopLineNum()==MaxTopLineNum()) return;
    int NewTop=TopLineNum()+W->High()-1;
    if (NewTop>MaxTopLineNum()) NewTop=MaxTopLineNum();
    SetTopLineNum(NewTop);
    FillWin();
  }

void FileWin::GoHome()
  {
    if (TopLineNum()==0) return;
    SetTopLineNum(0);
    FillWin();
  }

void FileWin::GoEnd()
  {
    if (TopLineNum()==MaxTopLineNum()) return;
    SetTopLineNum(MaxTopLineNum());
    FillWin();
  }

#ifdef UseMouse

  void FileWin::ProcessLeftButton(KeyType Key)
    {
      Bool Change=False;
      if ((VSBar)&&(VSBar->Test(Key))) Change=True;
      if ((HSBar)&&(HSBar->Test(Key))) Change=True;
      if (Change) FillWin();
    }

#endif

KeyType FileWin::Activate()
  {
    #ifdef UseMouse
      PreserveMouseHideStatus(On);
    #endif
    Bool Done = False;
    KeyType Key;
    while(!Done)
      {
        if (KeyPressed())
          {
            #ifdef UseMouse
              HideCursor();
            #endif
            Key=GetKey();
            switch (int(Key))
              {
                case ArrowUpKey:        GoUp(); break;
                case ArrowDownKey:      GoDown(); break;
                case ArrowLeftKey:      GoLeft(); break;
                case ArrowRightKey:     GoRight(); break;
                case CtrlArrowLeftKey:  JumpLeft(); break;
                case CtrlArrowRightKey: JumpRight(); break;
                case PageUpKey:         DoPageUp(); break;
                case PageDownKey:       DoPageDown(); break;
                case HomeKey:           GoHome(); break;
                case EndKey:            GoEnd(); break;
                #ifdef UseMouse
                  case RightMouseButtonDown:
                  case LeftMouseButtonDown: TestForExit(Done,Key); break;
                  case LeftMouseButtonUp: ProcessLeftButton(Key); break;
                #endif
              }
            if ((Key==EscKey) || (ExitKeys(int(Key)))) Done=True;
            #ifdef UseMouse
              ShowCursor();
            #endif
          }
      }
    return Key;
  }

int FileWin::TopLineNum()
  {
    if (VSBar) return VSBar->CurStep();
    else return 0;
  }

int FileWin::MaxTopLineNum()
  {
    if (VSBar) return VSBar->CurStepRange()-1;
    else return 0;
  }

void FileWin::SetTopLineNum(int L)
  {
    if (VSBar)
        if (L<=MaxTopLineNum()) VSBar->SetStep(L);
  }

int FileWin::LeftColNum()
  {
    if (HSBar) return HSBar->CurStep();
    return 0;
  }

int FileWin::MaxLeftColNum()
  {
    if (HSBar) return HSBar->CurStepRange()-1;
    return 0;
  }

void FileWin::SetLeftColNum(int L)
  {
    if (HSBar)
        if (L<=MaxLeftColNum()) HSBar->SetStep(L);
  }

FileWin::FileWin(LogicalWindow& ParentWin, const char* FileName,const BitVector& ExitKeySet)
  {
    ExitKeys=ExitKeySet;
    TotLines=0;
    MaxWidth=0;
    F=new TextFile(FileName);
    LinePos.ReAlloc(F->Size()/100);
      // trying to save some re-alloc time without over-alloc-ing
    Long FSize=F->Size();
    LinePos.ExtraAlloc(Max(Long(FSize/200),Long(50)));
    Long Pos=0;
    while (F->Read(TempStr))  //(F->CurPos()<FSize)
      {
        //F->Read(TempStr);
        LinePos[int(TotLines)]=Pos;
        Pos=F->CurPos();
        TotLines++;
        MaxWidth=Max(MaxWidth,int(strlen(TempStr)));
        if (TotLines>16250) FSize=Pos;  // keep from blowing out the vector
      }
    int WWide=ParentWin.Wide();
    int WHigh=ParentWin.High();
    Bool Thinner=False;
    Bool Shorter=False;
    if (TotLines>WHigh)
      {
        #ifdef UseGraphics
          WWide-=3;
        #else
          WWide-=2;
        #endif
        Thinner=True;
      }
    if (MaxWidth>WWide)
      {
        #ifdef UseGraphics
          WHigh-=2;
        #else
          WHigh-=1;
        #endif
        Shorter=True;
        if (!Thinner)
            if (TotLines>WHigh)
              {
                #ifdef UseGraphics
                  WWide-=3;
                #else
                  WWide-=2;
                #endif
                Thinner=True;
              }
      }
    W=new LogicalWindow(ParentWin,1,1,WWide,WHigh);
    if (Thinner) VSBar=new VertScrollBar(*W,int(TotLines-WHigh+1));
    else VSBar=NULL;
    if (Shorter) HSBar=new HorzScrollBar(*W,MaxWidth-WWide+1);
    else HSBar=NULL;
  }

FileWin::~FileWin()
  {
    delete F;
    delete W;
    if (VSBar) delete VSBar;
    if (HSBar) delete HSBar;
  }

KeyType LogicalWindow::ShowTextFile(const char* FileName,const KeySetType& ExitKeySet)
  {
    KeyType K=EscKey;
    if (FileExists(FileName))
      {
        Display("loading data...",Center,Center);
        FileWin FW(*this,FileName,ExitKeySet);
        FW.Show();
        K=FW.Activate();
      }
    else Warning("Cannot process file "+String(FileName)+".");
    return K;
  }

void LogicalWindow::ShowTextFile(const char* FileName)
  {
    KeySetType ExitSet;
    ShowTextFile(FileName,ExitSet);
  }

