#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

#ifdef FED

  void ScreenForm::WriteOn(const char *FileName,Word Token)
    {
      Long FormSize=1;
        // how much space this form will take up on disk
        // plus one byte to record the number of recs
      Byte RecNum;
      For(RecNum,Byte(Size())) FormSize+=Next().Size();
      TokenFile F(FileName);
      Long OrigFormSize=FormSize;
      F.WritePrep(Token,FormSize);
      Byte Filler=Byte(FormSize-OrigFormSize);
      F.WriteThing(RecNum);
      Root();
      For(RecNum,Byte(Size()))
        {
          Cur().WriteOn(F);
          Next();
        }
      if (Filler) F.Write(&Filler,Filler); // fill out the last block with garbage
    }

  Bool ScreenForm::CopyCur()
    {
      Rect R=Cur().GridRect();
      Point LastPos=VideoDevice1->MousePos();
      if (!PointOnRect(LastPos,R)) LastPos=R;
      Point Offset=LastPos-Point(R);
      Rect Limits(1,1,VideoDevice1->Wide(),VideoDevice1->High());
      Limits.Adjust(Offset.X(),Offset.Y(),1-R.Wide(),1-R.High());
      Limits=VideoDevice1->GridToDevice(Limits);
      LimitMouse(Limits.X(),Limits.Y(),Limits.Right(),Limits.Bottom());
      PreservePenState();
      PenMode(2);
      PenColor(Yellow);
      DrawGridRect(R);
      Bool Changes=False;
      Bool Done=False;
      while (!Done)
        {
          if (KeyPressed())
            {
              KeyType Key=GetKey();
              if (Key==LeftMouseButtonUp)
                {
                  Point NewPos=VideoDevice1->DeviceToGrid(Key.MousePos())-Offset;
                  if (NewPos==Point(Cur().GridRect())) DrawGridRect(R);
                  else
                    {
                      Changes=True;
                      Append(Cur().Ditto(NewPos));
                    }
                  Done=True;
                }
              else if (Key.Mouse())
                {
                  WaitForMouseClear();
                  DrawGridRect(R);
                  Done=True;
                }
            }
          else
            {
              Point NewPos=VideoDevice1->MousePos();
              if (NewPos!=LastPos)
                {
                  HideCursor();
                  DrawGridRect(R);
                  R=NewPos-Offset;
                  DrawGridRect(R);
                  ShowCursor();
                  LastPos=NewPos;
                }
            }
        }
      LimitMouse(0,0,VideoDevice1->DeviceWide(),VideoDevice1->DeviceHigh());
      return Changes;
    }

  void ScreenForm::FEDDisplay()
    {
      PreserveMouseHideStatus(Off);
      VideoDevice1->Clear();
      Root();
      int RecNum;
      For(RecNum,Size())
        {
          Cur().FEDShow();
          Next();
        }
    }

  Bool ScreenForm::PointOnObj(Point P)
    {
      Bool Found=False;
      int I=Size();
      Root();
      while ((!Found) && (I>0))
        {
          I--;
          if (Prev().LocatedOnCell(P)) Found=True;
        }
      return Found;
    }

  Bool ScreenForm::SelectObjectFromScreen()
    {
      KeyType Key=FilterKey(BitVector(RightMouseButtonUp,LeftMouseButtonDown,EscKey));
      if (Key!=EscKey) return (PointOnObj(VideoDevice1->DeviceToGrid(Key.MousePos())));
      return False;
    }

  Bool FixedTextRec::EditWindow(LogicalWindow& LW,String S)
    {
      Bool Peachy=False;
      Window W(LW,1,5,79,5,0,S+" a Fixed Text Field");
      char Buf[100];
      if (Text) strcpy(Buf,Text);
      else Buf[0]=0;
      KeyType Key;
      EditStringRec ESR(W,Buf,79,Point(1,2));
      ESR.AddExitKey(F3Key);
      while (!((Key==EscKey)||(Key==EnterKey)))
        {
          W.ClearFromY(4);
          String ColorStr="Default Color";
          if (Att!=0)
              ColorStr=String(ColorName[Att.Foreground()])+" on "+ColorName[Att.Background()];
          W.Display("Press F3 to change color from "+ColorStr,Center,4,Att);
          Key=ESR.Activate();
          if (Key==F3Key) if (W.Edit(Att)!=EscKey) Peachy=True;
        }
      if (Key!=EscKey)
        {
          if (Text) delete Text;
          if (Buf[0])
            {
              int Len=strlen(Buf);
              Text=new char[Len+1];
              strcpy(Text,Buf);
              if (Pt.X()>80-Len+1) Pt.SetX(80-Len+1);
              Point DP=VideoDevice1->GridToDevice(Pt);
              MoveCursor(DP.X(),DP.Y());
              W.Close();
              MoveObject(*this,DP);
              Peachy=True;
            }
          else Text=NULL;
        }
      return Peachy;
    }

  void FixedTextRec::FEDShow()
    {
      if (Text) VideoDevice1->Display(Text,Pt,Att);
    }

  Rect FixedTextRec::GridRect()
    {
      int Len=(Text?strlen(Text):0);
      Rect R(Pt,Len,1);
      return R;
    }

  void FixedTextRec::MoveTo(Point P) { Pt=P; }


  int FixedTextRec::Size()
    {
      return (8+strlen(Text));
    }

  String FixedTextRec::Desc()
    {
      String S="Fixed Text:  X="+Form(3,Long(Pt.X()))+"; Y="+Form(3,Long(Pt.Y()))+
               "; Att="+Form(6,Long(Att))+"; Text=\""+Text+"\"";
      return S;
    }

  FixedTextRec::FixedTextRec(LogicalWindow& LW,char* S,Point P,VideoAtt A):
        FormRec(LW)
    {
      if ((S)&&(S[0]))
        {
          Text=new char[strlen(S)+1];
          strcpy(Text,S);
        }
      else Text=NULL;
      Pt=P;
      Att=A;
    }

  void FixedTextRec::WriteOn(File &F)
    {
      if (Text)
        {
          Byte Code=FixedTextCode;
          F.WriteThing(Code);
          F.WriteThing(Pt);
          F.WriteThing(Att);
          Byte B=Byte(strlen(Text));
          F.WriteThing(B);
          F.Write(Text,B);
        }
    }

  Bool FixedTextRec::Modify()
    {
      return (EditWindow(*VideoDevice1,"Edit"));
    }

  Bool CreateFixedTextRec(ScreenForm& SF)
    {
      FixedTextRec* FTR=new FixedTextRec(*VideoDevice1,NULL,Point(35,11));
      if (FTR->EditWindow(*VideoDevice1,"Add"))
        {
          SF.Append(*FTR);
          return True;
        }
      else
        {
          delete FTR;
          return False;
        }
    }

  FormRec& FixedTextRec::Ditto(Point P)
    {
      return (*(new FixedTextRec(*VideoDevice1,Text,P,Att)));
    }

  static Bool MakeRect(Rect& R) // R is in grid coords.  Returns False if Rect not completed
    {
      Bool Peachy=False;
      RootWindow& W=*VideoDevice1;
      W.SetMousePos(Point(R));
      KeyType Key=WaitForKeypress();
      if (Key==LeftMouseButtonDown)
        {
          PreserveMouseHideStatus(On);
          PreservePenState();
          PenMode(2);
          PenColor(White);
          Point P=W.DeviceToGrid(Key.MousePos()); // original point
          R=P;
          DrawGridRect(R);
          while (Key!=LeftMouseButtonUp)
            {
              Point P2=W.MousePos();
              //if ((P2.X())>=(P.X())) P2.SetX(P2.X()+1);
              //if ((P2.Y())>=(P.Y())) P2.SetY(P2.Y()+1);
              Rect NewR(P,P2);
              if (NewR!=R)
                {
                  PreserveMouseHideStatus(Off);
                  DrawGridRect(R);
                  R=NewR;
                  DrawGridRect(R);
                }
              Key=GetKey();
            }
          DrawGridRect(R);
          Peachy=True;
        }
      return Peachy;
    }

  Bool ColorBoxRec::EditWindow(LogicalWindow& LW,String S)
    {
      Bool Peachy=False;
      FullColorMenuRec M(LW,BlueGreen,S+" a ColorBox");
      if (M.Activate()!=EscKey)
        {
          Color=(M.CurChoice()%16);
          M.Close();
          Peachy=MakeRect(R);
        }
      return Peachy;
    }

  void ColorBoxRec::FEDShow() { Show(); }
  Rect ColorBoxRec::GridRect() { return R; }
  void ColorBoxRec::MoveTo(Point P) { R=P; }
  int ColorBoxRec::Size() { return (10); }

  String ColorBoxRec::Desc()
    {
      String S="ColorBox:  X="+Form(3,Long(R.X()))+"; Y="+Form(3,Long(R.Y()));
      S+="; Wide="+Form(3,Long(R.Wide()))+"; High="+Form(3,Long(R.High()));
      S+="; Color="+Form(6,Long(Color));
      return S;
    }

  ColorBoxRec::ColorBoxRec(LogicalWindow& LW,Rect GR,int C):FormRec(LW)
    {
      R=GR;
      Color=C;
    }

  void ColorBoxRec::WriteOn(File &F)
    {
      Byte Code=ColorBoxCode;
      F.WriteThing(Code);
      F.WriteThing(R);
      F.WriteThing(Color);
    }

  Bool ColorBoxRec::Modify()
    {
      return (EditWindow(*VideoDevice1,"Edit"));
    }

  Bool CreateColorBoxRec(ScreenForm& SF)
    {
      ColorBoxRec* FTR=new ColorBoxRec(*VideoDevice1,Rect(35,11,1,1),BlueGreen);
      if (FTR->EditWindow(*VideoDevice1,"Add"))
        {
          SF.Append(*FTR);
          return True;
        }
      else
        {
          delete FTR;
          return False;
        }
    }

  FormRec& ColorBoxRec::Ditto(Point P)
    {
      return (*(new ColorBoxRec(*VideoDevice1,Rect(P,1,1),Color)));
    }

  void DrawGridRect(Rect R)
    {
      HideCursor();
      VideoDevice1->Draw(VideoDevice1->GridToDevice(R));
      ShowCursor();
    }

  Bool MoveObject(FormRec& F,Point ClickPos)
    // ClickPos is in Device coords
    {
      Rect R=F.GridRect();
      Point LastPos=VideoDevice1->DeviceToGrid(ClickPos);
      Point Offset=LastPos-Point(R);
      Rect Limits(1,1,VideoDevice1->Wide(),VideoDevice1->High());
      Limits.Adjust(Offset.X(),Offset.Y(),1-R.Wide(),1-R.High());
      Limits=VideoDevice1->GridToDevice(Limits);
      LimitMouse(Limits.X(),Limits.Y(),Limits.Right(),Limits.Bottom());
      PreservePenState();
      PenMode(2);
      PenColor(White);
      DrawGridRect(R);
      Bool Changes=False;
      Bool Done=False;
      while (!Done)
        {
          if (KeyPressed())
            {
              KeyType Key=GetKey();
              if (Key==LeftMouseButtonUp)
                {
                  Point NewPos=VideoDevice1->DeviceToGrid(Key.MousePos())-Offset;
                  if (NewPos==Point(F.GridRect())) DrawGridRect(R);
                  else
                    {
                      Changes=True;
                      F.MoveTo(NewPos);
                    }
                  Done=True;
                }
              else if (Key.BothMouseButtonsDown())
                {
                  WaitForMouseClear();
                  DrawGridRect(R);
                  Done=True;
                }
            }
          else
            {
              Point NewPos=VideoDevice1->MousePos();
              if (NewPos!=LastPos)
                {
                  HideCursor();
                  DrawGridRect(R);
                  R=NewPos-Offset;
                  DrawGridRect(R);
                  ShowCursor();
                  LastPos=NewPos;
                }
            }
        }
      LimitMouse(0,0,VideoDevice1->DeviceWide(),VideoDevice1->DeviceHigh());
      return Changes;
    }

  String EditStringRec::Desc()
    {
      String S="Edit String: X="+Form(3,Long(Pt.X()))+"; Y="+Form(3,Long(Pt.Y()));
      S+="; Len="+Form(2,Long(Mask.Length()))+"; Parm="+Form(2,Long(Parm));
      S+="; Offset="+Form(3,Long(Offset));
      return S;
    }

  void EditStringRec::FEDShow()
    {
      VideoDevice1->Display(LeftText("Edit Field",Mask.Length()),Pt,VideoDevice1->DeadEditAtt());
    }

  Bool EditStringRec::EditWindow(LogicalWindow& LW,String S)
    {
      Window W(LW,Center,Center,20,7,0,S+" a char* Edit Field");
      W.Display("Field Length:",3,2);
      W.Display("Parameter Num:",2,4);
      W.Display("Offset:",9,6);
      ScreenForm SF(W);
      int Len=Mask.Length();
      SF.Append(*(new EditNumRec(W,Len,    Point(16,2 ))));
      SF.Append(*(new EditNumRec(W,Parm,   Point(16,4 ))));
      SF.Append(*(new EditNumRec(W,Offset, Point(16,6))));
      SF.Show();
      KeyType Key=SF.Activate();
      if (Key==EscKey) return False;
      else
        {
          Mask=DefaultMask(Len);
          if (Pt.X()>80-Mask.Length()+1) Pt.SetX(80-Mask.Length()+1);
          Point DP=VideoDevice1->GridToDevice(Pt);
          MoveCursor(DP.X(),DP.Y());
          W.Close();
          MoveObject(*this,DP);
          return True;
        }
    }

  Bool CreateEditStringRec(ScreenForm& SF)
    {
      EditStringRec* ESR=new EditStringRec(*VideoDevice1,1,0,10,Point(35,11));
      if (ESR->EditWindow(*VideoDevice1,"Add"))
        {
          SF.Append(*ESR);
          return True;
        }
      else
        {
          delete ESR;
          return False;
        }
    }

  FormRec& EditStringRec::Ditto(Point P)
    {
      return (*(new EditStringRec(*W,Parm,Offset+Mask.Length()+1,Mask.Length(),P)));
    }

  Bool EditStringRec::Modify()
    {
      return (EditWindow(*VideoDevice1,"Change"));
    }

  EditStringRec::EditStringRec(LogicalWindow& PW,int Pm, int O,
      int FieldLen, Point P):EditRec(PW,P,Pm,O)
    {
      ZZZ=NULL;
      Mask=DefaultMask(FieldLen);
      MaxLen=FieldLen;
    }

  void EditStringRec::WriteOn(File &F)
    {
      Byte Code=EditStringCode;
      F.WriteThing(Code);
      EditRec::WriteOn(F);
      Byte Len=Mask.Length();
      F.WriteThing(Len);
      F.WriteThing(Parm);
      F.WriteThing(Offset);
    }

  Rect EditStringRec::GridRect()
    {
      Rect R(Pt,Mask.Length(),1);
      return R;
    }

  int EditStringRec::Size(){return 9;}
  void EditStringRec::MoveTo(Point P){Pt=P;}

  const char* TypeName(int Num);

  String EditNumRec::Desc()
    {
      String S="Edit Num:    X="+Form(3,Long(Pt.X()))+"; Y="+Form(3,Long(Pt.Y()));
      S+="; Type="+String(TypeName(NumType))+"; Parm="+Form(2,Long(Parm));
      S+="; Offset="+Form(3,Long(Offset));
      return S;
    }

  FormRec& EditNumRec::Ditto(Point P)
    {
      EditNumRec* ENR=new EditNumRec(*W,Parm,Offset+NumSize(),P,NumType,ILen,DLen);
      ENR->Num=Num;
      return (*ENR);
    }

  void EditNumRec::FEDShow()
    {
      Double D=0.0;
      Num=&D;
      Byte OrigType=NumType;
      NumType=72+(NumType&Bit7);
      ConvertNumToString();
      Disp(S);
      NumType=OrigType;
    }

  void EditNumRec::WriteOn(File &F)
    {
      Byte Code=EditNumCode;
      F.WriteThing(Code);
      EditRec::WriteOn(F);
      F.WriteThing(ILen);
      F.WriteThing(DLen);
      F.WriteThing(NumType);
      F.WriteThing(Parm);
      F.WriteThing(Offset);
    }

  Bool EditNumRec::EditWindow(LogicalWindow& LW,String S)
    {
      Window W(LW,Center,Center,30,11,0,S+" a Numeric Edit Field");
      W.Display("Integer Field Length:",2,2);
      W.Display("Decimal Field Length:",2,4);
      W.Display("Numeric Type:",10,6);
      W.Display("Parameter Num:",9,8);
      W.Display("Offset:",16,10);
      ScreenForm SF(*VideoDevice1);
      SF.Append(*(new EditNumRec(W,ILen,   Point(25,2 ))));
      SF.Append(*(new EditNumRec(W,DLen,   Point(25,4 ))));
      SF.Append(*(new EditNumRec(W,NumType,Point(25,6 ),3)));
      SF.Append(*(new EditNumRec(W,Parm,   Point(25,8 ))));
      SF.Append(*(new EditNumRec(W,Offset,   Point(25,10))));
      SF.Show();
      KeyType Key=SF.Activate();
      if (Key==EscKey) return False;
      else
        {
          if (Pt.X()>80-TotLen()+1) Pt.SetX(80-TotLen()+1);
          Point DP=VideoDevice1->GridToDevice(Pt);
          MoveCursor(DP.X(),DP.Y());
          W.Close();
          MoveObject(*this,DP);
          return True;
        }
    }

  EditNumRec::EditNumRec(LogicalWindow& PW,int Pm, int Of, Point P,
      SByte Type, int IFL,int DFL):EditRec(PW,P,Pm,Of)
    {
      ILen=IFL;
      DLen=DFL;
      Num=NULL;
      NumType=Type;
      TickMarkSpacing=3;
    }

  Bool CreateEditNumRec(ScreenForm& SF)
    {
      EditNumRec* ENR=new EditNumRec(*VideoDevice1,1,0,Point(35,11));
      if (ENR->EditWindow(*VideoDevice1,"Add"))
        {
          SF.Append(*ENR);
          return True;
        }
      else
        {
          delete ENR;
          return False;
        }
    }

  Bool EditNumRec::Modify()
    {
      return (EditWindow(*VideoDevice1,"Change"));
    }

  int EditNumRec::Size(){return 11;}
  void EditNumRec::MoveTo(Point P){Pt=P;}

  Rect EditNumRec::GridRect()
    {
      Rect R(Pt,TotLen(),1);
      return R;
    }

  void EditRec::WriteOn(File& F)
    {
      F.WriteThing(Pt);
    }

#else

//#pragma warn -par
//#pragma warn -rvl

static void* XXX;

//  void ScreenForm::WriteOn(const char *FileName,Word Token)
//  Bool ScreenForm::CopyCur()
//  void ScreenForm::FEDDisplay()
//  Bool ScreenForm::PointOnObj(Point P)
//  Bool ScreenForm::SelectObjectFromScreen()
//  Bool FixedTextRec::EditWindow(LogicalWindow& LW,String S)
  void FixedTextRec::FEDShow(){}
  Rect FixedTextRec::GridRect(){return Rect();}
  void FixedTextRec::MoveTo(Point P){XXX=&P;}
  int FixedTextRec::Size(){return 0;}
  String FixedTextRec::Desc(){return String();}
//  FixedTextRec::FixedTextRec(LogicalWindow& LW,char* S,Point P,VideoAtt A):
//        FormRec(LW)
  void FixedTextRec::WriteOn(File &F){F.Write(XXX,0);}
  Bool FixedTextRec::Modify(){return True;}
  FormRec& FixedTextRec::Ditto(Point P){XXX=&P; return *this;}
//  Bool ColorBoxRec::EditWindow(LogicalWindow& LW,String S)
  void ColorBoxRec::FEDShow() {}
  Rect ColorBoxRec::GridRect() {return Rect();}
  void ColorBoxRec::MoveTo(Point P) {XXX=&P;}
  int ColorBoxRec::Size() {return 0;}
  String ColorBoxRec::Desc(){return String();}
//  ColorBoxRec::ColorBoxRec(LogicalWindow& LW,Rect GR,int C):FormRec(LW)
  void ColorBoxRec::WriteOn(File &F){F.Write(XXX,0);}
  Bool ColorBoxRec::Modify(){return False;}
  FormRec& ColorBoxRec::Ditto(Point P){XXX=&P; return *this;}
  String EditStringRec::Desc(){return String();}
  void EditStringRec::FEDShow(){}
//  Bool EditStringRec::EditWindow(LogicalWindow& LW,String S)
  FormRec& EditStringRec::Ditto(Point P){XXX=&P;return *this;}
  Bool EditStringRec::Modify(){return False;}
//  EditStringRec::EditStringRec(LogicalWindow& PW,int Pm, int O,
//      int FieldLen, Point P):EditRec(PW,P,Pm,O)
  void EditStringRec::WriteOn(File &F){F.Write(XXX,0);}
  Rect EditStringRec::GridRect(){return Rect();}
  int EditStringRec::Size(){return 0;}
  void EditStringRec::MoveTo(Point P){XXX=&P;}
  String EditNumRec::Desc(){return String();}
  FormRec& EditNumRec::Ditto(Point P){XXX=&P;return *this;}
  void EditNumRec::FEDShow(){}
  void EditNumRec::WriteOn(File &F){F.Write(XXX,0);}
//  Bool EditNumRec::EditWindow(LogicalWindow& LW,String S)
//  EditNumRec::EditNumRec(LogicalWindow& PW,int Pm, int Of, Point P,
//      SByte Type, int IFL,int DFL):EditRec(PW,P,Pm,Of)
  Bool EditNumRec::Modify(){return False;}
  int EditNumRec::Size(){return 0;}
  void EditNumRec::MoveTo(Point P){XXX=&P;}
  Rect EditNumRec::GridRect(){return Rect();}
  String EditSelectRec::Desc(){return String();}
  void EditSelectRec::FEDShow(){}
  FormRec& EditSelectRec::Ditto(Point P){XXX=&P;return *this;}
  Bool EditSelectRec::Modify(){return False;}
  void EditSelectRec::WriteOn(File &F){F.Write(XXX,0);}
  Rect EditSelectRec::GridRect(){return Rect();}
  int EditSelectRec::Size(){return 0;}
  void EditSelectRec::MoveTo(Point P){XXX=&P;}
  void EditRec::WriteOn(File& F){F.Write(XXX,0);}

#endif

