#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

class ActiveEditNum
  {
    public:
      EditNumRec* ENR;
      Bool Negative; //  Is the number currently Negative?
      Bool Activity;   // has there been activitiy since starting
        // used to determine whether or not "AutoClear" should be used.
      String S;  // the work string
        // may have leading spaces. Will never have a '+' or '-' on end like ENR->S
      TextCursor* TC;
      KeyType Key;

      ActiveEditNum(EditNumRec*);
      ~ActiveEditNum(){delete TC;}

      void KeyUsed(){Key=NullKey; Activity=True;}
      void Disp();
      Bool AutoClear()       {return ENR->Toggles(0);}
      Bool InsertStatusLine(){return ENR->Toggles(1);}
      Bool HomeCPos()        {return ENR->Toggles(2);}
      Bool Insert()          {return ENR->Toggles(4);}
      Bool IncDecMode()      {return ENR->Toggles(8);}
      Bool IntActive()       {return ((ENR->CPos)<(ENR->ILen));}
      int  CalcCursorX();
      void ProcessChar();
      void ProcessEsc();
      void GoLeft();
      void GoRight();
      void GoHome();
      void GoEnd();
      void DelLeft();
      void DelRight();
      void DelAllLeft();
      void DelAllRight();
      void ToggleInsertMode();
      void Inc();
      void Dec();
      void SetNegative(Bool N);
      void DealWithMinus();
      void DealWithPlus();
      KeyType Activate();
      void AlignCursor();
      void TestFirstChar();
      void TestForNegZero();
  };

//.parse

// #define SuperFunc
// Uncomment the above line for increased ability

void EditNumRec::Init(int IL, int DL, void* N, Byte NT)
  {
    ILen=IL;
    DLen=DL;
    Num=N;
    NumType=NT;
    ConvertNumToString();
    PreserveOrig();
    CPos=ILen-1;
    #ifdef UseGraphics
      TickMarkSpacing=3;
    #endif
    SetIncDecMode();
    if (HelpLineActivated()) HL=&RegularHL;
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, Byte& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,1);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, SByte& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,129);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, Word& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,2);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, SWord& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,130);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, UInt& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,2);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, int& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,2);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, Long& N, Point P,
    int IntFieldLen, int DecFieldLen):
      EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,4);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, SLong& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,132);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, float& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,68);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW, double& N, Point P,
    int IntFieldLen, int DecFieldLen):EditRec(PW,P)
  {
    Init(IntFieldLen,DecFieldLen,&N,72);
  }

//.parse

EditNumRec::EditNumRec(LogicalWindow& PW,File& F,const KeySetType& MasterKeySet):
      EditRec(PW,F,MasterKeySet)
  {
    F.ReadThing(ILen);
    F.ReadThing(DLen);
    F.ReadThing(NumType);
    F.ReadThing(Parm);
    F.ReadThing(Offset);
    Num=NULL;
    CPos=ILen-1;
    #ifdef UseGraphics
      TickMarkSpacing=3;
    #endif
    SetIncDecMode();
  }

//.parse

static SLong RangeCheck(double D,SLong Low, SLong High,Bool& UpdateS)
  {
    double DLow=double(Low);
    double DHigh=double(High);
    if (D<DLow)
      {
        D=DLow;
        UpdateS=Yes;
      }
    if (D>DHigh)
      {
        D=DHigh;
        UpdateS=Yes;
      }
    return Round(D);
  }

static Long LongRangeCheck(double D,Bool& UpdateS)
  {
    double DHigh=4294967295.0;
    if (D<0.0)
      {
        D=0.0;
        UpdateS=Yes;
      }
    if (D>DHigh)
      {
        D=DHigh-0.4;  // 0.5 will be added later
        UpdateS=Yes;
      }
    Long L;
    L=Long(D+0.5);
    return L;
  }

void EditNumRec::ConvertStringToNum()
  {
    String St=S;
    St.Trim(); // remove leading spaces
    if (NegativesAllowed())
      {
        int I=St.Length()-1;
        char LastChar=St(I);
        St.Delete(I);
        if (LastChar=='-') St.Insert('-');
      }
    if (DLen) St.Insert('.',St.Length()-DLen);
    double D=atof(St);
    if (!NumIsReal()) D*=pow(10,DLen);
    Bool UpdateS=False;
    switch(NumType)
      {
        case 1:
            *((Byte*)(Num))  =Byte  (RangeCheck(D,0,MaxByte,UpdateS));
            break;
        case 129:
            *((SByte*)(Num)) =SByte (RangeCheck(D,MinSByte,MaxSByte,UpdateS));
            break;
        case 2:
            *((Word*)(Num))  =Word  (RangeCheck(D,0,MaxWord,UpdateS));
            break;
        case 130:
            *((SWord*)(Num)) =SWord (RangeCheck(D,MinSWord,MaxSWord,UpdateS));
            break;
        case 4:
            *((Long*)(Num))  =LongRangeCheck(D,UpdateS);
            break;
        case 132:
            *((SLong*)(Num)) =SLong (RangeCheck(D,MinSLong,MaxSLong,UpdateS));
            break;
        case 68:
        case 196:
            *((float*)(Num)) =float (D);
            break;
        case 72:
        case 200:
            *((double*)(Num))=double(D);
            break;
      }
    if (UpdateS) ConvertNumToString();
    memcpy(&LastNum[0],Num,NumSize());
  }

//.parse

static void TestForOverflow(String& S,Word MaxLen)
  {
    if (S.Length()>MaxLen)
      {
        int I;
        For(I,MaxLen) S[I]='9';
        S.Delete(MaxLen,S.Length()-MaxLen);
      }
  }

static String ConvertLongToString(Long* L)
  {
    String S;
    S=DStr(*L);
    return S;
  }

void EditNumRec::ConvertNumToString()
  {
    switch(NumType)
      {
        case 1:   S=Str(*( (Byte*)(Num)));  break;
        case 129: S=Str(*((SByte*)(Num)));  break;
        case 2:   S=Str(*( (Word*)(Num)));  break;
        case 130: S=Str(*((SWord*)(Num)));  break;
        case 4:   S=ConvertLongToString(((Long*)(Num)));  break;
        case 132: S=Str(*((SLong*)(Num)));  break;
        case 68:
        case 196: S=DStr((*((float*)(Num))) * pow(10,DLen));  break;
        case 72:
        case 200: S=DStr((*((double*)(Num)))*pow(10,DLen)); break;
      }
    if (NegativesAllowed())
      {
        char EndChar;
        if (S(0)=='-')
          {
            S.Delete();
            EndChar='-';
          }
        else EndChar='+';
        TestForOverflow(S,DLen+ILen);
        S+=EndChar;
      }
    else
      {
        if (S(0)=='-') S.Delete();
        TestForOverflow(S,DLen+ILen);
      }
    if (DLen) // make sure that there are numbers up to first integral
      {
        while (S.Length()<=DLen) S.Insert('0');
      }
    while (S.Length()<(ILen+DLen+(NegativesAllowed()?1:0))) S.Insert(' ');
    if (S(ILen-1)==' ') S[ILen-1]='0';
  }

//.parse

KeyType EditNumRec::Activate()
  {
    //if (InFunc!=NULL) (*InFunc)();
    KeyType Key;
    //Bool GoActive=True;
    //while(GoActive)
    //  {
        if (memcmp(Num,&LastNum[0],NumSize())!=0) ConvertNumToString();
        if (HomeCPosMode()) CPos=ILen-1;
        if (CPos>=ILen+DLen) CPos=ILen+DLen-1;
        ActiveEditNum AES(this);
        Key=AES.Activate();
        Disp(S);
    //    OutKey=Key;
    //    if (OutFunc==NULL) GoActive=False;
    //    else if ((*OutFunc)()) GoActive=False;
    //  }
    return Key;
  }

//.parse

void ActiveEditNum::Disp()
  {
    TC->Hide();
    String Temp=S;
    if (ENR->NegativesAllowed()) Temp+=(Negative?"-":"+");
    ENR->Disp(Temp,Yes);
    TC->Show();
  }

int ActiveEditNum::CalcCursorX()
  {
    int X=(ENR->Pt.X())+(ENR->CPos);
    if (!IntActive()) X++;
    return X;
  }

ActiveEditNum::ActiveEditNum(EditNumRec* ENRec)
  {
    ENR=ENRec;
    EditNumRec& E=*ENR;
    Activity=False;
    S=E.S;
    if (E.NegativesAllowed())
      {
        char NegChar=S(S.Length()-1);
        S.Delete(S.Length()-1);
        Negative=(NegChar=='-');
      }
    else Negative=False;
    TC=new TextCursor(*(E.W),CalcCursorX(),E.Pt.Y());
    TC->SetInsertMode(Insert());
    #ifdef UseGraphics
      TC->SetLeftEdgeMode(!IntActive());
    #endif
    Disp();
  }

void ActiveEditNum::AlignCursor()
  {
    #ifdef UseGraphics
      TC->SetLeftEdgeMode(!IntActive());
    #endif
    TC->Goto(CalcCursorX(),ENR->Pt.Y());
  }

void ActiveEditNum::TestFirstChar() // removes unneeded leading zeros
  {
    int I=0;
    while (S(I)==' ') I++;
    if ((S(I)=='0')&&(I<((ENR->ILen)-1))) S[I]=' ';
  }

void ActiveEditNum::ProcessChar()
  {
    EditNumRec& E=*ENR;
    if ((E.AutoClearMode())&&(E.CPos==(E.ILen-1))&&(!Activity))
      {
        S=StringOf(E.ILen-1,' ')+'0';
        if (E.DLen) S+=StringOf(E.DLen,'0');
        Negative=No;
      }
    if (Insert())
      {
        if (IntActive())
          {
            S.Delete();
            S.Insert(char(int(Key)),E.CPos);
            TestFirstChar();
          }
        else
          {
            S.Insert(char(int(Key)),E.CPos);
            S.Delete(S.Length()-1);
            if (E.CPos<(S.Length()-1))
              {
                E.CPos++;
                AlignCursor();
              }
          }
      }
    else
      {
        S[E.CPos]=char(int(Key));
        if ((E.CPos)<(S.Length()-1))
          {
            E.CPos++;
            AlignCursor();
          }
      }
    TestForNegZero();
    Disp();
    KeyUsed();
  }

void ActiveEditNum::ProcessEsc()
  {
    String OrigS=ENR->S;
    Bool Neg=False;
    if (ENR->NegativesAllowed())
      {
        Neg=(OrigS(OrigS.Length()-1)=='-');
        OrigS.Delete(OrigS.Length()-1);
      }
    if (S!=OrigS)
      {
        S=OrigS;
        Negative=Neg;
        (ENR->CPos)=(ENR->ILen)-1;
        Disp();
        KeyUsed();
        AlignCursor();
      }
  }

void ActiveEditNum::GoLeft()
  {
    if ((ENR->CPos>0)&&(S(ENR->CPos)!=' '))
      {
        (ENR->CPos)--;
        AlignCursor();
        Key=NullKey;
      }
  }

void ActiveEditNum::GoRight()
  {
    if (ENR->CPos<S.Length()-1)
      {
        ENR->CPos++;
        AlignCursor();
        Key=NullKey;
      }
  }

void ActiveEditNum::GoHome()
  {
    if ((ENR->CPos>0)&&(S(ENR->CPos)!=' '))
      {
        ENR->CPos=0;
        AlignCursor();
        Key=NullKey;
      }
  }

void ActiveEditNum::GoEnd()
  {
    EditNumRec& E=*ENR;
    if (E.CPos<S.Length()-1)
      {
        E.CPos = S.Length()-1;
        AlignCursor();
        Key=NullKey;
      }
  }

void ActiveEditNum::DelLeft()
  {
    EditNumRec& E=*ENR;
    if (IntActive())
      {
        if (S(E.CPos)!=' ')
          {
            char Ch=S(E.CPos);
            Bool Change=Yes;
            S.Delete(E.CPos);
            S.Insert(' ');
            if ((S(E.CPos)==' ')&&(E.CPos==(E.ILen-1)))
              {
                S[E.CPos]='0';
                if (Ch=='0') Change=No;
              }
            if (Change)
              {
                TestForNegZero();
                KeyUsed();
                Disp();
              }
          }
      }
    else
      {
        if (E.CPos!=E.ILen)
          {
            S.Delete(E.CPos-1);
            S+='0';
            E.CPos--;
            KeyUsed();
            TestForNegZero();
            Disp();
            AlignCursor();
          }
      }
  }

void ActiveEditNum::DelRight()
  {
    if (IntActive())
      {
        if ((ENR->CPos)!=((ENR->ILen)-1))
          {
            (ENR->CPos)++;
            S.Delete(ENR->CPos);
            S.Insert(' ');
            if (S((ENR->ILen)-1)==' ') S[(ENR->ILen)-1]='0';
            TestForNegZero();
            KeyUsed();
            Disp();
            AlignCursor();
          }
      }
    else
      {
        S.Delete(ENR->CPos);
        S+='0';
        TestForNegZero();
        KeyUsed();
        Disp();
      }
  }

#ifdef SuperFunc

  void ActiveEditNum::DelAllLeft()
    {
      EditNumRec& E=*ENR;
      if (IntActive())
        {
          if (S(E.CPos)!=' ')
            {
              Bool NowZero=((E.CPos==E.ILen-1)&&(S(E.CPos)=='0')&&((E.ILen==1)||((E.ILen>1)&&(S(E.CPos-1)==' '))));
              if (!NowZero)
                {
                  while (S(E.CPos)!=' ')
                    {
                      S.Delete(E.CPos);
                      S.Insert(' ');
                    }
                  if ((S(E.CPos)==' ')&&(E.CPos==(E.ILen-1))) S[E.CPos]='0';
                  TestForNegZero();
                  KeyUsed();
                  Disp();
                }
            }
        }
      else
        {
          Bool Change=False;
          if (E.CPos!=E.ILen)
            {
              Change=True;
              int Len=E.CPos-E.ILen;
              S.Delete(E.ILen,Len);
              S+=StringOf(Len,'0');
              E.CPos=E.ILen;
            }
          int I;
          For(I,E.ILen-1)
              if (S(I)!=' ')
                {
                  S[I]=' ';
                  Change=True;
                }
          if (S(E.ILen-1)!='0')
            {
              S[I]='0';
              Change=True;
            }
          if (Change)
            {
              TestForNegZero();
              KeyUsed();
              Disp();
              AlignCursor();
            }
        }
    }

  void ActiveEditNum::DelAllRight()
    {
      EditNumRec& E=*ENR;
      if (IntActive())
        {
          Bool Change=False;
          if (E.CPos!=(E.ILen-1))
            {
              Change=True;
              int Len=E.ILen-E.CPos-1;
              S.Delete(E.CPos+1,Len);
              S=StringOf(Len,' ')+S;
              E.CPos+=Len;
              if (S(E.ILen-1)==' ') S[E.ILen-1]='0';
            }
          if (E.DLen)
            {
              int I;
              for(I=E.ILen;I<S.Length();I++)
                  if (S(I)!='0')
                    {
                      S[I]='0';
                      Change=True;
                    }
            }
          if (Change)
            {
              TestForNegZero();
              KeyUsed();
              Disp();
              AlignCursor();
            }
        }
      else
        {
          int I;
          for(I=E.CPos;I<S.Length();I++) S[I]='0';
          TestForNegZero();
          KeyUsed();
          Disp();
        }
    }

#endif

static void StringInc(String& S) // do not feed "9999"
  {
    Bool Carry=Yes;
    int I=S.Length();
    while (Carry)
      {
        I--;
        if (S(I)==' ') S[I]='0';
        S[I]=S(I)+1;
        if (S(I)>'9') S[I]='0';
        else Carry=No;
      }
  }

static void StringDec(String& S) // do not feed "0000"
  {
    Bool Carry=Yes;
    int I=S.Length();
    while (Carry)
      {
        I--;
        S[I]=S(I)-1;
        if (S(I)<'0') S[I]='9';
        else Carry=No;
      }
  }

static Bool StringIsAllNines(String& S)
  {
    Bool AN=Yes;
    int I;
    For(I,S.Length()) if (S(I)!='9') AN=No;
    return AN;
  }

static Bool StringIsZero(String& S)
  {
    Bool Z=Yes;
    int I;
    For(I,S.Length()) if (!((S(I)==' ')||(S(I)=='0'))) Z=No;
    return Z;
  }

void ActiveEditNum::Inc()
  {
    if (Negative)
      {
        StringDec(S);
        TestFirstChar();
        TestForNegZero();
        if (StringIsZero(S)) SetNegative(Off);
        Disp();
        KeyUsed();
      }
    else
      {
        if (!StringIsAllNines(S))
          {
            StringInc(S);
            Disp();
            KeyUsed();
          }

      }
  }

void ActiveEditNum::Dec()
  {
    if (Negative)
      {
        if (!StringIsAllNines(S))
          {
            StringInc(S);
            Disp();
            KeyUsed();
          }
      }
    else
      {
        if (StringIsZero(S))
          {
            if (ENR->NegativesAllowed())
              {
                StringInc(S);
                SetNegative(On);
                Disp();
                KeyUsed();
              }
          }
        else
          {
            StringDec(S);
            TestFirstChar();
            Disp();
            KeyUsed();
          }
      }
  }

void ActiveEditNum::ToggleInsertMode()
  {
    ENR->SetInsertMode(!Insert());
    TC->SetInsertMode(Insert());
    KeyUsed();
  }

void ActiveEditNum::TestForNegZero()
  {
    if ((Negative)&&(StringIsZero(S))) SetNegative(Off);
  }

void ActiveEditNum::SetNegative(Bool N)
  {
    if (Negative!=N)
      {
        Negative=N;
        Key=NullKey;
      }
  }

void ActiveEditNum::DealWithMinus()
  {
    if (ENR->NegativesAllowed())
      {
        SetNegative(On);
        Disp();
        Activity=Yes;
      }
    else Dec();
  }

void ActiveEditNum::DealWithPlus()
  {
    if (ENR->NegativesAllowed())
      {
        SetNegative(Off);
        Disp();
        Activity=Yes;
      }
    else Inc();
  }

KeyType ActiveEditNum::Activate()
  {
    EditNumRec& E=*ENR;
    KeySetType KS(ArrowLeftKey,ArrowRightKey,HomeKey,EndKey);
    KS|=KeySetType(BackspaceKey,DelKey,InsKey);
    #ifdef SuperFunc
      KS|=KeySetType(CtrlBackspaceKey,CtrlDelKey);
      KS|=KeySetType(CtrlMinus1,CtrlMinus2,CtrlPlus1,CtrlPlus2);
    #endif
    KS|=E.KeySet;
    if ((E.NegativesAllowed())||(IncDecMode())) KS|=KeySetType('-','+');
    Key=NullKey;
    while(!E.KeySet(Key))
      {
        KS['.']=(IntActive()&&(E.DLen>0));
        Key=FilterKey(KS,'&',TC);
        if (InRange(int(Key),int('0'),int('9'))) ProcessChar();
        else switch (int(Key))
          {
            case '.': E.CPos=E.ILen; AlignCursor();     break;
            case EscKey:            ProcessEsc();       break;
            case ArrowLeftKey:      GoLeft();           break;
            case ArrowRightKey:     GoRight();          break;
            case HomeKey:           GoHome();           break;
            case EndKey:            GoEnd();            break;
            case BackspaceKey:      DelLeft();          break;
            case DelKey:            DelRight();         break;
            #ifdef SuperFunc
              case CtrlBackspaceKey:  DelAllLeft();       break;
              case CtrlDelKey:        DelAllRight();      break;
              case CtrlMinus1:
              case CtrlMinus2:        Dec();              break;
              case CtrlPlus1:
              case CtrlPlus2:         Inc();              break;
            #endif
            case InsKey:            ToggleInsertMode(); break;
            case '-':               DealWithMinus();    break;
            case '+':               DealWithPlus();     break;
          }
      }
    if (Key!=EscKey)
      {
        E.S=S;
        if (E.NegativesAllowed()) E.S+=(Negative?'-':'+');
        E.ConvertStringToNum();
      }
    TC->Hide();
    return Key;
  }

//.parse

void EditNumRec::Disp(const String& Z, Bool Live)
  {
    #ifdef UseGraphics
      PreserveMouseHideStatus(Off);
    #endif
    VideoAtt A;
    VideoAtt NA;
    if (Live)
      {
        A=LiveAtt;
        NA=NeutralAtt;
      }
    else
      {
        A=DeadAtt;
        NA=DeadAtt;
      }
    W->Display(Z.Before(ILen),Pt,A);
    if (DLen)
      {
        W->Display(".",Pt.X()+ILen,Pt.Y(),NA);
        W->Display(Z.From(ILen),Pt.X()+ILen+1,Pt.Y(),A);
      }
    if (NegativesAllowed())
        W->Display(String(Z(Z.Length()-1,1)),Pt.X()+ILen+DLen+(DLen>0),Pt.Y(),NA);
    #ifdef UseGraphics
      if (TickMarkSpacing)
        {
          PreservePenState();
          PenColor(CursorAtt.Foreground());
          int Inc=TickMarkSpacing*(W->GridCellWide());
          int X=W->GridToDeviceX(Pt.X()+ILen);
          int Y=W->GridToDeviceY(Pt.Y()+1)-2;
          int NumTicks=(ILen-1)/TickMarkSpacing;
          int I;
          For(I,NumTicks)
            {
              X-=Inc;
              W->DrawTickMark(X,Y);
            }
        }
    #endif
  }

//.parse

void EditNumRec::Show()
  {
    Disp(S);
  }

//.parse

void EditNumRec::PreserveOrig()
  {
    memcpy(&OrigNum[0],Num,sizeof(double));
    memcpy(&LastNum[0],Num,sizeof(double));
  }

//.parse

void EditNumRec::AdjustDataPointer(void* Parms[])
  {
    Num=((char*)(Parms[Parm-1]))+Offset;
    ConvertNumToString();
    PreserveOrig();
  }

//.parse

int EditNumRec::TotLen()
  {
    return (ILen+DLen+int(NegativesAllowed())+int(DLen>0));
  }

//.parse

Bool EditNumRec::LocatedOnCell(Point P)
  {
    int X=P.X();
    Bool WithinX=InRange(X,Pt.X(),int(Pt.X()+(TotLen())-1));
    return ((Pt.Y()==P.Y())&&(WithinX));
  }

//.parse

void EditNumRec::Restore()
  {
    memcpy(Num,&OrigNum[0],NumSize());
  }

//.parse

KeyType LogicalWindow::Edit(Byte& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(SByte& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(Word& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(SWord& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(UInt& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(int& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(Long& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(SLong& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(float& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(double& Num,int X, int Y,
    int IntegerFieldLength, int DecimalFieldLength)
  {
    EditNumRec Z(*this,Num,Point(X,Y),IntegerFieldLength,DecimalFieldLength);
    KeyType K=Z.Activate();
    ClearHelpLine();
    return K;
  }

/*

  NumType

    Bits 0..5: How many bytes this type occupies (Range: 0..63)
            6: 0= this is an integer;  1= this is a float
            7: Negatives are allowed

    Values currently supported

      Type  Size  float   sign    NumType

      Byte    1                 =     1   Range: 0..255
      SByte   1           +Bit7 =   129   Range: -128..127
      Word    2                 =     2   Range: 0..65535
      SWord   2           +Bit7 =   130   Range: -32768..32767
      Long    4                 =     4   Range: 0..4294967295
      SLong   4           +Bit7 =   132   Range: -2147483648..2147483647
      Float   4   +Bit6         =    68   Negatives not allowed
      Float   4   +Bit6   +Bit7 =   196
      Double  8   +Bit6         =    72   Negatives not allowed
      Double  8   +Bit6   +Bit7 =   200

DecimalFieldLen

  -2..19.

  When positive:  The number of decimal places to edit.  if the type is an
                  integer,  "Num" will be treated as a fixed decimal
                  number. So, if "Num" is a word equal to 65535 and DLen
                  is 2  "Num" will appear and be edited as 655.35.
  When 0:         No decimal stuff
  When Negative:  (not yet implemented) makes it so that the comma in the
                  integer field can be offset.  So, if "Num" is a word
                  equal to 65535 and DLen is -2  "Num" will appear
                  as 6,553,500 and all but the last two digits can be
                  edited.


*/
