#include "WWLocal.h"
#pragma hdrstop

#include <ctype.h>

// copyright (c) 1992, 1993 by Paul Wheaton

class ActiveEditString
  {
      EditStringRec* ESR;
      Bool Activity;   // has there been activitiy since starting
        // used to determine whether or not "AutoClear" should be used.
      String OverBuff;  // stuff extra chars in here
      String S;  // the work string
      TextCursor* TC;
      KeyType Key;

      ActiveEditString(EditStringRec*);
      ~ActiveEditString(){delete TC;}

      int MaskPos();
      void Disp();
      void DispPart(int Index,int Len);
      Bool AutoClear()       {return ESR->Toggles(0);}
      Bool InsertStatusLine(){return ESR->Toggles(1);}
      Bool HomeCPos()        {return ESR->Toggles(2);}
      Bool Insert()          {return ESR->Toggles(4);}
      Bool Floater()         {return ESR->Toggles(8);}
      Bool PassMode()        {return ESR->Toggles(9);}
      void KeyUsed(){Key=NullKey; Activity=True;}
      void ProcessChar();
      void ProcessEsc();
      void GoLeft();
      void GoRight();
      void GoHome();
      void GoEnd();
      void DelLeft();
      void DelRight();
      void DelAllLeft();
      void DelAllRight();
      void ToggleInsertMode();
      KeyType Activate();
      void AlignCursor();
      void CheckOverBuff();
      void Trim();
      friend class EditStringRec;
  };

//.parse

FormRec::FormRec(LogicalWindow& PW)
  {
    EditField=No;
    W=&PW;
    InFunc=NULL;
    OutFunc=NULL;
    HelpNum=NoHelp;
    HL=NULL;
  }

//.parse

void EditRec::InternalInit(int Pm,int Of)
  {
    EditField=True;
    Parm=Pm;
    Offset=Of;
    LiveAtt=W->LiveEditAtt();
    DeadAtt=W->DeadEditAtt();
    NeutralAtt=W->NeutralEditAtt();
    CursorAtt=W->EditCursorAtt();
    CPos=0;
    SetInsertMode();
    SetAutoClearMode();
  }

//.parse

EditRec::EditRec(LogicalWindow& PW,Point P,int Pm,int Of):FormRec(PW)
  {
    Pt=P;
    InternalInit(Pm,Of);
    KeySet|=KeySetType(EscKey,EnterKey,F2Key,ArrowUpKey,ArrowDownKey,TabKey,ShiftTabKey);
  }

//.parse

EditRec::EditRec(LogicalWindow& PW,File& F,const KeySetType& MasterKeySet):
      FormRec(PW)
  {
    F.ReadThing(Pt);
    InternalInit(0,0);
    KeySet=MasterKeySet;
  }

//.parse

void EditRec::SetAutoClearMode(Bool OnOrOff)
  {
    Toggles[ 0]=OnOrOff;
  }

//.parse

void EditRec::SetHomeCPosMode(Bool OnOrOff)
  {
    Toggles[ 2]=OnOrOff;
  }

//.parse

void EditRec::SetInsertMode(Bool OnOrOff)
  {
    Toggles[ 4]=OnOrOff;
  }

//.parse

EditStringRec::EditStringRec(LogicalWindow& PW,File& F,const KeySetType& MasterKeySet):
      EditRec(PW,F,MasterKeySet)
  {
    int Len;
    F.ReadThing(Len);
    Mask=DefaultMask(Len);
    MaxLen=Len;
    F.ReadThing(Parm);
    F.ReadThing(Offset);
    CPos=0;
    SetCharStarMode();
    ZZZ=NULL;
    PreserveOrig();
    if (HelpLineActivated()) HL=&RegularHL;
    #ifdef UseGraphics
      if (Len>12) TickMarkSpacing=5;
      else TickMarkSpacing=0;
    #endif
  }

//.parse

EditStringRec::EditStringRec(LogicalWindow& PW,String& Str, int FieldLen, Point P):
      EditRec(PW,P)
  {
    ZZZ=&Str;
    PreserveOrig();
    Mask=DefaultMask(FieldLen);
    MaxLen=FieldLen;
    if (HelpLineActivated()) HL=&RegularHL;
    #ifdef UseGraphics
      if (MaxLen>12) TickMarkSpacing=5;
      else TickMarkSpacing=0;
    #endif
  }

//.parse

EditStringRec::EditStringRec(LogicalWindow& PW,char* Str, int FieldLen, Point P):
      EditRec(PW,P)
  {
    ZZZ=(String*)Str;
    SetCharStarMode();
    PreserveOrig();
    Mask=DefaultMask(FieldLen);
    MaxLen=FieldLen;
    if (HelpLineActivated()) HL=&RegularHL;
    #ifdef UseGraphics
      if (MaxLen>12) TickMarkSpacing=5;
      else TickMarkSpacing=0;
    #endif
  }

//.parse

EditStringRec::EditStringRec(LogicalWindow& PW,char* Str, const char* M, Point P):
      EditRec(PW,P)
  {
    ZZZ=(String*)Str;
    SetCharStarMode();
    PreserveOrig();
    Mask=M;
    MaxLen=Mask.Length();
    if (HelpLineActivated()) HL=&RegularHL;
    #ifdef UseGraphics
      if (MaxLen>12) TickMarkSpacing=5;
      else TickMarkSpacing=0;
    #endif
  }

//.parse

EditStringRec::EditStringRec(LogicalWindow& PW,String& Str, const char* M, Point P):
      EditRec(PW,P)
  {
    ZZZ=&Str;
    //SetCharStarMode();
    PreserveOrig();
    Mask=M;
    MaxLen=Mask.Length();
    if (HelpLineActivated()) HL=&RegularHL;
    #ifdef UseGraphics
      if (MaxLen>12) TickMarkSpacing=5;
      else TickMarkSpacing=0;
    #endif
  }

//.parse

KeyType EditStringRec::Activate()
  {
    //if (InFunc!=NULL) (*InFunc)();
    KeyType Key;
    //Bool GoActive=True;
    //while(GoActive)
    //  {
        if (HomeCPosMode()) CPos=0;
        if (CPos>CurZ().Length()) CPos=CurZ().Length();
        if (CPos>MaxLen) CPos=MaxLen;
        ActiveEditString AES(this);
        Key=AES.Activate();
        Disp(CurZ());
    //    OutKey=Key;
    //    if (OutFunc==NULL) GoActive=False;
    //    else if ((*OutFunc)()) GoActive=False;
    //  }
    return Key;
  }

//.parse

void ActiveEditString::Disp()
  {
    #ifdef UseGraphics
      TC->Hide();
    #endif
    ESR->Disp(S,Yes,Yes);
    #ifdef UseGraphics
      TC->Show();
    #endif
  }

void ActiveEditString::DispPart(int Index, int Len)
  {
    #ifdef UseGraphics
      #ifdef UseMouse
        PreserveMouseHideStatus(Off);
      #endif
      TC->Hide();
      if (ESR->Mask.Length()==ESR->MaxLen)
        {
          if ((Index+Len)>(ESR->Mask.Length())) Len=(ESR->Mask.Length())-Index;
          String St=S(Index,Len);
          if (PassMode())
            {
              int I;
              For(I,St.Length())
                  if (St(I)!=' ') St[I]='.';
            }
          if (Len>St.Length()) St+=' ';
          ESR->W->Display(St,(ESR->Pt.X())+Index,ESR->Pt.Y(),ESR->LiveAtt);
          #ifdef UseGraphics
            ESR->DrawTicks(Index,Len);
          #endif
        }
      else ESR->Disp(S,Yes,Yes);
      TC->Show();
    #else
      static X1=Index;  // eliminates warnings
      static X2=Len;    // eliminates warnings
      ESR->Disp(S,Yes,Yes);
    #endif
  }

int ActiveEditString::MaskPos()
  {
    String& M=ESR->Mask;
    int MP=0;
    int P=0;
    while (P<=(ESR->CPos))
      {
        if (ValidMaskToken(M(MP))) P++;
        MP++;
      }
    MP--;
    return MP;
  }

ActiveEditString::ActiveEditString(EditStringRec* ESRec)
  {
    ESR=ESRec;
    EditStringRec& E=*ESR;
    Activity=False;
    S=E.CurZ();
    TC=new TextCursor(*(E.W),E.Pt.X()+E.CPos,E.Pt.Y());
    TC->SetInsertMode(Insert());
    Disp();
  }

void ActiveEditString::AlignCursor()
  {
    TC->Goto(ESR->Pt.X()+MaskPos(),ESR->Pt.Y());
  }

void ActiveEditString::Trim() // whacks off extra spaces
  {
    S.TrimTrail();
    //while ( ((ESR->CPos)<S.Length()) && (S(S.Length()-1)==' ') )
    //    S.Delete(S.Length()-1);
  }

void ActiveEditString::CheckOverBuff()
  {
    if (S.Length()>ESR->MaxLen)
      {
        OverBuff.Insert(S.Last());
        S.Clip(ESR->MaxLen);
      }
    else if ((S.Length()<ESR->MaxLen)&&(OverBuff.Length()>0))
      {
        S+=OverBuff(0);
        OverBuff.Delete();
      }
  }

void ActiveEditString::ProcessChar()
  {
    if ((ESR->AutoClearMode())&&(ESR->CPos==0)&&(!Activity))
      {
        if (S.Length()>0)
          {
            S=StringOf(S.Length(),' ');
            DispPart(0,S.Length());
            S="";
          }
      }
    if (Insert())
      {
        S.Insert(int(Key),ESR->CPos);
        CheckOverBuff();
        DispPart(ESR->CPos,S.Length()-(ESR->CPos));
      }
    else
      {
        if (ESR->CPos==S.Length()) S+=char(int(Key));
        else S[ESR->CPos]=int(Key);
        DispPart(ESR->CPos,1);
      }
    if ((ESR->CPos)<((ESR->MaxLen)-1))
      {
        ESR->CPos++;
        AlignCursor();
      }
    KeyUsed();
  }

void ActiveEditString::ProcessEsc()
  {
    if (S!=ESR->CurZ())
      {
        S=ESR->CurZ();
        ESR->CPos=0;
        Disp();
        KeyUsed();
        AlignCursor();
      }
  }

void ActiveEditString::GoLeft()
  {
    if (ESR->CPos>0)
      {
        ESR->CPos--;
        AlignCursor();
        Key=NullKey;
        Trim();
      }
  }

void ActiveEditString::GoRight()
  {
    if ( (ESR->CPos<(S.Length())) && ((ESR->CPos)<((ESR->MaxLen)-1)) )
      {
        ESR->CPos++;
        AlignCursor();
        Key=NullKey;
      }
  }

void ActiveEditString::GoHome()
  {
    if (ESR->CPos>0)
      {
        ESR->CPos=0;
        AlignCursor();
        Key=NullKey;
        Trim();
      }
  }

void ActiveEditString::GoEnd()
  {
    EditStringRec& E=*ESR;
    if (E.CPos<S.Length())
      {
        E.CPos = S.Length();
        if (E.CPos>E.MaxLen-1) E.CPos=E.MaxLen-1;
        AlignCursor();
        Key=NullKey;
      }
  }

void ActiveEditString::DelLeft()
  {
    if (ESR->CPos>0)
      {
        ESR->CPos--;
        S.Delete(ESR->CPos);
        CheckOverBuff();
        DispPart(ESR->CPos,S.Length()+1-(ESR->CPos));
        AlignCursor();
        KeyUsed();
      }
  }

void ActiveEditString::DelRight()
  {
    if (ESR->CPos<S.Length())
      {
        S.Delete(ESR->CPos);
        CheckOverBuff();
        DispPart(ESR->CPos,S.Length()+1-(ESR->CPos));
        AlignCursor();
        KeyUsed();
      }
  }

void ActiveEditString::DelAllLeft()
  {
    if (ESR->CPos>0)
      {
        S.Delete(0,ESR->CPos);
        ESR->CPos=0;
        CheckOverBuff();
        Disp();
        KeyUsed();
        AlignCursor();
      }
  }

void ActiveEditString::DelAllRight()
  {
    if (ESR->CPos<S.Length())
      {
        S.Delete(ESR->CPos,S.Length()-ESR->CPos);
        OverBuff="";
        Disp();
        KeyUsed();
      }
  }

void ActiveEditString::ToggleInsertMode()
  {
    ESR->SetInsertMode(!Insert());
    TC->SetInsertMode(Insert());
    Key=NullKey;
  }

KeyType ActiveEditString::Activate()
  {
    EditStringRec& E=*ESR;
    TC->Show();
    KeySetType KS(ArrowLeftKey,ArrowRightKey,HomeKey,EndKey,BackspaceKey,DelKey);
    KS|=KeySetType(CtrlBackspaceKey,CtrlDelKey,InsKey);
    KS|=E.KeySet;
    Key=NullKey;
    while(!E.KeySet(Key))
      {
        char MaskChar=E.Mask(MaskPos());
        Key=FilterKey(KS,MaskChar,TC);
        KeySetType CharKeys=TokenKeys(MaskChar);
        if (CharKeys(Key)) ProcessChar();
        else switch (int(Key))
          {
            case EscKey:            ProcessEsc();  break;
            case ArrowLeftKey:      GoLeft();      break;
            case ArrowRightKey:     GoRight();     break;
            case HomeKey:           GoHome();      break;
            case EndKey:            GoEnd();       break;
            case BackspaceKey:      DelLeft();     break;
            case DelKey:            DelRight();    break;
            case CtrlBackspaceKey:  DelAllLeft();  break;
            case CtrlDelKey:        DelAllRight();  break;
            case InsKey:            ToggleInsertMode(); break;
          }
      }
    S.Trim();
    if (Key!=EscKey) E.SetZ(S);
    TC->Hide();
    return Key;
  }

#ifdef UseGraphics

  void EditStringRec::DrawTicks(int I,int Len)
    {
      if ((TickMarkSpacing)&&(Len))
        {
          if (I>0)
            {
              I--;
              Len++;
            }
          while (((I+Len)>=Mask.Length())&&(Len>0)) Len--;
          if (Len==0) return;
          PreservePenState();
          PenColor(ForeColor(CursorAtt));
          int Inc=TickMarkSpacing*(W->GridCellWide());
          int Adj=I%TickMarkSpacing;
          int X=W->GridToDeviceX(Pt.X()+I-Adj);
          int Y=W->GridToDeviceY(Pt.Y()+1)-2;
          int NumTicks=(Len+Adj-1)/TickMarkSpacing;
          int T;
          For(T,NumTicks)
            {
              X+=Inc;
              W->DrawTickMark(X,Y);
            }
        }
    }

#endif

//.parse

void EditStringRec::Disp(const String& Z,Bool SkipMask, Bool Live)
  {
    #ifdef UseMouse
      PreserveMouseHideStatus(Off);
    #endif
    int Pos=0;
    int ZPos=0;
    while (Pos<Mask.Length())
      {
        int StartPos=Pos;
        String S;
        Bool UseNeutral=True;
        while (!ValidMaskToken(Mask(Pos)))
          {
            S+=Mask(Pos);
            Pos++;
          }
        if (S.Length()==0)
          {
            UseNeutral=False;
            while (ValidMaskToken(Mask(Pos)))
              {
                if (ZPos<Z.Length())
                  {
                    if (PassMode()) S+='.';
                    else S+=Z(ZPos);
                  }
                else S+=' ';
                Pos++;
                ZPos++;
              }
          }
        if (!(UseNeutral&&SkipMask))
          {
            VideoAtt A=Live?(UseNeutral?NeutralAtt:LiveAtt):DeadAtt;
            W->Display(S,Pt.X()+StartPos,Pt.Y(),A);
          }
      }
    #ifdef UseGraphics
      DrawTicks(0,Mask.Length());
    #endif
  }

#ifdef UseGraphics

  void LogicalWindow::DrawTickMark(int X, int Y)
    {
      DrawLine(X,Y,X,Y+1);
      DrawLine(X-1,Y+1,X+1,Y+1);
    }

#endif

//.parse

String EditStringRec::CurZ()
  {
    if (CharStarMode()) return String(((char*)ZZZ));
    else return (*ZZZ);
  }

void EditStringRec::SetZ(const String& Z)
  {
    if (CharStarMode()) strcpy(((char*)ZZZ),Z);
    else (*ZZZ)=Z;
  }

//.parse

void EditStringRec::Show()
  {
    Disp(CurZ());
  }

//.parse

void EditStringRec::PreserveOrig()
  {
    if (ZZZ)
      {
        if (CharStarMode()) OrigZ=(char*)ZZZ;
        else OrigZ=*ZZZ;
      }
  }

//.parse

void EditStringRec::AdjustDataPointer(void* Parms[])
  {
    ZZZ=(String*)(((char*)(Parms[Parm-1]))+Offset);
    // points to the same place whether its a char* or a String*
    PreserveOrig();
  }

//.parse

Bool EditStringRec::LocatedOnCell(Point P)
  {
    int X=P.X();
    Bool WithinX=InRange(X,Pt.X(),int(Pt.X()+(Mask.Length())-1));
    return ((Pt.Y()==P.Y())&&(WithinX));
  }

//.parse

void EditStringRec::Restore()
  {
    if (CharStarMode()) strcpy((char*)ZZZ,OrigZ);
    else *ZZZ=OrigZ;
  }

/*
EditSelectRec::EditSelectRec(LogicalWindow& PW,File& F,const KeySetType& MasterKeySet):
      EditRec(PW,F,MasterKeySet)
  {
    int Len;
    F.ReadThing(Len);
    Mask=DefaultMask(Len);
    MaxLen=Len;
    F.ReadThing(Parm);
    F.ReadThing(Offset);
    CPos=0;
    SetCharStarMode();
    ZZZ=NULL;
    PreserveOrig();
    #ifdef UseGraphics
      if (Len>12) TickMarkSpacing=5;
      else TickMarkSpacing=0;
    #endif
  }
*/
//.parse

EditSelectRec::EditSelectRec(LogicalWindow& PW,int& Index,
    char** Selections, int FieldLen, Point P,const char* Title):EditRec(PW,P)
  {
    ZZZ=&Index;
    PreserveOrig();
    FLen=FieldLen;
    S=Selections;
    KeySet|=KeySetType('+','-',F3Key);
    int I=0;
    while(S[I]!=NULL)
      {
        char C=S[I][0];
        KeySet[tolower(C)]=On;
        KeySet[toupper(C)]=On;
        I++;
      }
    T=Title;
    if (HelpLineActivated()) HL=&SelectHL;
  }

//.parse

KeyType EditSelectRec::Activate()
  {
    W->Goto(Point(Pt.X()+FLen/2,Pt.Y()));
    KeyType Key;
    Bool Done=False;
    while(!Done)
      {
        Disp(Yes);
        Key=FilterKey(KeySet);
        int K=Key;
        if (InRange(K,int('a'),int('z'))||InRange(K,int('A'),int('Z'))||InRange(K,int('0'),int('9')))
          {
            char K=tolower(Key);
            int Z=*ZZZ+1;
            if (S[Z]==NULL) Z=0;
            Bool Done=False;
            while (!Done)
              {
                if (tolower(S[Z][0])==K) Done=True;
                else
                  {
                    Z++;
                    if (S[Z]==NULL) Z=0;
                    if (Z==(*ZZZ)) Done=True;
                  }
              }
            *ZZZ=Z;
          }
        else switch(K)
          {
            case F3Key:
              int X=*ZZZ;
              X++;
              if (W->Menu(X,S,T,Auto,Auto)>0) *ZZZ=X-1;
              break;
            case '+':
              if (S[(*ZZZ)+1]!=NULL)
                {
                  if (S[(*ZZZ)+1][0]!='\0') (*ZZZ)++;
                }
              break;
            case '-':
              if ((*ZZZ)>0) (*ZZZ)--;
              break;
            default: Done=True; break;
          }
      }
    Disp();
    return Key;
  }

//.parse

void EditSelectRec::Disp(Bool Live)
  {
    #ifdef UseMouse
      PreserveMouseHideStatus(Off);
    #endif
    VideoAtt A=Live?LiveAtt:DeadAtt;
    W->Display(LeftText(S[*ZZZ],FLen),Pt,A);
  }

//.parse

void EditSelectRec::Show()
  {
    Disp();
  }

//.parse

void EditSelectRec::PreserveOrig()
  {
    if (ZZZ) OrigZ=*ZZZ;
  }

//.parse

void EditSelectRec::AdjustDataPointer(void* Parms[])
  {
    ZZZ=(((int*)(Parms[Parm-1]))+Offset);
    // points to the same place whether its a char* or a String*
    PreserveOrig();
  }

//.parse

Bool EditSelectRec::LocatedOnCell(Point P)
  {
    int X=P.X();
    Bool WithinX=InRange(X,Pt.X(),int(Pt.X()+(FLen)-1));
    return ((Pt.Y()==P.Y())&&(WithinX));
  }

//.parse

void EditSelectRec::Restore()
  {
    *ZZZ=OrigZ;
  }

//.parse

KeyType FilterKey(const KeySetType& B,char MaskToken,TextCursor* TC)
  {
    KeyType K;
    KeySetType M=TokenKeys(MaskToken);
    KeySetType KS=B|M;
    KeySetType KS2=KS;
    int I;
    // for all upper case letters in KS make sure there is a matching lower case letter
    for(I='A';I<='Z';I++)
        if (KS(I)) KS2[I+32]=On;
    // for all lower case letters in KS make sure there is a matching upper case letter
    for(I='a';I<='z';I++)
        if (KS(I)) KS2[I-32]=On;
    while (!KS2(K))
      {
        if (TC!=NULL)
          #ifdef UseGraphics
            TC->Blink()
          #endif
          ;
        K=GetKey();
      }
    if (!KS(K)) // K needs to be converted to upper case or lower case
      {
        if (InRange(int(K),int('a'),int('z'))) K.SetCode(int(K)-32);
        else K.SetCode(int(K)+32);
      }
    return K;
  }

//.parse

KeyType LogicalWindow::Edit(char* Str, int FieldLen,int X, int Y)
  {
    String S=Str;
    KeyType Key=Edit(S,FieldLen,X,Y);
    strcpy(Str,S);
    return Key;
  }

//.parse

KeyType LogicalWindow::Edit(String& S, int FieldLen, int X, int Y)
  {
    EditStringRec ESR(*this,S,FieldLen,Point(X,Y));
    KeyType Key=ESR.Activate();
    ClearHelpLine();
    return Key;
  }

//.parse

#ifdef UseGraphics

  class EditPat
    {
        WWW* MainWin;
        LogicalWindow* TW;
        ByteVector Pats;
        Rect OutterRect,InnerRect,SampleRect;
        int CPX; // 0..Pats.Size()-1: Current Pattern Index
        int CC;  // 1..15: Current Color
        void DrawVert(Bool Clear=No);
        void DrawHorz(Bool Clear=No);
        void Disp(Bool Norm=Yes);
      public:
        EditPat(LogicalWindow& ParentWin, const ByteVector& Patterns,
            int WinX=Center,int WinY=Center,VideoAtt WinAtt=UseDefaultAtt,
            const char* Title=NULL);
        ~EditPat(){delete MainWin; delete TW;}
        void Show();
        KeyType Activate(int& PatIndex,int& Color);
    };

  void EditPat::Disp(Bool Norm)
    {
      PreservePenState();
      PenPattern(Pats(CPX));
      VideoAtt A=VAtt(CC,Black);
      if (!Norm)
        {
          MainWin->DeviceColorBox(SampleRect,A);
          A=ReverseAtt(A);
        }
      TW->ColorBox((CC-1)*2+1,CPX+1,2,1,A);
    }

  void EditPat::DrawVert(Bool Clear)
    {
      PreservePenState();
      if (Clear) PenColor(MainWin->Att().Background());
      else PenColor(ForeColor(MainWin->Att()));
      int X=MainWin->GridToDeviceX(((CC-1)*2)+3);
      MainWin->DrawLine(X,OutterRect.Top(),X,InnerRect.Top());
      MainWin->DrawLine(X,OutterRect.Bottom(),X,InnerRect.Bottom());
    }

  void EditPat::DrawHorz(Bool Clear)
    {
      PreservePenState();
      if (Clear) PenColor(BackColor(MainWin->Att()));
      else PenColor(ForeColor(MainWin->Att()));
      int Y=MainWin->GridToDeviceY(CPX+2);
      MainWin->DrawLine(OutterRect.Left(),Y,InnerRect.Left(),Y);
      MainWin->DrawLine(OutterRect.Right(),Y,InnerRect.Right(),Y);
    }

  EditPat::EditPat(LogicalWindow& ParentWin, const ByteVector& Patterns,
      int WinX,int WinY,VideoAtt WinAtt,const char* Title)
    {
      const int SampleWide=7;
      const int ColorsWide=15*2;
      Pats=Patterns;
      {
        int W=ColorsWide+2+SampleWide;
        int H=Max(Pats.Size()+1,4);
        MainWin=new WWW(ParentWin,WinX,WinY,W,H,WinAtt,Title);
      }
      if (MainWin->High()<Pats.Size()+1) Pats=Pats.Before(MainWin->High()-1);
      MainWin->Show();
      TW=new LogicalWindow(*MainWin,2,Center,ColorsWide,MainWin->High()-1);
      OutterRect=MainWin->LocalDeviceRect();
      OutterRect.Adjust(0,0,-SampleWide*(MainWin->GridCellWide()));
      MainWin->Draw(OutterRect);
      OutterRect.Shrink();
      InnerRect=TW->DeviceRect();
      InnerRect.Swell();
      LogicalWindow SampleWin(*MainWin,ColorsWide+3,Center,7,4);
      SampleWin.Display("Sample",Center,1);
      SampleRect=SampleWin.DeviceRect();
      SampleRect.Adjust(SampleWin.GridCellWide()/2,SampleWin.GridCellHigh(),
                        -SampleWin.GridCellWide(),-SampleWin.GridCellHigh());
      MainWin->Draw(SampleRect);
      SampleRect.Shrink();
      For(CPX,Pats.Size())
          for(CC=1;CC<16;CC++) Disp();
    }

  KeyType LogicalWindow::PickPattern(const ByteVector& Patterns,
      int& PatternIndex, int& Color,
      int WinX, int WinY,VideoAtt WinAtt,const char* Title)
    {
      PreserveMouseHideStatus(Off);
      PreservePenState();
      EditPat EP(*this,Patterns,WinX,WinY,WinAtt,Title);
      return EP.Activate(PatternIndex,Color);
    }

  KeyType EditPat::Activate(int& PatIndex,int& Color)
    {
      CC=Color;
      if (CC==0) CC=1;
      else if (CC>15) CC=15;
      CPX=PatIndex;
      if (CPX>=Pats.Size()) CPX=Pats.Size()-1;
      Disp(No);
      DrawVert();
      DrawHorz();
      KeyType Key;
      while ((Key!=EnterKey)&&(Key!=EscKey))
        {
          Key=WaitForKeypress();
          Disp();
          switch(Key)
            {
              case ArrowUpKey:
                  DrawHorz(Yes);
                  if (CPX>0) CPX--;
                  else CPX=Pats.Size()-1;
                  DrawHorz();
                  break;
              case ArrowDownKey:
                  DrawHorz(Yes);
                  if (CPX<Pats.Size()-1) CPX++;
                  else CPX=0;
                  DrawHorz();
                  break;
              case ArrowRightKey:
                  DrawVert(Yes);
                  if (CC<15) CC++;
                  else CC=1;
                  DrawVert();
                  break;
              case ArrowLeftKey:
                  DrawVert(Yes);
                  if (CC>1) CC--;
                  else CC=15;
                  DrawVert();
                  break;
            }
          Disp(No);
        }
      if (Key!=EscKey)
        {
          PatIndex=CPX;
          Color=CC;
        }
      return Key;
    }

  void TextCursor::Convert(int X,int Y)
    // note that the Rect's Wide and High must be preset
    {
      Point P(L->DeviceRectA());
      int Shift=(Ins?(LeftEdge?0:ShiftVal()):0);
      P.Adjust((X-1)*(L->GridCellWide())+Shift,((Y==Curs)?0:(Y-1)*(L->GridCellHigh())));
      R=P;
    }

#endif

#pragma warn -par

TextCursor::TextCursor(LogicalWindow& LW, int X, int Y,VideoAtt Att,
    Bool OnOrOff)
  {
    #ifdef UseGraphics
      LeftEdge=On;
      B=Off;
    #else
      Vis=Bool(Att);  // shuts up the bc++ warning (pragma warn isn't working)
    #endif
    Vis=False;
    Ins=On;
    L=&LW;
    #ifdef UseGraphics
      if (Att==0) A=LW.EditCursorAtt();
      else A=Att;
      R=LW.DeviceRectA();
      R.SetHigh(LW.GridCellHigh()-2);
      R.SetWide(2);
      Convert(X,Y);
      rect r=R;
      Image=(image*)new Byte[size_t(ImageSize(&r))];
      if (Image==NULL) FatalError("Text cursor needs memory");
      LastTick=SystemTick();
    #endif
    LW.Goto(Point(X,Y));
    if (OnOrOff==On) Show();
  }

#pragma warn +par

TextCursor::~TextCursor()
  {
    Hide();
    #ifdef UseGraphics
      delete Image;
    #endif
  }

void TextCursor::Hide()
  {
    if (Vis)
      {
        Vis=False;
        #ifdef UseGraphics
          HideCursor();
          rect r=R;
          WriteImage(&r,Image);
          ShowCursor();
        #else
          TextModeCursorOff();
        #endif
      }
  }

void TextCursor::Show()
  {
    if (!Vis)
      {
        Vis=True;
        #ifdef UseGraphics
          penState p;
          GetPenState(&p);
          PenColor(BackColor(A));
          BackColor(ForeColor(A));
          rect r=R;
          HideCursor();
          ReadImage(&r,Image);
          L->RootWin().Fill(R);
          ShowCursor();
          SetPenState(&p);
        #else
          TextModeCursorOn(Ins);
        #endif
      }
  }

void TextCursor::Adjust(int X, int Y)
  {
    #ifdef UseGraphics
      R.Adjust(X*(L->GridCellWide()),Y*(L->GridCellHigh()));
    #endif
    L->Goto(L->TextCursorPos()+Point(X,Y));
  }

void TextCursor::Goto(int X, int Y)
  {
    #ifdef UseGraphics
      Bool OldVis=Vis;
      if (Vis) Hide();
      Convert(X,Y);
      if (OldVis) Show();
    #endif
    L->Goto(Point(X,Y));
  }

void TextCursor::Goto(Point P)
  {
    Goto(P.X(),P.Y());
  }

#ifdef UseGraphics
  static Bool Blinking=On;

  void BlinkingTextCursor(Bool OnOrOff)
    {
      Blinking=OnOrOff;
    }

  void TextCursor::Blink()
    {
      if (Blinking)
        {
          Long CurrentTick=SystemTick();
          if ((CurrentTick-LastTick>5)||(CurrentTick<LastTick))
            {
              LastTick=CurrentTick;
              if (Vis) Hide();
              else Show();
            }
        }
    }

  void TextCursor::SetLeftEdgeMode(Bool NewStat)
    {
      if (LeftEdge!=NewStat)
        {
          if (Ins)
            {
              Bool OrigVis=Vis;
              Hide();
              int Shift=ShiftVal();
              R.SetX(R.X()+(NewStat?(-Shift):Shift));
              if (OrigVis) Show();
            }
          LeftEdge=NewStat;
        }
    }

#endif

void TextCursor::SetInsertMode(Bool NewStat)
  {
    if (Ins!=NewStat)
      {
        #ifdef UseGraphics
          Bool OrigVis=Vis;
          Hide();
          delete Image;
          R.SetWide(NewStat?2:(L->GridCellWide()-2));
          if (!LeftEdge)
            {
              int Shift=ShiftVal();
              R.Adjust(NewStat?Shift:(-Shift));
            }
          rect r=R;
          Image=(image*)new Byte[size_t(ImageSize(&r))];
          if (Image==NULL) FatalError("Text cursor out of memory");
          if (OrigVis) Show();
          Ins=NewStat;
        #else
          if (Vis)
            {
              TextModeCursorOn(NewStat);
            }
          Ins=NewStat;
        #endif
      }
  }



/*

  Note!:  In all of the edit classes there is a int parameter called
  "Toggles".  The bits are used to turn certain features on and off.  The
  first 4 bits are the same for all edit classes although they may not
  always be used.  if set to 1, these bits will.....

       0 = Auto Clear.  if the cursor is in the "home" position and the
           variable has not yet been altered, the variable will be cleared.
       1 = Insert Status Line override.  Will NOT display "Insert" or
           "overwrite" in the Insert/Overwrite window.
       2 = Home CPos.  On entry, the cursor will be placed at the "Home"
           position regardless of the CPos value.
       3 = Live Exit.  On exit, the field color will remain "Live".
           This is for edit routines that use other edit routines.  It helps
           to cut down on flicker.
       4 = Insert/Overwrite is currently overwrite
       5   not used
       6   not used
       7   not used

  for the edit string stuff only:

       8 = end of string floater is on
       9 = password mode is on
      10 = Z is of type char* (rather than String*)
      11
      12
      13
      14
      15

  for the edit num stuff only:

       8 = the "+" and "-" keys will increment/decrement the value
       9
      10
      11
      12
      13
      14
      15

*/

