#include "WWLocal.h"
#pragma hdrstop
#include <WWDBase.h>

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

void DBaseMenuRec::SeekChar(char C)
  {
    Window* W;
    Bool Grinding=(NumChoices>1000);
    if (Grinding)
      {
        W=new Window(*TW,Center,Center,15,5,TW->DialogAtt());
        W->Display("searching....",Center,2);
        W->InitGrind(Center,4);
      }
    int I=(CurItem+1)%NumChoices;
    if (I<SplitTop) I=SplitTop;
    String120 S;
    int GrindVal=0;
    Bool Done=False;
    while (!Done)
      {
        if (Grinding)
          {
            GrindVal++;
            if (GrindVal%40==0)
              {
                GrindVal=0;
                W->Grind();
              }
          }
        if (I==CurItem) Done=True;
        else
          {
            DBP->GetRec(V[I]);
            S=(*DisplayStr)();
            if (S(0)==C) Done=True;
            else
              {
                I=(I+1)%NumChoices;
                if (I<SplitTop) I=SplitTop;
              }
          }
      }
    if (Grinding) delete W;
    if (I!=CurItem)
      {
        CurItem=I;
        AlignTextToChoice();
      }
  }

void DBaseMenuRecSeekChar(MenuRec* MR, char C)
  {
    ((DBaseMenuRec*)MR)->SeekChar(C);
  }

DBaseMenuRec::DBaseMenuRec(LogicalWindow &PW, DBase* DB,String120FuncPtr DispS,
    const char* Tag, const char* Heading, int X, int Y,int Wide,int High,
    VideoAtt Att):MenuRec()
  {
    Window W(PW,X,Y,18,3,Att);
    W.Display("loading menu",3,2);
    W.InitGrind(16,2);
    V.ExtraAlloc(300);
    DisplayStr=DispS;
    Bool Backward=False;
    long SkipVal=1;
    if (Tag!=NULL)
      {
        if (Tag[0]=='-')
          {
            Backward=True;
            Tag++;
            SkipVal=-1;
          }
      }
    DBP=DB;
    int Grind=0;
    if ((Tag==NULL)&&(DBP->Tag()==NULL))
      {
        if (Backward) DBP->Bottom();
        else DBP->Top();
        while (!(Backward?DBP->bof():DBP->eof()))
          {
            if (Grind%100==0)
              {
                W.Grind();
                Grind=1;
              }
            else Grind++;
            if (!(DBP->Deleted())) V+=DBP->RecNum();
            DBP->Skip(SkipVal);
          }
      }
    else
      {
        DBaseTag T(*DBP,Tag);
        if (Backward) T.Bottom();
        else T.Top();
        if (!T.eof())
          {
            Bool Done=False;
            while (!Done)
              {
                if (Grind%100==0)
                  {
                    W.Grind();
                    Grind=1;
                  }
                else Grind++;
                V+=T.RecNum();
                Done=(T.Skip(SkipVal)==0);
              }
          }
      }
    NumChoices=int(V.Size());
    V+=0;
    char* Dummy[]={" ",NULL};
    Init(PW,1,Dummy,Heading,X,Y,Wide,High,Att,EnterKey,NULL,0,True);
    DBaseMenuRecSeekFunc=DBaseMenuRecSeekChar;
  }

void DBaseMenuRec::Disp(int ItemNum,Bool Normal)
  {
    int Y;
    if (ItemNum<SplitTop) Y=ItemNum+1;
    else
      {
        if (ItemNum==UseCurItem) ItemNum=CurItem;
        Y=ItemNum-TopChoice()+1+SplitTop;
      }
    VideoAtt A=TW->NoBlink(Normal?(TW->Att()):(ReverseAtt(TW->Att())));
    long RecNum=V[ItemNum];
    DBP->GetRec(RecNum);
    String120 S=(*DisplayStr)();
    if (SplitLeft) TW->Display(LeftText(S,SplitLeft),1,Y,A);
    TW->Display(LeftText(&S[LeftColNum()+SplitLeft],TW->Wide()-SplitLeft),1+SplitLeft,Y,A);
  }

long DBaseMenuRec::CurRecNum()
  {
    return V[CurItem];
  }

void DBaseMenuRec::LoadCurRec()
  {
    DBP->GetRec(V[CurItem]);
  }

