#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

int LogicalWindow::BarMenu(int &Choice,const char* MenuList,
    int Y, VideoAtt Att)
  {
    char** M=ConvertStringToArray(MenuList);
    int C=BarMenu(Choice,M,Y,Att);
    delete M;
    return C;
  }

//.parse

static void Change(LogicalWindow& W,const char* Choices[],int ItemX[],
    int NumChoices,int& Choice,int Dir)
  {
    int C=Choice-1;
    W.Display(Choices[C],ItemX[C]);
    C+=Dir;
    if (C<0) C=NumChoices-1;
    else if (C>=NumChoices) C=0;
    W.Display(Choices[C],ItemX[C],1,W.NoBlink(ReverseAtt(W.Att())));
    Choice=C+1;
  }

static void SetX(int NumSpaces, int NumChoices,int ItemLen[], int ItemX[])
  {
    int Delimeter[30];
    int X=(NumSpaces/NumChoices)/2;  //  start off with a smaller offset
    PigeonHole(NumSpaces-(2*X),NumChoices-1,Delimeter);
    X++;  //  adjust from 0..x  to  1..x  coord system
    int I;
    For(I,NumChoices)
      {
        ItemX[I]=X;
        X+=ItemLen[I]+Delimeter[I];
      }
  }

#ifdef UseMouse

  static void DoMouseStuff(LogicalWindow& W, int& Choice, int NumChoices,
      const char* Choices[], int ItemX[], int ItemLen[], Point& LastMousePos)
    {
      Point MP=W.DeviceMousePos();
      if (MP!=LastMousePos)
        {
          if (PointOnRect(MP,W.LocalDeviceRect()))
            {
              int Col=MP.X()/W.GridCellWide()+1;
              int OldChoice=Choice;
              int I;
              For(I,NumChoices)
                  if (InRange(Col,int(ItemX[I]),int(ItemX[I]+ItemLen[I]-1))) Choice=I+1;
              if (Choice!=OldChoice)
                {
                  W.Display(Choices[OldChoice-1],ItemX[OldChoice-1]);
                  W.Display(Choices[Choice-1],ItemX[Choice-1],1,ReverseAtt(W.Att()));
                }
            }
          LastMousePos=MP;
        }
    }

  static void ProcessLeftButton(KeyType& Key, Bool& Done, LogicalWindow& W,
      int& Choice, int ItemX[], int ItemLen[], int NumChoices)
    {
      if ((!Done) && (PointOnRect(Key.MousePos(),W.DeviceRectA())))
        {
          Point LMP=Key.MousePos()-Point(W.DeviceRectA()); // LocalMousePos
          int Col=LMP.X()/W.GridCellWide()+1;
          int I;
          For(I,NumChoices)
              if (InRange(Col,int(ItemX[I]),int(ItemX[I]+ItemLen[I]-1)))
                {
                  Choice=I+1;
                  Done=True;
                }
        }
    }

#endif

static int BarMenuHandler(LogicalWindow &LW,int& Choice,const char* Choices[],
    int NumChoices, int Y, VideoAtt Att)
  {
    if(NumChoices <= 1 ) return 0;
    LogicalWindow W(LW,1,Y,LW.Wide(),1,Att);
    int ItemX[30];
    int ItemLen[30];
    int TotalItemWidth = 0;
    int I;
    For(I,NumChoices)
      {
        ItemLen[I]=strlen(Choices[I]);
        TotalItemWidth+=ItemLen[I];
      }
    SetX(W.Wide()-TotalItemWidth,NumChoices,ItemLen,ItemX);
    For(I,NumChoices) W.Display(Choices[I],ItemX[I]);
    if (Choice>NumChoices) Choice=NumChoices;
    else if (Choice==0) Choice=1;
    W.Display(Choices[Choice-1],ItemX[Choice-1],1,ReverseAtt(Att));
    #ifdef UseMouse
      MoveCursor(W.DeviceXA()+(ItemX[Choice-1]+ItemLen[Choice-1]-1)*W.GridCellWide()
                            -(W.GridCellWide()/2),
                 W.DeviceYA()+W.GridCellHigh()/2);
      Point LastMousePos=W.DeviceMousePos();
      ShowCursor();
    #endif
    Bool Done = False;
    while(!Done)
      {
        if (KeyPressed())
          {
            KeyType Key=GetKey();
            int K=Key;
            if (InRange(K,int(' '),int('~')))
              {
                int I=Choice;
                if (Choice>=NumChoices) I-=NumChoices;
                while (((I+1)!=Choice)&&((ToUpper(Choices[I][0]))!=(ToUpper(K))))
                    I=(I+1)%NumChoices;
                I++;
                if (I!=Choice)
                  {
                    W.Display(Choices[Choice-1],ItemX[Choice-1]);
                    Choice=I;
                    W.Display(Choices[Choice-1],ItemX[Choice-1],1,ReverseAtt(Att));
                  }
              }
            switch (K)
              {
                #ifdef UseMouse
                  case RightMouseButtonDown:
                  case LeftMouseButtonDown:
                      int WChoice=int(Choice);
                      TestForExit(Done,Key);
                      Choice=int(WChoice);
                      break;
                  case LeftMouseButtonUp:
                      ProcessLeftButton(Key,Done,W,Choice,ItemX,ItemLen,NumChoices);
                      break;
                #endif
                case ArrowUpKey:
                case ArrowLeftKey:
                    Change(W,Choices,ItemX,NumChoices,Choice,-1);
                    break;
                case ArrowDownKey:
                case ArrowRightKey:
                    Change(W,Choices,ItemX,NumChoices,Choice,1);
                    break;
                case EnterKey:
                    Done=True;
                    break;
                case EscKey:
                    Choice=0;
                    Done=True;
                    break;
              }
            if (Key==EscKey)
              {
                Choice=0;
                Done=True;
              }
          }
        #ifdef UseMouse
        else DoMouseStuff(W,Choice,NumChoices,Choices,ItemX,ItemLen,LastMousePos);
        #endif
      }
    return(Choice);
  }

int LogicalWindow::BarMenu(int &Choice,char** MenuList,
    int Y,VideoAtt Att)
  {
    PreserveDevice();
    Touch();
    #ifdef UseMouse
      Mouse();
      PreserveMouseHideStatus(Off);
    #endif
    int MenuItems=1;
    while (MenuList[MenuItems] && (MenuList[MenuItems][0])) MenuItems++;
      // check both that the pointer is not null and the string is not empty
    if (Att==0) Att=VAtt(Black,Gray);
    if (Y==Bottom) Y=High();
    Choice=BarMenuHandler(*this,Choice,(const char**)(&MenuList[0]),MenuItems,Y,Att);
    return ( Choice=(InRange(Choice,int(1),MenuItems)? Choice : 0) );
  }

