#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

const char* ColorName[]={"Black","Blue","Green","Blue Green","Red","Purple",
    "Brown","Gray","Dark Gray","Light Blue","Light Green","Light Blue Green",
    "Light Red","Light Purple","Yellow","White"};

//.parse

#ifdef UseMouse

  KeyType::KeyType(const event& E)
    {
      Status=E.State;
      M=Point(E.CursorX,E.CursorY);
      Tick=E.Time;
      Byte Ascii=E.ASCII;
      Byte Scan=E.ScanCode;
      switch (Ascii)
        {
          case 0:
              if (Scan==0) // mouse key
                {
                  Code=NullKey;
                  return;
                }
              else if (Scan==15) Scan=Byte(ShiftTabKey);
              break;
          case 224: Ascii=0; break;  // some AT weirdness
          case 9:if (Scan==15)  Ascii=0; break;
          case 27:
              if (InRange(Scan,Byte(1),Byte(34)))
                {
                  Ascii=0;
                  if (ShiftKey()) Scan=Byte(ShiftEscKey);
                  else if (CtrlKey()) Scan=Byte(CtrlEscKey);
                }
              break;
          case 8:
          case 127:
              if (Scan==14)
                {
                  Ascii=0;
                  if (ShiftKey()) Scan=Byte(ShiftBackspaceKey);
                  else if (CtrlKey()) Scan=Byte(CtrlBackspaceKey);
                }
              break;
          case 10:
          case 13:
              if ((Scan==28)||(Scan==224))
                {
                  Scan=28;
                  Ascii=0;
                }
              break;
        }
      if (Ascii>0) Code=Ascii;
      else Code=Scan+256;
    }

  KeyType::KeyType(const KeyType &K)
    {
      Code=K.Code;
      Status=K.Status;
      M=K.M;
      Tick=K.Tick;
    }

  KeyType::KeyType(int I)
    {
      Code=I;
      Status=0;
      M=Point(0,0);
      Tick=0;
    }

  KeyType::KeyType()
    {
      Code=0;
      Status=0;
      M=Point(0,0);
      Tick=0;
    }

  void KeyType::operator=(KeyType K)
    {
      Code=K.Code;
      Status=K.Status;
      M=K.M;
      Tick=K.Tick;
    }

  void KeyType::operator=(Word I)
    {
      Code=I;
      Status=0;
      M=Point(0,0);
      Tick=0;
    }

  Bool KeyType::operator==(KeyType K)
    {
      return(Code==K.Code);
    }

  Bool KeyType::operator==(Word I)
    {
      return(Code==I);
    }

  Bool KeyType::operator!=(KeyType K)
    {
      return(Code!=K.Code);
    }

  Bool KeyType::operator!=(Word I)
    {
      return(Code!=I);
    }

  Bool KeyType::Mouse()
    {
      return((Status & (Bit8+Bit10))!=0);
    }

  Bool operator==(Word I, KeyType K)
    {
      return (K.Code==I);
    }

  Bool operator!=(Word I, KeyType K)
    {
      return (K.Code!=I);
    }

  Bool KeyType::LeftMouseButtonDown()
    {
      return ((Status&Bit10)!=0);
    }

  Bool KeyType::RightMouseButtonDown()
    {
      return ((Status&Bit8)!=0);
    }

  Bool KeyType::BothMouseButtonsDown()
    {
      return (LeftMouseButtonDown() && RightMouseButtonDown());
    }

  Bool KeyType::ShiftKey()
    {
      return ((Status&(Bit0+Bit1))!=0);
    }

  Bool KeyType::CtrlKey()
    {
      return ((Status&Bit2)!=0);
    }

  Bool KeyType::AltKey()
    {
      return ((Status&Bit3)!=0);
    }

  static Bool LeftDown=False; // holds the last status
  static Bool RightDown=False;
  static Bool MiddleDown=False;
  Bool ExtraKey=False;  // needs to be access by fortran initialization
  static KeyType EKey;

  void ExtractMouseButtons(KeyType& Key,Bool FromKeyPressed)
    {
      if (Key.Code==0)
        {
          Bool MBD=Bool((Key.Status&Bit9)!=0);
          Bool MiddleChange=Bool(MBD!=MiddleDown);
          MiddleDown=MBD;
          Bool LBD=Bool((Key.Status&Bit10)!=0);
          Bool RBD=Bool((Key.Status&Bit8)!=0);
          if ((LBD!=LeftDown)&&(RBD!=RightDown))
            {
              if (LBD) Key.Code=LeftMouseButtonDown;
              else Key.Code=LeftMouseButtonUp;
              if (!FromKeyPressed)
                {
                  EKey=Key;
                  if (RBD) EKey.Code=RightMouseButtonDown;
                  else EKey.Code=RightMouseButtonUp;
                  ExtraKey=True;
                  LeftDown=LBD;
                  RightDown=RBD;
                }
            }
          else if (LBD!=LeftDown)
            {
              if (LBD) Key.Code=LeftMouseButtonDown;
              else Key.Code=LeftMouseButtonUp;
              if (!FromKeyPressed) LeftDown=LBD;
            }
          else if (RBD!=RightDown)
            {
              if (RBD) Key.Code=RightMouseButtonDown;
              else Key.Code=RightMouseButtonUp;
              if (!FromKeyPressed) RightDown=RBD;
            }
          else if (MiddleChange)
            {
              if (FromKeyPressed) EatAKey();
            }
        }
    }

#else

  KeyType::KeyType(int ASCII,int Scan)
    {
      switch (ASCII)
        {
          case 0:
              if (Scan==15) Scan=(ShiftTabKey&255);
              break;
          case 224: ASCII=0; break;  // some AT weirdness
          case 9:if (Scan==15)  ASCII=0; break;
          case 27:
              if (InRange(Scan,1,34)) ASCII=0;
              break;
          case 8:
          case 127:
              if (Scan==14) ASCII=0;
              break;
          case 10:
          case 13:
              if ((Scan==28)||(Scan==224))
                {
                  Scan=28;
                  ASCII=0;
                }
              break;
        }
      if (ASCII>0) Code=ASCII;
      else Code=Scan+256;
    }

  KeyType::KeyType(const KeyType &K)
    {
      Code=K.Code;
    }

  KeyType::KeyType(int I)
    {
      Code=I;
    }

  KeyType::KeyType()
    {
      Code=0;
    }

  void KeyType::operator=(KeyType K)
    {
      Code=K.Code;
    }

  void KeyType::operator=(int I)
    {
      Code=I;
    }

  Bool KeyType::operator==(KeyType K)
    {
      return(Code==K.Code);
    }

  Bool KeyType::operator==(int I)
    {
      return(Code==I);
    }

  Bool KeyType::operator!=(KeyType K)
    {
      return(Code!=K.Code);
    }

  Bool KeyType::operator!=(int I)
    {
      return(Code!=I);
    }

  Bool operator==(int I, KeyType K)
    {
      return (K.Code==I);
    }

  Bool operator!=(int I, KeyType K)
    {
      return (K.Code!=I);
    }

#endif // UseMouse

//.parse

void EatAKey() // take a key out of the keyboard buffer
               // Assumes there is a key in the buffer to take out
  {
    #ifdef UseGraphics
      event E;
      KeyEvent(False,&E);
      KeyType K=E;
      ExtractMouseButtons(K);
    #else
      Registers Regs;
      Regs.AH()=0;
      CallBIOS(0x16,Regs);
    #endif
  }

//.parse

void InitHotKey(int Key,VoidFuncPtr FuncPtr)
  {
    int I;
    For(I,int(Hots.Size()))
        if (Hots(I).K==Key)
          {
            Hots[I].P=FuncPtr;
            return;
          }
    I=int(Hots.Size());
    Hots[I].K=Key;
    Hots[I].P=FuncPtr;
  }

void InitHotKey(VoidFuncPtr FuncPtr,int Key)
  {
    int I;
    For(I,int(Hots.Size()))
        if (Hots(I).P==FuncPtr)
          {
            Hots[I].K=Key;
            return;
          }
    I=int(Hots.Size());
    Hots[I].K=Key;
    Hots[I].P=FuncPtr;
  }

//.parse

HotVec Hots;

void TestForHotKey(KeyType& K,Bool FromKeyPressed)
  {
    int I;
    For(I,int(Hots.Size()))
        if (K==Hots(I).K)
          {
            if (FromKeyPressed) EatAKey();
            Hots(I).P();
            K=NullKey;
          }
  }

//.parse

KeyType WaitForKeypress()
  {
    KeyType K;
    #ifdef UseMouse
      if (ExtraKey)
        {
          ExtraKey=False;
          return EKey;
        }
      Bool Done=False;
      while (!Done)
        {
          event E;
          KeyEvent(True,&E);
          K=E;
          ExtractMouseButtons(K);
          TestForWindowMove(K);
          TestForHotKey(K);
          if (K!=NullKey) Done=True;
        }
    #else
      Bool Done=False;
      while (!Done)
        {
          Registers Regs;
          Regs.AH()=0;
          CallBIOS(0x16,Regs);
          K=KeyType(Regs.AL(),Regs.AH());
          TestForHotKey(K);
          if (K!=NullKey) Done=True;
        }
    #endif
    return(K);
  }

#ifdef UseMouse
  void WaitForMouseClear()
    {
      while (WaitForKeypress().Mouse());
    }
#endif

//.parse

Bool KeyPressed()
  {
    #ifdef UseMouse
      if (ExtraKey) return True;
      event E;
      if (PeekEvent(1,&E)==1)
        {
          KeyType K=E;
          ExtractMouseButtons(K,Yes);
          TestForWindowMove(K,Yes);
          TestForHotKey(K,Yes);
          return (K!=NullKey);
        }
      else return False;
    #else
      Registers Regs;
      Regs.AH()=1;
      CallBIOS(0x16,Regs);
      if (Regs.ZF()) return False;
      KeyType K(Regs.AL(),Regs.AH());
      TestForHotKey(K,Yes);
      return (K!=NullKey);
    #endif
  }

//.parse

KeyType GetKey()
  {
    #ifdef UseMouse
      if (ExtraKey)
        {
          ExtraKey=False;
          return EKey;
        }
      event E;
      if (KeyEvent(False,&E))
        {
          KeyType K=E;
          ExtractMouseButtons(K);
          TestForWindowMove(K);
          TestForHotKey(K);
          return(K);
        }
      else return(KeyType(0));
    #else
      KeyType K;
      if (KeyPressed()) K=WaitForKeypress();
      return K;
    #endif
  }

//.parse

KeyType FilterKey(const BitVector& B)
  {
    KeyType K;
    while (!B(K)) K=WaitForKeypress();
    return K;
  }

#ifdef UseGraphics

  Bool SmoothScroll=Off;

  void SmoothScrolling(Bool OnOrOff)
    {
      SmoothScroll=OnOrOff;
    }

#endif

//.parse

void AlignWinBoundry(Rect& R,const Rect& RR) // RR = Root Rect
  {
    R.SetWide(Min(R.Wide(),RR.Wide()));
    if (R.X()<1) R.SetX(1);
    if (R.Right()>RR.Right())
      {
        int Dif=(R.Right()-RR.Right());
        R.SetX(R.X()-Dif);
      }
    R.SetHigh(Min(R.High(),RR.High()));
    if (R.Y()<1) R.SetY(1);
    if (R.Bottom()>RR.Bottom())
      {
        int Dif=R.Bottom()-RR.Bottom();
        R.SetY(R.Y()-Dif);
      }
  }

//.parse

void LogicalWindow::InternalInit(LogicalWindow &LW, int X, int Y,
    int Wide, int High, VideoAtt Att)
  {
    DefAtt=NULL;
    IsAWindow=False;
    Root=LW.Root;
    Root->Touch();
    Parent=&LW;
    #ifdef UseGraphics
      GCW=LW.GCW;
      GCH=LW.GCH;
      Font=LW.Font;
      PreDispClear=LW.PreDispClear;
    #endif
    if (X==Auto) X=LW.AutoX(Wide);
    if (Y==Auto) Y=LW.AutoY(High);
    #ifdef UseGraphics
      GridToDeviceWide(Wide,Wide);
      GridToDeviceHigh(High,High);
      Wide=Min(Wide,Root->DeviceRectA().Wide());
      High=Min(High,Root->DeviceRectA().High());
      if (X==Center) X=int(SLong(LW.DeviceWide()-SLong(Wide))/2);
      else GridToDeviceX(X,X);
      if (Y==Center) Y=int(SLong(LW.DeviceHigh()-SLong(High))/2);
      else GridToDeviceY(Y,Y);
      WR=Rect(X+LW.DeviceXA(),Y+LW.DeviceYA(),Wide,High);
      AlignWinBoundry(WR,Root->DeviceRectA());
    #else
      Wide=Min(Wide,Root->WRectA().Wide());
      High=Min(High,Root->WRectA().High());
      if (X==Center) X=int((LW.Wide()-Wide)/2)+1;
      if (Y==Center) Y=int((LW.High()-High)/2)+1;
      WR=Rect(X+LW.XA()-1,Y+LW.YA()-1,Wide,High);
      AlignWinBoundry(WR,Root->WRectA());
    #endif
    TCP=Point(1,1);
    if (Att!=UseDefaultAtt)
      {
        WAtt=Att;
        #ifdef UseGraphics
          PreservePenState();
          BackColor(Att.Background());
          PenColor(Att.Foreground());
          PreserveMouseHideStatus(Off);
          Root->Fill(WR);
        #else
          Clear();
        #endif
      }
    else WAtt = LW.WAtt;
    Parent->Children.Add(this);
  }

//.parse

LogicalWindow::LogicalWindow(){}

//.parse

LogicalWindow::LogicalWindow(LogicalWindow &LW, int X, int Y, int Wide,
    int High, VideoAtt Att)
  {
    InternalInit(LW,X,Y,Wide,High,Att);
  }

//.parse

LogicalWindow::~LogicalWindow()
  {
    if (this!=Root)
      {
        if (DefAtt) delete DefAtt;
        if (Parent!=NULL) // parent would be NULL if it was deleted before this
          {
            // remove self from parents list
            LinkedList& LL=(Parent->Children);
            if (LL.Size())
              {
                LL.Last();
                int Stopper=int(LL.Size()+1);
                while ((LL.Cur()!=this)&&(Stopper))
                  {
                    LL.Prev();
                    Stopper--;
                  }
                if (Stopper) LL.DelCur();
              }
          }
        while (Children.Size())
          {
            ((LogicalWindow*)Children.Cur())->Parent=NULL;
            Children.DelCur();
          }
      }
  }

//.parse

Rect LogicalWindow::WRect()
  {
    return Rect(X(),Y(),Wide(),High());
  }

//.parse

int LogicalWindow::X()
  {
    return (XA()-(Parent->XA())+1);
  }

int LogicalWindow::Y()
  {
    return (YA()-(Parent->YA())+1);
  }

//.parse

int LogicalWindow::XA()
  {
    #ifdef UseGraphics
      int X=WR.X()/GridCellWide()+1;
    #else
      int X=WR.X();
    #endif
    return X;
  }

int LogicalWindow::YA()
  {
    #ifdef UseGraphics
      int Y=WR.Y()/GridCellHigh()+1;
    #else
      int Y=WR.Y();
    #endif
    return Y;
  }

//.parse

int LogicalWindow::Wide()
  {
    #ifdef UseGraphics
      int W=WR.Wide()/GridCellWide();
    #else
      int W=WR.Wide();
    #endif
    return W;
  }

int LogicalWindow::High()
  {
    #ifdef UseGraphics
      int H=WR.High()/GridCellHigh();
    #else
      int H=WR.High();
    #endif
    return H;
  }

#ifdef UseGraphics
  int LogicalWindow::DeviceX()
    {
      return (DeviceXA()-(Parent->DeviceXA()));
    }

  int LogicalWindow::DeviceY()
    {
      return (DeviceYA()-(Parent->DeviceYA()));
    }

  int LogicalWindow::GridToDeviceWide(int Wide)
    {
      return(Wide*GridCellWide());
    }

  int LogicalWindow::GridToDeviceHigh(int High)
    {
      return(High*GridCellHigh());
    }

  int LogicalWindow::GridToDeviceX(int X)
    {
      return((X-1)*GridCellWide());
    }

  int LogicalWindow::GridToDeviceY(int Y)
    {
      return((Y-1)*GridCellHigh());
    }

  int LogicalWindow::DeviceToGridWide(int Wide)
    {
      if (Wide==0) return 0;
      Wide--;
      return(Wide/GridCellWide()+1);
    }

  int LogicalWindow::DeviceToGridHigh(int High)
    {
      if (High==0) return 0;
      High--;
      return(High/GridCellHigh()+1);
    }

  int LogicalWindow::DeviceToGridX(int X)
    {
      return(X/GridCellWide()+1);
    }

  int LogicalWindow::DeviceToGridY(int Y)
    {
      return(Y/GridCellHigh()+1);
    }

  Rect LogicalWindow::GridToDevice(Rect R)
    {
      Rect NR(GridToDevice(Point(R)),
              GridToDeviceWide(R.Wide()),GridToDeviceHigh(R.High()));
      return NR;
    }

  Point LogicalWindow::GridToDevice(Point P)
    {
      return Point(GridToDeviceX(P.X()),GridToDeviceY(P.Y()));
    }

  Point LogicalWindow::DeviceToGrid(Point P)
    {
      return Point(DeviceToGridX(P.X()),DeviceToGridY(P.Y()));
    }

  Rect LogicalWindow::DeviceToGrid(Rect R)
    {
      Point P1=DeviceToGrid(R.TopLeft());
      Point P2=DeviceToGrid(R.BottomRight());
      Rect NR(P1,P2);
      return NR;
    }

  void GetColors(VideoAtt Att, Byte& Back, Byte& Bright, Byte& Dark)
    {
      Back=Att.Background();
      if (CurVideoDevice->FullColor())
        {
          Bright=White;
          Dark=Black;
          if ((Back==White) || (Back==Black))
            {
              Bright=Gray;
              Dark=DkGray;
            }
          else if (Back<8) Bright=Back+8;
          else Dark=Back-8;
        }
      else
        {
          Bright=!Back;
          Dark=Bright;
        }
    }

  void GetColors(VideoAtt Att, Byte& Bright, Byte& Dark)
    {
      Byte Back;
      GetColors(Att,Back,Bright,Dark);
    }

  Byte BrightColor(VideoAtt Att)
    {
      Byte Bright,Dark;
      GetColors(Att,Bright,Dark);
      return Bright;
    }

  Byte DarkColor(VideoAtt Att)
    {
      Byte Bright,Dark;
      GetColors(Att,Bright,Dark);
      return Dark;
    }

  Rect LogicalWindow::LocalDeviceRect()
    {
      Rect R(0,0,WR.Wide(),WR.High());
      return R;
    }

  Rect LogicalWindow::DeviceRect()
    {
      Rect R(DeviceX(),DeviceY(),WR.Wide(),WR.High());
      return R;
    }

  fontRec* CurFont=NULL;

  void ResetDefaultFont() {CurFont=NULL;}

#endif  // UseGraphics

#ifdef UseMouse

  Point LogicalWindow::DeviceMousePos()
    {
      int X,Y,C,B;
      QueryCursor(&X,&Y,&C,&B);
      Point P=(Point(X,Y)-Point(DeviceRectA()));
      return P;
    }

  Point LogicalWindow::MousePos()
    {
      return DeviceToGrid(DeviceMousePos());
    }

  void LogicalWindow::SetDeviceMousePos(Point P)
    {
      P+=Point(WR);
      MoveCursor(P.X(),P.Y());
    }

  void LogicalWindow::SetMousePos(Point P)
    {
      P=GridToDevice(P);
      SetDeviceMousePos(P);
    }

  int LogicalWindow::MouseX()
    {
      int X,Y,S;
      ReadMouse(&X,&Y,&S);
      X/=GridCellWide();
      X=X-this->X()+2;
      return X;
    }

  int LogicalWindow::MouseY()
    {
      int X,Y,S;
      ReadMouse(&X,&Y,&S);
      Y/=GridCellHigh();
      Y=Y-this->Y()+2;
      return Y;
    }

#endif

//.parse

DefaultAttRec* LogicalWindow::ActiveDefAtt()
  {
    LogicalWindow* W=this;
    while ((W->DefAtt)==NULL) W=W->Parent;
    return W->DefAtt;
  }

//.parse

void LogicalWindow::MakeDefAtt()
  {
    if (DefAtt==NULL)
      {
        DefAtt=new DefaultAttRec;
        *DefAtt = *(Parent->ActiveDefAtt());
      }
  }

//.parse

static void WordWrap(char** P, char* Buf, int& Lines, String& S,int& Wide)
  {
    int X=S.Index('|');  // X will be the wrap width decider.
    if (X==NotFound) X=Min(int(50),S.Length());
    else S[X]=' ';  // remove bar
    { // reduce all double spaces to one
      int SX;
      while((SX=S.Index("  "))!=NotFound) S.Delete(SX);
    }
    S.Trim();  // remove any leading or trailing spaces
    strcpy(Buf,S); // copy the string to Buf
    int Remaining=S.Length();  // how much of the string is left
    char* BP=Buf;  // Buf Pointer for the current line
    while (Remaining>0)
      {
        P[Lines]=BP;
        int I;
        if (Remaining>X)
          {
            I=X; // Index to wrap point
            while(BP[I]!=' ') I--;
            BP[I]='\0';
          }
        else I=Remaining;
        Wide=Max(Wide,I);
        I++;
        BP+=I;
        Remaining-=I;
        Lines++;
      }
  }

Window* MakeWinOText(LogicalWindow& PW,const char* St,int X,int Y,VideoAtt Att,int MinWide)
  {
    int Wide=MinWide; // Wide will be the final width
    int Lines=0;
    String S=St;
    int Margin=0;
    while(S(Margin)==' ') Margin++;
    if (Margin) S.Delete(0,Margin);
    char* PBuf[24];
    char** P=PBuf;  // pointers to each line
    char* Buf=new char[S.Length()+1];
    if (S(0)=='|') // use word wrap
      {
        S.Delete(); // remove leading |
        WordWrap(P,Buf,Lines,S,Wide);
      }
    else if (S.Index('|')==NotFound)  // one constant line
      {
        if (S.Length()>79-(Margin*2)) WordWrap(P,Buf,Lines,S,Wide);
        else
          {
            Wide=Max(Wide,int(strlen(St)));
            strcpy(Buf,S);
            P[0]=Buf;
            Lines=1;
          }
      }
    else // there are lots of bars
      {
        delete Buf;
        P=ConvertStringToArray(S);
        Buf=(char*)P;
        Lines=StringArrayLen(P);
        int L;
        For(L,Lines) Wide=Max(Wide,int(strlen(P[L])));
      }
    Wide+=(Margin*2);
    if (Att==0) Att=PW.DialogAtt();
    Window* W=new Window(PW,X,Y,Wide,Lines+4,Att);
    int I;
    For(I,Lines) W->Display(P[I],Center,2+I);
    delete Buf;
    return W;
  }

//.parse

void LogicalWindow::DialogBox(const char* St,int X,int Y,VideoAtt Att)
  {
    char* PressAnyKey="Press any key to continue";
    int Wide=strlen(PressAnyKey);
    if (Att==UseDefaultAtt) Att=DialogAtt();
    Window* W=MakeWinOText(*this,St,X,Y,Att,Wide);
    W->Display(PressAnyKey,Center,W->High()-1);
    #ifdef UseMouse
      if (WaitForKeypress().Mouse()) WaitForMouseClear();
    #else
      WaitForKeypress();
    #endif
    delete W;
  }

//.parse

void LogicalWindow::Warning(const char* Str,int X,int Y,VideoAtt Att)
  {
    Beep(3);
    if (Att==0) Att=PanicAtt();
    DialogBox(Str,X,Y,Att);
  }

#ifndef UseGraphics

  ScreenPtrType Screen1;
  ScreenPtrType Screen2;

#endif

//.parse

void LogicalWindow::Display(const char *Str,int X, int Y, VideoAtt Att)
  {
    Touch();
    if (Att==0) Att=WAtt;
    #ifdef UseGraphics
      if (CurFont!=Font)
        {
          SetFont(Font);
          CurFont=Font;
        }
      int StrWide=strlen(Str)*GridCellWide();
      if (X==Center) X = ((DeviceWide()-StrWide)/2);
      else if (X==Right) X = DeviceWide()-StrWide;
      else if (X==Curs) X=GridToDeviceX(TextCursorPos().X());
      else X=GridToDeviceX(X);
      X+=DeviceXA();

      if (Y==Curs) Y=GridToDeviceY(TextCursorPos().Y());
      else if (Y==Center) Y = ((DeviceHigh()-GridCellHigh())/2);
      else if (Y==Bottom) Y = (High()-1)*GridCellHigh();
      else Y=GridToDeviceY(Y);
      Y+=DeviceYA();

      MoveTo(X,Y);
      PreservePenState();
      BackColor(Att.Background());
      PenColor(Att.Foreground());
      PreserveMouseHideStatus(Off);
      DrawString((char*)Str);
    #else
      const char* CS=Str;
      while (*CS) CS++;
      int StrWide=int(CS-Str);
        //  the ansi function strlen() cannot cope with characters in the
        //  range of 128 to 255

      if (X==Center) X = ((Wide()-StrWide)/2)+1;
      else if (X==Left) X=1;
      else if (X==Right) X = Wide()-StrWide+1;
      else if (X==Curs) X=TextCursorPos().X();
      X+=XA()-2;

      if (Y==Curs) Y=TextCursorPos().Y();
      else if (Y==Center) Y = High()/2+1;
      else if (Y==Bottom) Y = High();
      else if (Y==Top) Y=1;
      Y+=YA()-2;

      Byte* Screen=Root->ScreenMemoryPos();
      Screen+=X*2+Y*160;
      while (*Str)
        {
          *Screen=*Str;
          Str++;
          Screen++;
          *Screen=Byte(Att);
          *Screen++;
        }
    #endif
  }

//.parse

int LogicalWindow::AutoX(int Wide)
  {
    Root->Touch();
    int ScreenWide=Root->Wide();
    int NewX=(TextCursorPos().X()+X()-1)-(Wide/4);
    if (NewX<1) NewX=2;
    if (NewX+Wide>=ScreenWide) NewX=ScreenWide-Wide;
    return(NewX);
  }

//.parse

int LogicalWindow::AutoY(int High)
  {
    Root->Touch();
    int ScreenHigh=Root->Wide();
    int NewY=TextCursorPos().Y()+Y()-1;
    if (NewY>=ScreenHigh/2)
      {
        NewY=NewY-High-2;
        if (NewY<3) NewY=3;
      }
    else
      {
       NewY+=2;
       if (NewY+High>ScreenHigh) NewY=ScreenHigh-High;
      }
    return(NewY);
  }

//.parse

void LogicalWindow::Draw(const Rect& R, VideoAtt A)
  {
    Touch();
    #ifdef UseGraphics
      if (A==UseDefaultAtt) A=WAtt;
      PreservePenState();
      PenColor(A.Foreground());
      rect r=R+Point(DeviceRectA());
      FrameRect(&r);
    #else
      DrawLine(R.TopLeft(),R.TopRight(),A);
      DrawLine(R.TopRight(),R.BottomRight(),A);
      DrawLine(R.TopLeft(),R.BottomLeft(),A);
      DrawLine(R.BottomLeft(),R.BottomRight(),A);
      Display("\x0da",R.Left(),R.Top(),A);
      Display("\x0c0",R.Left(),R.Bottom(),A);
      Display("\x0bf",R.Right(),R.Top(),A);
      Display("\x0d9",R.Right(),R.Bottom(),A);
    #endif
  }

//.parse

void LogicalWindow::DrawLine(Point P1, Point P2, VideoAtt A)
  {
    Touch();
    if (A==UseDefaultAtt) A=WAtt;
    #ifdef UseGraphics
      PreservePenState();
      PenColor(A.Foreground());
      P1+=Point(DeviceRectA());
      P2+=Point(DeviceRectA());
      MoveTo(P1.X(),P1.Y());
      LineTo(P2.X(),P2.Y());
    #else
      if (P1.X()==P2.X())  // if vert line
        {
          int Y=Min(P1.Y(),P2.Y());
          int YMax=Max(P1.Y(),P2.Y());
          while (Y<=YMax)
            {
              Display("\x0b3",P1.X(),Y,A);
              Y++;
            }
        }
      else  // horz line
        {
          int Len=Abs(P1.X()-P2.X())+1;
          Display(StringOf(Len,196),Min(P1.X(),P2.X()),P1.Y(),A);
        }
    #endif
  }

void LogicalWindow::DrawLine(int X1,int Y1,int X2,int Y2,VideoAtt A)
  {
    DrawLine(Point(X1,Y1),Point(X2,Y2),A);
  }

#ifdef UseGraphics

  void LogicalWindow::DrawLineTo(Point P)
    {
      Touch();
      P+=Point(DeviceRectA());
      LineTo(P.X(),P.Y());
    }

#endif

//.parse

void LogicalWindow::Fill(const Rect& R, char Ch, VideoAtt A)
  {
    Touch();
    int Y;
    for (Y=R.Top();Y<=R.Bottom();Y++)
      Display(StringOf(R.Wide(),Ch),R.X(),Y,A);
  }

//.parse

void LogicalWindow::Paint(const Rect& R, VideoAtt A)
  {
    #ifdef UseGraphics
      Touch();
      if (A==UseDefaultAtt) A=WAtt;
      PreservePenState();
      PenColor(A.Foreground());
      BackColor(A.Background());
      rect r=R+Point(DeviceRectA());
      PreserveMouseHideStatus(Off);
      PaintRect(&r);
    #else
      Fill(R,' ',A);
    #endif
  }

#ifdef UseGraphics

  void LogicalWindow::DeviceColorBox(Rect R, VideoAtt Att)
    {
      PreservePenState();
      if (Att==0) Att=WAtt;
      PenColor(Att.Foreground());
      BackColor(Att.Background());
      Paint(R);
    }

  void LogicalWindow::DeviceColorBox(int X, int Y, int Wide, int High, VideoAtt Att)
    {
      DeviceColorBox(Rect(X,Y,Wide,High),Att);
    }

#endif

//.parse

void LogicalWindow::ColorBox(Rect R, VideoAtt Att)
  {
    #ifdef UseGraphics
      DeviceColorBox(GridToDevice(R),Att);
    #else
      Paint(R,Att);
    #endif
  }

void LogicalWindow::ColorBox(int X, int Y, int Wide, int High, VideoAtt Att)
  {
    ColorBox(Rect(X,Y,Wide,High),Att);
  }

//.parse

void LogicalWindow::DrawBox(Rect R,VideoAtt Att)
  {
    Root->Touch();
    #ifdef UseGraphics
      PreservePenState();
      PenColor(Att.Foreground());
      R=GridToDevice(R);
    #endif
    Draw(R,Att);
  }

void LogicalWindow::DrawBox( int X, int Y, int Wide, int High,VideoAtt Att)
  {
    DrawBox(Rect(X,Y,Wide,High),Att);
  }

#ifdef UseGraphics

  void LogicalWindow::DeviceClearBox(Rect R, VideoAtt Att)
    {
      Touch();
      PreservePenState();
      if (Att)
        {
          WAtt=Att;
          if (IsAWindow)  // then re-color in the inner border
            {
              R.Swell(2);
              PreservePenState();
              PenColor(Att.Background());
              PreserveMouseHideStatus(Off);
              Draw(R);
              R.Shrink();
              Draw(R);
              R.Shrink();  // now we're back to the size we started from
            }
        }
      BackColor(WAtt.Background());
      Fill(R);
    }

  void LogicalWindow::DeviceClearBox(int X, int Y, int Wide, int High, VideoAtt Att)
    {
      DeviceClearBox(Rect(X,Y,Wide,High),Att);
    }

#endif

//.parse

void LogicalWindow::ClearBox(int X, int Y, int Wide, int High, VideoAtt Att)
  {
    #ifdef UseGraphics
      DeviceClearBox(GridToDevice(Rect(X,Y,Wide,High)),Att);
    #else
      if (Att) WAtt=Att;
      Paint(Rect(X,Y,Wide,High));
    #endif
  }

void LogicalWindow::Clear(VideoAtt A)
  {
    ClearBox(1,1,Wide(),High(),A);
  }

//.parse

VideoAtt ReverseAtt(VideoAtt A)
  {
    VideoAtt V=VAtt(BColor(A),FColor(A));
    return V;
  }

//.parse

static const char* GrindStr[]={"/","-","\\","|"};
static int GrindIndex=0;

void LogicalWindow::Grind(const char* C)
  {
    if (C==NULL)
      {
        GrindIndex++;
        if (GrindIndex>3) GrindIndex=0;
        C=GrindStr[GrindIndex];
      }
    Display(C,GrindPos);
  }

void LogicalWindow::StepGrind()
  {
    Grind("\x10");
    GrindPos.SetY(GrindPos.Y()+1);
    Grind();
  }
