#include <dos.h>
#include <WWEdit.h>
#include <WFile.h>
#include <WWMenu.h>
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

// this is my "test suite" where I press the extremes of my libraries
// to make sure that any changes I make won't effect other parts of
// the library

void EEE(LogicalWindow& W,LogicalWindow& WX,int Y)
  {
    WX.Display("Edit a Str :",2,Y);
    String S="doo dah";
    EditStringRec ESR(WX,S,60,Point(14,Y));
    ESR.Activate();
    W.Display(String('>')+S+'<',1,4+Y);
  }

void TestEdit(LogicalWindow& W)
  {
    Window WX(*VideoDevice1,2,15,75,6,VAtt(Blue,Gray));
    WX.Display("Edit a Word:",2,1);
    Long Num=200000000L;
    WX.Edit(Num,14,1,10);
    double D=double(Num);
    if (D<0.0) D+=4294967296.0;
    W.Display(DStr(D),1,4);
    WX.Display("Edit a Real:",2,2);
    double Num2=0.0;
    W.Display(Form("######.######",Num2),1,5);
    EditNumRec ENR2(WX,Num2,Point(14,2),2,5);
    ENR2.SetAllowNegatives();
    ENR2.Activate();
    W.Display(Form("######.######",Num2),1,6);
    ENR2.Activate();
    W.Display(Form("######.######",Num2),1,7);
    for(int I=3; I<7; I++) EEE(W,WX,I);
  }

void HotTest()
  {
    VideoDevice1->DialogBox("Hot Key Test");
  }

void ClearTest(Window& W)
  {
    W.Display("will the right most pixels get cleared? ",1,1,VAtt(Black,Gray));
    WaitForKeypress();
    W.Clear();
    WaitForKeypress();
  }

void ShowTest()
  {
    Window W(*VideoDevice1,10,10,70,15,VAtt(Black,BlueGreen));
    BitVector KeySet;
    W.ShowTextFile("t.c",KeySet);
  }

void SuperMenu()
  {
    String XXX="first   first first first first first first first first first first first first|";
    String S="second  second second second second second second second second second second second second|";
    XXX+=S;
    S="third   third third third third third third third third third third third third|";
    XXX+=S;
    S="fourth  fourth fourth fourth fourth fourth fourth fourth fourth fourth fourth fourth fourth|";
    XXX+=S;
    S="fifth   fifth fifth fifth fifth fifth fifth fifth fifth fifth fifth fifth fifth|";
    XXX+=S;
    S="sixth   sixth sixth sixth sixth sixth sixth sixth sixth sixth sixth sixth sixth|";
    XXX+=S;
    S="seventh seventh seventh seventh seventh seventh seventh seventh seventh seventh seventh |";
    XXX+=S;
    S="eighth  eighth eighth eighth eighth eighth eighth eighth eighth eighth eighth eighth eighth|";
    XXX+=S;
    S="ninth   ninth ninth ninth ninth ninth ninth ninth ninth ninth ninth ninth ninth|";
    XXX+=S;
    S="tenth   tenth tenth tenth tenth tenth tenth tenth tenth tenth tenth tenth tenth|";
    XXX+=S;
    S="eleventh eleventh eleventh eleventh eleventh eleventh eleventh eleventh eleventh eleventh|";
    XXX+=S;
    S="twelfth twelfth twelfth twelfth twelfth twelfth twelfth twelfth twelfth twelfth twelfth twelfth twelfth|";
    XXX+=S;
    S="thirteenth thirteenth thirteenth thirteenth thirteenth thirteenth thirteenth thirteenth thirteenth thirteenth|";
    XXX+=S;
    S="fourteenth fourteenth fourteenth fourteenth fourteenth fourteenth fourteenth fourteenth fourteenth fourteenth|";
    XXX+=S;
    S="fifteenth fifteenth fifteenth fifteenth fifteenth fifteenth fifteenth fifteenth fifteenth fifteenth fifteenth|";
    XXX+=S;
    S="sixteenth sixteenth sixteenth sixteenth sixteenth sixteenth sixteenth sixteenth sixteenth sixteenth sixteenth|";
    XXX+=S;
    S="seventeenth seventeenth seventeenth seventeenth seventeenth seventeenth seventeenth seventeenth seventeenth|";
    XXX+=S;
    S="eighteenth eighteenth eighteenth eighteenth eighteenth eighteenth eighteenth eighteenth eighteenth eighteenth|";
    XXX+=S;
    S="nineteenth nineteenth nineteenth nineteenth nineteenth nineteenth nineteenth nineteenth nineteenth nineteenth|";
    XXX+=S;
    S="twentieth twentieth twentieth twentieth twentieth twentieth twentieth twentieth twentieth twentieth twentieth|";
    XXX+=S;
    S="twenty-first twenty-first twenty-first twenty-first twenty-first twenty-first twenty-first twenty-first|";
    XXX+=S;
    S="twenty-second twenty-second twenty-second twenty-second twenty-second twenty-second twenty-second|";
    XXX+=S;
    S="twenty-third twenty-third twenty-third twenty-third twenty-third twenty-third twenty-third twenty-third|";
    XXX+=S;
    S="twenty-fourth twenty-fourth twenty-fourth twenty-fourth twenty-fourth twenty-fourth twenty-fourth ";
    XXX+=S;
    static int VAA[]={LtBlue,LtGreen,LtBlueGreen,Red,LtBlue,LtGreen,LtBlueGreen,Red,LtBlue,LtGreen,
        Gray,Gray,Gray,Gray,Gray,Gray,Gray,Gray,Gray,Gray,Gray,Gray,Gray,Gray,
        Gray,Gray,Gray,Gray,Gray,Gray,Gray};
    PartyMenuRec MMM(*(LogicalWindow*)VideoDevice1,XXX,VAA,"Some Title");
    MMM.Split(2,2);
    MMM.Activate();
    MMM.Close();
    int C=1;
    VideoDevice2->BarMenu(C,"First|Second|Third|Fourth|Fifth|Sixth");
    char* XXX2="first first first|second second second|third third third|fourth fourth fourth";//|fifth|sixth|7777|8888|9999|ten";
    PartyMenuRec PMR(*VideoDevice1,XXX2,VAA,NULL,1,Center,Center,10,3);
    PMR.Show();
    PMR.Activate();
    #ifdef UseGraphics
      int Choice=1;
      ByteVector Pats(12,13,14,15,22,26,27,30,31);
      PatternMenu(*VideoDevice1,Choice,Pats);
      Pats+=ByteVector(2,3,4,5,8,9,10,11,18);
      Pats+=ByteVector(6,7,16,28,29,25);
      int P=5;
      VideoDevice1->PickPattern(Pats,P,C);
    #endif
  }

extern unsigned _stklen=32000;

int main()
  {
    RootWindow RootWin(AutoDetect,VAtt(Black,Gray));
    RootWin.BlinkAtt(Off);
    InitHotKey(F4Key,HotTest);
    RootWin.Display("F4 installed as a Hot Key",1,Bottom);
    char* DBS=" two all beef patties|special sauce|lettuce|cheese|pickles|"
        "onions|on a sesame seed bun";
    RootWin.DialogBox(DBS);
    #ifdef UseMouse
      HideCursor();
    #endif
    SuperMenu();
    //RootWin.Display("Window 1",1,3);
    //RootWindow RootWin2(HER);
    //RootWin2.Display("Window 2",1,Bottom);
    //RootWin.Display("I'm baaaak!",1,4);
    Window W(*VideoDevice2,5,5,40,10,VAtt(Black,Purple),"A Window Title");
    ClearTest(W);


    int Choice=5;
    W.ColorMenu();
    char* S="First|Second|Third|Fourth|Fifth|Sixth|Seventh|"
             "Eighth|Ninth|Tenth|Eleventh|Twelfth|13|14|15|16|17|18";
    {
    MenuRec M1(RootWin,S,"Some Title",Choice,30,Center,0,5);
    M1.Show();
    M1.Activate();
    MenuRec M2(*VideoDevice1,S,NULL,Choice,35);
    M2.Show();
    M2.Activate();
    M2.Hide();
    M1.Activate();
    M2.Show();
    M2.Activate();
    }
    W.Menu(Choice,S,"Some Title",Center,Center,0,5);
    W.Display(Str(Choice));
    #ifdef UseMouse
      PreserveMouseHideStatus(On);
    #endif

    RootWin.Display("test",1,1,VAtt(Yellow,Blue));
    RootWin.Display(Form("#.####",5.0/8),1,2,VAtt(Yellow,Blue));
    VideoAtt MAtt=VAtt(Black,BlueGreen);
    RootWin.EditAtt(MAtt);
    BitVector BitVec;
    W.MultiMenu(BitVec,"First|Second|Third|Fourth|Fifth|Sixth|Seventh|Last");
    W.Display(Str(BitVec.Size())+' ');
    ByteVector ByteVec;
    W.OrderedMenu(ByteVec,"First|Second|Third|Fourth|Fifth|Sixth|Seventh|"
        "Eighth|Ninth|Tenth|Eleventh|Twelfth|13|14|15|16|17|18|19|20|21|22|Last","Title",Choice,Center,Center);
    W.Display(Str(ByteVec.Size()),1,2);
    W.Display(Str(Choice),1,3);
    int C=2;
    W.BarMenu(C,"First|Second|Third|Fourth");
    W.Display(Str(C),1,4);
    TestEdit(W);
    Bool YN=Yes;
    W.YesNoBox(YN,"Do you want|a cookie?");
    W.Close();
    ShowTest();
    WaitForKeypress();
    return (0);
  }


