#ifndef _WSND_H
#define _WSND_H

#define FULLVOLUME 0xffff
#define THREEQUARTERVOLUME 0xBFFD
#define HALFVOLUME 0x7FFE
#define ONEQUARTERVOLUME 0x3FFF
#define NOVOLUME 0x0000

typedef enum {NoWaveError, NoWaveMemAlloc, NoWaveMemLock, WaveFileNotOpened,
							NotWaveFile, WaveFormatNotRead, NotWavePCMFile, WaveGenericError,
							WaveDeviceCantPlayFormat, WaveFileHasNoDataChunk,
							WaveDeviceNotOpened, NoWaveDataChunk, WaveOutPrepareHeaderError,
							WaveOutWriteError, WaveOutGetDevCapsError, WaveOutSetPlaybackRateError,
							WaveOutSetVolumeError, WaveOutGetVolumeError, WaveOutGetPitchError,
							WaveOutSetPitchError, WaveOutGetPlaybackRateError, WaveFileCorrupted
						 } WAVEERRORTYPE;

typedef enum {StereoMonoNotSet, StereoOutput, MonoOutput} CHANNELS;

#ifdef __cplusplus
extern "C" {
#endif
void CALLBACK SetWaveLoops (DWORD Loops);
void CALLBACK ResetWaveLoops (void);
WAVEERRORTYPE CALLBACK GetLastWaveError(void);
UINT CALLBACK GetLastDeviceResult (void);
UINT CALLBACK GetWaveDeviceID(void);
DWORD CALLBACK SetWaveVolume(WORD wVolume);
DWORD CALLBACK SetWaveVolumeEx(WORD wLeft, WORD wRight);
DWORD CALLBACK  SetWavePlaybackRate(DWORD dwRate);
DWORD CALLBACK SetWavePlaybackRateEx(WORD IntPart, WORD FracPart);
DWORD CALLBACK SetWavePitch(DWORD dwPitch);
DWORD CALLBACK SetWavePitchEx(WORD IntPart, WORD FracPart);
UINT CALLBACK GetWaveManufacturerID(void);
UINT CALLBACK GetWaveProductID(void);
VERSION CALLBACK GetWaveDriverVersion(void);
void CALLBACK GetWaveProductName (LPSTR lpStr);
DWORD CALLBACK GetWaveDeviceFormat(void);
CHANNELS CALLBACK GetWaveChannel(void);
BOOL CALLBACK GetWaveSupportPitch(void);
BOOL CALLBACK GetWaveSupportPlaybackRate(void);
BOOL CALLBACK GetWaveSupportVolume(void);
BOOL CALLBACK GetWaveSupportSeparateVolume(void);
void CALLBACK RemoveWave (HGLOBAL hWaveInst);
BOOL CALLBACK PlayWave(HGLOBAL hWaveInst);
HGLOBAL CALLBACK MakeWave(HWND hwnd, LPSTR szFileName);
void CALLBACK WaveStop(void);
void CALLBACK WavePause(void);
void CALLBACK WaveRestart(void);
HWAVEOUT CALLBACK GetWaveHandle(void);
#ifdef __cplusplus
}
#endif

#endif

