#pragma option -zESCORESFAR
#pragma option -zFFAR_DATA
/*
  Ŀ
 ݳ                                                                         
 ݳ SCORES.EXE                                                              
 ݳ                                                                         
 ݳ AUTHOR: Jay Perez                                                       
 ݳ                                                                         
 ݳ COMPUSERVE ID: 75030,3613                                               
 ݳ                                                                         
 ݳ PROGRAM: LOTUS.CPP                                                      
 ݳ                                                                         
 ݳ LANGUAGE: C++                                                           
 ݳ                                                                         
 ݳ DESCRIPTION:  Public domain...                                                                                                                   
 ݳ                                                                         
 ݳ     Caution: This program:                                              
 ݳ                                                                         
 ݳ         1. Creates a spreadsheet in .WK1 format.                        
 ݳ         2. Sets column widths.                                          
 ݳ         3. Writes an integer, a double, or a charater string to a cell. 
 ݳ                                                                         
 ݳ                                                                         
 ݳ     It's pretty easy...                                                 
 ݳ                                                                         
 ݳ     Step1:                                                              
 ݳ     Just call the constructor like:                                     
 ݳ          wk1 Siva("MA.WK1);                                             
 ݳ                                                                         
 ݳ     Step2:                                                              
 ݳ     Check if file was created:                                          
 ݳ          if (!Siva.WorkSheetOK())                                       
 ݳ               return;                                                   
 ݳ                                                                         
 ݳ     Step3:                                                              
 ݳ     If there's a need, change the column widths:                        
 ݳ                                                                         
 ݳ          Siva.SetColumnWidth( 0, 11 ); ( first column set to 11 wide )  
 ݳ          Siva.SetColumnWidth( 1, 21 ); ( second column set to 21 wide ) 
 ݳ          Siva.SetColumnWidth( 2, 21 ); ( third column set to 21 wide )  
 ݳ                                                                         
 ݳ     Step4:                                                              
 ݳ     Select a column and a row and write a value to a cell:              
 ݳ                                                                         
 ݳ          Siva.WriteCell( "DOUBLE HEADER", 'L', 1, 1 );  // writing text    
 ݳ          Siva.WriteCell( "INTEGER HEADER", 'L', 1, 2 );  // writing text       
 ݳ                                                                         
 ݳ          The "L" = Left justified...                                    
 ݳ          A "R" would =  right justification...                          
 ݳ          A "C" would =  center justification...                         
 ݳ          A "^" would =  repeating string...                             
 ݳ                                                                         
 ݳ          Siva.WriteCell( 1008.108, 2, 1, CURRENCY | TwoDecimals);       
 ݳ                                                                         
 ݳ          Siva.WriteCell( 108, 2, 2, COMMA );   // writing an integer    
 ݳ                                                                         
 ݳ     Format options: COMMA, CURRENCY, PERCENT, FIXED                     
 ݳ                                                                         
 ݳ     Any one of the above may be combined with the following:            
 ݳ                                                                         
 ݳ              OneDecimals, TwoDecimals, ThreeDecimals, etc.              
 ݳ                                                                         
 ݳ                                                                         
 ݳ  If you want to add functionality to this program please do so and      
 ݳ  share it.  Please notify me.  Included are a set of LOTUS CORP. public 
 ݳ  domain notes on .WK* files.                                            
 ݳ                                                                         
 ݳ                                                                         
 
 
 */

#include <tv.h>

#include <string.h>
#include <fstream.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include "lotus.h"

/*
main()
{
	 wk1 Siv("MA.WK1");             // Call the constructor

	 Siv.SetColumnWidth( 0, 11 );   // Set column widths (if necessary)
	 Siv.SetColumnWidth( 1, 21 );
	 Siv.SetColumnWidth( 2, 21 );

	 Siv.WriteCell( "DOUBLE HEADER",   // a string (or label in lotus parlance)
							'R',          // Right justified
							1,            // row
							1 );          // column

	 Siv.WriteCell( "INTEGER HEADER",      // a string (or label in lotus parlance)
							'R',          // Right justified
							1,            // row one, (2nd row - starts with zero)
							2); 		     // column two, (third column)

	 Siv.WriteCell( 1008.108,       // a double number
							2,            // row (the third row)
							1,            // column (the second column)
							COMMA | ThreeDecimals );  // format

	 Siv.WriteCell( 108.1008,       // a double number
							3,            // row (the third row)
							1,            // column (the second column)
							CURRENCY | TwoDecimals ); // format

	 Siv.WriteCell( 108,            // an integer number
							2,            // row
							2             // column
							CURRENCY );   // FORMAT

	 return;

}
*/

//
//=== Write a double ======================================================
//
void wk1::WriteCell( double number, int row, int col, char format )
{
	 if( !wk1WorkSheet )
		  return;

	 // Number Cell Header, 4 bytes

	 wk1WorkSheet->write( WKS_NUMBERHDR, 4 );

	 // cell format, 1 char

	 wk1WorkSheet->write( &format, 1 );
	 //wk1WorkSheet->write( STANDARD_FORMAT, 1 );

	 // Worksheet Co-Ordinates, 4 bytes

	 WriteCellCoordinates( row, col );


	 // The number, 8 bytes

	 char * ptr = (char *) &number;

	 wk1WorkSheet->write( ptr, 8 );

	 return;
}

//
//=== Write an integer ====================================================
//
void wk1::WriteCell( int number, int row, int col, char format )
{
	 if( !wk1WorkSheet )
		  return;

	 // Number Cell Header, 4 bytes

	 wk1WorkSheet->write( WKS_INTEGER, 4 );

	 // cell format, 1 char

	 wk1WorkSheet->write( &format, 1 );

	 // Worksheet Co-Ordinates, 4 bytes

	 WriteCellCoordinates( row, col );

	 // The number, 8 bytes

	 char * ptr = (char *) &number;

	 wk1WorkSheet->write( ptr, 2 );

	 return;
}

//
//=== Write a character string ============================================
//
void wk1::WriteCell( char *ostr, char just, int row, int col )
{
	 if( !wk1WorkSheet )
		  return;

	 just = toupper( just );

	 ostr = rtrim( ostr );

	 // if ostr is blank, return

	 if (!strlen(ostr))
		  return;

	 int len = strlen(ostr);

	 if (len>255)
		  return;

	 // Text label header, 2 bytes

	 wk1WorkSheet->write( WKS_LABELHDR, 2 );

	 // Text Label length, 2 bytes

	 char LabelLength[2];
	 LabelLength[0]=(len+7)%256;
	 LabelLength[1]=(len+7)/256;

	 int rem = LabelLength[0]=(len+7)%256;
	 int div = LabelLength[1]=(len+7)/256;

	 wk1WorkSheet->write( LabelLength, 2 );

	 // default cell format, 1 char //

	 wk1WorkSheet->write( STANDARD_FORMAT, 1 );

	 // cell co-ordinates, 4 bytes total ( numbers in reverse byte format ! )

	 WriteCellCoordinates( row, col );

	 // Justification, 1 char

	 switch( just ){
	 case 'R':
		  wk1WorkSheet->write( RIGHT_JUSTIFY, 1 );
		  break;
	 case 'L':
		  wk1WorkSheet->write( LEFT_JUSTIFY, 1 );
		  break;
	 case 'C':
		  wk1WorkSheet->write( CENTERED, 1 );
		  break;
	 case '^':
		  wk1WorkSheet->write( REPEATING, 1 );
		  break;
	 }

	 // actual textual string, len(ostr) bytes

	 wk1WorkSheet->write( ostr, strlen(ostr)+1 );

	 return;
}

//
//=== write the coordinates. ==============================================
//
void wk1::WriteCellCoordinates( int row, int col )
{
	 LotusWord(col);
	 LotusWord(row);
}

//
// returns the lotus format of a number (lsb first)
//
void wk1::LotusWord(ushort mvalue){

	 char LabelLength[2];

	 LabelLength[0]=mvalue%256;
	 LabelLength[1]=mvalue/256;

	 int rem = LabelLength[0]=mvalue%256;
	 int div = LabelLength[1]=mvalue/256;

	 wk1WorkSheet->write( LabelLength, 2 );

}

//
//=== The constructor =====================================================
//
wk1::wk1( char *fileName)
{
	 wk1WorkSheet = new ofstream( fileName, ios::out | ios::binary );

	 if( wk1WorkSheet )
		  wk1WorkSheet->write( WKS_BOF, 6 );

	 return;

}

//
//=== The destructor ======================================================
//
wk1::~wk1( void )
{
	 if( wk1WorkSheet )
		  wk1WorkSheet->write( WKS_EOF, 4 );

	 if( wk1WorkSheet )
		  delete wk1WorkSheet;

	 wk1WorkSheet = NULL;

	 return;

}

//
//== Set width of specified column to width in file handle ================
//
void wk1::SetColumnWidth( int col, int width )
{
	 if( !wk1WorkSheet )
		  return;

	 wk1WorkSheet->write( "\x08" "\x00" "\x03" "\x00", 4 );

	 LotusWord(col);

	 char wid[2];
	 wid[0] = width;

	 wk1WorkSheet->write( wid, 1 );

}


//
/*
char *rtrim(char *string)
{
			int len = strlen(string) ;
			int x ;

			for(x = len-1; x >= 0; --x)
						if (string[x] == ' ')
										  string[x] = NULL;
						else break ;

			return(string);
}
*/
