/*  No need to assemble external code.  writef will give you extremely
    fast screen writes, in any color with any background.  It consists
    of only one small procedure (14 lines) written entirely in Turbo C.

    example:

     writef(5,4,0x17,"This demonstrates the speed fo writef");

            The above line will write the enclosed text on
          line 4, column 5 with a background color of 1 (blue)
          and a forground color of 7 (gray).  Using numbers greater
          than 7 for background will create blinking characters.


    This routine was developed by:
    			
                       Gemini Systems
                       Tom Hunter
                       P.O. Box 7086
                       Bloomfield Hills, Mi 48302




*/

#include <stdio.h>

int  i;

void writef(int x, int y, int attr, char line[80])
{
  const long vmode   = 0x00449lu;  /* video mode byte */
  int   i, j, scrseg, scrofs;

  if (7 == *((char far*) vmode))
    scrseg = 0xb000u;
  else
    scrseg = 0xb800u;
  j = strlen(line);
  for (i = 0; i < j; i++)
  {
    scrofs = (((y * 160) - 160) + (x * 2)) - 2;
    pokeb(scrseg, scrofs, line[i]);
    pokeb(scrseg, scrofs+1, attr);
    x++;
  }
  return;
}

main()
{

   for (i = 1; i < 20; i++)
     writef(5,i,0x4e,"This demonstrates the speed fo writef, by Gemini Systems.");
   exit(0);

}


