/* wpguess.c -- WordPerfect 5.1 password guesser  -- version 1.0
** Copyright 1992 by Raymond Gardner -- All rights reserved.
** written by Raymond Gardner -- Englewood, Colorado -- 7/92
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define coincidence_cutoff  5
#define maxkeylen           32
#define bufsz               (24*1024)

void confusion_mask(int keylen, char *buf, int cnt)
{
    while ( cnt-- )
        *buf++ ^= ++keylen;
}

void guess_password(char *buf, int bufcnt, int keylen)
{
    static long freq[maxkeylen+1][256];
    int c, i, j;
    long n;
    for ( j = i = 0; i + keylen < bufcnt; ++i )
        j += (buf[i] == buf[i+keylen]);
    if ( (n = j * 256L / bufcnt) >= coincidence_cutoff ) {
        printf("coincidence index: %2ld  probable key: ", n);
        memset(freq, 0, sizeof(freq));
        for ( i = 0; i < bufcnt; ++i )
            ++freq[i % keylen][255 & buf[i]];
        for ( i = 0; i < keylen; ++i ) {
            for ( n = j = 0; j < 256; ++j ) {
                if ( freq[i][j] > n ) {
                    n = freq[i][j];
                    c = j ^ ' ';
                }
            }
            putchar(isprint(c) ? c : '~');
        }
        putchar('\n');
    }
}

int main(int argc, char **argv)
{
    FILE *infile;
    static char buf[bufsz];
    int keylen, bufcnt;
    printf("%s\n%s\n%s\n\n",
        "WordPerfect 5.1 password guesser -- version 1.0",
        "Copyright 1992 by Raymond Gardner -- All rights reserved.",
        "Use and distribute freely WITH SOURCE CODE; no fee may be charged.");
    if ( argc < 2 ) {
        printf("Usage: wpguess filename\n");
    } else {
        printf("Highest coincidence index is most probable key.\n\n");
        infile = fopen(argv[1], "rb");
        if ( infile == NULL ) {
            printf("can't open file %s.\n", argv[1]);
        } else {
/***/       fread(buf, 1, 16, infile);
            bufcnt = fread(buf, 1, bufsz, infile);
            if ( bufcnt <= 48 ) {
                printf("input file bad or too short.\n");
            } else {
                for ( keylen = 1; keylen <= maxkeylen; ++keylen ) {
/***/               confusion_mask(keylen, buf, bufcnt);
                    guess_password(buf, bufcnt, keylen);
/***/               confusion_mask(keylen, buf, bufcnt);
                }
            }
        }
    }
    return 0;
}
