//----------------------------------------------------------------------------
//    Access / Softek  Wordprocessor Example
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\dc.h>
#include <owl\dialog.h>
#include <owl\framewin.h>
#include <owl\point.h>

#define VBXGEN_DATA
#define RIGHT_BUTTON 2

#include <pidoc1.h>
#include "wp4.rh"

const char AppName[] = "WP"; // Name of app, window title & icon resource id
//
// Client window class for the application
//
//  TWindow and TVbxEventHandler have TEventHandler as a base
//  so derivation is virtual

class TMyWindow : public virtual TWindow, public virtual TVbxEventHandler
{
  public:
	 TMyWindow( TWindow *parent, const char far *title );
	 ~TMyWindow();
  protected:
	 void SetupWindow();
	 void EvSize( UINT, TSize& );
	 void EvFileNew();
	 void EvFileOpen();
	 void EvFileSave();
	 void EvFileSaveAs();
	 void EvFilePrint();
	 void EvFileExit();

	 void EvEditCut();
	 void EvEditCopy();
	 void EvEditPaste();
	 void EvEditDelete();
	 void EvEditSelectAll();

	 void EvMouseUp( VBXEVENT far *);
	 void EvMouseDown( VBXEVENT far *);

	 TVbxPI_DocEdit *myWP;
	 TPoint lastClick;

  DECLARE_RESPONSE_TABLE( TMyWindow );
};

DEFINE_RESPONSE_TABLE2(TMyWindow,TWindow,TVbxEventHandler)
  EV_WM_SIZE,
  EV_COMMAND( CM_FILENEW, EvFileNew ),
  EV_COMMAND( CM_FILEOPEN, EvFileOpen ),
  EV_COMMAND( CM_FILESAVE, EvFileSave ),
  EV_COMMAND( CM_FILESAVE_AS, EvFileSaveAs ),
  EV_COMMAND( CM_FILEPRINT, EvFilePrint ),
  EV_COMMAND( CM_FILEEXIT, EvFileExit ),
  EV_COMMAND( CM_EDITCUT, EvEditCut ),
  EV_COMMAND( CM_EDITCOPY, EvEditCopy ),
  EV_COMMAND( CM_EDITPASTE, EvEditPaste ),
  EV_COMMAND( CM_EDITDELETE, EvEditDelete ),
  EV_COMMAND( CM_EDITSELECTALL, EvEditSelectAll ),
  EV_VBXEVENTNAME( PI_DocEdit,"MouseDown", EvMouseDown ),
  EV_VBXEVENTNAME( PI_DocEdit,"MouseUp", EvMouseUp ),
END_RESPONSE_TABLE;

TMyWindow::TMyWindow( TWindow *parent, const char far *title )
{
  TWindow::Init( parent, title, 0 );
  myWP = new TVbxPI_DocEdit( this, PI_DocEdit, "Word Processor",
					0, 0, 0, 0, sizeof(PI_DocEditData), PI_DocEditData );

}

TMyWindow::~TMyWindow()
{
	delete myWP;
}

void TMyWindow::SetupWindow()
{
  TRect rect;

  TWindow::SetupWindow();
  TWindow parent( GetParent( ) );  // get the parent
  parent.GetClientRect( rect );    // get the size of the TFrameWindow
  // size the client to the TFrameWindow
  myWP->MoveWindow( 0, 0, rect.Width(), rect.Height(), TRUE );
}

void TMyWindow::EvSize( UINT , TSize& size)
{
  myWP->MoveWindow( 0, 0, size.cx, size.cy, TRUE );
}

void TMyWindow::EvFileNew()
{
	if( ::MessageBox( GetParent(), "Save the file?", "Save?",
							 MB_OK | MB_ICONEXCLAMATION ) )
	{
		myWP->SetPropAction( TVbxPI_DocEdit::Action_Save_As );
	}
	myWP->SetPropAction( TVbxPI_DocEdit::Action_Clear );
}

void TMyWindow::EvFileOpen()
{
  myWP->SetPropAction( TVbxPI_DocEdit::Action_Open );
}

void TMyWindow::EvFileSave()
{
  myWP->SetPropAction( TVbxPI_DocEdit::Action_Save );
}

void TMyWindow::EvFileSaveAs()
{
  myWP->SetPropAction( TVbxPI_DocEdit::Action_Save_As );
}

void TMyWindow::EvFilePrint()
{
  myWP->SetPropAction( TVbxPI_DocEdit::Action_Print );
}

void TMyWindow::EvFileExit()
{
	 ::PostMessage( GetParent(), WM_CLOSE, 0, 0L );
}

void TMyWindow::EvEditCut( )
{
	 myWP->SetPropAction( TVbxPI_DocEdit::Action_Cut );
}

void TMyWindow::EvEditCopy( )
{
	 myWP->SetPropAction( TVbxPI_DocEdit::Action_Copy );
}

void TMyWindow::EvEditPaste( )
{
	 myWP->SetPropAction( TVbxPI_DocEdit::Action_Paste );
}

void TMyWindow::EvEditDelete( )
{
	 myWP->SetPropAction( TVbxPI_DocEdit::Action_Cut );
}

void TMyWindow::EvEditSelectAll( )
{
	 myWP->SetPropAction( TVbxPI_DocEdit::Action_SelectAll );
}

void TMyWindow::EvMouseUp( VBXEVENT far *event )
{
	 if( (VBX_EVENTARGNUM( event, int, 1 )) == RIGHT_BUTTON )
			if( lastClick == TPoint( VBX_EVENTARGNUM( event, int, 3 ), VBX_EVENTARGNUM( event, int, 4 ) ) )

				 TDialog( this, IDC_DIALOG1 ).Execute();
}

void TMyWindow::EvMouseDown( VBXEVENT far *event )
{
	 if( VBX_EVENTARGNUM( event, int, 1) == RIGHT_BUTTON )
		 lastClick = TPoint( VBX_EVENTARGNUM( event, int, 3 ),
									VBX_EVENTARGNUM( event, int, 4 ) );
}

class TWPApp : public TApplication
{
  public:
	 TWPApp(const char far* name) : TApplication(name) {}
	 ~TWPApp() {  }
	 void   InitMainWindow();
};

void
TWPApp::InitMainWindow()
{
  SetMainWindow( new TFrameWindow((TWindow *)0, Name, new TMyWindow(0,"hello"), FALSE ));

  GetMainWindow()->SetIcon(this, AppName);
  GetMainWindow()->AssignMenu(WP_MENU);
}

int
OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TBIVbxLibrary VbxLib;

  TWPApp    App(AppName);
  return App.Run();
}
