// words.h
// Author : Chris, 3/10/1993

#include "wordsid.h"
#include "wordsqre.h"
#include "wordlist.h"

const char WSQ_TITLE[] = "WordSquare (3.1) ";

// ================================================================
// Declare TWordsApp, a TApplication descendant
// ================================================================

class TWordsApp : public TApplication {
public:
		TWordsApp(const char far* AName)
			: TApplication(AName) {};
		virtual void InitMainWindow();
};


// ================================================================
// Declare TMyDialog, a TDialog descendant
// ================================================================
_CLASSDEF(TMyDialog)
class TMyDialog : public TDialog {
public :
	TMyDialog();

	~TMyDialog();

  virtual void SetupWindow();

  void SetCaption();

  virtual BOOL CanClose();

  virtual LPSTR GetClassName();
  virtual void GetWindowClass(WNDCLASS&);

  // Define how the buttons are to be handled
	void IDAddWord( WPARAM );
	void IDAmendWord( WPARAM );
//	void WMLBNDblClk();
//	void WMLBNDblClk( WPARAM );
	void IDDeleteWord( WPARAM );

	// Handle the List Box
	void HandleUser();
	void HandleListBoxMsg(UINT);

	// Define how the menu options are to be handled
	void CMOpen();
	void CMSave();
	void CMSaveAs();
	void CMNew();

	void CMCheckWordSquare();
	void CMWordsNotUsed();
	void CMLettersNotUsed();
	void CMOverusedLetters();

	void CMAbout();

	// Menu Command Enablers
	void EvCheckedTest(TCommandEnabler&);
	void EvNotCheckedTest(TCommandEnabler&);

	// Capture the Return key
	//	void WMReturn();

protected:
	void EvClose();

private:
	void ENChange();
	void Checked(BOOL);

	PTMyListBox ptLBWords;
	PWordSquare ptEdSquare;
	BOOL IsDirty, IsNewFile, IsChecked;
	TOpenSaveDialog::TData* FileData;

	char FileName[MAXPATH];
	char Title[MAXPATH];
	int aiWordUse[MAX_WORDS];

	void OpenFile();
	void SaveFile();
	void SaveFileAs();

DECLARE_RESPONSE_TABLE( TMyDialog );

};
