// ==================================================================
// file : words.cpp
// Word square implementation code
// ==================================================================

#include "comhdrs.h"
#pragma hdrstop

#include "utility.h"

#include "words.h"

// ================================================================
// Construct the TWordsApp's MainWindow of type TMyFileWindow
// ================================================================

void TWordsApp::InitMainWindow()
{
//	TWindow* wordWin = new TMyDialog();
//	MainWindow = new TFrameWindow(0, Name, wordWin, TRUE);
	SetMainWindow(new TFrameWindow(0, Name, new TMyDialog(), TRUE));
	MainWindow->Attr.Style &= ~(WS_MAXIMIZEBOX | WS_THICKFRAME);
	MainWindow->AssignMenu(WORDMENU);
	MainWindow->SetIcon(this,"ICON_1");
}

// =====================================================================
// Handle Dialogs Buttons
// =====================================================================

TMyDialog::TMyDialog()
	 : TWindow((TWindow*)0), TDialog(0,WORDSQUARE)
{
	FileData = new TOpenSaveDialog::TData(OFN_HIDEREADONLY|OFN_FILEMUSTEXIST,
								"Word Square Files (*.WSQ)|*.WSQ", 0, "", "WSQ");
	ptLBWords = new TMyListBox(this,LB_WORDS);
	ptEdSquare = new WordSquare(this,ED_SQUARE);
	IsDirty = FALSE;
	IsNewFile = TRUE;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
TMyDialog::~TMyDialog()
{
	delete ptLBWords;
	delete ptEdSquare;
	delete FileData;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::SetupWindow()
{
	TDialog::SetupWindow();
	Checked(FALSE);
	SetCaption();
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::IDAddWord( WPARAM )
{

	char newWord[MAX_WORD_SIZE] = "";

	while ( GetApplication()->ExecDialog(
			 new TInputDialog(this,"Add a Word","Enter new word:",
			 newWord, sizeof newWord)) == IDOK )
	{
		// Do the adding word work
		strRemCh(newWord,' ');
		if (strlen(newWord)>0)
		{
			toupper(newWord);
			if (ptLBWords->AddString(newWord) <0)
			{
	::MessageBox(HWindow, "Error adding word to list box!","System Error",MB_OK);
			}
			else
			{
	IsDirty=TRUE;
	Checked(FALSE);
      }
	 }
    else MessageBeep(0);

    newWord[0]='\0';
  }
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::HandleUser()
{
	int iSel=ptLBWords->GetSelIndex();

	if (iSel>=0)
		IDAmendWord(0);
	else
		IDAddWord(0);
}


// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::HandleListBoxMsg(UINT msg)
{
  switch (msg)
  {
	 case LBN_DBLCLK :
		HandleUser();
		break;
	 default :
		DefaultProcessing();
  }
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::IDAmendWord( WPARAM )
{

	int iSel=ptLBWords->GetSelIndex();
  char newWord[MAX_WORD_SIZE] = "";
  char achOldWord[MAX_WORD_SIZE] = "";

  if (iSel>=0)
  {
	 ptLBWords->GetSelString(newWord,MAX_WORD_SIZE);
    strcpy(achOldWord,newWord);
		if ( GetApplication()->ExecDialog(
	 new TInputDialog(this,"Amend a Word","Amend this word:",
	 newWord, sizeof newWord)) == IDOK )
    {
      // Do the amending word work
			strRemCh(newWord,' ');
      if (strlen(newWord)>0)
			{
	toupper(newWord);
	ptLBWords->DeleteString(iSel);
	if (ptLBWords->AddString(newWord) <0)
	{
		::MessageBox(HWindow, "Error adding word to list box!","System Error",MB_OK);
	}
	IsDirty=TRUE;
	Checked(FALSE);
      }
    }
  }
  else MessageBeep(0);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::IDDeleteWord( WPARAM )
{

	char ach[30];
	int iSel=ptLBWords->GetSelIndex();
	char achWord[MAX_WORD_SIZE];

	if (iSel>=0)
	{
		ptLBWords->GetSelString(achWord,MAX_WORD_SIZE);

		sprintf(ach,"Delete Word %s?",achWord);
		if (::MessageBox(HWindow, ach, "Are you sure?",
		   MB_YESNO)  == IDYES )
    {
      // Do the deleting word work
	ptLBWords->DeleteString(iSel);
	IsDirty=TRUE;
	Checked(FALSE);
	 }
  }
  else MessageBeep(0);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMOpen()
{
  if (CanClose())
		if ((TFileOpenDialog(this, *FileData)).Execute() == IDOK)
		{
			OpenFile();
			Checked(FALSE);
		}
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMSave()
{

  if (IsNewFile)
    SaveFileAs();
  else
    SaveFile();
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMSaveAs()
{
	SaveFileAs();
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMNew()
{

	if (CanClose())
	{
		// clear data?
		ptEdSquare->Clear();
    ptLBWords->ClearList();

	 // set flags
	 strcpy(FileData->FileName,"");
	 SetCaption();
	 IsDirty=FALSE;
    IsNewFile=TRUE;
	 Checked(FALSE);
  }
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMCheckWordSquare()
{

//  ::MessageBox(HWindow, "CWS Option selected","Hurrah!",MB_OK);
  int iNumWords = ptLBWords->GetCount();
  int i;
  int iWordLen;
	int ix,iy;
  char sThisWord[MAX_WORD_SIZE];

  for (i=0; i<iNumWords; i++)
	 aiWordUse[i]=0;

  for (i=0; i<iNumWords; i++)
  {
	 iWordLen=ptLBWords->GetString(sThisWord, i);
    aiWordUse[i]=0;
	 // For each word
    if (iWordLen>0)
    {
      ptLBWords->SetSelIndex(i);
		for (iy=0; iy<ptEdSquare->theHeight(); iy++)
		  for (ix=0; ix<ptEdSquare->theWidth(); ix++)
		  {
			 // Check x,y,word
			 if (ptEdSquare->pXYWordCheck(ix,iy,sThisWord))
			 {
				// Maintain information about number of times word is found
				aiWordUse[i]++;
			 }
		  }
	 }
  }
  ptLBWords->SetSelIndex(-1);
  Checked(TRUE);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMWordsNotUsed()
{

	char mess[MAX_SQUARE_SIZE];
  int i,iNumWords= ptLBWords->GetCount();
  BOOL init=FALSE;

#if DEBUG_ON == 1
  if (init)
  { DebugMsg("Init is TRUE %s.\n",""); }
	else
  { DebugMsg("Init is FALSE %s.\n",""); }
#endif

  mess[0]='\0';

  for (i=0; i<iNumWords; i++)
	 if (aiWordUse[i]==0)
	 {
		if (init)
		{
	strcat(mess,"\n");
#if DEBUG_ON == 1
   DebugMsg("Adding CR %s.\n","");
#endif
      }
			int l=strlen(mess);
      ptLBWords->GetString(mess+l,i);
      init=TRUE;


    }

	::MessageBox(HWindow,mess,"Words Not Used",MB_OK);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*  LATER...
void TMyDialog::DefaultProcessing()
{
	WORD wNotify = HIWORD(Msg.LParam);

	switch(wNotify)
	{
		case EN_CHANGE :
			ENChange(Msg);
			break;
		default :
			DefaultProcessing();
			break;
	}
}
*/

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::ENChange()
{
	IsDirty=TRUE;
	Checked(FALSE);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMLettersNotUsed()
{

  char mess[MAX_SQUARE_SIZE];
  int ix,iy;
  BOOL init=FALSE;

  mess[0]='\0';

  for (iy=0; iy<ptEdSquare->theHeight(); iy++)
		for (ix=0; ix<ptEdSquare->theWidth(); ix++)
      if (ptEdSquare->usedCount(ix,iy)==0)
			{
	char ch=ptEdSquare->letter(ix,iy);
	if (ch!=' ')
	{
		if (init)
	    strcat(mess,"\n");
	  mess[strlen(mess)+1]='\0';
		mess[strlen(mess)]=ch;
	  init=TRUE;
	}
		}

  ::MessageBox(HWindow,mess,"Letters Not Used",MB_OK);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMOverusedLetters()
{

  char mess[MAX_SQUARE_SIZE];
  int ix,iy;
	BOOL init=FALSE;

	mess[0]='\0';

  for (iy=0; iy<ptEdSquare->theHeight(); iy++)
    for (ix=0; ix<ptEdSquare->theWidth(); ix++)
      if (ptEdSquare->usedCount(ix,iy)>1)
		{
	char ch=ptEdSquare->letter(ix,iy);
	if (ch!=' ')
	{
	  if (init)
		 strcat(mess,"\n");
	  mess[strlen(mess)+1]='\0';
	  mess[strlen(mess)]=ch;
	  init=TRUE;
	}
		}

  ::MessageBox(HWindow,mess,"Overused Letters",MB_OK);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::CMAbout()
{
  TDialog(this, "About").Execute();
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::OpenFile()
{
	// ?? read ...

	ifpstream is(FileData->FileName);

	if (is.bad())
		MessageBox("Unable to open file", "File Open Error",
		 MB_OK | MB_ICONEXCLAMATION);
	else
	{
		ptLBWords->ClearList();
		ptEdSquare->SetText("");

		is >> ptLBWords;

		is >> ptEdSquare;

		is.close();
	}

  SetCaption();
  IsNewFile = IsDirty = FALSE;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::SaveFile()
{
	// ?? write ...

	ofpstream os(FileData->FileName);

	os << ptLBWords;

	os << ptEdSquare;

	os.close();

	SetCaption();
	IsNewFile = IsDirty = FALSE;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::SaveFileAs()
{
  if (IsNewFile)
	 strcpy(FileData->FileName, "");

	if ((TFileSaveDialog(this, *FileData)).Execute() == IDOK)
		SaveFile();
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::SetCaption()
{
	char extra[MAXPATH];

	if (strlen(FileData->FileName)==0)
		strcpy(extra," [untitled]");
	else
	 strcat(strcat(strcpy(extra," ["),
				FileData->FileName), "]");

  strcat(strcpy(Title,WSQ_TITLE), extra);

  ::SetWindowText(GetParent(), Title);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::EvCheckedTest(TCommandEnabler& ce)
{
  ce.Enable(IsChecked);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::EvNotCheckedTest(TCommandEnabler& ce)
{
  ce.Enable(!IsChecked);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::Checked(BOOL b)
{
  IsChecked=b;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::EvClose()
{
  CloseWindow();
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LPSTR TMyDialog::GetClassName()
{
  return "WORDSQUARE:MAIN";
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TMyDialog::GetWindowClass(WNDCLASS& wc)
{
  TDialog::GetWindowClass(wc);
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BOOL TMyDialog::CanClose()
{
	if (!IsDirty)
		return TRUE;
	return ::MessageBox(HWindow,"Do you want to Save?",
				 "Data has been changed",
				 MB_YESNOCANCEL | MB_ICONQUESTION) == IDNO;
}

// =====================================================================
// Run the FileApp
// =====================================================================

int OwlMain(int , char*[])
{
	return TWordsApp("WordSquareApp").Run();
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DEFINE_RESPONSE_TABLE1( TMyDialog, TDialog )
		EV_COMMAND( CM_OPEN, CMOpen ),
		EV_COMMAND( CM_SAVE, CMSave ),
		EV_COMMAND( CM_SAVE_AS, CMSaveAs ),
		EV_COMMAND( CM_NEW, CMNew ),
		EV_COMMAND( CM_CHECK_WORD_SQUARE, CMCheckWordSquare ),
		EV_COMMAND( CM_WORDS_NOT_USED, CMWordsNotUsed ),
		EV_COMMAND( CM_LETTERS_NOT_USED, CMLettersNotUsed ),
		EV_COMMAND( CM_OVERUSED_LETTERS, CMOverusedLetters ),
		EV_COMMAND_ENABLE( CM_CHECK_WORD_SQUARE, EvNotCheckedTest ),
		EV_COMMAND_ENABLE( CM_WORDS_NOT_USED, EvCheckedTest ),
		EV_COMMAND_ENABLE( CM_LETTERS_NOT_USED, EvCheckedTest ),
		EV_COMMAND_ENABLE( CM_OVERUSED_LETTERS, EvCheckedTest ),
		EV_COMMAND( CM_ABOUT, CMAbout ),
		EV_WM_CLOSE,
		EV_LBN_DBLCLK( LB_WORDS, HandleUser ),
		EV_CHILD_NOTIFY( ED_SQUARE, EN_CHANGE, ENChange ),
		EV_CHILD_NOTIFY_ALL_CODES( ID_ADD_WORD, IDAddWord ),
		EV_CHILD_NOTIFY_ALL_CODES( ID_AMEND_WORD, IDAmendWord ),
		EV_CHILD_NOTIFY_ALL_CODES( ID_DELETE_WORD, IDDeleteWord ),
END_RESPONSE_TABLE;


