// ==================================================================
// file : savelist.cpp
// Word list implementation code
// ==================================================================

#include "comhdrs.h"
#pragma hdrstop

#include "utility.h"

#include "savelist.h"

IMPLEMENT_CASTABLE( TSaveList );
IMPLEMENT_STREAMABLE( TSaveList );

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	TSaveList::TSaveList(TListBox _FAR * plb)
	{
	 char buff[20];
	 int i;
	 wc=plb->GetCount();

	 for (i=0; i<wc; i++)
		{
		plb->GetString(buff, i);
			wds[i]=buff;
		}
	}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	TSaveList::TSaveList()
	{
		wc=0;
	}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	void TSaveList::unload(TListBox _FAR * plb)
	{
		int i;

		char * buff = new char [30];
		for (i=0; i<wc; i++)
		{
			wds[i].copy(buff,30);
			plb->AddString(buff);
		}
		delete buff;
	}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void TSaveList::Streamer::Write(opstream & os) const
{
	int i;

	os << GetObject()->wc;

	for (i=0; i<(GetObject()->wc); i++)
	{
		os << GetObject()->wds[i];
	}
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void * TSaveList::Streamer::Read(ipstream & is, uint32) const
{
	is >> GetObject()->wc;

	for (int i=0; i<GetObject()->wc; i++)
	{
		is >> GetObject()->wds[i];
	}

	return GetObject();
}

