
// ========================================================================
// file : wordsqre.hpp
// Word square specification code
// ========================================================================

#ifndef WORDSQRE_H
#define WORDSQRE_H

//#include <edit.h>

#include "savesqre.h"

const int MAX_SQUARE_SIZE      =1600;

typedef char * Pchar;

_CLASSDEF(WordSquare)

class WordSquare : public TEdit
{
public:
  enum WordSquareConsts { colLimit = 30, rowLimit = 30 };
	// Constructor
	WordSquare(TWindow* pop, int rid);

  // Update functions
  int letterUsed(int row, int col);

  // Access functions
  int theHeight();
  int theWidth();
  char letter(int row, int col);
  int usedCount(int row, int col);
  BOOL pXYWordCheck(int, int, Pchar);
  virtual void SetText(LPSTR);

protected:
  class Cell
  {
  public:
	 char letter;
	 int usedCount;
  };


  virtual BOOL IsModified();
  virtual void SetModify();
  virtual void ClearModify();
  BOOL IsChanged;

  Cell square[colLimit][rowLimit];
  void loadDetails();
  int height, width;
  Pchar file;
};

inline ipstream& operator >> (ipstream& is, RPWordSquare cl)
	{
	TSaveSquare *tmp;
	ipstream& rip = is >> tmp;
	tmp->unload(cl);
	return rip;
	}

inline opstream& operator << (opstream& os, PWordSquare cl)
	{
	TSaveSquare* tmp = new TSaveSquare(cl);
	return os << tmp;
	}

#endif

