// OWLCVT 01/29/94 18:21:18
// ==================================================================
// file : wordsqre.cpp
// Word square implementation code
// ==================================================================

#include "comhdrs.h"
#pragma hdrstop

#include "utility.h"
#include "wordsqre.h"


// class WordSquare
// {
// public:
//   enum WordSquareConsts { colLimit = 30, rowLimit = 30 };

  // Constructor
  WordSquare::WordSquare(TWindow * pop, int rid)
  : TEdit(pop,rid, colLimit*rowLimit), file(0)
  {
    ClearModify();

#if DEBUG_ON == 1
      DebugMsg("Modify flag cleared %s:\n","");
#endif

  }

  // Update functions
  int WordSquare::letterUsed(int col, int row)
  {
    if (IsModified())
      loadDetails();

    if (! IsModified())
      return ++square[col][row].usedCount;
    else
      return 0;
  }


// =====================================================================
// Handle Edit Double Clicks
// =====================================================================

  // Access functions
  int WordSquare::theHeight()
  {
    if (IsModified())
      loadDetails();

    if (! IsModified())
      return height;
    else
      return 0;
  }

  int WordSquare::theWidth()
  {
    if (IsModified())
      loadDetails();

    if (! IsModified())
      return width;
    else
      return 0;
  }

  char WordSquare::letter(int col, int row)
  {
    if (IsModified())
      loadDetails();

    if (! IsModified())
      return square[col][row].letter;
    else
      return 0;
  }

  int WordSquare::usedCount(int col, int row)
  {
    if (IsModified())
      loadDetails();

    if (! IsModified())
      return square[col][row].usedCount;
    else
      return 0;
  }

const int ddx[] = {0, 0, 1, 1, -1, -1, 1, -1};
const int ddy[] = {1, -1, 1, -1, 1, -1, 0, 0};


  BOOL WordSquare::pXYWordCheck(int x,int y, Pchar wd)
  {
  int dir;
  int dx,dy,lc;
  char ch;

  ch=letter(x,y);

  if (wd[0]==ch)
    for (dir=0; dir<8; dir++)
    {
      dx=x+ddx[dir];
      dy=y+ddy[dir];
      lc=1;
      ch=letter(dx,dy);

#if DEBUG_ON == 1
      DebugMsg("2 letter %c:\n",ch);
      DebugMsg("2 word   %c:\n",wd[0]);
#endif

      while (lc<strlen(wd) && wd[lc]==ch)
      {
	lc++;
	dx+=ddx[dir];
	dy+=ddy[dir];
	ch=letter(dx,dy);

#if DEBUG_ON == 1
      DebugMsg("++letter:%c:\n",ch);
      DebugMsg("++word:%c  :\n",wd[lc]);
#endif
      }

      if (lc==strlen(wd))
      {
	// Still need to mark the letters as used!
	for (lc=0,dx=x,dy=y;lc<strlen(wd);lc++,dx+=ddx[dir],dy+=ddy[dir])
	  letterUsed(dx,dy);

	return TRUE;
      }
    }
    return FALSE;
  }



  void WordSquare::loadDetails()
  {
    char buffer[MAX_SQUARE_SIZE];
    int i=0;
    int j=0;

#if DEBUG_ON == 1
      DebugMsg("Loading Details\n","");
#endif

    // Ensure the square is square initialised
    for (j=0; j<rowLimit; j++)
      for (i=0; i<colLimit; i++)
	  square[i][j].letter = ' ';

    width  = -1;
    height = GetNumLines();

    for (j=0; j<height; j++)
    {
      GetLine(buffer, colLimit, j);
      for (i=0; i<strlen(buffer); i++)
      {
#if DEBUG_ON == 2
      DebugMsg("%c;",buffer[i]);
#endif

	if (i>width)
	  width = i;

	square[i][j].letter = toupper(buffer[i]);
	square[i][j].usedCount = 0;
#if DEBUG_ON == 2
      DebugMsg("%c,",square[i][j].letter);
#endif

      }
    }

    // These vars are used for saying how many.

    width++;

#if DEBUG_ON == 1
      DebugMsg("\nHeight= %d\n",height);
      DebugMsg("Width = %d\n",width);
#endif


    // Ensure the square is square shaped, i.e. remove odd \0
    for (j=0; j<height; j++)
      for (i=0; i<width; i++)
	{
	if (square[i][j].letter == '\0')
	  square[i][j].letter = ' ';
#if DEBUG_ON == 1
      DebugMsg("%c,",square[i][j].letter);
#endif
	}
#if DEBUG_ON == 1
      DebugMsg(".\n","");
#endif

    ClearModify();
 }

void WordSquare::SetText(LPSTR lpstr)
{
  SetModify();
  TEdit::SetText(lpstr);
}

BOOL WordSquare::IsModified()
{
  return TEdit::IsModified() || IsChanged;
}

void WordSquare::SetModify()
{
  IsChanged=TRUE;
}

void WordSquare::ClearModify()
{
  IsChanged=FALSE;
  TEdit::ClearModify();
}


