// ==================================================================
// file : wordlist.cpp
// Word list implementation code
// ==================================================================

#include "comhdrs.h"
#pragma hdrstop

#include "utility.h"

#include "wordsid.h"
#include "wordlist.h"


// =====================================================================
// Handle ListBox Return Key and Space as double clicks
// =====================================================================

void TMyListBox::EvKeyDown(UINT key,UINT repeats, UINT flags)
{
	BOOL Previous;
	switch( key )
	{
	  case VK_SPACE:
	  case VK_RETURN:
		 ::SendMessage(::GetParent(HWindow),WM_COMMAND,LB_WORDS,
						 MAKELONG(HWindow,LBN_DBLCLK));
		 break;
	  case VK_TAB:
		 Previous = GetKeyState(VK_SHIFT) & 0x8000 ? TRUE : FALSE;
		 Parent->PostMessage( WM_NEXTDLGCTL, Previous, 0 );
		 break;
	  default:
		 TListBox::EvKeyDown(key, repeats, flags);
	}
}

UINT TMyListBox::EvGetDlgCode(MSG far*)
{
  UINT retVal = (UINT)DefaultProcessing();
  retVal |= DLGC_WANTALLKEYS;
  return retVal;
}

DEFINE_RESPONSE_TABLE1( TMyListBox, TListBox )
		EV_WM_GETDLGCODE,
		EV_WM_KEYDOWN,
END_RESPONSE_TABLE;



