#include <dos.h>
#include <string.h>
#include <WMisc.h>
#include <WDOS.h>
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

#ifndef MAJORBBS

  void Sound(float Pitch,int MilliSecs)
    {
      sound(int(Pitch));
      Delay(MilliSecs);
      nosound();
    }

#endif

SByte  Abs(SByte  x)  { return x >= 0 ? x : -x; }
SWord  Abs(SWord  x)  { return x >= 0 ? x : -x; }
int    Abs(int    x)  { return x >= 0 ? x : -x; }
SLong  Abs(SLong  x)  { return x >= 0 ? x : -x; }
float  Abs(float  x)  { return x >= 0 ? x : -x; }
double Abs(double x)  { return x >= 0 ? x : -x; }

//.parse

Byte   Max(Byte   a, Byte b  ) { return a >= b ? a : b; }
SByte  Max(SByte  a, SByte b ) { return a >= b ? a : b; }
Word   Max(Word   a, Word b  ) { return a >= b ? a : b; }
SWord  Max(SWord  a, SWord b ) { return a >= b ? a : b; }
int    Max(int    a, int b   ) { return a >= b ? a : b; }
UInt   Max(UInt   a, UInt b  ) { return a >= b ? a : b; }
Long   Max(Long   a, Long b  ) { return a >= b ? a : b; }
SLong  Max(SLong  a, SLong b ) { return a >= b ? a : b; }
double Max(double a, double b) { return a >= b ? a : b; }

//.parse

Byte   Min(Byte   a, Byte b  ) { return a <= b ? a : b; }
SByte  Min(SByte  a, SByte b ) { return a <= b ? a : b; }
Word   Min(Word   a, Word b  ) { return a <= b ? a : b; }
SWord  Min(SWord  a, SWord b ) { return a <= b ? a : b; }
int    Min(int    a, int b   ) { return a <= b ? a : b; }
UInt   Min(UInt   a, UInt b  ) { return a <= b ? a : b; }
Long   Min(Long   a, Long b  ) { return a <= b ? a : b; }
SLong  Min(SLong  a, SLong b ) { return a <= b ? a : b; }
double Min(double a, double b) { return a <= b ? a : b; }

//.parse

Bool InRange(Byte   Val, Byte   Low, Byte   High)
  {return((Val>=Low) && (Val<=High));}
Bool InRange(SByte  Val, SByte  Low, SByte  High)
  {return((Val>=Low) && (Val<=High));}
Bool InRange(Word   Val, Word   Low, Word   High)
  {return((Val>=Low) && (Val<=High));}
Bool InRange(SWord  Val, SWord  Low, SWord  High)
  {return((Val>=Low) && (Val<=High));}
//.parse

Bool InRange(int    Val, int    Low, int    High)
  {return((Val>=Low) && (Val<=High));}
Bool InRange(UInt   Val, UInt   Low, UInt   High)
  {return((Val>=Low) && (Val<=High));}
Bool InRange(Long   Val, Long   Low, Long   High)
  {return((Val>=Low) && (Val<=High));}
//.parse

Bool InRange(SLong  Val, SLong  Low, SLong  High)
  {return((Val>=Low) && (Val<=High));}
Bool InRange(double Val, double Low, double High)
  {return((Val>=Low) && (Val<=High));}
Bool InRange(long double Val, long double Low, long double High)
  {return((Val>=Low) && (Val<=High));}

//.parse

Long SystemTick()
  {
    Registers Regs;
    Regs.AH()=0;
    CallBIOS(26,Regs);
    return(Regs.CX()*MaxWord+Regs.DX());
  }

//.parse

SLong Round(double Val)
  {
    return SLong((Val<0.0)?(Val-0.5):(Val+0.5));
  }

//.parse

SLong RoundUp(double Val)
  {
    return SLong((Val<0.0)?(Val):(Val+1.0));
  }

SLong RoundDown(double Val)
  {
    return SLong((Val<0.0)?(Val-1.0):(Val));
  }

//.parse

SLong RoundOut(double Val)
  {
    return SLong((Val<0.0)?(Val-1.0):(Val+1.0));
  }

SLong RoundIn(double Val)
  {
    SLong X=SLong(Val);
    return X;
  }

//.parse

char ToUpper(char C)
  {
    return (InRange(C,'a','z')?C-32:C);
  }

char ToLower(char C)
  {
    return (InRange(C,'A','Z')?C+32:C);
  }

/*  a pigeon hole algorithm (I think):

       Tries to spread a number as evenly as possible across an array
*/

//.parse

void PigeonHole(Long TotQuan, int ArrayLen, int A[])
  {
    int I;
    int V=int(TotQuan/ArrayLen);
    For(I,ArrayLen) A[I]=V;
    if (TotQuan%ArrayLen==0) return;
    double X= -0.5;  //  an accumulator
    int Left=int(TotQuan-(V*ArrayLen)); // amount left
    double D=double(Left)/ArrayLen;
      // difference between the int val there is and what the float value s/b
    int Stop=ArrayLen-1; // I wanna do the last one seperately
    For(I,Stop)
      {
        X+=D;
        if (X>=0.0)
          {
            A[I]++;
            X-=1.0;
            Left--;
          }
      }
    A[Stop]+=Left;
      // this makes certain that all of TotQuan is spread out.
      // leaves no room for floating point round off probs
  }

//.parse

const Word CRCMask=0x1021; // crc-ccitt mask

Word CRC(void* P,Long Size)
  {
    Word X=0;
    char* CP=(char*)P;
    Long I;
    For(I,Size)
      {
        Word Z=Word(*CP);
        CP++;
        Z<<=8;
        Word J;
        For(J,8)
          {
            if((X ^ Z) & 0x8000) X=(X<<1)^CRCMask;
            else X<<=1;
            Z<<=1;
          }
      }
    return X;
  }

Word CRC(const char* S)
  {
    return (CRC((void*)S,Long(strlen(S))));
  }

//.parse

void BigMemCopy(void* Dest, const void* Source, long Size)
  {
    const Chunk=512*62; // close to MaxInt
    while (Size>=Chunk)
      {
        memcpy(Dest,Source,Chunk);
        Size-=Chunk;
        (char*)Dest+=Chunk;
        (char*)Source+=Chunk;
      }
    if (Size>0) memcpy(Dest,Source,size_t(Size));
  }

//.parse

void SimpleEncode(char* S)
  {
    int Size=strlen(S);
    Word I;
    For(I,Size) S[I]-=20;
  }

void SimpleDecode(char* S)
  {
    int Size=strlen(S);
    int I;
    For(I,Size) S[I]+=20;
  }

//.parse

#ifndef MAJORBBS

  void Beep(int Num)
    {
      int I;
      For(I,Num)
        {
          Sound(783.99,35); //  note G5 for 0.05 secs
          Sound(1174.66,35); // note D6
        }
    }

#endif
