#include "VecLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

void ObjVec::ExtraAlloc(long Quan)
  {
    ByteVector::ExtraAlloc(Quan*BlockSize);
  }

//.parse

void ObjVec::CopyFrom(void* Source, long Quan)
  {
    ByteVector::CopyFrom(Source,Quan*ObjSize);
  }

//.parse

void ObjVec::AppendOneObj(void* X)
  {
    memcpy(Ref(Size()),X,ObjSize);
  }

//.parse

ObjVec ObjVec::PrependOneObj(void* X) const
  {
    ObjVec V(ObjSize,X);
    V+=*this;
    return V;
  }

//.parse

void ObjVec::operator+=(const ObjVec& V)
  {ByteVector::operator+=(*((ByteVector*)&V));}

//.parse

void* ObjVec::Ref(long Index)
  {
    ByteVector::Ref(((Index+1)*BlockSize)-1);
    return PtrInc(P,Index*BlockSize);
  }

//.parse

void ObjVec::Insert(const ObjVec& V,long Index)
  { ByteVector::Insert(*((ByteVector*)&V),Index*BlockSize); }

//.parse

void ObjVec::Insert(void* X,long Index)
  {
    ObjVec V(ObjSize,X);
    ByteVector::Insert(*((ByteVector*)&V),Index*BlockSize);
  }

//.parse

void ObjVec::Delete(long Index,long Length)
  { ByteVector::Delete(Index*BlockSize,Length*BlockSize); }

//.parse

void ObjVec::operator=(const ObjVec& V){Assign(*((ByteVector*)&V));}

//.parse

void ObjVec::CopyTo(void* Dest, long Quan) const
  {
    ByteVector::CopyTo(Dest,Quan*ObjSize);
  }

//.parse

ObjVec ObjVec::Concat(void* X) const
  {
    ObjVec V(*this);
    memcpy(V.Ref(Size()),X,ObjSize);
    return V;
  }

//.parse

ObjVec ObjVec::Concat(const ObjVec&V2) const
  {
    ObjVec V3(*this);
    V3+=V2;
    return V3;
  }

//.parse

void ObjVec::CtorHelper(int ObjectSize)
  {
    ObjSize=ObjectSize;
    BlockSize=ObjectSize;
    CFP=NULL;
  }

ObjVec::ObjVec(int ObjectSize):ByteVector()
  {CtorHelper(ObjectSize);}

ObjVec::ObjVec(int ObjectSize,void* X):ByteVector(X,ObjectSize)
  {CtorHelper(ObjectSize);}

ObjVec::ObjVec(int ObjectSize,void* P, long Len):ByteVector(P,ObjectSize*Len)
  {CtorHelper(ObjectSize);}

ObjVec::ObjVec(const ObjVec& V):ByteVector(*((ByteVector*)&V))
  {CtorHelper(V.ObjSize);}

//.parse

void ObjVec::Empty(){ByteVector::Empty();}
ObjVec::operator ConstVoidPointerType()const{return P;}
long ObjVec::Capacity()const{return (Alloc/BlockSize);}
long ObjVec::ByteCapacity()const{return Alloc;}
long ObjVec::ReAlloc(long NewCap){return ByteVector::ReAlloc(NewCap*BlockSize);}
long ObjVec::Size()const{return Len/BlockSize;}

//.parse

long ObjVec::Index(void* SearchObj, long StartIndex) const
  {
    if (StartIndex>=Size()) return(NotFound);
    long I=StartIndex;
    while ((I<Size()) && (memcmp(SearchObj,PtrInc(P,I*BlockSize),ObjSize)!=0)) I++;
    if (I==Size()) return(NotFound);
    else return(I);
  }

//.parse

ObjVec ObjVec::After(long Index) const
  {
    return At(Index+1,Size()-Index-1);
  }

//.parse

ObjVec ObjVec::From(long Index) const
  {
    return At(Index,Size()-Index);
  }

//.parse

void* ObjVec::At(long I) const
  {
    if (I>=Size()) I=Size()-1;
    return PtrInc(P,I*BlockSize);
  }

//.parse

ObjVec ObjVec::At(long I,long L) const
  {
    long S=Size();
    ObjVec V(ObjSize);
    if (I<S)
      {
        if (I+L>=S) L=S-I;
        *((ByteVector*)&V)=ByteVector::At(I*BlockSize,L*BlockSize);
      }
    return V;
  }

//.parse

static int DefaultIntCompFunc(const void* A,const void* B)
  {
    int& a=*((int*)A);
    int& b=*((int*)B);
    if (a>b) return 1;
    else if (a<b) return -1;
    else return 0;
  }

static int DefaultLongCompFunc(const void* A,const void* B)
  {
    long& a=*((long*)A);
    long& b=*((long*)B);
    if (a>b) return 1;
    else if (a<b) return -1;
    else return 0;
  }

CompFuncPtr ObjVec::CurCompFunc() const
  {
    if (CFP==NULL) return ((ObjSize==2)?DefaultIntCompFunc:DefaultLongCompFunc);
    else return CFP;
  }

//.parse

long ObjVec::BInsert(void* X)
  {
    long ReturnVal=FindGE(X);
    if (ReturnVal==NotFound)
      {
        ReturnVal=Size();
        AppendOneObj(X);
      }
    else
      {
        CompFuncPtr CF=CurCompFunc();
        if ((*CF)(At(ReturnVal),X)!=0) Insert(X,ReturnVal);
      }
    /*
    long ReturnVal;
    CompFuncPtr CF=CurCompFunc();
    if (Size()==0)
      {
        ReturnVal=0;
        AppendOneObj(X);
      }
    else if ((*CF)(Ref(Size()-1),X)<0)
      {
        ReturnVal=Size();
        AppendOneObj(X);
      }
    else
      {
        long CurLow=0;
        long CurHigh=Size()-1;
        while (CurHigh-CurLow>4)
          {
            long Middle=(CurLow+CurHigh)/2;
            if ((*CF)(Ref(Middle),X)>0) CurHigh=Middle;
            else CurLow=Middle;
          }
        Bool Done=False;
        while(!Done)
          {
            if (CurLow==Size())
              {
                ReturnVal=CurLow;
                AppendOneObj(X);
                Done=True;
              }
            else
              {
                if ((*CF)(Ref(CurLow),X)<0) CurLow++;
                else
                  {
                    ReturnVal=CurLow;
                    if ((*CF)(Ref(CurLow),X)>0) Insert(X,CurLow);
                    Done=True;
                  }
              }
          }
      }
    */
    return ReturnVal;
  }

//.parse

long ObjVec::FindE(void* X) const
  {
    long ReturnVal=FindGE(X);
    if (ReturnVal!=NotFound)
      {
        CompFuncPtr CF=CurCompFunc();
        if ((*CF)(At(ReturnVal),X)!=0) ReturnVal=NotFound;
      }
    return ReturnVal;
  }

//.parse

long ObjVec::FindGE(void* X) const
  {
    long ReturnVal;
    CompFuncPtr CF=CurCompFunc();
    if (Size()==0) ReturnVal=NotFound;
    else if ((*CF)(At(Size()-1),X)<0) ReturnVal=NotFound;
    else
      {
        long CurLow=0;
        long CurHigh=Size()-1;
        Bool Found=False;
        while (CurHigh-CurLow>4)
          {
            long Middle=(CurLow+CurHigh)/2;
            int CompVal=(*CF)(At(Middle),X);
            if (CompVal==0)
              {
                ReturnVal=Middle;
                Found=True;
                CurLow=CurHigh;
              }
            else if (CompVal>0) CurHigh=Middle;
            else CurLow=Middle;
          }
        if (!Found)
          {
            Bool Done=False;
            while(!Done)
              {
                if (CurLow==Size())
                  {
                    ReturnVal=NotFound;
                    Done=True;
                  }
                else
                  {
                    if ((*CF)(At(CurLow),X)<0) CurLow++;
                    else
                      {
                        ReturnVal=CurLow;
                        Done=True;
                      }
                  }
              }
          }
      }
    return ReturnVal;
  }
