#ifndef WDOSIncluded
#define WDOSIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WTime.h>
#include <WLink.h>
#include <WFile.h>
#include <WStr.h>

typedef char FileNameType[13];

struct DirElementType
  {
    FileNameType Name;
    Moment M;
  };

CreateLinkedListClass(Directory,DirElementType);

void LoadDirectory(const char* DirMask,Moment StartMoment,Directory& D);
void LoadDirectory(const char* DirMask,Directory& D);
long DirCount(const char* DirMask);  // how many files match dirmask

typedef union
  {
    REGS R;
    Word W[7];
    Byte B[8];
  } URegsType;

class Registers
  {
      URegsType UR;
      friend void CallBIOS(Byte IntNum, Registers& R);
    public:
      Registers(Word ax=0,Word bx=0,Word cx=0,Word dx=0)
          {AX()=ax;BX()=bx;CX()=cx;DX()=dx;}
      Word& AX(){return UR.W[0];}
      Word& BX(){return UR.W[1];}
      Word& CX(){return UR.W[2];}
      Word& DX(){return UR.W[3];}
      Word& SI(){return UR.W[4];}
      Word& DI(){return UR.W[5];}
      Word& Flags(){return UR.W[6];}
      Bool CF(){return ((UR.W[6]&1)>0);}
      Bool PF(){return ((UR.W[6]&4)>0);}
      Bool AF(){return ((UR.W[6]&16)>0);}
      Bool ZF(){return ((UR.W[6]&64)>0);}
      Bool SF(){return ((UR.W[6]&128)>0);}
      Bool TF(){return ((UR.W[6]&256)>0);}
      Bool IF(){return ((UR.W[6]&512)>0);}
      Bool DF(){return ((UR.W[6]&1024)>0);}
      Bool OF(){return ((UR.W[6]&2048)>0);}
      Byte& AL(){return UR.B[0];}
      Byte& AH(){return UR.B[1];}
      Byte& BL(){return UR.B[2];}
      Byte& BH(){return UR.B[3];}
      Byte& CL(){return UR.B[4];}
      Byte& CH(){return UR.B[5];}
      Byte& DL(){return UR.B[6];}
      Byte& DH(){return UR.B[7];}
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

inline void CallBIOS(Byte IntNum, Registers& R){int86(IntNum,&R.UR.R,&R.UR.R);}

#endif
