#include <WDBase.h>
#include <WFile.h>
#pragma hdrstop

// copyright (c) 1993 Paul Wheaton

class DBaseSystem
  {
    public:
      C4CODE CodeBaseGlobalData;
      DBaseSystem()
        {
          d4init(&CodeBaseGlobalData);
          CodeBaseGlobalData.read_lock=0;
        }
      ~DBaseSystem()
        {
          d4close_all(&CodeBaseGlobalData);
          e4exit(&CodeBaseGlobalData);
        }
  } DBaseSys;

void DBaseAutoOpen(Bool OnOff)
  {
    DBaseSys.CodeBaseGlobalData.auto_open=OnOff;
  }

DBase::DBase(const char* FileName)
  {
    D=d4open(&(DBaseSys.CodeBaseGlobalData),(char*)FileName);
    if (D==NULL) FatalError("dbase null "+String(FileName));
    e4exit_test(&(DBaseSys.CodeBaseGlobalData));
    Closed=False;
    int I=d4num_fields(D);
    while(I>0)
      {
        V[I]=d4field_j(D,I);;
        I--;
      }
  }

void DBase::Close()
  {
    if (!Closed)
      {
        d4close(D);
        Closed=True;
      }
  }

void DBase::SetIndexTag(const char* TagName)
  {
    T4TAG* tag=d4tag(D,(char*)TagName);
    if (tag==NULL) FatalError("set tag");
    d4tag_select(D,tag);
  }

T4TAG* DBase::Tag(const char* TagName)
  {
    if (TagName==NULL) return d4tag_default(D);
    else return d4tag(D,(char*)TagName);
  }

String40 DateToDbase(const Date& D)
  {
    String40 S=Str(D.Year())+D.MonthStr2()+D.DayStr();
    return S;
  }

Date DbaseToDate(const char* CS)
  {
    String40 S(CS);
    Date D(atoi(S.Before(4)),atoi(S(4,2)),atoi(S(6,2)));
    return D;
  }

static void MallocAndCopy(char*& A,const char* B)
  {
    A=(char*)malloc(strlen(B)+1);
    strcpy(A,B);
  }

void CreateDBaseFile::DefineField(const char* FieldName,char Type,int Width,int Decimals)
  {
    F4FIELD_INFO F;
    MallocAndCopy(F.name,FieldName);
    F.type=Type;
    F.len=Width;
    F.dec=Decimals;
    FV+=F;
  }

const char* NotDeleted=".NOT. DELETED()";

static void AddTag(CDBTVector& TV, const char* TN, const char* Key,
    const char* Filter, int Unique, int D)
  {
    T4TAG_INFO T;
    MallocAndCopy(T.name,TN);
    MallocAndCopy(T.expression,Key);
    if (Filter==NULL) T.filter=NULL;
    else MallocAndCopy(T.filter,Filter);
    T.unique=Unique;
    T.descending=D;
    TV+=T;
  }

void CreateDBaseFile::DefineTag(const char* TagName, const char* KeyExpression,
          const char* FilterExpression, int Unique, int Descending)
  {
    AddTag(TV,TagName,KeyExpression,FilterExpression,Unique,Descending);
  }

void CreateDBaseFile::Done()
  {
    if (Name.Length()>0)
      {
        DeleteFile(Name);
        F4FIELD_INFO F={NULL,0,0,0};
        FV+=F;
        T4TAG_INFO* TA;
        if (TV.Size()==0) TA=NULL;
        else
          {
            T4TAG_INFO T={NULL,NULL,NULL,0,0};
            TV+=T;
            TA=&TV[0];
          }
        D4DATA* D=d4create(&(DBaseSys.CodeBaseGlobalData),
            (char*)(const char*)Name,&FV[0],TA);
        d4close(D);
        FV.Pop();
        TV.Pop();
        int I;
        For(I,FV.Size()) free(FV[I].name);
        For(I,TV.Size())
          {
            free(TV[I].name);
            free(TV[I].expression);
            char* F=TV[I].filter;
            if (F!=NULL) free(F);
          }
        Name.Clip(0);
      }
  }

/*
void CreateDBaseIndex(DBase& DB,const char* IndexFileName,const char* TagName,
    const char* KeyExpression,const char* FilterExpression,
    int Unique,int Descending)
  {
    CDBTVector TV;
    T4TAG_INFO T;
    MallocAndCopy(T.name,TagName);
    MallocAndCopy(T.expression,KeyExpression);
    if (FilterExpression==NULL) T.filter=NULL;
    else MallocAndCopy(T.filter,FilterExpression);
    T.unique=Unique;
    T.descending=Descending;
    TV+=T;
    String120 Name=IndexFileName;
    DeleteFile(Name);
    T4TAG_INFO NullT={NULL,NULL,NULL,0,0};
    TV+=NullT;
    I4INDEX* X=i4create(DB,(char*)(const char*)Name,&TV[0]);
    if (X==NULL) FatalError("dbase index create");
    if (i4reindex(X)!=0) FatalError("dbase index create 2");
    DB.SetIndexTag(TagName);
    TV.Pop();
    free(TV[0].name);
    free(TV[0].expression);
    char* F=TV[0].filter;
    if (F!=NULL) free(F);
  }
*/

void CreateADBaseIndex(DBase& DB,const char* IndexFileName,const char* TagName,
    const char* KeyExpression,const char* FilterExpression,
    int Unique,int Descending)
  {
    CreateDBaseIndex DBX(DB,IndexFileName);
    DBX.DefineTag(TagName,KeyExpression,FilterExpression,Unique,Descending);
  }

CreateDBaseIndex::CreateDBaseIndex(DBase& D,const char* IndexFileName)
  {
    DB=&D;
    if (IndexFileName!=NULL) Name=IndexFileName;
    Finished=False;
  }

void CreateDBaseIndex::DefineTag(const char* TagName, const char* KeyExpression,
    const char* FilterExpression, int Unique, int Descending)
  {
    AddTag(TV,TagName,KeyExpression,FilterExpression,Unique,Descending);
  }

void CreateDBaseIndex::Done()
  {
    if (!Finished)
      {
        DeleteFile(Name);
        T4TAG_INFO NullT={NULL,NULL,NULL,0,0};
        TV+=NullT;
        char* N=NULL;
        if (Name.Length()>0) N=(char*)(const char*)Name;
        I4INDEX* X=i4create(*DB,N,&TV[0]);
        if (X==NULL) FatalError("dbase index create");
        if (i4reindex(X)!=0) FatalError("dbase index create 2");
        DB->SetIndexTag(TV[0].name);
        TV.Pop();
        int I;
        For(I,TV.Size())
          {
            free(TV[I].name);
            free(TV[I].expression);
            char* F=TV[I].filter;
            if (F!=NULL) free(F);
          }
        Finished=True;
      }
  }
