/****************************************************************************
 *                                                                          *
 *                               APPLIS.CPP                                 *
 *--------------------------------------------------------------------------*
 *  First version:  11/07/1994                                              *
 *  Latest release: 11/14/1994                                              *
 *--------------------------------------------------------------------------*
 *  By Emmanuel Thioux //1994                                               *
 *                                                                          *
 ****************************************************************************/

#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <shellapi.h>
#include "hook.h"

#ifdef __WIN32__
  #define READ OF_READ
  #define READ_WRITE OF_READWRITE
#endif

int TheIcon = 0;

// Finds the first (16 colors) Icon of the specified file

char* FindFirstIcon(char* Name)
{
 HFILE    Handle;
 EXEHDR   HDR;
 WORD     NE;
 RESFMT   *ResF;
 RESOURCE *Res;
 BOOL     FindIcon = FALSE;
 int      Size = 0;
 char     *ResourceTable, *p;
 char     *Buff = new char[0x2FE];

 // Open the file
 Handle = _lopen(Name, READ);

 // Move to the stub (0x3c is the word which gives the offet of the NE header)
 _llseek(Handle, 0x3c, 0);

 // Get NE header offset, move to it then read it.
 _lread(Handle, &NE, 2);
 _llseek(Handle, NE, 0);
 _lread(Handle, &HDR, sizeof(HDR));

 // move to the resource table begining,
 _llseek(Handle, NE + HDR.offset_res_table, 0);

 // Get the size of the resource table then allocate it
 HDR.file_alig = 1 << HDR.file_alig;
 NE = HDR.offset_resid_table - HDR.offset_res_table;
 ResourceTable = new char[NE];
 p = ResourceTable;

 // Read the resource table.
 // might be buggy if the resource table size is over 64k !!!
 _lread(Handle, ResourceTable, NE);
 do {
      (char*) ResF = p;
      p+= sizeof(RESFMT);
      Size+=sizeof(RESFMT);
      (char*) Res = p;
      if (ResF->ResType != 3)  // is the resource an ICON
          {                     // No so continue
           p+= ResF->NumRes * sizeof(RESOURCE);
           Size+=ResF->NumRes * sizeof(RESOURCE);
          }
      else
          {                     // Yes ! then load the Icon in the buffer
           for (NE = 0; NE < ResF->NumRes; NE++)
               {
                _llseek(Handle, (long) ((long) Res->OFFSET * HDR.file_alig), 0);
                _lread(Handle, Buff, 16);
                if (Buff[0x0E] == 0x4) // test if it's an 16 colors Icon (I think)
                   {
                    _llseek(Handle, (long) ((long) Res->OFFSET * HDR.file_alig), 0);
                    _lread(Handle, Buff, 0x2FE);
                    TheIcon = NE;
                    FindIcon = TRUE;
                   }
                if (FindIcon)
                   {
                    NE = ResF->NumRes;
                    continue;
                   }
                (char*) Res+=sizeof(RESOURCE);
               }
          }
     } while ((!FindIcon) && (Size < NE));
 _lclose(Handle);
 delete ResourceTable;
 if (FindIcon)
     return Buff;    // return the Icon buffer.
 else
     return NULL;
}

// This function seek for the specified Icon then overwrite it with 
// the given one.
// I just overwrite my own icons to avoid to load 'em at each time from
// the application.
// for the moment the number of icons is limited to 10

void SetupAPPLI(char* Buffer, WORD WhichIcon)
{
 HFILE Handle;
 EXEHDR HDR;
 WORD NE;
 char* ResourceTable, *p;
 RESFMT *ResF;
 RESOURCE *Res;
 BOOL FindIcon = FALSE;
 int  Size = 0;

 // open the current executable in Read/Write
 Handle = _lopen(_argv[0], READ_WRITE);

 // Same proc as above.
 _llseek(Handle, 0x3c, 0);
 _lread(Handle, &NE, 2);
 _llseek(Handle, NE, 0);
 _lread(Handle, &HDR, sizeof(HDR));
 _llseek(Handle, NE + HDR.offset_res_table, 0);
 HDR.file_alig = 1 << HDR.file_alig;
 NE = HDR.offset_resid_table - HDR.offset_res_table;
 ResourceTable = new char[NE];
 p = ResourceTable;
 _lread(Handle, ResourceTable, NE);
 do {
      (char*) ResF = p;
      p+= sizeof(RESFMT);
      Size+=sizeof(RESFMT);
      (char*) Res = p;
      if (ResF->ResType != 3)
          {
            p+= ResF->NumRes * sizeof(RESOURCE);
            Size+=ResF->NumRes * sizeof(RESOURCE);
          }
      else
          {
            for (NE = 0; NE < ResF->NumRes; NE++)
                {
                 Res->ID = Res->ID & 0xFFF;
                 if (Res->ID == WhichIcon) // The only difference is now I write.
                    {
                     _llseek(Handle, (long) ((long) Res->OFFSET * HDR.file_alig), 0);
                     _lwrite(Handle, Buffer, 0x2FE);
                     FindIcon = TRUE;
                    }
                 (char*) Res+=sizeof(RESOURCE);
                 if (FindIcon)
                    continue;
                 }
          }
     } while ((!FindIcon) && (Size < NE));
 _lclose(Handle);
 delete ResourceTable;
}

APPLIDESC *LookForAppli(HWND hwndDlg, int Text, int Box, int Slot)
{
 OPENFILENAME ofn;
 char szDirName[256];
 char szFile[256], szFileTitle[256];
 UINT  i, cbString;
 char  chReplace;    /* string separator for szFilter */
 char  szFilter[256];
 HICON  Icon;
 HDC DC;
 char *Buffer;
 APPLIDESC* APP = new APPLIDESC;


/* Get the system directory name, and store in szDirName */

 GetWindowsDirectory(szDirName, sizeof(szDirName));
 szFile[0] = '\0';

 strcpy(szFilter, "Exe Files(*.EXE)|*.exe|");
 cbString = strlen(szFilter);
 chReplace = szFilter[cbString - 1]; /* retrieve wildcard */

 for (i = 0; szFilter[i] != '\0'; i++)
      {
        if (szFilter[i] == chReplace)
            szFilter[i] = '\0';
      }

 /* Set all structure members to zero. */

 memset(&ofn, 0, sizeof(OPENFILENAME));

 ofn.lStructSize = sizeof(OPENFILENAME);
 ofn.hwndOwner = hwndDlg;
 ofn.lpstrFilter = szFilter;
 ofn.nFilterIndex = 1;
 ofn.lpstrFile= szFile;
 ofn.nMaxFile = sizeof(szFile);
 ofn.lpstrFileTitle = szFileTitle;
 ofn.nMaxFileTitle = sizeof(szFileTitle);
 ofn.lpstrInitialDir = szDirName;
 ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;


 if (GetOpenFileName(&ofn)) // Get the name of the application
     {                       // Setup the returned structure
      Buffer = FindFirstIcon(ofn.lpstrFile); // find the first icon of the given file
      APP->PathName = strdup(ofn.lpstrFile);
      APP->AppNum = Slot;
      GetProfileString("SpeedManu", "ApplicationCount", "0", szDirName, 256);
      APP->TotalApp = atoi(szDirName);
      SetupAPPLI(Buffer, Slot + 2); // Write the icon in the executable
     }

 // Load the icon then draw it in the Dialog box.
 Icon = ExtractIcon(MainInstance, _argv[0], Slot);
 SendDlgItemMessage(hwndDlg, Text, WM_SETTEXT, 0, (long) ofn.lpstrFile);
 DC = GetDC(GetDlgItem(hwndDlg, Box));
 SetMapMode(DC, MM_TEXT);
 DrawIcon(DC, 0, 0, Icon);
 DestroyIcon(Icon);
 ReleaseDC(GetDlgItem(hwndDlg, Box), DC);
 return APP;
}

// ********************************************************************************

BOOL ClickClick = FALSE;

char* szHelpName = "HelpWin";

long FAR PASCAL _export __WndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 PAINTSTRUCT PS;
 int Y;
 char HelpStr[64];
 HBITMAP Help, HelpOld;
 static HDC HelpDC = 0;
 POINT Old;
 RECT r;

 switch (message) {
      case WM_LBUTTONDBLCLK:
             DestroyWindow(hwnd);
             ClickClick = TRUE;
             return TRUE;
      case WM_PAINT:
             BeginPaint(hwnd, &PS);
             TextOut(PS.hdc, 0, 0, "Double-click to close...", 24);
             GetClientRect(hwnd, &r);
             MoveToEx(PS.hdc, 0, 17, &Old);
             LineTo(PS.hdc, r.right, 17);
             if (!HelpDC)
                  HelpDC = CreateCompatibleDC(PS.hdc);
             Y = 20;
             for (int i = 0; i < ICONS; i++)
                 {
                  LoadString(MainInstance, HELPSTR + i, HelpStr, 64);
                  TextOut(PS.hdc, 18, Y + 1, HelpStr, strlen(HelpStr));
                  Help = LoadBitmap(MainInstance, MAKEINTRESOURCE(i + 1000));
                  HelpOld = SelectObject(HelpDC, Help);
                  BitBlt(PS.hdc, 1, Y, 16, 16, HelpDC, 0, 0, SRCCOPY);
                  SelectObject(HelpDC, HelpOld);
                  DeleteObject(Help);
                  Y+=18;
                 }
             EndPaint(hwnd, &PS);
             return TRUE;
     }
 return(DefWindowProc(hwnd,message,wParam,lParam));
}


void MakeWinHelp()
{
 WNDCLASS wndclass;
 MSG msg;
 HWND hwnd;

 wndclass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS; // WINDOW STYLE
 wndclass.lpfnWndProc   = __WndProc;                          // WND PROC
 wndclass.cbClsExtra    = 0;                                // EXTRAS
 wndclass.cbWndExtra    = 0;                                // EXTRAS
 wndclass.hInstance     = MainInstance;                     // APP INSTANCE
 wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);       // CURSOR
 wndclass.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
 wndclass.lpszMenuName  = NULL;                             // MENU
 wndclass.lpszClassName = (char*) szHelpName;                // CLASS NAME

 RegisterClass((WNDCLASS*) &wndclass);
 hwnd=CreateWindow(szHelpName,                     // WINDOW CLASS NAME
                   "Speed Manu Help",              // WINDOW CAPTION
                   WS_OVERLAPPED,                  // WINDOW STYLE
                   CW_USEDEFAULT,                  // INITIAL X POSITION
                   CW_USEDEFAULT,                  // INITIAL Y POSITION
                   250,                            // INITIAL X SIZE
                   18 * ICONS + 40,                // INITIAL Y SIZE
                   NULL,                           // PARENT WINDOW HANDLE
                   NULL,                           // WINDOW MENU HANDLE
                   MainInstance,                   // PROGRAM INSTANCE HANDLE
                   NULL);                          // CREATION PARAMETERS

 if (hwnd)
    {
     ShowWindow(hwnd, SW_SHOWNORMAL);
     while (!ClickClick)
      {
       PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
       TranslateMessage(&msg);
       DispatchMessage(&msg);
      }
     ClickClick = FALSE;
    }
}

