/*****************************************************************************
 *                                                                           *
 *                               TOOLBAR.CPP                                 *
 *---------------------------------------------------------------------------*
 *  First version:  11/07/1994                                               *
 *  Latest release: 11/14/1994                                               *
 *---------------------------------------------------------------------------*
 *  By Emmanuel Thioux //1994                                                *
 *                                                                           *
 *****************************************************************************/

// Include all the files we are going to use
#include <Windows.h>
#include <string.h>
#include <mem.h>
#include "Hook.h"

// ClassName of the toolbar window
char* szToolBar = "ToolBar";

// ClassName of the help window
char* szHelp = "Help";

// Coordinates of the parent window
int ParentX, ParentY;

int  HelpIndex;

// is help active ?
BOOL Help = FALSE;

// Handles of the different windows
HWND HelpWindow;
HWND ButtonParent;
HWND ToolBarhwnd;
HWND Parent;           // Parent window of the Toolbar
HWND TActive;          // Active window when creating the toolbar.

// New Button class
WNDCLASS ButtonClass;

// Keep a track of each buttons.
// A linked list would be better but I didn't have that much time
BUTTONDATA Buttons[ICONS];

// Window proc functions
long FAR PASCAL _export ToolWndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam);
long FAR PASCAL _export HelpWndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam);

// Aux functions
HWND CreateButton(HWND Parent, int x, int y);
HWND CreateHelpWindow(HWND Parent, int x, int y, char TextRef);


BOOL MakeToolBar(HWND _Parent, int x, int y)
{
 WNDCLASS wndclass;

 Parent = _Parent;
 wndclass.style         = CS_HREDRAW|CS_VREDRAW;   // WINDOW STYLE
 wndclass.lpfnWndProc   = ToolWndProc;             // WND PROC
 wndclass.cbClsExtra    = 0;                       // EXTRAS
 wndclass.cbWndExtra    = 0;                       // EXTRAS
 wndclass.hInstance     = MainInstance;            // APP INSTANCE
 wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW); // CURSOR
 wndclass.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
 wndclass.lpszMenuName  = NULL;                    // MENU
 wndclass.lpszClassName = (char*) szToolBar;       // CLASS NAME

 // Get the current active window to give it the focus when destroy the toolbar
 TActive = GetActiveWin();
 // Save the coordinates of the parent window
 ParentX = x;
 ParentY = y;
 RegisterClass((WNDCLASS*) &wndclass);

 ToolBarhwnd=CreateWindow(szToolBar,               // WINDOW CLASS NAME
                         szToolBar,                      // WINDOW CAPTION
                         WS_POPUP|WS_VISIBLE|WS_BORDER,  // WINDOW STYLE
                         x,                              // INITIAL X POSITION
                         y,                              // INITIAL Y POSITION
                         2 + (16 * ICONS),               // INITIAL X SIZE
                         18,                             // INITIAL Y SIZE
                         NULL,                           // PARENT WINDOW HANDLE
                         NULL,                           // WINDOW MENU HANDLE
                         MainInstance,                   // PROGRAM INSTANCE HANDLE
                         NULL);                          // CREATION PARAMETERS

    if (ToolBarhwnd)
      {
        // create all the buttons (dependently of the ICONS #define)
        // Not really convinient but this is not an example for toolbar.
        for (int I = 0; I < ICONS; I++)
             {
              Buttons[I].ID = IDB_FIRST + I;
              Buttons[I].hwnd = CreateButton(ToolBarhwnd, I * 16, 0);
             }
        ShowWindow(ToolBarhwnd, SW_NORMAL);
        return TRUE;
      }

 return FALSE;
}

// --------------------------------------------------------------------------------------

long FAR PASCAL _export ToolWndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 static HBITMAP hBtnUp[ICONS];  // store the handle of the bitmaps
 static HBITMAP hBtnDn[ICONS];  // to drae the buttons
 static HDC DCMEM;              // and store the HDC for time saving
 static Unactive = FALSE;       // is the the Toolbar non active ?
 LPDRAWITEMSTRUCT lpdis;        // Struct for the WM_DRAWITEM message
 int I, J;
 BOOL Destroy;                  // may I destroy the toolbar ?

  switch (message)
     {
      case WM_CREATE:
          // load all the bitmaps in the static arrays
          for (I = 0; I < ICONS; I++)
                {
                 hBtnUp[I] = LoadBitmap(MainInstance, MAKEINTRESOURCE(1000 + I)); // Up state
                 hBtnDn[I] = LoadBitmap(MainInstance, MAKEINTRESOURCE(3000 + I)); // Down state
                } return TRUE;

      case WM_DRAWITEM:
                {
                 lpdis = (LPDRAWITEMSTRUCT) lParam;
                 DCMEM = CreateCompatibleDC(lpdis->hDC);

                 J = 0;
                 // Get the current button to draw
                 for (I = 0; I < ICONS; I++)
                      if (Buttons[I].hwnd == lpdis->hwndItem)
                          J = I;

                 if (lpdis->itemState & ODS_SELECTED) // if selected
                     SelectObject(DCMEM, hBtnDn[J]);   // Draw the button with down state
                else
                     SelectObject(DCMEM, hBtnUp[J]);   // otherwise draw it up.

                BitBlt(
                     lpdis->hDC,        // destination device context

                     lpdis->rcItem.left, // x upper-left destination
                     lpdis->rcItem.top,  // y upper-left destination

                     // The next two lines specify the width and height.

                     lpdis->rcItem.right - lpdis->rcItem.left,
                     lpdis->rcItem.bottom - lpdis->rcItem.top,
                     DCMEM,    // handle of source device context
                0,         // x-coordinate upper-left source
                0,         // y-coordinate upper-left source
                SRCCOPY);  // raster operation

            DeleteDC(DCMEM);
            return TRUE;

                }

      case WM_COMMAND:
          {
            if (HIWORD(wParam) == BN_CLICKED)
                 {
                  Unactive = TRUE;
                  // Get the clicked button ID
                  for (I = 0; I < ICONS; I++)
                      if (Buttons[I].hwnd == (HWND) lParam)
                         // Then send the messsage to the parent window.
                         PostMessage(Parent, WM_COMMAND, (WPARAM) Buttons[I].ID, (LPARAM) 0);

                  // destroy the objects
                  for (I = 0; I < ICONS; I++)
                      DestroyWindow(Buttons[I].hwnd);
                  DestroyWindow(hwnd);
                  return TRUE;
                 }
          }
      case WM_ACTIVATE:    // An other window has been activated
          if (!Unactive)    // this boolean avoid the reentrance of the call
              if (wParam==0) // if the toolbar is not active destroy it
                 {
                  Unactive = TRUE;
                  DestroyWindow(hwnd);
                  SetActiveWindow(TActive); // Set the previous active window active again
                 }
          break;

      // Display the help window if right click on the button
      case WM_RBUTTONDOWN:
                 {
                  Help = TRUE;
                  for (I = 0; I < ICONS; I++)
                      if (Buttons[I].hwnd == (HWND) wParam)
                         HelpWindow = CreateHelpWindow(0, 0, 0, I);
                 } break;

      // destroy the help window
      case WM_RBUTTONUP:
                 {
                  if (Help)
                      DestroyWindow(HelpWindow);
                  Help = FALSE;
                 } break;

      // destroy the help window
      case WM_MOUSEMOVE:
                 {
                  if (Help)
                      DestroyWindow(HelpWindow);
                  Help = FALSE;
                 } break;

      // kill the Button bar if it loses the focus
      case WM_KILLFOCUS:
             Destroy = TRUE;
             for (I = 0; I < ICONS; I++)
                  if (Buttons[I].hwnd == (HWND) wParam)
                      Destroy = FALSE;
             if (Help)
                 Destroy = FALSE;
             if (Destroy)
                 {
                  DestroyWindow(hwnd);
                 }
             return FALSE;

      // Delete the bitmaps.
      case WM_DESTROY:
          for (I = 0; I < ICONS; I++)
                {
                 DeleteObject(hBtnUp[I]);
                 DeleteObject(hBtnDn[I]);
                }
          BarActive = FALSE;
          PostMessage(Parent, WM_USER + WM_DRAW, GetActiveWindow(), 0);
          break;
        }
 return(DefWindowProc(hwnd,message,wParam,lParam));
}

// ******************************************************************************

// this proc replaces the default window proc for thew buttons
// to handle the Right-click

long FAR PASCAL _export ButtonWndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 static long OldPos;
 BOOL Destroy;
  switch (message)
     {
      // Notify the parent window
      case WM_RBUTTONDOWN:
          SendMessage(ButtonParent, WM_RBUTTONDOWN, (WPARAM) hwnd, (LPARAM) lParam);
          OldPos = lParam;
          return 1;
      case WM_RBUTTONUP:
          SendMessage(ButtonParent, WM_RBUTTONUP, wParam, lParam);
          return 1;
      case WM_MOUSEMOVE:
          if (lParam != OldPos)
              SendMessage(ButtonParent, WM_MOUSEMOVE, wParam, lParam);
          break;

      // kill the Button bar if it loses the focus
      case WM_KILLFOCUS:
             Destroy = TRUE;
             for (int I = 0; I < ICONS; I++)
                  if (Buttons[I].hwnd == (HWND) wParam)
                      Destroy = FALSE;
             if (Help)
                 Destroy = FALSE;
             if (Destroy)
                 {
                  DestroyWindow(ToolBarhwnd);
                 }
             return FALSE;
     }
 // call the default function
 return(ButtonClass.lpfnWndProc(hwnd,message,wParam,lParam));
}

// Create a button and set its window proc to our proc
HWND CreateButton(HWND Parent, int x, int y)
{
 HWND hwndButton;

 ButtonParent = Parent;
 // Save the default parameters of the button class
 GetClassInfo(NULL, "Button", &ButtonClass);

 hwndButton = CreateWindow(
     "BUTTON",  // predefined class
     "OK",      // button text
     WS_VISIBLE | WS_CHILD | BS_OWNERDRAW, // styles

     x,         // starting x position
     y,         // starting y position

     16,        // button width
     16,        // button height
     Parent,    // parent window
     NULL,      // No menu
     MainInstance,
     NULL);     // pointer not needed

    if (hwndButton)
      {
        // Change the adress of the DefaultWndProc
        SetWindowLong(hwndButton, GWL_WNDPROC, (long) ButtonWndProc);
        ShowWindow(hwndButton, SW_NORMAL);
        return hwndButton;
      }
 return NULL;
}

// *******************************************************************************

HWND CreateHelpWindow(HWND /*Parent*/, int x, int y, char TextRef)
{
 WNDCLASS wndclass;
 HWND hwnd;

 wndclass.style         = CS_HREDRAW|CS_VREDRAW;   // WINDOW STYLE
 wndclass.lpfnWndProc   = HelpWndProc;             // WND PROC
 wndclass.cbClsExtra    = 0;                       // EXTRAS
 wndclass.cbWndExtra    = 0;                       // EXTRAS
 wndclass.hInstance     = MainInstance;            // APP INSTANCE
 wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW); // CURSOR
 wndclass.hbrBackground = (HBRUSH) GetStockObject(LTGRAY_BRUSH);
 wndclass.lpszMenuName  = NULL;                    // MENU
 wndclass.lpszClassName = (char*) szHelp;       // CLASS NAME

 HelpIndex = TextRef;
 RegisterClass((WNDCLASS*) &wndclass);
 hwnd=CreateWindow(szHelp,                         // WINDOW CLASS NAME
                   szHelp,                         // WINDOW CAPTION
                   WS_POPUP|WS_VISIBLE|WS_BORDER,  // WINDOW STYLE
                   x,                              // INITIAL X POSITION
                   y,                              // INITIAL Y POSITION
                   50,                             // INITIAL X SIZE
                   18,                             // INITIAL Y SIZE
                   NULL,                           // PARENT WINDOW HANDLE
                   NULL,                           // WINDOW MENU HANDLE
                   MainInstance,                   // PROGRAM INSTANCE HANDLE
                   NULL);                          // CREATION PARAMETERS


    if (hwnd)
      {
        ShowWindow(hwnd, SW_NORMAL);
        return hwnd;
      }
 return NULL;
}

// Really need help ?

long FAR PASCAL _export HelpWndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
#ifndef __WIN32__
 static DWORD Unit;
#else
 static SIZE  Unit;
#endif
 PAINTSTRUCT PS;
 HBRUSH Brush, OldBrush;
 HPEN Pen, OldPen;
 RECT r;
 HDC DC;
 static char HelpStr[64];

  switch (message)
     {
      case WM_CREATE:
             {
              DC = GetDC(hwnd);
#ifndef __WIN32__
              LoadString(MainInstance, HELPSTR + HelpIndex, HelpStr, 64);
              Unit = GetTextExtent(DC, HelpStr, strlen(HelpStr));
              MoveWindow(hwnd, ParentX + ((HelpIndex) * 16), ParentY + 16, LOWORD(Unit) + 8, HIWORD(Unit) + 2, TRUE);
#else
              GetTextExtentPoint32(DC, HelpStr, strlen(HelpStr), &Unit);
              MoveWindow(hwnd, ParentX + ((HelpIndex) * 16), ParentY + 16, Unit.cx + 8, Unit.cy + 2, TRUE);
#endif
              ReleaseDC(hwnd, DC);
             } break;
      case WM_PAINT:
             {
              BeginPaint(hwnd, &PS);
              Pen = CreatePen(PS_SOLID, 1, RGB(255,255,0));
              Brush = CreateSolidBrush(RGB(255,255,0));
              OldBrush = SelectObject(PS.hdc, Brush);
              OldPen = SelectObject(PS.hdc, Pen);
              GetClientRect(hwnd, &r);
              Rectangle(PS.hdc, 0, 0, r.right, r.bottom);
              SetBkColor(PS.hdc, RGB(192,192,0));
              TextOut(PS.hdc, 2, 0, HelpStr, strlen(HelpStr));
              SelectObject(PS.hdc, OldBrush);
              DeleteObject(Brush);
              SelectObject(PS.hdc, OldPen);
              DeleteObject(Pen);
              EndPaint(hwnd, &PS);
             } break;
     }
 return(DefWindowProc(hwnd,message,wParam,lParam));
}

