/*****************************************************************************
 *                                                                           *
 *                                HOOK.CPP                                   *
 *---------------------------------------------------------------------------*
 *  First version:  11/07/1994                                               *
 *  Latest release: 11/14/1994                                               *
 *---------------------------------------------------------------------------*
 *  By Emmanuel Thioux //1994                                                *
 *                                                                           *
 *****************************************************************************/

#include <windows.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "CTL3D.H"          // 3-D control Header
#include "Hook.h"
#include <shellapi.h>
#ifndef __WIN32__
  #include <toolhelp.h>
#endif

#pragma inline

// Global variables
HINSTANCE MainInstance = NULL;
HDC  MainDC;
HWND MainWindow;
HWND MainActive;
BOOL BarActive = FALSE;

// Hooks ...
HHOOK PrevHook;       // Messages hook
HHOOK PrevMouseHook;  // Mouse hook
HHOOK PrevShellHook;  // Shell hook

HDC DesktopDC;
FARPROC FarProc;
HOOKPROC THook;

LPSTR ErrorString = new char far[256];
BOOL NewSlot = FALSE;
BOOL ScreenON = TRUE;
BOOL DisplayResources = FALSE;

// Class name of the main window
char* szWinName = "Icon Stuff";
int SLOT = 0;

extern "C" GETDS();

// Differents Handles for the bitmaps and the icons
HBITMAP SmileyOR;
HBITMAP SmileyOldOR;
HDC     SmileDC;
HICON   Icon;
WINDOWPLACEMENT wndplc;

int MouseX, MouseY, MouseXMax, MouseYMax;

// Declaration for the calculator
void FAR PASCAL (*SpeedCalc) (HWND Parent);

// Display the resources and the clock on the active window caption bar
#pragma warn -aus
void DrawRes(HWND Window)
{
 HDC TmpDC;
 RECT r;
 HFONT hfont, hfontOld;
 LPSTR pszFace = "MS Serif";
 char  MEM[15] = "Mem: ";
 char  RES[20] = "Res: ";
 int iPtSize = 7;
 int XStart, YStart, Caption;
 long Style;
 struct time Time;
#ifndef __WIN32__
 SYSHEAPINFO shi;
#endif

 // Do not display resources on an icon
 if (IsIconic(Window))
     return;
 XStart = GetSystemMetrics(SM_CXSIZE);
 XStart += GetSystemMetrics(SM_CXFRAME);
 YStart = GetSystemMetrics(SM_CYFRAME);
 Caption = GetSystemMetrics(SM_CYCAPTION) - GetSystemMetrics(SM_CYBORDER);
 Style = GetWindowLong(Window, GWL_STYLE);

 TmpDC = GetWindowDC(Window);
 if (Window == GetActiveWin())
     {
        if ((Style & DS_MODALFRAME) == DS_MODALFRAME)
            YStart+= GetSystemMetrics(SM_CXFRAME);
        if ((Style & WS_THICKFRAME) != WS_THICKFRAME)
            YStart-= GetSystemMetrics(SM_CXFRAME);

        GetWindowRect(Window, &r);
        hfont = CreateFont(-iPtSize , 0, 0, 0, 0, /* specify pt size    */
             0, 0, 0, 0, 0, 0, 0, 0, pszFace);     /* and face name only */

#ifndef __WIN32__
        shi.dwSize = sizeof(shi);
        SystemHeapInfo(&shi);
        gettime(&Time);
        sprintf(&MEM[5], "%lu Ko", GetFreeSpace(0) / 1024);
        sprintf(&RES[5], "%d%% - %02d:%02d", ((shi.wUserFreePercent + shi.wGDIFreePercent) >> 1), Time.ti_hour, Time.ti_min);
#endif
        hfontOld = SelectObject(TmpDC, hfont);
        SetTextColor(TmpDC, RGB(255,255,255));
        SetBkMode(TmpDC, OPAQUE);
        SetBkColor(TmpDC, GetPixel(TmpDC, XStart + 18, YStart + 1));
        TextOut(TmpDC, XStart + 18, YStart + 1, MEM, strlen(MEM));
        TextOut(TmpDC, XStart + 18, YStart + 9, RES, strlen(RES));
        SelectObject(TmpDC, hfontOld);
        DeleteObject(hfont);
     }
 ReleaseDC(Window, TmpDC);
}


// Paint the SpeedManu Icon into the caption bar of the active window (Only if it's not a dialog)
#pragma warn -aus
void PaintBitmap(HWND Window, BOOL Clear, BOOL FORCED)
{
 HDC TmpDC;
 HBRUSH Brush, OBrush;
 int XStart, YStart, Caption;
 int TooAdd = 16;
 long Style;


 // Do not display the bitmap on an icon
 if (IsIconic(Window))
     return;
 XStart = GetSystemMetrics(SM_CXSIZE);
 XStart += GetSystemMetrics(SM_CXFRAME);
 YStart = GetSystemMetrics(SM_CYFRAME);
 Caption = GetSystemMetrics(SM_CYCAPTION) - GetSystemMetrics(SM_CYBORDER);
 Style = GetWindowLong(Window, GWL_STYLE);
 // Place the bitmap dependently of the Caption style and the frame
 if (Window == GetActiveWin())
     {
      if ((Style & DS_MODALFRAME) == DS_MODALFRAME)
         YStart+= GetSystemMetrics(SM_CXFRAME);
      if ((Style & WS_THICKFRAME) != WS_THICKFRAME)
         YStart-= GetSystemMetrics(SM_CXFRAME);
     }

 TmpDC = GetWindowDC(Window);
 // if we can draw the bitmap hust do it
 if ((!Clear) && ( (Window == GetActiveWin()) || FORCED))
     {
      SmileDC = CreateCompatibleDC(TmpDC);
      SmileyOldOR = SelectObject(SmileDC, SmileyOR);
      // Stretch it to fit in the caption
      StretchBlt(TmpDC, XStart, YStart, 16, Caption, SmileDC, 0, 0, 16, 18, SRCCOPY);
      SelectObject(SmileDC, SmileyOldOR);
      DeleteDC(SmileDC);
      if (DisplayResources)
          DrawRes(Window);
     }
 else
     {// else just erase the bitmap
      SelectObject(TmpDC, GetStockObject(NULL_PEN));
      Brush = CreateSolidBrush(GetPixel(TmpDC, XStart+17, YStart+1));
      OBrush = SelectObject(TmpDC, Brush);
      Rectangle(TmpDC, XStart+1, YStart, XStart + TooAdd, YStart + Caption);
      SelectObject(TmpDC, OBrush);
      DeleteObject(Brush);
     }
 ReleaseDC(Window, TmpDC);
}

// Hook for WH_CALLWND

LRESULT CALLBACK Hook(int nCode, WPARAM wParam, LPARAM lParam)
{
 CWPSTRUCT *Info;
 HDC TmpDC;
 int XStart, YStart, Caption;
 long Style;
 POINT rc;

 // just return if the message is not for us
 if (nCode != HC_ACTION)
     {
      return CallNextHookEx(PrevHook, nCode, wParam, lParam);
     }

 // get the info about the message
 Info = (CWPSTRUCT*) lParam;
 switch (Info->message)
    {// All those message have to redraw the bitmap
     case WM_PAINT:
     case WM_SYNCPAINT:
     case WM_NCPAINT:
     case WM_ERASEBKGND:
     case WM_SETFOCUS:
     case WM_PARENTNOTIFY:
     case WM_SETTEXT:
     case WM_SHOWWINDOW:if (IsIconic(Info->hwnd))
                                  return 0;
     case WM_SIZE:
          {
            if ((GetParent(Info->hwnd) == NULL) && (Info->hwnd == GetActiveWin()))
                {
                 asm {// Security
                        pusha
                        push ds
                        push es
                      }
                 GETDS(); // Get the correct Data segment (sometimes I lose it, so...)
                 Style = GetWindowLong(Info->hwnd, GWL_STYLE);

                 // Just draw the bitmap if the window has a system menu
                 if ((Style & WS_SYSMENU) == WS_SYSMENU)
                     {
                      XStart = GetSystemMetrics(SM_CXSIZE);
                      XStart += GetSystemMetrics(SM_CXFRAME);
                      YStart = GetSystemMetrics(SM_CYFRAME);
                      Caption = GetSystemMetrics(SM_CYCAPTION) - GetSystemMetrics(SM_CYBORDER);

                      if ((Style & DS_MODALFRAME) == DS_MODALFRAME)
                            YStart+= GetSystemMetrics(SM_CXFRAME);
                      if ((Style & WS_THICKFRAME) != WS_THICKFRAME)
                            YStart-= GetSystemMetrics(SM_CXFRAME);

                      TmpDC = GetWindowDC(Info->hwnd);
                      YStart = GetSystemMetrics(SM_CYFRAME);
                      rc.x = 0;
                      rc.y = 0;
                      ClientToScreen(Info->hwnd, &rc);
                      rc.x -= GetSystemMetrics(SM_CXFRAME);
                      MouseX = rc.x + XStart;
                      rc.y -= GetSystemMetrics(SM_CYCAPTION);
                      rc.y -= GetSystemMetrics(SM_CYMENU);
                      rc.y -= GetSystemMetrics(SM_CYFRAME);
                      MouseY = rc.y + YStart;
                      MouseXMax = MouseX + 16;
                      MouseYMax = MouseY + 16;
                      ReleaseDC(Info->hwnd, TmpDC);
                      // Let's the main window draw the bitmap
                      PostMessage(MainWindow, WM_USER + WM_DRAW, (WPARAM) Info->hwnd, (LPARAM) 0);
                     }
                 asm {
                      pop es
                      pop ds
                      popa
                     }
                }
            }
            break;

     case WM_MOVE:// if moving the window then setup the correct coordinates for the mouse
            if ((GetParent(Info->hwnd) == NULL) && (Info->hwnd == GetActiveWin()))
                {
                 asm {
                      pusha
                      push ds
                      push es
                     }
                 GETDS();
                 Style = GetWindowLong(Info->hwnd, GWL_STYLE);
                 if ((Style & WS_SYSMENU) == WS_SYSMENU)
                     {
                      XStart = GetSystemMetrics(SM_CXSIZE);
                      XStart += GetSystemMetrics(SM_CXFRAME);
                      YStart = GetSystemMetrics(SM_CYFRAME);
                      TmpDC = GetWindowDC(Info->hwnd);
                      rc.x = 0;
                      rc.y = 0;
                      ClientToScreen(Info->hwnd, &rc);
                      rc.x -= GetSystemMetrics(SM_CXFRAME);
                      MouseX = rc.x + XStart;
                      rc.y -= GetSystemMetrics(SM_CYCAPTION);
                      rc.y -= GetSystemMetrics(SM_CYMENU);
                      rc.y -= GetSystemMetrics(SM_CYFRAME);
                      MouseY = rc.y + YStart;
                      MouseXMax = MouseX + 16;
                      MouseYMax = MouseY + 16;
                      ReleaseDC(Info->hwnd, TmpDC);
                     }
                 asm {
                      pop es
                      pop ds
                      popa
                     }
                } break;
     }
 return 0;
}

// Hook for the WH_SHELL
// This one is used to stop the screen saver
// But it just works if the screen saver is a Windows one (cos' of the class name)
LRESULT CALLBACK ShellHook(int nCode, WPARAM wParam, LPARAM lParam)
{
 HHOOK PrevHook = PrevShellHook;
 if (nCode == HSHELL_WINDOWCREATED)  // a window has been created.
     {
      asm push DS
      GETDS();
      if (ScreenON)
         {
          asm pop DS
          return CallNextHookEx(PrevHook, nCode, wParam, lParam);
         }
      else
         {                          // test the Class name
          LPSTR Class = new char far[255];
          GetClassName((HWND) wParam, Class, 255);
          if (strcmp(Class, "WindowsScreenSaverClass") != 0)
             {
              delete Class;         // if it's screen saver the destroy it.
              asm pop DS
              return CallNextHookEx(PrevHook, nCode, wParam, lParam);
             }
          else
             {
              delete Class;
              PostMessage((HWND) wParam, WM_MOUSEMOVE, (WPARAM) 0, (LPARAM) 0x0a0a);
              PostMessage((HWND) wParam, WM_DESTROY, (WPARAM) 0, (LPARAM) 0);
              asm pop DS
              return CallNextHookEx(PrevHook, nCode, wParam, lParam);
             }
         }
      }
 return 0;
}

// Mouse Hook
LRESULT CALLBACK MouseHook(int nCode, WPARAM wParam, LPARAM lParam)
{
 HHOOK PrevHook = PrevShellHook;
 MOUSEHOOKSTRUCT *Info;
 long MousePos;
 if (nCode != HC_ACTION)
     {
      return CallNextHookEx(PrevHook, nCode, wParam, lParam);
     }
 if ((wParam != WM_MOUSEMOVE) && (wParam != WM_NCMOUSEMOVE))
    {
     // if right-click on the bitmap then active the toolbar
     if ((wParam == WM_NCRBUTTONDOWN) || (wParam == WM_RBUTTONDOWN))
     {
      Info = (MOUSEHOOKSTRUCT*) lParam;
      if ((GetParent(Info->hwnd) == NULL) && (Info->hwnd == GetActiveWin()))
         {
          asm {
               pusha
               push ds
               push es
              }
          GETDS();
          if ((Info->pt.x >= MouseX) && (Info->pt.y >= MouseY))
              if ((Info->pt.x <= MouseXMax) && (Info->pt.y <= MouseYMax))
                 {
                  MousePos = ((long) Info->pt.x << 16) + (Info->pt.y);
                  PostMessage(MainWindow, WM_USER + WM_MENU, (WPARAM) Info->hwnd, (LPARAM) MousePos);
                 }
          asm {
               pop es
               pop ds
               popa
              }
         }
     }
    }
 return CallNextHookEx(PrevHook, nCode, wParam, lParam);
}

BOOL CALLBACK DialogProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM /*lParam*/);
BOOL CALLBACK SlotDialogProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);

// Main Window proc.
// answers to the button queries

long FAR PASCAL _export WndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 HWND Prev;
 char App[10] = "App#";
 char NApp[128];
 char *p;
 PAINTSTRUCT PS;
 HANDLE Handle;

 switch (message)
     {
      case WM_CREATE:
          PaintBitmap(GetActiveWin(), FALSE, TRUE);
          GetProfileString("SpeedManu", "ResourcesDisplay", "NO", NApp, 128);
          if (strcmp(NApp, "YES") == 0)
              SendMessage(hwnd, WM_COMMAND, CM_RES, 0);
          break;

      case WM_USER + WM_DRAW:
          PaintBitmap((HWND) wParam, FALSE, FALSE);
          break;

      case WM_USER + WM_MENU: {
          ShowWindow(hwnd, SW_SHOWNORMAL);
          MainActive = (HWND) wParam;
          PaintBitmap(MainActive, FALSE, TRUE);
          BarActive = TRUE;
          MakeToolBar(hwnd, MouseX + 16, MouseY);
          ShowWindow(hwnd, SW_HIDE);
         } break;

      case WM_USER + WM_ERROR:
             Ctl3dRegister(MainInstance);        // setup for 3-d controls (CTL3D.DLL)
             Ctl3dAutoSubclass(MainInstance);    // auto subclassing for all controls
             LoadString(MainInstance, wParam, ErrorString, 255);
             MessageBox(0, ErrorString, "Error", MB_OK | MB_ICONEXCLAMATION);
             Ctl3dUnregister(MainInstance);        // unregister the 3D controls
             break;

      case WM_COMMAND:
        if (LOWORD(wParam) >= 500)
            {
             itoa(LOWORD(wParam) - 500, &App[4], 10);
             GetProfileString("SpeedManu", App, "Error", NApp, 128);
             p = strchr(NApp, ',');
             p++;
             WinExec(p, SW_SHOWNORMAL);
             break;
            }

        switch (LOWORD(wParam))
          {
            case CM_DOS:
                WinExec(getenv("COMSPEC"), SW_SHOWNORMAL);
                return 0;

            case CM_EXIT:
                DestroyWindow(hwnd);
                break;

            case CM_CLOCK:
                WinExec("CLOCK.EXE", SW_SHOWNORMAL);
                break;

            case CM_CALC:
                if (_argv[1])
                    strupr(_argv[1]);
                else
                    {
                     WinExec("CALC.EXE", SW_SHOWNORMAL);
                     return 0;
                    }
                if (strcmp(_argv[1], "/IC") != 0)
                    WinExec("CALC.EXE", SW_SHOWNORMAL);
                else
                    {
                     Handle = LoadLibrary("SPEEDDLL.DLL");
                     (FARPROC) SpeedCalc = GetProcAddress(Handle, "SPEEDCALC");
                     if (!SpeedCalc)
                         {
                          FreeLibrary(Handle);
                          SendMessage(hwnd, WM_USER + WM_ERROR, DLL_ERR, 0);
                         }
                     else
                         {
                          SpeedCalc(GetActiveWin());
                          FreeLibrary(Handle);
                         }
                     }
                break;

            case CM_SHUT:
                DestroyWindow(hwnd);
                ExitWindows(0, 0);
                break;

            case CM_SCRSV:
                PostMessage((HWND) 0xFFFF, WM_SYSCOMMAND, SC_SCREENSAVE, 0);
                break;

            case CM_APP:
                MakeIconBar(MainWindow, MouseX + 16 * (CM_APP - 100), MouseY + 18);
                break;

            case CM_HELP:
                MakeWinHelp();
                break;

            case CM_CONF:
                Ctl3dRegister(MainInstance);        // setup for 3-d controls (CTL3D.DLL)
                Ctl3dAutoSubclass(MainInstance);    // auto subclassing for all controls
                Prev = GetActiveWin();
                DialogBox(MainInstance, MAKEINTRESOURCE(100), hwnd, (DLGPROC) DialogProc);
                BringWindowToTop(Prev);
                Ctl3dUnregister(MainInstance);        // unregister the 3D controls
                break;

            case CM_CANC:
                PaintBitmap(GetActiveWin(), FALSE, FALSE);
                break;

            case CM_SSON:
                if (ScreenON)
                     ScreenON = FALSE;
                else
                     ScreenON = TRUE;
                break;
            case CM_RES:
                if (!DisplayResources)
                    {
                     SetTimer(hwnd, 1, 1000, NULL);
                     DisplayResources = TRUE;
                    }
                else
                    {
                     KillTimer(hwnd, 1);
                     DisplayResources = FALSE;
                    }
                break;
          }
          PaintBitmap(GetActiveWin(), FALSE, FALSE);
          break;
      case WM_PAINT:
         BeginPaint(hwnd, &PS);
         SelectObject(PS.hdc, GetStockObject(WHITE_BRUSH));
         Rectangle(PS.hdc, 0, 0, PS.rcPaint.right, PS.rcPaint.bottom);
         EndPaint(hwnd, &PS);
         break;

      case WM_TIMER:
         if (!BarActive)
             DrawRes(GetActiveWin());
         break;
      case WM_DESTROY:
         ReleaseDC(hwnd, MainDC);
         UnhookWindowsHookEx((HHOOK) PrevHook);
         UnhookWindowsHookEx((HHOOK) PrevMouseHook);
         UnhookWindowsHookEx((HHOOK) PrevShellHook);
         DeleteObject(SmileyOR);
         PaintBitmap(MainActive, TRUE, FALSE);
         if (DisplayResources)
             {
              DisplayResources = FALSE;
              KillTimer(hwnd, 1);
              WriteProfileString("SpeedManu", "ResourcesDisplay", "YES");
             }
         else
              WriteProfileString("SpeedManu", "ResourcesDisplay", "NO");

       PostQuitMessage(0);
      }
 return(DefWindowProc(hwnd,message,wParam,lParam));
}

#pragma warn -aus

BOOL CALLBACK DialogProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
 static APPLIDESC* APPL = NULL;
 char App[10] = "App#";
 char *AppName = new char[256];
 LRESULT OkReady = 0;

 // -----------------------

 LPMEASUREITEMSTRUCT lpmis;
 LPDRAWITEMSTRUCT    lpdis;
 HICON Icon;
 LRESULT j;
 char Number[5] = "0000";
 int Slots;
 char Profile[16] = "App#";
 char *p;
 char Text[32];

 // -----------------------

 switch (msg)
   {
    case WM_INITDIALOG:
      SendDlgItemMessage(hwndDlg, 101, WM_SETTEXT, 0, (long) " ");
      SendDlgItemMessage(hwndDlg, 104, WM_SETTEXT, 0, (long) " ");
      GetProfileString("SpeedManu", "Applicationcount", "Error", Number, 32);
      Slots = atoi(Number);
      for (j = 0; j < 10; j++)
          {
           itoa((int) j, Number, 10);
           strcpy(Profile, "App#");
           strcat(Profile, Number);
           GetProfileString("SpeedManu", Profile, "Error", Text , 128);
           if (strcmp(Text, "Error") != 0)
              {
                    p = strchr(Text, ',');
               *p = 0x0;
               SendDlgItemMessage(hwndDlg, 104, LB_ADDSTRING, 0, (LPARAM) Text);
              }
           else
              {
               strcpy(Text, "Empty Slot #");
               strcat(Text, Number);
               SendDlgItemMessage(hwndDlg, 104, LB_ADDSTRING, 0, (LPARAM) Text);
              }
          }
        EnableWindow(GetDlgItem(hwndDlg, 100), FALSE);
      EnableWindow(GetDlgItem(hwndDlg, 1), FALSE);
      break;

    case WM_MEASUREITEM:
      {
       lpmis = (LPMEASUREITEMSTRUCT) lParam;
       lpmis->itemHeight = 34;
       return TRUE;
      }
    case WM_DRAWITEM:
      {
       lpdis = (LPDRAWITEMSTRUCT) lParam;
       if ((int) lpdis->itemID == -1)
          break;
       switch (lpdis->itemAction)
          {
           case ODA_SELECT:
              case ODA_DRAWENTIRE:
                 {
                  SelectObject(lpdis->hDC, GetStockObject(WHITE_PEN));
                  SelectObject(lpdis->hDC, GetStockObject(WHITE_BRUSH));
                  Rectangle(lpdis->hDC, lpdis->rcItem.left, lpdis->rcItem.top,
                            lpdis->rcItem.right, lpdis->rcItem.bottom);

                  Icon = ExtractIcon(MainInstance, _argv[0], lpdis->itemID);
                  SetMapMode(lpdis->hDC, MM_TEXT);
                  DrawIcon(lpdis->hDC, 1, lpdis->rcItem.top, Icon);
                  DestroyIcon(Icon);

                  SendDlgItemMessage(hwndDlg, 104, LB_GETTEXT, lpdis->itemID, (LPARAM) Text);
                  TextOut(lpdis->hDC, 34, lpdis->rcItem.top + 8, Text, strlen(Text));
/*             }
             break;
           case ODA_FOCUS:
             {*/
              if (lpdis->itemState == ODS_SELECTED)
                 {
                  SelectObject(lpdis->hDC, GetStockObject(BLACK_BRUSH));
                  Rectangle(lpdis->hDC, lpdis->rcItem.left, lpdis->rcItem.top,
                            lpdis->rcItem.right, lpdis->rcItem.bottom);

                  Icon = ExtractIcon(MainInstance, _argv[0], lpdis->itemID);
                  SetMapMode(lpdis->hDC, MM_TEXT);
                  DrawIcon(lpdis->hDC, 1, lpdis->rcItem.top, Icon);
                  DestroyIcon(Icon);

                  SendDlgItemMessage(hwndDlg, 104, LB_GETTEXT, lpdis->itemID, (LPARAM) Text);
                  SetTextColor(lpdis->hDC, RGB(255, 255, 255));
                  SetBkColor(lpdis->hDC, RGB(0, 0, 0));
                  TextOut(lpdis->hDC, 34, lpdis->rcItem.top + 8, Text, strlen(Text));
                  SendDlgItemMessage(hwndDlg, 103, WM_SETTEXT, 0, (LPARAM) Text);
                  EnableWindow(GetDlgItem(hwndDlg, 100), TRUE);
                 }
             }
             break;
          }
      }

    case WM_COMMAND:
      switch (LOWORD(wParam))
        {
         case IDOK:
          {
           if (APPL)
            {
             APPL->AppliName = new char[30];
             OkReady = SendDlgItemMessage(hwndDlg, 103, WM_GETTEXT, (WPARAM) 30, (LPARAM) APPL->AppliName);
             if (NewSlot)
                APPL->TotalApp++;
             itoa(APPL->TotalApp, AppName, 10);
             WriteProfileString("SpeedManu", "ApplicationCount", AppName);
             itoa(SLOT, &App[4], 10);
             strcpy(AppName, APPL->AppliName);
             strcat(AppName, ",");
             strcat(AppName, APPL->PathName);
                 WriteProfileString("SpeedManu", App, AppName);
            }
            if (OkReady)
                EndDialog(hwndDlg, 0);
            else
               MessageBox(hwndDlg, "You must enter an name for the aplication", "error", MB_OK);
           } break;
         case IDCANCEL:
              EndDialog(hwndDlg, 1);
              break;
         case IDAPPLI:
              j = SendDlgItemMessage(hwndDlg, 104, LB_GETCURSEL, 0, 0);
           SendDlgItemMessage(hwndDlg, 104, LB_GETTEXT, (WPARAM) j, (LPARAM) Text);
           if (strncmp(Text, "Empty", 5) == 0)
              NewSlot = TRUE;
           else
              NewSlot = FALSE;
           SLOT = (int) j;
           APPL = LookForAppli(hwndDlg, 101, 102, (int) j);
           EnableWindow(GetDlgItem(hwndDlg, 1), TRUE);
           InvalidateRect(GetDlgItem(hwndDlg, 104), NULL, TRUE);
           UpdateWindow(hwndDlg);
           break;
        }; break;
   }
 return FALSE;
}


// ----------------------------------------------------------------------

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE /*hPrevInstance*/, LPSTR /*lpszCmdLine*/,
                                                  int /*nCmdShow*/ )
{
 WNDCLASS wndclass;
 MSG msg;
 HWND hwnd;
 HWND Prev = GetActiveWin();

 FarProc = (FARPROC) Hook;
 MainInstance = hInstance;
 THook = (HOOKPROC) MakeProcInstance(FarProc, MainInstance);
 PrevHook = SetWindowsHookEx(WH_CALLWNDPROC, THook, hInstance, NULL);

 FarProc = (FARPROC) MouseHook;
 THook = (HOOKPROC) MakeProcInstance(FarProc, MainInstance);
 PrevMouseHook = SetWindowsHookEx(WH_MOUSE, THook, hInstance, NULL);

 FarProc = (FARPROC) ShellHook;
 THook = (HOOKPROC) MakeProcInstance(FarProc, MainInstance);
 PrevShellHook = SetWindowsHookEx(WH_SHELL, THook, hInstance, NULL);


 SmileyOR  = LoadBitmap(hInstance, MAKEINTRESOURCE(103));

 wndclass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS; // WINDOW STYLE
 wndclass.lpfnWndProc   = WndProc;                          // WND PROC
 wndclass.cbClsExtra    = 0;                                // EXTRAS
 wndclass.cbWndExtra    = 0;                                // EXTRAS
 wndclass.hInstance     = MainInstance;                     // APP INSTANCE
 wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);       // CURSOR
 wndclass.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
 wndclass.lpszMenuName  = NULL;                             // MENU
 wndclass.lpszClassName = (char*) szWinName;                // CLASS NAME
 RegisterClass((WNDCLASS*) &wndclass);
 hwnd=CreateWindow(szWinName,                      // WINDOW CLASS NAME
                   szWinName,                      // WINDOW CAPTION
                   WS_BORDER|WS_POPUP,                // WINDOW STYLE
                   GetSystemMetrics(SM_CXFULLSCREEN), // INITIAL X POSITION
                   GetSystemMetrics(SM_CYFULLSCREEN), // INITIAL Y POSITION
                   34,                             // INITIAL X SIZE
                   34,                             // INITIAL Y SIZE
                   NULL,                           // PARENT WINDOW HANDLE
                   NULL,                           // WINDOW MENU HANDLE
                   MainInstance,                   // PROGRAM INSTANCE HANDLE
                   NULL);                          // CREATION PARAMETERS

    if (hwnd)
      {
       ShowWindow(hwnd, SW_SHOWNORMAL);
       BringWindowToTop(Prev);
       MainWindow = hwnd;
       MainDC = GetDC(hwnd);
      }

 ShowWindow(hwnd, SW_HIDE);
 PaintBitmap(GetActiveWin(), FALSE, FALSE);
 while (GetMessage(&msg,NULL,0,0))
       {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
       }
 return 0;
}
