#include <windows.h>
#include <windowsx.h>
#include "CTL3D.H"          // 3-D control Header
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#pragma warn -sig

HINSTANCE DLLInstance;
BOOL Hexa;
BOOL Float;
BOOL FirstEntry;
BOOL AfterPoint;
BOOL Error;
UINT      Num;
char      NumberA[32];
float     Base10;
double    FirstNumberF;
double    SecondNumberF;
double    ResultF;
long      FirstNumber;
long      SecondNumber;
long      Result;
long      NResult;
double    NResultF;
long      Tmp;
char      Op;

#define ID0   100
#define ID1   101
#define ID2   102
#define ID3   103
#define ID4   104
#define ID5   105
#define ID6   106
#define ID7   107
#define ID8   108
#define ID9   109
#define IDA   110
#define IDB   111
#define IDC   112
#define IDD   113
#define IDE   114
#define IDF   115

#define ID_POINT 141
#define ID_CONV  140
#define ID_EQUAL 1

#define ID_PLUS  136
#define ID_MOINS 138
#define ID_MULTI 139
#define ID_DIVI  137
#define ID_LSHIFT 130
#define ID_RSHIFT 131
#define ID_NOT    132
#define ID_OR     133
#define ID_AND    134
#define ID_XOR    135

#define PLUS   1
#define MOINS  2
#define MULTI  3
#define DIVI   4

#define LSHIFT 5
#define RSHIFT 6
#define __AND  7
#define __OR   8
#define __XOR  9
#define __NOT 10

#define ID_ERASE 129
#define ID_BACK  128

#define IDABOUT  150

#pragma argused
#pragma warn -par
int FAR PASCAL LibMain (HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpCmdLine)
{
    if ( cbHeapSize != 0 )
        UnlockData( 0 );
    DLLInstance = hInstance;
    return 1;
}

#pragma argused

int FAR PASCAL WEP ( int bSystemExit )
{
    return 1;
}


// ****************************************************************************************

BOOL CALLBACK DialogProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM /*lParam*/);

void FAR PASCAL SpeedCalc(HWND Parent)
{
 Ctl3dRegister(DLLInstance);        // setup for 3-d controls (CTL3D.DLL)
 Ctl3dAutoSubclass(DLLInstance);    // auto subclassing for all controls
 DialogBox(DLLInstance, MAKEINTRESOURCE(100), Parent, (DLGPROC) DialogProc);
 Ctl3dUnregister(DLLInstance);        // unregister the 3D controls
}

#pragma warn -aus

long Hexa2Long(char *Number)
{
 long i;
 int s;
 long result = 0;
 char N;
 s = strlen(Number);
 for (i = 0; i < s; i++)
     {
      N = (char) Number[(char)(s - 1 - i)];
      if (N > '9')
         result+=(long) ((N - 'A') + 10) << (i * 4);
      else
         result+=(long) (N - '0') << (i * 4);
     }
 return result;
}

double _ResultF(double F, double S, char O)
{
 switch (O)
   {
    case PLUS : return (F + S);
    case MOINS: return (F - S);
    case MULTI: return (F * S);
    case DIVI : if (SecondNumberF != 0)
                   return (F / S);
                else
                   Error = TRUE;
   }
 return 0;
}

long _Result(long F, long S, char O)
{
 switch (O)
   {
    case PLUS : return (F + S);
    case MOINS: return (F - S);
    case MULTI: return (F * S);
    case DIVI : if (SecondNumber != 0)
                   return (F / S);
                else
                   Error = TRUE;
    case LSHIFT : return (F << S);
    case RSHIFT : return (F >> S);
    case __AND  : return (F & S);
    case __OR   : return (F | S);
    case __XOR  : return (F ^ S);
    case __NOT  : return (!F);
   }
 return 0;
}

void Compute(HWND hwndDlg)
{
 if (Float)
    {
     NResultF = _ResultF(FirstNumberF, SecondNumberF, Op);
     sprintf(NumberA, "%8.4f", NResultF);
    }
 else
    {
     NResult = _Result(FirstNumber, SecondNumber, Op);
     if (Hexa)
        ltoa(NResult, NumberA, 16);
     else
        ltoa(NResult, NumberA, 10);
    }
 if (!Error)
   {
    if (Hexa)
       strupr(NumberA);
    SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
   }
 else
    SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) "Error");
}

long Pow10(int Power)
{
 int i;
 long R = 1;
 for (i = 0; i < Power; i++)
      R*=10;
 return R;
}

void SetOp(char O, HWND Dialog)
{
 if ((SecondNumber) || (SecondNumberF))
    {
     Compute(Dialog);
     SecondNumber = 0;
     SecondNumberF = 0;
    }
 Op = O;
 if ((NResultF!=0) || (NResult!=0))
    {
     FirstNumber = NResult;
     FirstNumberF = NResultF;
     FirstEntry = FALSE;
    }
 else
    FirstEntry = FALSE;
 Base10 = 1;
 AfterPoint = FALSE;
}

BOOL CALLBACK AboutProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);

BOOL CALLBACK DialogProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
 // -----------------------

 switch (msg)
   {
    case WM_INITDIALOG:
      EnableWindow(GetDlgItem(hwndDlg, IDA), FALSE);
      EnableWindow(GetDlgItem(hwndDlg, IDB), FALSE);
      EnableWindow(GetDlgItem(hwndDlg, IDC), FALSE);
      EnableWindow(GetDlgItem(hwndDlg, IDD), FALSE);
      EnableWindow(GetDlgItem(hwndDlg, IDE), FALSE);
      EnableWindow(GetDlgItem(hwndDlg, IDF), FALSE);
      Hexa = FALSE;
      Float = FALSE;
      Base10 = 1;
      FirstEntry = TRUE;
      FirstNumberF = 0;
      FirstNumber = 0;
      SecondNumberF = 0;
      SecondNumber = 0;
      AfterPoint = FALSE;
      Error = FALSE;
      Op = 0;
      NResultF = 0;
      NResult = 0;
      SetFocus(GetDlgItem(hwndDlg, ID0));
      break;

    case WM_COMMAND:
      Num = LOWORD(wParam);
      if ( (Num >= ID0) && (Num <= IDF))
         {
          if (Float)
             {
              if (FirstEntry)
                 {
                  if (!AfterPoint)
                     FirstNumberF = FirstNumberF * Base10 + (Num - 100);
                  else
                     FirstNumberF = FirstNumberF + (Base10 * (Num - 100));

                  sprintf(NumberA, "%8.4f", FirstNumberF);
                  NResultF = 0;
                 }
              else
                 {
                  if (!AfterPoint)
                     SecondNumberF = SecondNumberF * Base10 + (Num - 100);
                  else
                     SecondNumberF = SecondNumberF + (Base10 * (Num - 100));

                  sprintf(NumberA, "%8.4f", SecondNumberF);
                 }
              if (!AfterPoint)
                 {
                  if (Base10==1)
                     Base10*=10;
                 }
              else
                 {
                  Base10/=10;
                 }
              SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
             }
          else
             {
              if (FirstEntry)
                 {
                  FirstNumber = FirstNumber * Base10 + (Num - 100);
                  if (Hexa)
                     {
                      ltoa(FirstNumber, NumberA, 16);
                      strupr(NumberA);
                     }
                  else
                     ltoa(FirstNumber, NumberA, 10);
                  NResult = 0;
                 }
              else
                 {
                  SecondNumber = SecondNumber * Base10 + ( Num - 100);
                  if (Hexa)
                     {
                      ltoa(SecondNumber, NumberA, 16);
                      strupr(NumberA);
                     }
                  else
                     ltoa(SecondNumber, NumberA, 10);
                 }
              if (Base10==1)
                 if (!Hexa)
                    Base10*=10;
                 else
                    Base10*=16;
              SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
             }
         }

      switch (LOWORD(wParam))
        {
         case ID_CONV:
           {
            Hexa^= 1;
            if (Hexa)
               {
                SetWindowText(GetDlgItem(hwndDlg, ID_CONV), "Decimal");
                Tmp = atol(NumberA);
                ltoa(Tmp, NumberA, 16);
                strupr(NumberA);
                SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
                //Hexa  = FALSE;
               }
            else
               {
                SetWindowText(GetDlgItem(hwndDlg, ID_CONV), "Hexa");
                //Hexa  = TRUE;
                Float = FALSE;
                strupr(NumberA);
                Tmp = Hexa2Long(NumberA);
                ltoa(Tmp, NumberA, 10);
                SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
                EnableWindow(GetDlgItem(hwndDlg, ID_POINT), FALSE);
               }
            EnableWindow(GetDlgItem(hwndDlg, IDA), Hexa);
            EnableWindow(GetDlgItem(hwndDlg, IDB), Hexa);
            EnableWindow(GetDlgItem(hwndDlg, IDC), Hexa);
            EnableWindow(GetDlgItem(hwndDlg, IDD), Hexa);
            EnableWindow(GetDlgItem(hwndDlg, IDE), Hexa);
            EnableWindow(GetDlgItem(hwndDlg, IDF), Hexa);
           } break;
         case ID_POINT:
            {
             if (!Float)
               {
                Float = TRUE;
                FirstNumberF = FirstNumber;
                AfterPoint = TRUE;
                Base10 = 0.1;
                if (FirstEntry)
                  {
                   FirstNumberF = FirstNumber;
                   sprintf(NumberA, "%8.4f", FirstNumberF);
                  }
                else
                  {
                   SecondNumberF = SecondNumber;
                   sprintf(NumberA, "%8.4f", SecondNumberF);
                  }
                SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
                EnableWindow(GetDlgItem(hwndDlg, ID_CONV), FALSE);
                EnableWindow(GetDlgItem(hwndDlg, ID_LSHIFT), FALSE);
                EnableWindow(GetDlgItem(hwndDlg, ID_RSHIFT), FALSE);
                EnableWindow(GetDlgItem(hwndDlg, ID_AND), FALSE);
                EnableWindow(GetDlgItem(hwndDlg, ID_OR), FALSE);
                EnableWindow(GetDlgItem(hwndDlg, ID_XOR), FALSE);
                EnableWindow(GetDlgItem(hwndDlg, ID_NOT), FALSE);
               }
            } break;
         case ID_BACK  : {
                          if (!Float)
                            {
                             if (Hexa)
                               {
                                if (FirstEntry)
                                 {
                                  FirstNumber>>=4;
                                  ltoa(FirstNumber, NumberA, 16);
                                  if (FirstNumber == 0)
                                     Base10 = 1;
                                 }
                                else
                                 {
                                  SecondNumber>>=4;
                                  ltoa(SecondNumber, NumberA, 16);
                                  if (SecondNumber == 0)
                                     Base10 = 1;
                                 }
                                strupr(NumberA);
                                SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
                               }
                             else
                               {
                                if (FirstEntry)
                                 {
                                  FirstNumber=FirstNumber / 10;
                                  ltoa(FirstNumber, NumberA, 10);
                                  if (FirstNumber == 0)
                                     Base10 = 1;
                                 }
                                else
                                 {
                                  SecondNumber=SecondNumber / 10;
                                  ltoa(SecondNumber, NumberA, 10);
                                  if (SecondNumber == 0)
                                     Base10 = 1;
                                 }
                                strupr(NumberA);
                                SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM) NumberA);
                               }
                            }
                         } break;
         case ID_PLUS  : SetOp( PLUS, hwndDlg ); break;
         case ID_MOINS : SetOp( MOINS, hwndDlg ); break;
         case ID_MULTI : SetOp( MULTI, hwndDlg ); break;
         case ID_DIVI  : SetOp( DIVI, hwndDlg ); break;
         case ID_LSHIFT: SetOp( LSHIFT, hwndDlg ); break;
         case ID_RSHIFT: SetOp( RSHIFT, hwndDlg ); break;
         case ID_OR    : SetOp( __OR, hwndDlg ); break;
         case ID_AND   : SetOp( __AND, hwndDlg ); break;
         case ID_XOR   : SetOp( __XOR, hwndDlg ); break;
         case ID_ERASE : {
                          SendDlgItemMessage(hwndDlg, 201, WM_SETTEXT, 0, (LPARAM)"0");
                          Hexa = FALSE;
                          Float = FALSE;
                          Base10 = 1;
                          FirstEntry = TRUE;
                          FirstNumberF = 0;
                          FirstNumber = 0;
                          SecondNumberF = 0;
                          SecondNumber = 0;
                          AfterPoint = FALSE;
                          Error = FALSE;
                          Op = 0;
                          NResultF = 0;
                          NResult = 0;
                          SetFocus(GetDlgItem(hwndDlg, ID_EQUAL));
                         } break;
         case ID_NOT   : SetOp( __NOT, hwndDlg );
         case ID_EQUAL:
            {
             Compute(hwndDlg);
             EnableWindow(GetDlgItem(hwndDlg, ID_CONV), TRUE);
             EnableWindow(GetDlgItem(hwndDlg, ID_LSHIFT), TRUE);
             EnableWindow(GetDlgItem(hwndDlg, ID_RSHIFT), TRUE);
             EnableWindow(GetDlgItem(hwndDlg, ID_AND), TRUE);
             EnableWindow(GetDlgItem(hwndDlg, ID_OR), TRUE);
             EnableWindow(GetDlgItem(hwndDlg, ID_XOR), TRUE);
             EnableWindow(GetDlgItem(hwndDlg, ID_NOT), TRUE);
             Base10 = 1;
             FirstEntry = TRUE;
             FirstNumberF  = 0;
             FirstNumber   = 0;
             SecondNumberF = 0;
             SecondNumber  = 0;
             AfterPoint = FALSE;
             Op = 0;
            } break;

         case IDCANCEL:
              EndDialog(hwndDlg, 1);
              break;
         case IDABOUT:
              DialogBox(DLLInstance, MAKEINTRESOURCE(101), hwndDlg, (DLGPROC) AboutProc);
              break;
        } break;
   }
 return FALSE;
}


BOOL CALLBACK AboutProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
 static HICON Icon;
 static int Draw;
 static int XPos = -24;
 static int Dir = -1;
 static HBITMAP Bitmaps[4];
 static HPEN Pen , OldPen;
 static HBITMAP OldBmp;
 static HDC MemDC;
 RECT r;
 int i;
 static HDC TDC;

 switch (msg)
   {
    case WM_INITDIALOG:
         Icon = LoadIcon(DLLInstance, MAKEINTRESOURCE(100));
         for (i = 100; i < 104; i++)
             Bitmaps[i - 100] = LoadBitmap(DLLInstance, MAKEINTRESOURCE(i));
         SetTimer(hwndDlg, 1, 35, NULL);
         TDC = GetDC(hwndDlg);
         MemDC = CreateCompatibleDC(TDC);
         Pen = CreatePen(PS_SOLID, 1, RGB(192, 192, 192));
         OldPen = SelectObject(TDC, Pen);
         Draw = 0;
         break;
    case WM_DESTROY:
         KillTimer(hwndDlg, 1);
         for (i = 0; i < 4; i++)
             DeleteObject(Bitmaps[i]);
         DeleteDC(MemDC);
         ReleaseDC(hwndDlg, TDC);
         SelectObject(TDC, Pen);
         DeleteObject(Pen);
         break;
    case WM_TIMER:
         GetClientRect(hwndDlg, &r);
         if (XPos <= -24)
             XPos = r.right;
         MoveTo(TDC, XPos+24, 135);
         LineTo(TDC, XPos+24, 159);
         OldBmp = SelectObject(MemDC, Bitmaps[Draw]);
         BitBlt(TDC, XPos, 135, 24, 24, MemDC, 0, 0, SRCCOPY);
         Draw+=Dir;
         XPos--;
         if (Draw==4)
            {
             Draw = 3;
             Dir = -1;
            }
         if (Draw == -1)
            {
             Draw = 0;
             Dir = 1;
            }
         return 0;
    case WM_COMMAND:
         switch (LOWORD(wParam))
            {
             case IDOK:
               EndDialog(hwndDlg, 1);
               break;
            } break;
   }
return FALSE;
}


