#ifndef __cplusplus
#error WindowsClasses Require C++!!
#endif

#ifndef __COMPACT__
#ifndef __LARGE__
#error WindowsClasses Require Compact or Large memory model compilation
#endif
#endif

#ifndef __WINDOWS_H
#include <windows.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#ifndef __WINCLASS_HPP
#define __WINCLASS_HPP
#define __WINCLASSVER "1.40"


class Window {
	/*
        	WINCLASS.HPP
                Code by Michael Pittelkow
                Copyright (c) 1991, All Rights Reserved
                Hereby released as MostlyFreeWare.
                [That means, if you like it, and use it a lot, please send
                 a donation to my college fund.  If you use it in something
		 that earns income for you, you by default fall into this
		 category.  If you like it, and don't use it much, or, just
		 don't feel it's worth anything, then don't feel obligated
		 to send anything.  Either way, pass this on to whomever
		 you please!]



                Michael Pittelkow
                [summer]		[aug-may]
                10619 Zinran Circle     Friley 3399 Knapp
                Bloomington, MN  55438  Iowa State University
                			Ames, IA 50012

          				BITNET	TNA32@ISUVAX
                                     	TELNET  tna32@ccvax.iastate.edu

     		 Find a bug?  Got a suggestion?  Got a snazzy addition?
		 Drop a line to the appropriate address (please use ONLY
		 snail mail during the summer) above.

                Feel free to distibute this class, but please don't modify
                it, it's hard enough to keep up with my own code without
                trying to debug someone elses.  If you wish to distribute
                this file with your own derived classes, that's fine, but
                please put YOUR CLASSES in a SEPERATE FILE.  This module is
                set up to provide information for anything that would want
                to use it, such as defining the __WINCLASS_HPP.

        	This class (window) is almost everything to set up a
                window.

                The window class is given a classname that is the address
                of the ClassName pointer itself, followed by a "mp" postfix.
                This results in a guaranteed different name for each new
                variable of the class type, because they will always be at
                different memory addresses. [1672D4A:1.2:mp]




  public        Window(LPSTR TitleBar,HANDLE hInstance,(FAR PASCAL....) lpfnWndProc());
  public        Window(LPSTR TitleBar,HANDLE hInstance,(FAR PASCAL *lpfnWndProc)(), int nCmdShow);
  public	SetClassname(LPSTR cname); Sets classname (see getclassname for default);
  public	SethbrBackground(HBRUSH color); set background brush,
  						default = COLOR_APPWORKSPACE+1
  public        SetCreateStyle(DWORD style); for window creation time, see
					documentation for CreateWindow()
                                        default = NULL
  public        SetStyle(WORD style);      for class creation time, see
                			documentation for RegisterClass()
                                        default = NULL
  public        SetWndProc((FAR PASCAL *lpfnWndProc)()); default = DefWindowProc
  public        SetIcon(HICON hIcon); default = IDI_APPLICATION
  public        SetInitialCursor(HCURSOR hCursor); default = IDC_ARROW
  public        SetInitialBackground(HBRUSH hbrBackground);  default = WHITE_BRUSH
  public        SetInitialMenu(LPSTR MenuName); default = NULL
  public        BOOL SetMenu(LPSTR MenuName);
  public        SetParent(HWND hParent); default = NULL
  public        SetInitialPosition(int x, int y); default = CW_DEFAULT
  public        SetInitialSize(int width, int height); default = CW_DEFAULT
  protected     RegisterAndOpen(int nCmdShow);
  public        HWND GethWnd(void);  returns a handle to the window (for
			 	     adding hooks into a new class).
  public        LPSTR GetClassName(void); returns classname, a string that is
                			made up of the address of a particular
                                        class function, winclassed vers, and a postfix
					of mp, like "123412432A:1.2:mp", unless overridden
                                        by a call to SetClassname
  public        Close(void);  closes but does not deregister any information
                		about the window, use Reopen() reopen.
  public        Open(int nCmdShow); Registers and opens the window.
  public        Reopen(int nCmdShow); Reopens a closed window.
  private	MakeClassName(void); Makes the classname (see getclassname).



        */

protected:
	WNDCLASS wc;
        static defBackgroundBrush;
        LPSTR lpszTitle;
        DWORD  	CreateStyle;
        int   	x;
        int    	y;
        int   	width;
        int		height;
        HWND	 	hParent;
        HMENU		hMenu;
        HWND		hWnd;
        char     	ClassName[30];
        BOOL		WinClosed;

        void RegisterAndOpen(int nCmdShow)
        	{
                 MakeClassName();
                 RegisterClass(&wc);
                 hWnd = CreateWindow(wc.lpszClassName,
                 		lpszTitle,
                                CreateStyle,
                                x,
                                y,
                                width,
                                height,
                                hParent,
                                hMenu,
                                wc.hInstance,
				NULL);
                 ShowWindow(hWnd,nCmdShow);
                 UpdateWindow(hWnd);
                }

private:
	void MakeClassName(void)
        	{  LPSTR version = __WINCLASSVER;

               	 wsprintf(ClassName,"%lX:%s:mp",ClassName,version);
                }



public:
	void SetClassname(LPSTR clname)
        	{
                 stpcpy(ClassName,clname);
                }
        HWND GethWnd(void)
        	{
                 return hWnd;
                }
        LPSTR GetClassName(void)
        	{
                 return ClassName;
                }
void	SethbrBackground(HBRUSH color)
		{
                 wc.hbrBackground = color;
                }
        Window(LPSTR TitleBar, HANDLE hInstance,long (FAR PASCAL *lpfnWndProc)(HANDLE hWnd,unsigned message, WORD wParam,LONG lParam))
        	{
                 hWnd = NULL;
                 WinClosed = TRUE;
                 CreateStyle = NULL;
                 lpszTitle = TitleBar;
                 wc.hInstance = hInstance;
                 wc.style = NULL;
                 wc.lpfnWndProc = lpfnWndProc;
                 wc.cbClsExtra = 0;
                 wc.cbWndExtra = 0;
                 wc.hIcon = LoadIcon(NULL,IDI_APPLICATION);
                 wc.hCursor = LoadCursor(NULL,IDC_ARROW);
                 wc.hbrBackground = COLOR_APPWORKSPACE+1;
                 wc.lpszClassName = ClassName;
                 wc.lpszMenuName = NULL;
                 x = CW_USEDEFAULT;
                 y = CW_USEDEFAULT;
                 height = CW_USEDEFAULT;
                 width = CW_USEDEFAULT;
                 hMenu = NULL;
                 hParent = NULL;

                }
        void Reopen(int nCmdShow)
        	{
           	ShowWindow(hWnd,nCmdShow);
           	UpdateWindow(hWnd);
          	}
        Window(LPSTR TitleBar ,HANDLE hInstance,long (FAR PASCAL *lpfnWndProc)(HANDLE hWnd,unsigned message, WORD wParam,LONG lParam), int nCmdShow)
	        {
                 hWnd = NULL;
                 WinClosed = TRUE;
                 CreateStyle = NULL;
                 lpszTitle = TitleBar;
                 wc.hInstance = hInstance;
                 wc.style = NULL;
                 wc.lpfnWndProc = lpfnWndProc;
                 wc.cbClsExtra = 0;
                 wc.cbWndExtra = 0;
                 wc.hIcon = LoadIcon(NULL,IDI_APPLICATION);
                 wc.hCursor = LoadCursor(NULL,IDC_ARROW);
                 wc.hbrBackground = COLOR_APPWORKSPACE+1;
                 wc.lpszClassName = ClassName;
                 wc.lpszMenuName = NULL;
                 x = CW_USEDEFAULT;
                 y = CW_USEDEFAULT;
                 height = CW_USEDEFAULT;
                 width = CW_USEDEFAULT;
                 hMenu = NULL;
                 hParent = NULL;
                 RegisterAndOpen(nCmdShow);

                }
        ~Window(void)
        	{
                 if (!WinClosed)  DestroyWindow(hWnd);
                 UnregisterClass(ClassName,wc.hInstance);
                }
        void SetParent(HWND hPar)
        	{
                 hParent = hPar;
                }
        void SetInitialPosition(int x1, int y1)
        	{
                 x = x1;
                 y = y1;
                }
        void SetInitialSize(int w2,int h2)
        	{
                 width = w2;
                 height = h2;
                }

	   void SetInitialTitle(LPSTR TitleBar)
        	{
                 lpszTitle = TitleBar;
                }
        void SetNewTitle(LPSTR TitleBar)
           {
           	SetWindowText(hWnd,TitleBar);
           }
        void SetStyle(WORD style)
        	{
                 wc.style = style;
                }
        void AddStyle(WORD style)
        	{
          	wc.style &= style;
               }
        void SetWndProc(long (FAR PASCAL *lpfnWndProc)(unsigned int ,unsigned int ,unsigned int ,long))
	      	{
                 wc.lpfnWndProc = lpfnWndProc;
                }
        void SetIcon(HICON hIcon)
        	{
                 wc.hIcon = hIcon;
                }
        void SetInitialCursor(HCURSOR hCursor)
        	{
                 wc.hCursor = hCursor;
                }
        void SetInitialBackground(HBRUSH hbrBackground)
        	{
                 wc.hbrBackground = hbrBackground;
                }
        void SetInitialMenu(LPSTR lpszMenuName)
        	{
                 wc.lpszMenuName = lpszMenuName;
                }
        HMENU GethMenu( void )
          {      return GetMenu(hWnd);
          }
        BOOL SetMenu(LPSTR lpszMenuName)
        	{
          	return ::SetMenu(hWnd,LoadMenu(wc.hInstance,lpszMenuName));
          }

        void SetCreateStyle(DWORD newst)
        	{
                 CreateStyle = newst;
                }
        void AddCreateStyle(DWORD newst)
        	{
          	CreateStyle &= newst;
               }
	   void Close( void )
        	{
                 WinClosed = DestroyWindow(hWnd);
                }
	   WNDCLASS GetClass( void )
        	{
                 return wc;
                }
        void SameAs( WNDCLASS wc2 )
        	{
                 wc = wc2;
                }
        char *Open(int nCmdShow)
        	{
                 RegisterAndOpen(nCmdShow);
                 return "WindowsClasses Copyright (c) 1991 Michael Pittelkow";
                }

};

// Here are two examples of derived classes of the basic window type,
// one Modal, one Overlapped.

class  OverlappedWindow : public Window {
public:
OverlappedWindow(LPSTR TitleBar, HANDLE hInstance,long (FAR PASCAL *lpfnWndProc)(HANDLE hWnd,unsigned message, WORD wParam,LONG lParam)) : Window(TitleBar, hInstance, lpfnWndProc)
        	{
                 SetCreateStyle(WS_OVERLAPPEDWINDOW);
                }
OverlappedWindow(LPSTR TitleBar, HANDLE hInstance,long (FAR PASCAL *lpfnWndProc)(HANDLE hWnd,unsigned message, WORD wParam,LONG lParam), int nCmdShow) : Window(TitleBar, hInstance, lpfnWndProc)
        	{
                 SetCreateStyle(WS_OVERLAPPEDWINDOW);
                 RegisterAndOpen(nCmdShow);
                }
        };
class  ModalWindow : public Window {
public:
ModalWindow(LPSTR TitleBar, HANDLE hInstance,long (FAR PASCAL *lpfnWndProc)(HANDLE hWnd,unsigned message, WORD wParam,LONG lParam)) : Window(TitleBar, hInstance, lpfnWndProc)
        	{
                 SetCreateStyle(DS_MODALFRAME);
                 SethbrBackground(COLOR_WINDOW+1);
                }
ModalWindow(LPSTR TitleBar, HANDLE hInstance,long (FAR PASCAL *lpfnWndProc)(HANDLE hWnd,unsigned message, WORD wParam,LONG lParam), int nCmdShow) : Window(TitleBar, hInstance, lpfnWndProc)
        	{
                 SetCreateStyle(DS_MODALFRAME);
                 SethbrBackground(COLOR_WINDOW+1);
                 RegisterAndOpen(nCmdShow);
                }
        };
#endif
