/*-----------------------------------------------------------------
  This module loads and releases the System Hook DLL, WINHOOK.DLL.
------------------------------------------------------------------*/

#define INCL_DOS
#define INCL_ERRORS
#define INCL_PM
#define NUL '\0'

#include <os2.h>
#include <stdio.h>
#include <string.h>

#include "winback.h"

HAB              hab;
HMODULE          hmodule = (HMODULE)NULL;
PFN              pfnInputHook;

MRESULT EXPENTRY WinbackWndProc( HWND, USHORT, MPARAM, MPARAM );

VOID cdecl main()
  {
  HMQ              hmq;
  HPOINTER         hptrIcon;
  HWND             hwndDlg;

  hab = WinInitialize( NUL );
  hmq = WinCreateMsgQueue( hab, 0 );

  hwndDlg = WinLoadDlg( HWND_DESKTOP,        /* Load the dialog window     */
                        HWND_DESKTOP,        /* which allows turning the   */
                        WinbackDlgProc,      /* hook on and off.  This     */
                        NUL,                 /* window also provides a     */
                        IDD_WINBACK,         /* visual notification that a */
                        NUL );               /* hook may be active (if set)*/

  hptrIcon = WinLoadPointer( HWND_DESKTOP, NUL, IDD_WINBACK );

  WinSendMsg( hwndDlg,                       /* Attach the icon to the     */
              WM_SETICON,                    /* frame window.              */
              (MPARAM)hptrIcon,
              (MPARAM)NULL );

  WinProcessDlg( hwndDlg );

  WinReleaseHook( hab,            /* Make sure hook is released */
                  (HMQ)NULL,
                  HK_INPUT,
                  pfnInputHook,
                  hmodule );

  WinDestroyWindow( hwndDlg );

  WinDestroyMsgQueue( hmq );

  WinTerminate( hab );

  return;
  }


/***************************************************************************|
| Change Pointer Window Procedure                                             |
|***************************************************************************/

MRESULT EXPENTRY WinbackDlgProc( hwnd, msg, mp1, mp2 )
HWND         hwnd;
USHORT       msg;
MPARAM       mp1;
MPARAM       mp2;
{
  USHORT      usCheckedState;
  HWND        hwndSysMenu;          /* system menu handle       */

  switch(msg)
  {

    case WM_INITDLG:
    {
      USHORT      idSysMenu;            /* system menu id           */
      MENUITEM    miSysMenu;            /* system menu item info    */
      MENUITEM    miMenuItem;           /* About menu item info     */
      USHORT           rc = 0;           /* return code */

        /* add About item to system menu */
        if ( hwndSysMenu = WinWindowFromID( hwnd, FID_SYSMENU ) )
        {
          /* get handle of system submenu */
          idSysMenu = SHORT1FROMMR( WinSendMsg( hwndSysMenu, MM_ITEMIDFROMPOSITION, MPFROMSHORT( 0 ), 0L ) );
          WinSendMsg( hwndSysMenu, MM_QUERYITEM, MPFROM2SHORT( idSysMenu, FALSE ), MPFROMP( &miSysMenu ) );
          hwndSysMenu = miSysMenu.hwndSubMenu;

          /* add menu separator */
          miMenuItem.iPosition = MIT_END;
          miMenuItem.afStyle = MIS_SEPARATOR;
          miMenuItem.afAttribute = 0;
          miMenuItem.id = 0;
          miMenuItem.hwndSubMenu = NUL;
          miMenuItem.hItem = NUL;
          WinSendMsg( hwndSysMenu, MM_INSERTITEM, MPFROMP( &miMenuItem ), NUL );

          /* add About item */
          miMenuItem.afStyle = MIS_TEXT;
          miMenuItem.id = IDM_ABOUT;
          WinSendMsg( hwndSysMenu, MM_INSERTITEM, MPFROMP( &miMenuItem ), MPFROMP( "A~bout..." ) );

       }

      WinSetDlgItemText( hwnd,            /* Set title bar text        */
                          FID_TITLEBAR,
                        "WinBack Utility" );

      WinSendMsg( WinWindowFromID( hwnd,IDCB_WINBACKSW ),
                  BM_SETCHECK,                /* set check box */
                  MPFROMSHORT(1),
                  (MPARAM)NULL );


      rc = 0;
      rc = DosLoadModule( NULL,                /* Load the DLL module        */
                      0,                        /* containing the Hook        */
                      "Winhook",               /* procedure (must use a DLL).*/
                      &hmodule );               /* Get module handle          */
      if(rc)
      {
          WinMessageBox (HWND_DESKTOP,HWND_DESKTOP,
                        "There was an error in loading WINHOOK.DLL",
                        "DLL could not be loaded",
                         0,MB_OK | MB_ERROR);
          WinPostMsg(hwnd,WM_CLOSE,0L,0L);
      }
      else
      {
          rc = DosGetProcAddr( hmodule,            /* Get address of Hook Proc.  */
                          "WINHOOKPROC",          /* FOR THE WINSETHOOK AND     */
                          &pfnInputHook );         /* WinReleaseHook calls.      */
          if(rc)
          {
             WinMessageBox (HWND_DESKTOP,HWND_DESKTOP,
                           "There is an error in WINHOOK.DLL",
                           "Error in DLL",
                            0,MB_OK | MB_ERROR);
             WinPostMsg(hwnd,WM_CLOSE,0L,0L);
          }
          else
          {
             WinSetHook( hab,
                         (HMQ)NULL,   /* set hook to capture*/
                         HK_INPUT,    /* input messages for filtering.*/
                         pfnInputHook,
                         hmodule );
         }
      }
      break;
    }

    case WM_COMMAND:
      switch ( COMMANDMSG( &msg )->cmd )
      {
        case IDM_ABOUT:
          WinDlgBox( HWND_DESKTOP, hwnd, AboutDlgProc, NUL, IDD_ABOUT, NUL );
          return( (MRESULT)TRUE );
          break;
      break;
      }

    case WM_CONTROL:
      if(    (SHORT1FROMMP(mp1) != IDCB_WINBACKSW)   /* Only care about CLICK */
          || (SHORT2FROMMP(mp1) != BN_CLICKED) )  /* Check Box messages.   */
        break;
      usCheckedState                               /* Query if check box is*/
        = SHORT1FROMMR( WinSendDlgItemMsg( hwnd,  /* set or not after     */
                                    IDCB_WINBACKSW,
                                    BM_QUERYCHECK, /* activity in the check*/
                                    (MPARAM)NULL,  /* box.                 */
                                    (MPARAM)NULL ) );
      if( usCheckedState == 1 )
      {
        WinSetHook( hab,                   /* Check box is checked so make */
                    (HMQ)NULL,             /* sure hook is "set" to capture*/
                    HK_INPUT,              /* input messages for filtering.*/
                    pfnInputHook,
                    hmodule );
      }
      else
      {
        WinReleaseHook( hab,               /* Check box is not checked so  */
                        (HMQ)NULL,         /* make sure hook is not "set"  */
                        HK_INPUT,          /* so input messages are not    */
                        pfnInputHook,      /* intercepted by the hook      */
                        hmodule );         /* procedure.                   */
      }
      break;

    case WM_ERASEBACKGROUND:
      return( (MRESULT)TRUE );
      break;

    case WM_MINMAXFRAME:
      {
        PSWP        pswp;                     /* pos change structure */

        /* hide check box when minimized so it doesn't overwrite icon */
        pswp = PVOIDFROMMP( mp1 );
        WinShowWindow(
          WinWindowFromID( hwnd, IDCB_WINBACKSW ),
          !(pswp->fs & SWP_MINIMIZE)
        );
      }
      break;


  }

  return( WinDefDlgProc( hwnd, msg, mp1, mp2 ) );
}

/*
 * AboutDlgProc( hwndDlg, usMsg, mp1, mp2 ) : MRESULT;
 *
 *    hwndDlg        handle to dialog box
 *    usMsg          message number
 *    mp1            message parameter 1
 *    mp2            message parameter 2
 *
 * This is the dialog procedure for the About dialog box.
 *
 */

MRESULT EXPENTRY AboutDlgProc( HWND hwndDlg, USHORT usMsg, MPARAM mp1, MPARAM mp2 )
{
  MRESULT       mresRtnVal;                 /* function return value  */
  BOOL          fPassToDef;                 /* pass to def dlg proc?  */

  mresRtnVal = FALSE;
  fPassToDef = FALSE;

  switch ( usMsg ) {

    case WM_INITDLG:
      break;

    case WM_COMMAND:
      switch ( COMMANDMSG( &usMsg )->cmd ) {
        case DID_OK:
          WinDismissDlg( hwndDlg, TRUE );
          break;
        default:
          fPassToDef = TRUE;
          break;
      }
      break;

    default:
      fPassToDef = TRUE;
      break;

  }

  if ( fPassToDef )
    mresRtnVal = WinDefDlgProc( hwndDlg, usMsg, mp1, mp2 );

  return mresRtnVal;
}

/* Exit List processing at program termination */

VOID APIENTRY ProgramTermination( )
  {

  if( hmodule != (HMODULE)NULL )       /* Unfortunately does not free the  */
    DosFreeModule( hmodule );          /* DLL because System Input Queue   */
                                       /* hooks cannot be freed.           */


  DosExitList( EXLST_EXIT,             /* Required to end ExitList process.*/
               (PFNEXITLIST)ProgramTermination );
  }
