
{-----------------------------------------------------------------------------}
{                                                                             }
{           WEDL(tm) - Windows Enhanced Dialog Library                        }
{           Copyright (c) 1991-1992, Nemisoft, Inc.                           }
{           All Rights Reserved                                               }
{           Module:  WEDLE.PAS                                                }
{                                                                             }
{-----------------------------------------------------------------------------}

unit WEDL;

interface

uses WinTypes;

const

    FMF_NONE     : LongInt = 0;
    FMF_OVERTYPE : LongInt = 1;
    FMF_UPDATE   : LongInt = 2;
    FMF_VKEYPRES : LongInt = 4;
    FMF_VLEAVFLD : LongInt = 8;
    FMF_NOSELECT : LongInt = 16;
    FMF_COMPAT   : LongInt = 32;

    FDF_NONE     : LongInt = 0;
    FDF_COMPLETE : LongInt = 1;
    FDF_NOTBLANK : LongInt = 2;
    FDF_NOTZERO  : LongInt = 4;
    FDF_NOTEDIT  : LongInt = 8;
    FDF_MUSTEDIT : LongInt = 16;
    FDF_UPDATE   : LongInt = 32;
    FDF_NOSELECT : LongInt = 64;
    FDF_SPCFILL  : LongInt = 128;
    FDF_ZEROFILL : LongInt = 256;
    FDF_BLNKZERO : LongInt = 512;
    FDF_BLNKNEZ  : LongInt = 1024;
    FDF_PHYSICAL : LongInt = 2048;
    FDF_UPPER    : LongInt = 4096;
    FDF_LOWER    : LongInt = 8192;
    FDF_PROPER   : LongInt = 16384;
    FDF_NUMERIC  : LongInt = 32768;
    FDF_CALCNUM  : LongInt = 65536;
    FDF_VKEYPRES : LongInt = 131072;
    FDF_VLEAVFLD : LongInt = 262144;
    FDF_COMBO    : LongInt = 524288;

    ELC_BLANK    : LongInt = 1;
    ELC_ZERO     : LongInt = 2;
    ELC_EDITED   : LongInt = 3;
    ELC_CHECKED  : LongInt = 4;

    FDT_NULL     = 0;
    FDT_STRING   = 1;
    FDT_SHORT    = 2;
    FDT_USHORT   = 3;
    FDT_INTEGER  = 4;
    FDT_UNSIGNED = 5;
    FDT_LONG     = 6;
    FDT_ULONG    = 7;
    FDT_FLOAT    = 8;
    FDT_DOUBLE   = 9;

    BTF_NONE     : LongInt = 0;
    BTF_CHECKED  : LongInt = 1;
    BTF_GRAYED   : LongInt = 2;
    BTF_UPDATE   : LongInt = 4;
    BTF_GENERIC  : LongInt = 8;
    BTF_IDOK     : LongInt = 16;
    BTF_IDCANCEL : LongInt = 32;

    KSM_INSERT   = 0;
    KSM_CAPSLOCK = 1;
    KSM_NUMLOCK  = 2;

    ERV_BLANK    = 27701;
    ERV_INCOMPL  = 27702;
    ERV_INVCHAR  = 27703;
    ERV_NOTEDIT  = 27704;
    ERV_UNEDITED = 27705;
    ERV_ZERO     = 27706;

    ERE_KEYPRESS = 1;
    ERE_LEAVEFLD = 2;
    ERE_SELECTOK = 3;

type

    HFORM        = THandle;
    HFIELD       = THandle;
    HBUTTON      = THandle;

    PVALFUNC     = TFarProc;
    PERRFUNC     = TFarProc;

    FIELD = record
        features          : LongInt;
        help_context      : LongInt;
        picture_string    : PStr;
        pdata             : LPVoid;
        pvalid_func       : PVALFUNC;
        hcombo            : HWnd;
        hwnd              : HWnd;
        hfield            : HFIELD;
        hnext_field       : HFIELD;
        ctrl_id           : Integer;
        data_type         : Integer;
        decimal_position  : Integer;
        error_value       : Integer;
        logical_size      : Integer;
        physical_size     : Integer;
        has_changed       : Bool;
    end;

    PFIELD  = ^FIELD;
    LPFIELD = PFIELD;

    FIELD_POS = record
        ppicture_str_pos  : PStr;
        selection         : LongInt;
        logical_position  : Integer;
        physical_position : Integer;
        val_char_occ      : Integer;
        to_right_of_dec   : Bool;
        validation_char   : Char;
    end;

    PFIELD_POS  = ^FIELD_POS;
    LPFIELD_POS = PFIELD_POS;

    FORM = record
        features          : LongInt;
        perror_func       : PERRFUNC;
        pdialog_proc      : TFarProc;
        help_context      : LongInt;
        capslock_offmsg   : PStr;
        capslock_onmsg    : PStr;
        help_file_name    : PStr;
        insert_offmsg     : PStr;
        insert_onmsg      : PStr;
        numlock_offmsg    : PStr;
        numlock_onmsg     : PStr;
        undo_selection    : LongInt;
        hhead_elink       : THandle;
        hproc_array       : THandle;
        hundo_buffer1     : THandle;
        hundo_buffer2     : THandle;
        hdlg              : HWnd;
        hform             : HFORM;
        hnext_form        : HFORM;
        hcurr_field       : HFIELD;
        herror_field      : HFIELD;
        hhead_field       : HFIELD;
        hhead_button      : HBUTTON;
        cancel_id         : Integer;
        capslock_id       : Integer;
        error_event       : Integer;
        error_position    : Integer;
        error_value       : Integer;
        insert_id         : Integer;
        numlock_id        : Integer;
        num_controls      : Integer;
        ok_id             : Integer;
        undo_level        : Integer;
        edit_key_pressed  : Bool;
        help_invoked      : Bool;
        insert_mode       : Bool;
        in_error_handler  : Bool;
        just_passed_dec   : Bool;
        pressed_cancel    : Bool;
    end;

    PFORM  = ^FORM;
    LPFORM = PFORM;

    BUTTON = record
        features          : LongInt;
        help_context      : LongInt;
        pdata             : PInteger;
        hwnd              : HWnd;
        hbutton           : HBUTTON;
        hnext_button      : HBUTTON;
        ctrl_id           : Integer;
        group_id          : Integer;
        off_value         : Integer;
        on_value          : Integer;
        has_changed       : Bool;
    end;

    PBUTTON  = ^BUTTON;
    LPBUTTON = PBUTTON;

function button_define( form: HFORM; ctrl_id: Integer; pdata: PInteger;
                        group_id, on_value, off_value: Integer;
                        features, help_context: LongInt ): HBUTTON;
function button_get_check( button: HBUTTON ): Integer;
function button_get_from_ctrl_id( form: HFORM; ctrl_id: Integer ): HBUTTON;
function button_get_from_group( form: HFORM; group_id: Integer): HBUTTON;
function button_get_from_hwnd( form: HFORM; Wnd: HWnd ): HBUTTON;
function button_get_hwnd( button: HBUTTON ): HWnd;
function button_has_changed( button: HBUTTON ): Bool;
function button_lock( button: HBUTTON ): LPBUTTON;
function button_set_check( button: HBUTTON; state: Integer ): Integer;
procedure button_unlock( button: HBUTTON );

function char_is_printable( ch: Integer ): Bool;
function char_to_lower( ch: Integer ): Integer;
function char_to_upper( ch: Integer ): Integer;

function field_data_to_log( field: HFIELD; pbuf: PStr; pdata: LPVoid;
                            data_type: Integer ): Integer;
function field_define( form: HFORM; ctrl_id: Integer; pdata: LPVoid;
                       data_type: Integer; picture_string: PStr;
                       features: LongInt; pvalid_func: PVALFUNC;
                       error_value: Integer; help_context: LongInt ): HFIELD;
function field_get_character( field: HFIELD; position: Integer;
                              physical: Bool ): Integer;
function field_get_from_ctrl_id( form: HFORM; ctrl_id: Integer ): HFIELD;
function field_get_from_hwnd( form: HFORM; Wnd: HWnd ): HFIELD;
function field_get_hwnd( field: HFIELD ): HWND;
function field_get_pos_info( field: HFIELD; logical_position: Integer;
                             pfpos: LPFIELD_POS ): Integer;
function field_get_position( field: HFIELD; pfpos: LPFIELD_POS ): Integer;
function field_get_text( field: HFIELD; pbuf: PStr; physical: Bool ): Integer;
function field_has_changed( field: HFIELD ): Bool;
function field_lock( field: HFIELD ): LPFIELD;
function field_log_to_data( field: HFIELD; pbuf: PStr; pdata: LPVoid;
                            data_type: Integer ): Integer;
function field_log_to_phys( field: HFIELD; pbuf: PStr ): Integer;
function field_phys_to_log( field: HFIELD; pbuf: PStr ): Integer;
function field_set_text( field: HFIELD; pbuf: PStr; physical: Bool ): Integer;
procedure field_unlock( field: HFIELD );

function form_begin( hDlg: HWnd; features: LongInt; perror_func: PERRFUNC ): HFORM;
function form_cancel( form: HFORM ): Integer;
function form_end( form: HFORM ): Integer;
function form_exists( form: HFORM ): Bool;
function form_get_from_hdlg( hDlg: HWnd ): HFORM;
function form_get_hdlg( form: HFORM ): HWnd;
function form_has_changed( form: HFORM ): Bool;
function form_in_error_cond( form: HFORM ): Bool;
function form_is_cancelled( form: HFORM ): Bool;
function form_load( form: HFORM ): Integer;
function form_lock( form: HFORM ): LPFORM;
function form_ok( form: HFORM ): Integer;
function form_save( form: HFORM ): Integer;
function form_set_enable_link( form: HFORM; hcontrol: THandle;
                               condition: LongInt; ctrl_id: Integer;
                               enable: Bool ) : Integer;
function form_set_help( form: HFORM; help_file_name: PStr;
                        help_context: LongInt ): Integer;
procedure form_unlock( form: HFORM );
function form_validate( form: HFORM ): HFIELD;

function generic_define( form: HFORM; ctrl_id: Integer;
                         help_context: LongInt ): THandle;

function keystat_define( form: HFORM; ctrl_id, which: Integer;
                         onmsg, offmsg: PStr ): Integer;

function str_delete_char( str: PStr; ch: Integer ): Integer;
procedure str_insert_char( str: PStr; ch, offs: Integer );
function str_is_blank( str: PStr ): Bool;
function str_is_value_zero( str: PStr ): Bool;
procedure str_trim_spaces( str: PStr );

implementation

function button_define;             external 'WEDL2E' index 7;
function button_get_check;          external 'WEDL2E' index 8;
function button_get_from_ctrl_id;   external 'WEDL2E' index 9;
function button_get_from_group;     external 'WEDL2E' index 10;
function button_get_from_hwnd;      external 'WEDL2E' index 11;
function button_get_hwnd;           external 'WEDL2E' index 12;
function button_has_changed;        external 'WEDL2E' index 13;
function button_lock;               external 'WEDL2E' index 14;
function button_set_check;          external 'WEDL2E' index 15;
procedure button_unlock;            external 'WEDL2E' index 16;
function char_is_printable;         external 'WEDL2E' index 17;
function char_to_lower;             external 'WEDL2E' index 18;
function char_to_upper;             external 'WEDL2E' index 19;
function field_data_to_log;         external 'WEDL2E' index 20;
function field_define;              external 'WEDL2E' index 21;
function field_get_character;       external 'WEDL2E' index 22;
function field_get_from_ctrl_id;    external 'WEDL2E' index 23;
function field_get_from_hwnd;       external 'WEDL2E' index 24;
function field_get_hwnd;            external 'WEDL2E' index 25;
function field_get_pos_info;        external 'WEDL2E' index 26;
function field_get_position;        external 'WEDL2E' index 27;
function field_get_text;            external 'WEDL2E' index 28;
function field_has_changed;         external 'WEDL2E' index 29;
function field_lock;                external 'WEDL2E' index 30;
function field_log_to_data;         external 'WEDL2E' index 31;
function field_log_to_phys;         external 'WEDL2E' index 32;
function field_phys_to_log;         external 'WEDL2E' index 33;
function field_set_text;            external 'WEDL2E' index 34;
procedure field_unlock;             external 'WEDL2E' index 35;
function form_begin;                external 'WEDL2E' index 36;
function form_cancel;               external 'WEDL2E' index 37;
function form_end;                  external 'WEDL2E' index 38;
function form_exists;               external 'WEDL2E' index 39;
function form_get_from_hdlg;        external 'WEDL2E' index 40;
function form_get_hdlg;             external 'WEDL2E' index 41;
function form_has_changed;          external 'WEDL2E' index 42;
function form_in_error_cond;        external 'WEDL2E' index 43;
function form_is_cancelled;         external 'WEDL2E' index 44;
function form_load;                 external 'WEDL2E' index 45;
function form_lock;                 external 'WEDL2E' index 46;
function form_ok;                   external 'WEDL2E' index 47;
function form_save;                 external 'WEDL2E' index 48;
function form_set_enable_link;      external 'WEDL2E' index 49;
function form_set_help;             external 'WEDL2E' index 50;
procedure form_unlock;              external 'WEDL2E' index 51;
function form_validate;             external 'WEDL2E' index 52;
function generic_define;            external 'WEDL2E' index 53;
function keystat_define;            external 'WEDL2E' index 54;
function str_delete_char;           external 'WEDL2E' index 55;
procedure str_insert_char;          external 'WEDL2E' index 56;
function str_is_blank;              external 'WEDL2E' index 57;
function str_is_value_zero;         external 'WEDL2E' index 58;
procedure str_trim_spaces;          external 'WEDL2E' index 59;

end.

