
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          WEDL(tm) - Windows Enhanced Dialog Library                       */
/*          Copyright (c) 1991-1992, Nemisoft, Inc.                          */
/*          All Rights Reserved                                              */
/*          Module:  WEDL.H                                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#if !defined( __WEDL_H )
    #define __WEDL_H

/*---------------------------------------------------------------------------*/

/* Windows 3.0 SDK compatibility */

#if !defined( WINAPI )
    #define CALLBACK FAR PASCAL
    #define WINAPI FAR PASCAL
    typedef unsigned int UINT;
    typedef UINT WPARAM;
    typedef LONG LPARAM;
    typedef LONG LRESULT;
    typedef HANDLE HINSTANCE;
    typedef HANDLE HDROP;
    typedef LRESULT (CALLBACK* WNDPROC)(HWND, UINT, WPARAM, LPARAM);
#endif

/*---------------------------------------------------------------------------*/

/* form feature definitions */

#define FMF_NONE        0L      /* no features specified                  */
#define FMF_OVERTYPE    1L      /* set Insert mode off by default         */
#define FMF_UPDATE      2L      /* set all controls in update mode        */
#define FMF_VKEYPRES    4L      /* perform validation after each keypress */
#define FMF_VLEAVFLD    8L      /* do validation when user leaves field   */
#define FMF_NOSELECT    16L     /* no auto-select of fields upon focus    */
#define FMF_COMPAT      32L     /* compatibility mode                     */

/*---------------------------------------------------------------------------*/

/* field feature definitions */

#define FDF_NONE        0L      /* no features specified                  */
#define FDF_COMPLETE    1L      /* field must be complete                 */
#define FDF_NOTBLANK    2L      /* field cannot be blank                  */
#define FDF_NOTZERO     4L      /* field cannot be zero                   */
#define FDF_NOTEDIT     8L      /* field cannot be edited                 */
#define FDF_MUSTEDIT    16L     /* field must be edited                   */
#define FDF_UPDATE      32L     /* update existing data                   */
#define FDF_NOSELECT    64L     /* no auto-select of field upon focus     */
#define FDF_SPCFILL     128L    /* space-fill field from right            */
#define FDF_ZEROFILL    256L    /* zero-fill numeric field from left      */
#define FDF_BLNKZERO    512L    /* blank numeric field if equal to zero   */
#define FDF_BLNKNEZ     1024L   /* blank not equal zero (numeric field)   */
#define FDF_PHYSICAL    2048L   /* read/write data in physical format     */
#define FDF_UPPER       4096L   /* convert characters to UPPERCASE        */
#define FDF_LOWER       8192L   /* convert characters to lowercase        */
#define FDF_PROPER      16384L  /* convert characters to Proper Case      */
#define FDF_NUMERIC     32768L  /* standard numeric field                 */
#define FDF_CALCNUM     65536L  /* calculator-style numeric field         */
#define FDF_VKEYPRES    131072L /* perform validation after each keypress */
#define FDF_VLEAVFLD    262144L /* do validation when user leaves field   */
#define FDF_COMBO       524288L /* field belongs to a combo box           */

/*---------------------------------------------------------------------------*/

/* enable-link condition definitions */

#define ELC_BLANK       1L      /* field is blank                    */
#define ELC_ZERO        2L      /* field contains a zero value       */
#define ELC_EDITED      3L      /* field has been edited by the user */
#define ELC_CHECKED     4L      /* button is checked                 */

/*---------------------------------------------------------------------------*/

/* field data type definitions */

#define FDT_NULL        0       /* 'pdata' pointer == NULL      */
#define FDT_STRING      1       /* character string             */
#define FDT_SHORT       2       /* 16-bit signed integer        */
#define FDT_USHORT      3       /* 16-bit unsigned integer      */
#define FDT_INTEGER     4       /* signed integer               */
#define FDT_UNSIGNED    5       /* unsigned integer             */
#define FDT_LONG        6       /* 32-bit signed long integer   */
#define FDT_ULONG       7       /* 32-bit unsigned long integer */
#define FDT_FLOAT       8       /* single precision real number */
#define FDT_DOUBLE      9       /* double precision real number */

/*---------------------------------------------------------------------------*/

/* field date style definitions */

#define FDS_DEFAULT     0
#define FDS_MMDDYY      1
#define FDS_DDMMYY      2
#define FDS_YYMMDD      3

/*---------------------------------------------------------------------------*/

/* button feature definitions */

#define BTF_NONE        0L      /* no features specified                    */
#define BTF_CHECKED     1L      /* button is initially checked              */
#define BTF_GRAYED      2L      /* button is initially grayed               */
#define BTF_UPDATE      4L      /* button is initialize according to pdata  */
#define BTF_GENERIC     8L      /* button record holds generic control info */
#define BTF_IDOK        16L     /* button is the "OK" button                */
#define BTF_IDCANCEL    32L     /* button is the "Cancel" button            */

/*---------------------------------------------------------------------------*/

/* key status message definitions */

#define KSM_INSERT      0       /* Insert key status message    */
#define KSM_CAPSLOCK    1       /* CapsLock key status message  */
#define KSM_NUMLOCK     2       /* NumLock key status message   */

/*---------------------------------------------------------------------------*/

/* internal field error values (don't use these for your own error values) */

#define ERV_BLANK       27701   /* field is blank                       */
#define ERV_INCOMPL     27702   /* field is incomplete                  */
#define ERV_INVCHAR     27703   /* field contains invalid character(s)  */
#define ERV_NOTEDIT     27704   /* user tried to edit noneditable field */
#define ERV_UNEDITED    27705   /* field hasn't been edited             */
#define ERV_ZERO        27706   /* field has a value of zero            */

/*---------------------------------------------------------------------------*/

/* error event definitions */

#define ERE_KEYPRESS    1       /* a key was pressed                 */
#define ERE_LEAVEFLD    2       /* user attempted to leave the field */
#define ERE_SELECTOK    3       /* user attempted to select "OK"     */

/*---------------------------------------------------------------------------*/

/* definitions of WEDL handles */

typedef HANDLE  HFORM;          /* handle of a form record   */
typedef HANDLE  HFIELD;         /* handle of a field record  */
typedef HANDLE  HBUTTON;        /* handle of a button record */

/*---------------------------------------------------------------------------*/

/* function pointer definitions for error handling and validation functions */

typedef BOOL (CALLBACK *PERRFUNC) (HFORM,HFIELD,int,int,int);
typedef int (CALLBACK *PVALFUNC) (HFORM,HFIELD,LPSTR);

/*---------------------------------------------------------------------------*/

/* definition of a field record */

typedef struct {
    DWORD features;             /* field features                            */
    DWORD help_context;         /* help context ID of help topic for field   */
    LPSTR picture_string;       /* pointer to the field picture string       */
    LPVOID pdata;               /* pointer to data type to write/update      */
    PVALFUNC pvalid_func;       /* proc-instance address of validation func. */
    HWND hcombo;                /* handle of combo box field belongs to      */
    HWND hwnd;                  /* field's window handle                     */
    HFIELD hfield;              /* field's memory handle                     */
    HFIELD hnext_field;         /* handle of next field in linked list       */
    int ctrl_id;                /* dialog control ID of edit control         */
    int data_type;              /* data type pointed to by 'data' parameter  */
    int decimal_position;       /* virtual logical position of decimal point */
    int error_value;            /* unique error value                        */
    int logical_size;           /* logical size of field                     */
    int physical_size;          /* physical size of field                    */
    BOOL has_changed;           /* flag - "field has changed"                */
    DWORD field_ex;             /* additional field data                     */
} FIELD;

typedef FIELD *     PFIELD;
typedef FIELD FAR * LPFIELD;

/*---------------------------------------------------------------------------*/

/* field position information */

typedef struct {
    LPSTR ppicture_str_pos;     /* pointer to picture string position      */
    long selection;             /* selection                               */
    int logical_position;       /* logical position                        */
    int physical_position;      /* physical position                       */
    int val_char_occ;           /* validation character occurrence         */
    BOOL to_right_of_dec;       /* position is to the right of the decimal */
    char validation_char;       /* validation character for position       */
} FIELD_POS;

typedef FIELD_POS *     PFIELD_POS;
typedef FIELD_POS FAR * LPFIELD_POS;

/*---------------------------------------------------------------------------*/

/* definition of a form record */

typedef struct {
    DWORD features;             /* form features                            */
    PERRFUNC perror_func;       /* proc-instance address of error handler   */
    FARPROC pdialog_proc;       /* address of dialog box's window procedure */
    DWORD help_context;         /* default Windows Help context             */
    LPSTR capslock_offmsg;      /* pointer to CapsLock "off" status message */
    LPSTR capslock_onmsg;       /* pointer to CapsLock "on" status message  */
    LPSTR help_file_name;       /* help file name                           */
    LPSTR insert_offmsg;        /* pointer to Insert "off" status message   */
    LPSTR insert_onmsg;         /* pointer to Insert "on" status message    */
    LPSTR numlock_offmsg;       /* pointer to NumLock "off" status message  */
    LPSTR numlock_onmsg;        /* pointer to NumLock "on" status message   */
    long undo_selection;        /* undo selection                           */
    HANDLE hhead_elink;         /* handle of head enable-link record        */
    HANDLE hproc_array;         /* handle of window procedure array         */
    HANDLE hundo_buffer1;       /* handle of field undo buffer #1           */
    HANDLE hundo_buffer2;       /* handle of field undo buffer #2           */
    HWND hdlg;                  /* form's dialog box window handle          */
    HFORM hform;                /* form's memory handle                     */
    HFORM hnext_form;           /* handle of next form in linked list       */
    HFIELD hcurr_field;         /* handle of current node in field list     */
    HFIELD herror_field;        /* handle of field in error                 */
    HFIELD hhead_field;         /* handle of head node in field list        */
    HBUTTON hhead_button;       /* handle of head node in button list       */
    int cancel_id;              /* control ID of "Cancel" button            */
    int capslock_id;            /* control ID of CapsLock status message    */
    int error_event;            /* event which caused the error             */
    int error_position;         /* logical position of the error            */
    int error_value;            /* error value of field in error            */
    int insert_id;              /* control ID of Insert status message      */
    int numlock_id;             /* control ID of NumLock status message     */
    int num_controls;           /* number of defined controls in form       */
    int ok_id;                  /* control ID of "OK" button                */
    int undo_level;             /* undo level                               */
    BOOL edit_key_pressed;      /* flag - "an editing key was pressed"      */
    BOOL help_invoked;          /* flag - "Windows Help has been invoked"   */
    BOOL insert_mode;           /* flag - "insert mode on"                  */
    BOOL in_error_handler;      /* flag - "in field error handler"          */
    BOOL just_passed_dec;       /* flag - "just passed decimal point"       */
    BOOL pressed_cancel;        /* flag - "Cancel was pressed"              */
} FORM;

typedef FORM *     PFORM;
typedef FORM FAR * LPFORM;

/*---------------------------------------------------------------------------*/

/* definition of a button record */

typedef struct {
    DWORD features;             /* button features                          */
    DWORD help_context;         /* help context ID of help topic for button */
    LPINT pdata;                /* pointer to data to initialize/update     */
    HWND hwnd;                  /* button's window handle                   */
    HBUTTON hbutton;            /* handle of button's window                */
    HBUTTON hnext_button;       /* handle of next button in linked list     */
    int ctrl_id;                /* dialog control ID of button              */
    int group_id;               /* group affiliation ID                     */
    int off_value;              /* value stored at 'pdata' if not checked   */
    int on_value;               /* value stored at 'pdata' if checked       */
    BOOL has_changed;           /* flag - "button has changed"              */
} BUTTON;

typedef BUTTON *     PBUTTON;
typedef BUTTON FAR * LPBUTTON;

/*---------------------------------------------------------------------------*/

#if defined(__cplusplus)
    extern "C" {
#endif

/* button functions */

HBUTTON  WINAPI button_define( HFORM hform, int ctrl_id, LPINT pdata,
                               int group_id, int on_value, int off_value,
                               DWORD features, DWORD help_context );
int      WINAPI button_get_check( HBUTTON hbutton );
HBUTTON  WINAPI button_get_from_ctrl_id( HFORM hform, int ctrl_id );
HBUTTON  WINAPI button_get_from_group( HFORM hform, int group_id );
HBUTTON  WINAPI button_get_from_hwnd( HFORM hform, HWND hWnd );
HWND     WINAPI button_get_hwnd( HBUTTON hbutton );
BOOL     WINAPI button_has_changed( HBUTTON hbutton );
LPBUTTON WINAPI button_lock( HBUTTON hbutton );
int      WINAPI button_set_check( HBUTTON hbutton, int state );
void     WINAPI button_unlock( HBUTTON hbutton );

/*---------------------------------------------------------------------------*/

/* character manipulation functions */

BOOL WINAPI char_is_printable( int ch );
int  WINAPI char_to_lower( int ch );
int  WINAPI char_to_upper( int ch );

/*---------------------------------------------------------------------------*/

/* field functions */

int     WINAPI field_data_to_log( HFIELD hfield, LPSTR pbuf, LPVOID pdata,
                                  int data_type );
HFIELD  WINAPI field_define( HFORM hform, int ctrl_id, LPVOID pdata,
                             int data_type, LPSTR picture_string,
                             DWORD features, PVALFUNC pvalid_func,
                             int error_value, DWORD help_context );
int     WINAPI field_get_character( HFIELD hfield, int position,
                                    BOOL physical );
int     WINAPI field_get_ctrl_id( HFIELD hfield );
HFIELD  WINAPI field_get_from_ctrl_id( HFORM hform, int ctrl_id );
HFIELD  WINAPI field_get_from_hwnd( HFORM hform, HWND hWnd );
HWND    WINAPI field_get_hwnd( HFIELD hfield );
int     WINAPI field_get_pos_info( HFIELD hfield, int logical_position,
                                   LPFIELD_POS pfpos );
int     WINAPI field_get_position( HFIELD hfield, LPFIELD_POS pfpos );
int     WINAPI field_get_text( HFIELD hfield, LPSTR pbuf, BOOL physical );
BOOL    WINAPI field_has_changed( HFIELD hfield );
LPFIELD WINAPI field_lock( HFIELD hfield );
int     WINAPI field_log_to_data( HFIELD hfield, LPSTR pbuf, LPVOID pdata,
                                  int data_type );
int     WINAPI field_log_to_phys( HFIELD hfield, LPSTR pbuf );
int     WINAPI field_phys_to_log( HFIELD hfield, LPSTR pbuf );
int     WINAPI field_set_text( HFIELD hfield, LPSTR pbuf, BOOL physical );
void    WINAPI field_unlock( HFIELD hfield );

/*---------------------------------------------------------------------------*/

/* form functions */

HFORM  WINAPI form_begin( HWND hDlg, DWORD features, PERRFUNC perror_func );
int    WINAPI form_cancel( HFORM hform );
int    WINAPI form_end( HFORM hform );
BOOL   WINAPI form_exists( HFORM hform );
HFORM  WINAPI form_get_from_hdlg( HWND hDlg );
HWND   WINAPI form_get_hdlg( HFORM hform );
BOOL   WINAPI form_has_changed( HFORM hform );
BOOL   WINAPI form_in_error_cond( HFORM hform );
BOOL   WINAPI form_is_cancelled( HFORM hform );
int    WINAPI form_load( HFORM hform );
LPFORM WINAPI form_lock( HFORM hform );
int    WINAPI form_ok( HFORM hform );
int    WINAPI form_save( HFORM hform );
int    WINAPI form_set_enable_link( HFORM hform, HANDLE hcontrol,
                                    DWORD condition, int ctrl_id,
                                    BOOL enable );
int    WINAPI form_set_help( HFORM hform, LPSTR help_file_name,
                             DWORD help_context );
void   WINAPI form_unlock( HFORM hform );
HFIELD WINAPI form_validate( HFORM hform );

/*---------------------------------------------------------------------------*/

/* generic control functions */

HANDLE WINAPI generic_define( HFORM hform, int ctrl_id, DWORD help_context );

/*---------------------------------------------------------------------------*/

/* key status message functions */

int WINAPI keystat_define( HFORM hform, int ctrl_id, int which,
                           LPSTR onmsg, LPSTR offmsg );

/*---------------------------------------------------------------------------*/

/* string manipulation functions */

int  WINAPI str_delete_char( LPSTR pstr, int ch );
void WINAPI str_insert_char( LPSTR pstr, int ch, int offs );
BOOL WINAPI str_is_blank( LPSTR pstr );
BOOL WINAPI str_is_value_zero( LPSTR pstr );
void WINAPI str_trim_spaces( LPSTR pstr );

#if defined(__cplusplus)
    }
#endif

#endif  /* __WEDL_H */

