// ==============================================================
//  Listing 2 testapp.c - Simple test application for barcode dll
// ==============================================================

#define STRICT
#define WINVER  0x0300

#include <windows.h>
#include <string.h>
#include "barcode.h"

long FAR PASCAL WndProc (
    HWND    hwnd,
    UINT    message,
    WPARAM  wParam,
    LPARAM  lParam);

#pragma argsused
int PASCAL WinMain (
    HINSTANCE   hInstance,
    HINSTANCE   hPrevInstance,
    LPSTR       lpszCmdParam,
    int         nCmdShow)
// -------------
//  Main Program
// -------------
{
static char     szAppName[] = "TestApp";
HWND            hwnd ;
MSG             msg ;
WNDCLASS        wc ;

if (!hPrevInstance)
    {
    wc.style         = CS_HREDRAW | CS_VREDRAW ;
    wc.lpfnWndProc   = WndProc ;
    wc.cbClsExtra    = 0 ;
    wc.cbWndExtra    = 0 ;
    wc.hInstance     = hInstance ;
    wc.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
    wc.hbrBackground = GetStockObject (WHITE_BRUSH) ;
    wc.lpszMenuName  = NULL ;
    wc.lpszClassName = szAppName ;
    RegisterClass (&wc) ;
    }

hwnd = CreateWindow (
            szAppName, "Barcode Test Program", WS_OVERLAPPEDWINDOW,   
            CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,         
            NULL, NULL, hInstance, NULL) ;         

ShowWindow (hwnd, nCmdShow) ;
UpdateWindow (hwnd) ;

while (GetMessage (&msg, NULL, 0, 0))
     {
     TranslateMessage (&msg) ;
     DispatchMessage (&msg) ;
     }
return msg.wParam ;
}

long FAR PASCAL WndProc (
    HWND    hwnd,
    UINT    message,
    WPARAM  wParam,
    LPARAM  lParam)
// -------------
//  Main program
// -------------
{
HDC             hdc;
PAINTSTRUCT     ps;
static char
    sz [] = "Windows/DOS Developers Journal";

switch (message)
    {
    case WM_PAINT:
        hdc = BeginPaint (hwnd, &ps) ;
        SetMapMode (hdc, MM_HIENGLISH);
        SelectObject (hdc, GetStockObject (BLACK_BRUSH));
        BarCode (hdc, 500, -500, 80, 20, -500, sz);
        TextOut (hdc, 1250, -1000, sz, strlen (sz));
        EndPaint (hwnd, &ps) ;
        return 0 ;

    case WM_DESTROY:
        PostQuitMessage (0) ;
        return 0 ;
    }

return DefWindowProc (hwnd, message, wParam, lParam) ;
}
