/*------------------------------------------------
Listing 1 - HOST.C (Host program for toolbar demo)
------------------------------------------------*/

#include  <windows.h>
#include  "host.h"

/*-------------- GLOBAL VARIABLES ------------------*/
LONG textColor=RGB(255,0,0);
BOOL invert=FALSE;

/*--------------- WIN MAIN -------------------------*/
int PASCAL WinMain(HANDLE hInst, HANDLE hPrevInst,
        LPSTR lpCmdLine, int nCmdShow){
MSG       msg;
WNDCLASS  class;
HWND      hwnd;

  if(!hPrevInst){      /** Register window class **/
    class.style = NULL;
    class.lpfnWndProc = MainWndProc;
    class.cbClsExtra = 0;
    class.cbWndExtra = 0;
    class.hInstance = hInst;
    class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    class.hCursor = LoadCursor(NULL, IDC_ARROW);
    class.hbrBackground = GetStockObject(WHITE_BRUSH);
    class.lpszMenuName = "MainMenu";
    class.lpszClassName = "HostClass";
    RegisterClass(&class);
    }

  /**** Create the main window ****/
  hwnd=CreateWindow("HostClass", "Host Program",
    WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
    320, 400, NULL, NULL, hInst, NULL);

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);
  while (GetMessage(&msg, NULL, NULL, NULL)){
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
return (msg.wParam);
}

/*--------------- MainWndProc ----------------------*/
long FAR PASCAL MainWndProc(HWND hwnd, UINT message,
                    WPARAM wParam, LPARAM lParam){
void    print(HWND, char *);
extern  LONG            textColor;
extern  BOOL            invert;

  switch(message){

    case WM_COMMAND:                                                                                 /* MENU item */
    switch(wParam){

      case IDM_ABOUT:     /* Poor mans about box! */
        print(hwnd, "About the program....");
        MessageBox(NULL,"Toolbar Test","Msg",MB_OK);
        return 0;

      case IDM_EXIT:
        PostMessage(hwnd, WM_DESTROY, 0, 0L);
        break;

      case IDM_RED:
        textColor=RGB(255,0,0);
        print(hwnd, "RED text");
        return 0;

      case IDM_GREEN:
        textColor=RGB(0,128,0);
        print(hwnd, "GREEN text");
        return 0;

      case IDM_BLUE:
        textColor=RGB(0,0,255);
        print(hwnd, "BLUE text");
        return 0;

      case IDM_INV:       /* Toggle text mode */
        invert=(invert) ? FALSE : TRUE;
        if(invert)
          print(hwnd, "INVERTED text");
        else    print(hwnd, "REGULAR text");
        return 0;

      case IDM_CLEAR:      /* Send a NULL handle */
        print(hwnd, NULL); /* to clear the window*/
        return 0;

      case IDM_BEEP:       /* Sound the beeper */
        MessageBeep(0);
        print(hwnd, "Beep-Beep!");
        return 0;

      case IDM_TB_SHOW:    /* Create the toolbar */
        return 0;
    }
    break;

    case WM_DESTROY:
      PostQuitMessage(0);
      break;
}
return(DefWindowProc(hwnd, message, wParam, lParam));
}

/* Print a line of text and move cursor position */
void print(HWND hwnd, char *string){
HDC     hdc;
static  int   row=0;
extern  LONG  textColor;
extern  BOOL  invert;

  if(string==NULL){   /* Clear display if there */
     row=0;           /* is NO text to display  */
     REDRAW(hwnd);    /* Update the window.     */
     return;
     }

  hdc=GetDC(hwnd);    /* Get DC and Set Colors  */
  if(invert){
    SetTextColor(hdc, RGB(255,255,255));
    SetBkColor(hdc, textColor);
  } else  SetTextColor(hdc, textColor);

  /* Output the text and inc. row */
  TextOut(hdc,0,row,(LPSTR)string,lstrlen(string));
  row+=HIWORD(GetDialogBaseUnits());
  ReleaseDC(hwnd, hdc);
}
