
/* dyndlg.h */
/* defines and structs for Dynamic Dialog Box */

#ifndef DYNDLG_H
#define DYNDLG_H


#define ID_FNAME 3
#define IDM_OPEN 41
#define DYNM_CLOSE WM_USER+1
#define DYNM_ENTER WM_USER+2
#define DYNM_NEWFILE WM_USER+3

#define DLG_COUNT 5
#define MAX_STRING 80

#define PROP_DLGINFO "DLGINFO"
#define WINDOW_NAME "Dynamic Dialogs"



typedef struct{
		int   diiLength;
		int   diiPosition;  // in output
	      } DlgItemInfo;

typedef struct{
		GLOBALHANDLE dihDlgTmp;
		int diRecSize;
		DlgItemInfo diItems[1];
	      } DlgInfo;


// function prototypes

int Lookup(char far *key,char far *table[]);
GLOBALHANDLE NewDlgTemplate(DWORD Style,WORD X,WORD Y,
		WORD CX,WORD CY,LPSTR Menu,
		LPSTR Class,LPSTR Text,
		LPSTR TypeFace,WORD PointSize);
BOOL AddDlgItem(GLOBALHANDLE DlgTmp,DWORD Style,
		WORD X,WORD Y,WORD CX,WORD CY,
		LPSTR Class,LPSTR Text,BYTE DataLen,
		LPSTR Data,BYTE Type);
int TemplateSize(GLOBALHANDLE hDlgTmp);
GLOBALHANDLE ReadDialogDef(char *filename);
HWND OpenModelessDialog(char *filename);
int FindDlgBox(HWND hDlg);
LRESULT FAR PASCAL WndProc(HWND,UINT,WPARAM,LPARAM);
BOOL FAR PASCAL DialogProc(HWND,UINT,WPARAM,LPARAM);
BOOL FAR PASCAL FOpenProc(HWND,UINT,WPARAM,LPARAM);
BOOL  FAR PASCAL EnterProc(HWND hWnd,LPARAM Record);


extern DLGPROC lpDlgProc;
extern HINSTANCE hinstance;

// parser tables

enum {
    TYPE_UNUSED,TYPE_EDIT,TYPE_CHECKBOX,TYPE_LTEXT,
    TYPE_ENTERBUTTON,TYPE_NUMERIC,
    TYPE_NAME_COUNT};

#ifdef DEFINE_GLOBALS

char far *TypeNames[]={"UNUSED","EDIT","CHECKBOX",
		       "LTEXT","ENTERBUTTON",
		       "NUMERIC",NULL};

char far *ClassNames[]={"UNUSED","EDIT","BUTTON",
		"STATIC","BUTTON","EDIT"};

long FieldStyles[]={0,
		    WS_TABSTOP | WS_BORDER,
		    WS_TABSTOP | BS_AUTOCHECKBOX,
		    SS_LEFT,
		    BS_PUSHBUTTON | WS_TABSTOP,
		    WS_TABSTOP | WS_BORDER

		    };

#else
extern char far * TypeNames[];
extern char far *ClassNames[];
extern long FieldStyles[];

#endif

#endif
