/*dyndlg.c*/

#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#define STRICT
#define WINVER 0x3000
#include <windows.h>

#define DEFINE_GLOBALS
#include "dyndlg.h"
          

HWND hMainWnd;
HINSTANCE hInstanceGlobal;
HWND hDlgBox[DLG_COUNT];
DLGPROC lpDlgProc=NULL;
WNDENUMPROC lpEnterProc=NULL;
DLGPROC lpFOpnProc=NULL;




int PASCAL WinMain(HINSTANCE hInstance,
    HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{                           	
    MSG msg;
    int i,wTextExtent;
    WNDCLASS wndclass;
    char szClassName[]="DYNDLG";
    HDC hDC;
    hInstanceGlobal=hInstance;

    if(!hPrevInstance)
    {
	wndclass.style        =0;
	wndclass.lpfnWndProc  =(WNDPROC)WndProc;
	wndclass.cbClsExtra   =0;
	wndclass.cbWndExtra   =0;
	wndclass.hInstance    =hInstance;
	wndclass.hIcon        =LoadIcon(NULL,IDI_APPLICATION);
	wndclass.hCursor      =LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground=GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName =szClassName;
	wndclass.lpszClassName=szClassName;
	if(!RegisterClass(&wndclass))
      	    exit(1); 
    }

    hDC=GetDC(GetDesktopWindow());
    wTextExtent=LOWORD(GetTextExtent(hDC,WINDOW_NAME,strlen(WINDOW_NAME)))* 5 / 3;
    ReleaseDC(GetDesktopWindow(),hDC);

    hMainWnd=CreateWindow( szClassName,
	 WINDOW_NAME, WS_OVERLAPPED| WS_SYSMENU,
	 CW_USEDEFAULT,CW_USEDEFAULT,
	 wTextExtent + GetSystemMetrics(SM_CYCAPTION),
	 GetSystemMetrics(SM_CYCAPTION)+
	 GetSystemMetrics(SM_CYMENU)+
	 2*GetSystemMetrics(SM_CYBORDER),
	 NULL,NULL,hInstance,0 );

    if(!hMainWnd )
        exit( 2 ); 

    ShowWindow(hMainWnd,nCmdShow);

    lpEnterProc=(WNDENUMPROC)MakeProcInstance((FARPROC)EnterProc,hInstanceGlobal);
    lpDlgProc=(DLGPROC)MakeProcInstance((FARPROC)DialogProc,hInstanceGlobal);
    lpFOpnProc=(DLGPROC)MakeProcInstance((FARPROC)FOpenProc,hInstanceGlobal);


    while( GetMessage( &msg, NULL, 0, 0 ) )
    {
	for(i=0;i<DLG_COUNT;i++)
	{
	   if(!hDlgBox[i])
	       continue;
	   else
	       if(IsDialogMessage(hDlgBox[i],&msg))
		  break;
	}
	if(i==DLG_COUNT)
	{
	   TranslateMessage( &msg );
	   DispatchMessage( &msg );
	}
    }

    FreeProcInstance((FARPROC)lpEnterProc);
    FreeProcInstance((FARPROC)lpDlgProc);
    FreeProcInstance((FARPROC)lpFOpnProc);

    return msg.wParam;
}


// CallBack for dynamic dialogs
BOOL FAR PASCAL DialogProc(HWND hDlg,UINT Msg,
			WPARAM wParam,LPARAM lParam)
{
    int i,j;
    char buffer[MAX_STRING+1];

    switch(Msg)
    {
       case WM_INITDIALOG:
	  return TRUE; 
       case WM_COMMAND:
       {
	  switch(HIBYTE(wParam))
	  {
	     case TYPE_NUMERIC:
	     {
	        if(HIWORD(lParam)==EN_KILLFOCUS)
	        {
	           if(GetParent(GetFocus())==hDlg)
		   {
		      j=GetWindowText((HWND)LOWORD(lParam),buffer,MAX_STRING);
		      for(i=0;i<j;i++)
		      {
		         if(!isdigit(buffer[i]))
		            break; 
		      }
		      if(i<j)
		      {
		         MessageBox((HWND)LOWORD(lParam),"Must Be Numeric!",NULL,MB_OK);
		         SetFocus((HWND)LOWORD(lParam));
		      }
		   }
	        }
	        return TRUE;
	     }
	     case TYPE_ENTERBUTTON:
	     {
		SendMessage(hMainWnd,DYNM_ENTER,(WPARAM)hDlg,0);
	        return TRUE;
	     }
	     default:
	        return FALSE; 
	  }
       }
       case WM_SYSCOMMAND:
       {
	  if(wParam==SC_CLOSE)
	  {
	     SendMessage(hMainWnd,DYNM_CLOSE,(WPARAM)hDlg,0);
	     return TRUE;
	  }
	  return FALSE;
       }
       case WM_DESTROY:
       {
	  GlobalFree(RemoveProp(hDlg,PROP_DLGINFO));
	  return FALSE;
       }
       default:
	  return FALSE; 
    } 
}

// callback for EnumChildWindows()

BOOL FAR PASCAL EnterProc(HWND hWnd,LPARAM RecordParm)
{
     static HWND hDlg;
     static GLOBALHANDLE hDlgInfo;
     static DlgInfo far *lpDI;
     char str[80];
     int id,item,max_len,rec_len;
     DlgItemInfo far *lpDII;
     LPSTR Record=(LPSTR)RecordParm;

     rec_len=_fstrlen(Record);
     id=GetDlgCtrlID(hWnd);
     if((item=id&0xFF)==0)
     {
         hDlg=GetParent(hWnd);
         hDlgInfo=GetProp(hDlg,PROP_DLGINFO);
     }

     lpDI=GlobalLock(hDlgInfo);
     lpDII=(lpDI->diItems)+item;
     switch(id>>8)
     {
        case TYPE_EDIT:
        case TYPE_NUMERIC:
	{
	   GetWindowText(hWnd,str,79);
	   max_len=min(lpDII->diiLength,rec_len-
		     lpDII->diiPosition);
	   _fstrncpy((Record)+lpDII->diiPosition,
		  str,min(max_len,strlen(str)));
	   SetWindowText(hWnd,"");
	   break;
	}
        case TYPE_CHECKBOX:
        {
	   if(SendMessage(hWnd,BM_GETCHECK,0,0))
	   {
	      if(rec_len>lpDII->diiPosition)
	      {
		 Record[lpDII->diiPosition]=lpDII->diiLength;
		 SendMessage(hWnd,BM_SETCHECK,0,0);
	      }
	   }
	   break;
	}
        default:;
     }
     GlobalUnlock(hDlgInfo);
     return TRUE;
}

    // Callback for File Open dialog
BOOL FAR PASCAL FOpenProc(HWND hDlg,UINT Msg,
			    WPARAM wParam,LPARAM lParam)
{
    switch(Msg)
    {
       case WM_INITDIALOG:
	  return TRUE;
       case WM_COMMAND:
	  switch(wParam)
	  {
	     case IDOK:
	        SendMessage(hMainWnd,DYNM_NEWFILE,(WPARAM)hDlg,0);
	        EndDialog(hDlg,0);
	        return TRUE;
	     case IDCANCEL:
	        EndDialog(hDlg,0);
	        return TRUE;
	     default:
		;
	  }
       default:
	   ;
    }
    return 0;
}

LRESULT FAR PASCAL WndProc(HWND hWnd, UINT Msg,
			WPARAM wParam, LPARAM lParam)
{
    DlgInfo far * lpDlgInfo;
    GLOBALHANDLE hDlgInfo;
    int i;
    char filename[65];
    PSTR npszRecord;

    switch(Msg)
    {
       case DYNM_CLOSE:
       {
          i=FindDlgBox((HWND)wParam);
          DestroyWindow(hDlgBox[i]);
          hDlgBox[i]=0;
      	  return 0;
       }
       case DYNM_NEWFILE:
       {
          GetDlgItemText((HWND)wParam,ID_FNAME,filename,64);
          i=FindDlgBox(0);
          if(i!=DLG_COUNT)
             hDlgBox[i]=OpenModelessDialog(filename);
          else
             MessageBox(hWnd,"Too Many Dialog Boxes Open",NULL,MB_OK);
          return 0;
       }
       case DYNM_ENTER:
       {
          hDlgInfo=GetProp((HWND)wParam,PROP_DLGINFO);
	  lpDlgInfo=GlobalLock(hDlgInfo);
	  i=lpDlgInfo->diRecSize;
	  GlobalUnlock(hDlgInfo);
	  npszRecord=malloc(i+1);
	  if(NULL!=npszRecord)
	  {
	     *(((PSTR)(memset(npszRecord,' ',i)))+i)=0;
	     EnumChildWindows((HWND)wParam,lpEnterProc,(LPARAM)((LPSTR)npszRecord));
	     MessageBox((HWND)wParam,npszRecord,"Entered",MB_OK);
	     free(npszRecord);
	  }
	  SendMessage((HWND)wParam,WM_NEXTDLGCTL,0,0);
	  return 0;
       }
       case WM_COMMAND:
       {
          switch(wParam)
          { 
             default:
	     {
	        return DefWindowProc(hWnd,Msg,wParam,lParam);
	     }
             case IDM_OPEN:
	     {
	     DialogBox(hInstanceGlobal,"F_OPEN",hWnd,lpFOpnProc);
	     return 0;
	     }
          }
       }
       case WM_DESTROY:
       {
          for(i=0;i<DLG_COUNT;i++)
          { 
              if(hDlgBox[i])
		 DestroyWindow(hDlgBox[i]);
	  }
          PostQuitMessage(0);
          return 0;
       }
       default:
          return DefWindowProc(hWnd,Msg,wParam,lParam);
    }
}

// Opens dynamic modeless dialog box.
// returns handle or NULL on failure.
HWND OpenModelessDialog(char * filename)
{
    GLOBALHANDLE hDlgInfo;
    HWND hDlgBox=NULL;
    DlgInfo far * lpDlgInfo;
    LPSTR lpDlgTmp;

    if(NULL!=(hDlgInfo=ReadDialogDef(filename)))
    {
       lpDlgInfo=GlobalLock(hDlgInfo);
       lpDlgTmp=GlobalLock(lpDlgInfo->dihDlgTmp);
       hDlgBox=CreateDialogIndirect(hInstanceGlobal,lpDlgTmp,NULL,lpDlgProc);
       GlobalUnlock(lpDlgInfo->dihDlgTmp);
       GlobalFree(lpDlgInfo->dihDlgTmp);
       if(hDlgBox==NULL)
       {
	  farfree(lpDlgInfo);
	  return NULL;
       }
    }
    GlobalUnlock(hDlgInfo);
    SetProp(hDlgBox,PROP_DLGINFO,hDlgInfo);
    return hDlgBox;
}

// returns the index of the dialog box in hDlgBox[]
int FindDlgBox(HWND hDlg)
{
    int i;
    for(i=0;i<DLG_COUNT;i++)
    {
       if(hDlg==hDlgBox[i])
       break;
    }
    return i;
}
