/* bldtmp.c */

#include <string.h>
#define STRICT
#define WINVER 0x3000
#include <windows.h>
#include "dyndlg.h"


typedef struct{
		long  dtStyle;
		BYTE  dtItemCount;
		int   dtX;
		int   dtY;
		int   dtCX;
		int   dtCY;
	      } DlgTemplateHeader;

typedef struct{
		int   dtilX;
		int   dtilY;
		int   dtilCX;
		int   dtilCY;
		int   dtilID;
		long  dtilStyle;
	      }DlgItemTemplateHeader;


// Creates a dialog template. Returns
// NULL on failure.
GLOBALHANDLE NewDlgTemplate(DWORD Style,WORD X,WORD Y,
		WORD CX,WORD CY,LPSTR Menu,LPSTR Class,
		LPSTR Text,LPSTR TypeFace,WORD PtSize)
{
    DlgTemplateHeader far * lpDT;
    LPSTR lpsztemp;
    GLOBALHANDLE hDTemplate;
    long needed_size;

    needed_size=sizeof(DlgTemplateHeader)+
    lstrlen(Menu)+1+lstrlen(Class)+1+lstrlen(Text)+1;

    if(TypeFace[0])
        needed_size+=lstrlen(TypeFace)+1+sizeof(short);
    

    hDTemplate=GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT,
					    needed_size);
    if(hDTemplate==NULL)
       return hDTemplate;
     
    lpDT=GlobalLock(hDTemplate);

    lpDT->dtStyle=WS_VISIBLE | Style;
    lpDT->dtX=X;
    lpDT->dtY=Y;
    lpDT->dtCX=CX;
    lpDT->dtCY=CY;
     // here's where we copy in the variable length
     // elements
    lpsztemp=((LPSTR)lpDT)+sizeof(*lpDT);
    lpsztemp=_fmemccpy(lpsztemp,Menu,0,MAX_STRING+1);
    lpsztemp=_fmemccpy(lpsztemp,Class,0,MAX_STRING+1);
    lpsztemp=_fmemccpy(lpsztemp,Text,0,MAX_STRING+1);

    // if a Font was specified, build FontInfo
    if(TypeFace[0])
    {
       *((short far *)lpsztemp)=PtSize;
       _fmemccpy(lpsztemp+sizeof(short),TypeFace,0,
     					  MAX_STRING+1);
       lpDT->dtStyle|=DS_SETFONT;
    }

    GlobalUnlock(hDTemplate);

    return hDTemplate ;
}


// Adds a control to a dialog template. Returns
// FALSE if allocation fails.
BOOL
AddDlgItem(GLOBALHANDLE DlgTmp,DWORD Style,WORD X,
			WORD Y,WORD CX,WORD CY,
			LPSTR Class,LPSTR Text,
			BYTE DataLen,LPSTR Data,
			BYTE Type)
{
    DlgTemplateHeader far * lpDT;
    DlgItemTemplateHeader far *lpDIT;
    LPSTR lpsztemp;
    GLOBALHANDLE hDTemplate;
    unsigned new_size,BlockSize;

    BlockSize=TemplateSize(DlgTmp);

    new_size=BlockSize+sizeof(DlgItemTemplateHeader)+
		   lstrlen(Class)+1+lstrlen(Text)+1+1;

    // if DataLen is non-zero, reserve space for Data
    if(DataLen)
       new_size+=DataLen;
    

    hDTemplate=GlobalReAlloc(DlgTmp,new_size,
			  GMEM_ZEROINIT| GMEM_MOVEABLE);

    if(hDTemplate==NULL)
       return FALSE;
     

    lpDT=GlobalLock(hDTemplate);

    lpDIT=(DlgItemTemplateHeader far*)(((LPSTR)lpDT)+BlockSize);
    lpDIT->dtilX=X;
    lpDIT->dtilY=Y;
    lpDIT->dtilCX=min(CX,lpDT->dtCX);
    lpDIT->dtilCY=min(CY,lpDT->dtCY);
     // Control ID combines index and
     // Field type so DialogProc
     // will know how to handle control
    lpDIT->dtilID=lpDT->dtItemCount | (Type<<8);
    lpDIT->dtilStyle=WS_VISIBLE | WS_CHILD | Style;
    lpsztemp=(char far*)(lpDIT)+sizeof(*lpDIT);
    lpsztemp=_fmemccpy(lpsztemp,Class,0,MAX_STRING+1);
    lpsztemp=_fmemccpy(lpsztemp,Text,0,MAX_STRING+1);
    if(DataLen)
       _fmemcpy(lpsztemp,Data,DataLen);
    
    lpDT->dtItemCount++;

    GlobalUnlock(hDTemplate);

    return TRUE;
}

// Scans a dialog box template and returns
// its length
int TemplateSize(GLOBALHANDLE hDlgTmp)
{
    DlgTemplateHeader far * lpDT;
    // DlgItemTemplateHeader far *lpDIT;
    LPSTR lpstr,lpbase;
    int isize;
    int i;
    // first scan the DLGTEMPLATE
    lpDT=(DlgTemplateHeader far *)GlobalLock(hDlgTmp);
    lpbase=(LPSTR)lpDT;
    lpstr=(LPSTR)(lpDT+1);
    isize=sizeof(*lpDT);
    lpstr=lpbase+(isize+=(lstrlen(lpstr)+1));// Menu[]
    lpstr=lpbase+(isize+=(lstrlen(lpstr)+1));// Class[]
    lpstr=lpbase+(isize+=(lstrlen(lpstr)+1));// Caption[]
    // if necessary, the FONTINFO
    if((lpDT->dtStyle)&DS_SETFONT)
    {
       isize+=sizeof(short);
       lpstr+=sizeof(short);
       lpstr=lpbase+(isize+=(lstrlen(lpstr)+1));
    }
       // finally, each of the DLGITEMTEMPLATEs
       for(i=0;i<lpDT->dtItemCount;i++)
       {
          lpstr=lpbase+(isize+=sizeof(DlgItemTemplateHeader));
	  lpstr=lpbase+(isize+=(lstrlen(lpstr)+1));// Class[]
	  lpstr=lpbase+(isize+=(lstrlen(lpstr)+1));// Text[]
	  if(*lpstr) // i.e. if DataLen is non zero
	  {
	     isize+=*lpstr;
	     lpstr+=*lpstr;
	  }
	  isize++;
       }
    GlobalUnlock(hDlgTmp);
    return isize;
}
