/* intrprtr.c */

#define STRICT
#define WINVER 0x3000
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "dyndlg.h"

// accepts a filename and reads a definition into
// a DialogTemplate. Returns handle or NULL on error
GLOBALHANDLE ReadDialogDef(char *filename)
{
    int i=0;
    WORD wX,wY,wCX,wCY,wItemCount,wFieldType,
	 wPosition,wLength;
    char str1[MAX_STRING+1],str2[MAX_STRING+1];
    char buffer[200];
    GLOBALHANDLE hInfo=NULL;
    DlgInfo far* lpInfo=NULL;
    FILE *file;
    long lStyle;

    do
    {
       if(NULL==(file=fopen(filename,"r")))
	  break;

       fgets(buffer,199,file);
       if(8!=sscanf(buffer,"%7s%80s%d%d%d%d%d%d",str1,
		  str2,&wX,&wY,&wCX,&wCY,
		  &wLength,&wItemCount))
          break; 


       if(NULL==(hInfo=GlobalAlloc(GMEM_MOVEABLE |
		   GMEM_ZEROINIT, sizeof(DlgInfo)+
		   ((wItemCount-1)*sizeof(DlgItemInfo)))))
          break; 

       lpInfo=GlobalLock(hInfo);

       if(_fstrcmp(str1,"DIALOG"))
          break;

       if(!strcmp(str2,"\"\""))
          str2[0]=0; 

       lStyle=WS_SYSMENU | WS_CAPTION | WS_VISIBLE | WS_OVERLAPPED;

       lpInfo->diRecSize=wLength;

       if(NULL==(lpInfo->dihDlgTmp=NewDlgTemplate(lStyle,wX,wY,
			   wCX,wCY,"","",str2,"",0)))

          break; 


       for(i=0;i<wItemCount;i++)
       {
	  if(NULL==fgets(buffer,200,file))
	     break;
	  if(8!=sscanf(buffer,"%80s%80s%d%d%d%d%d%d",str1,
	      str2,&wX,&wY,&wCX,&wCY,&wLength,&wPosition))
	  {
	     i--;
	     continue;
	  }
	  if(!strcmp(str2,"\"\""))
	     str2[0]=0;
	  wFieldType=Lookup(str1,TypeNames);
	  if(wFieldType>TYPE_NAME_COUNT-1)
	  {
	     i--;
	     continue;
	  }
	  lStyle=FieldStyles[wFieldType];
	  if(!AddDlgItem(lpInfo->dihDlgTmp,lStyle,wX,wY,
			wCX,wCY,ClassNames[wFieldType],
			str2,0,NULL,wFieldType))
	  {
	     i--;
	     continue;
	  }

	  lpInfo->diItems[i].diiLength=wLength;
	  lpInfo->diItems[i].diiPosition=wPosition;

       }
    }
    while(0);

    if(file)
       fclose(file);

    if(hInfo)
       GlobalUnlock(hInfo);
     
    return hInfo;
}

// finds match for string in table or
// returns index or -1 on failure
int Lookup(char far *key,char far *table[])
{
    int i;
    for(i=0;table[i]!=NULL;i++)
    {
       if(!_fstrcmp(key,table[i]))
          return i;
    }
    return -1;
}
