#include <windows.h>
#include <string.h>

#define STRICT

BOOL CALLBACK FindThisNotePad (
    HWND    hwnd,
    LPARAM  lParam)
// ------------------------------------------
//  Look for a particular instance of notepad
// ------------------------------------------
{
if (GetWindowWord (hwnd, GWW_HINSTANCE)
                        == LOWORD (lParam))
    {
    *((HWND *) HIWORD (lParam)) = hwnd;
    return (0);
    }
return (1);
}

BOOL CALLBACK FindEdit (
    HWND    hwnd,
    LPARAM  lParam)
// -------------------------------------
//  Look for the edit control of notepad
// -------------------------------------
{
char    sz [80];

GetClassName (hwnd, sz, sizeof (sz));
if (strcmp (sz, "Edit") == 0)
    {
    *((HWND *) HIWORD (lParam)) = hwnd;
    return (0);
    }
return (1);
}

BOOL Note (
    LPSTR   lp)
// ---------------------------------
//  Launch the notepad and configure 
// ---------------------------------
{
int         iTab;
TEXTMETRIC  tm;
HDC         hdc;
HINSTANCE   h;
char        sz [80];
HWND        hwndEdit,
            hwndNote;

//  Execute notepad but hide the window
wsprintf (sz, "notepad.exe %s", lp);
h = WinExec (sz, SW_HIDE);
if (h < 32) return (FALSE);

//  Find the current notepad
hwndNote = NULL;
EnumWindows ((WNDENUMPROC) FindThisNotePad,
            MAKELONG (h, &hwndNote));
if (hwndNote == NULL) return (FALSE);

//  Find the main edit control of current notepad
hwndEdit = NULL;
EnumChildWindows (hwndNote, (WNDENUMPROC) FindEdit,
                    MAKELONG (0, &hwndEdit));
if (hwndEdit == NULL) return (FALSE);

//  Change the tab stops to 4 spaces instead of 8
hdc = GetDC (hwndEdit);
GetTextMetrics (hdc, &tm);
ReleaseDC (hwndEdit, hdc);
iTab = (tm.tmAveCharWidth * 16) / 
                LOWORD (GetDialogBaseUnits ());
SendMessage (hwndEdit, EM_SETTABSTOPS, 1,
                (LPARAM) (int far *) &iTab);

//  Show the window maximized
ShowWindow (hwndNote, SW_SHOWMAXIMIZED);
return (TRUE);
}

#pragma argsused
int PASCAL WinMain (
    HINSTANCE   hInstance,
    HINSTANCE   hPrevInstance,
    LPSTR       lpCmdLine,
    int         nCmdShow)
// -------------------------------------------
//  Main program.  Call the new note function.
//  Use a beep to show an error condition.
// -------------------------------------------
{
if (!Note (lpCmdLine)) MessageBeep (0);
return (0);
}
