#ifndef WDBaseIncluded
#define WDBaseIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#define S4FOX
//#define S4DEBUG

#include <d4all.h>
  // codebase stuff - if you don't have CodeBase, don't compile WDBASE.C
#include <WStr.h>
#include <WTime.h>
#include <WVec.h>

String40 DateToDbase(const Date&);
Date     DbaseToDate(const char*);

void DBaseAutoOpen(Bool OnOff);  // turn the index "auto-open" feature on and off

class Field
  {
      F4FIELD* F;
    public:
      Field(F4FIELD* FF){F=FF;}
      void operator=(const char* St){f4assign(F,(char*)St);}
      void Assign(const char* St){f4assign(F,(char*)St);}
      operator const char*(){return f4str(F);}
      operator String() {return String(f4str(F));}
      String St() {return String(f4str(F));}

      void operator=(double D){f4assign_double(F,D);}
      void Assign(double D){f4assign_double(F,D);}
      operator double(){return f4double(F);}
      double D(){return f4double(F);}

      void operator=(int I){f4assign_int(F,I);}
      void Assign(int I){f4assign_int(F,I);}
      operator int(){return f4int(F);}
      int I(){return f4int(F);}

      void operator=(long L){f4assign_long(F,L);}
      void Assign(long L){f4assign_long(F,L);}
      operator long(){return f4long(F);}
      long L(){return f4long(F);}

      // void operator=(Bool B){f4assign_char(F,(B?'T':'F'));}
      void AssignBool(Bool B){f4assign_char(F,(B?'T':'F'));}
      // operator Bool(){return f4true(F);}
      Bool B(){return f4true(F);}

      void operator=(const Date& D){f4assign(F,(char*)(const char*)DateToDbase(D));}
      void Assign(const Date& D){f4assign(F,(char*)(const char*)DateToDbase(D));}
      operator Date(){return DbaseToDate(f4str(F));}
      //Date D(){return DbaseToDate(f4str(F));}

      void Blank(){f4blank(F);}
      const char* Name(){return f4name(F);}
      int Len(){return f4len(F);}
  };

typedef F4FIELD* FieldStar;

CreateAtomicVectorClass(DBaseFieldVector,FieldStar);

class DBase
  {
      D4DATA* D;  //  points to the data CodeBase keeps on this database
      DBaseFieldVector V;
      Bool Closed;
    public:
      DBase(const char* FileName);
      ~DBase()                              {Close();}
      operator D4DATA*(){return D;}
      void Close();
      void Top()                            {d4top(D);}
      void Bottom()                         {d4bottom(D);}
      Bool bof()                            {return (d4bof(D)!=0);}
      Bool eof()                            {return (d4eof(D)!=0);}
        // "EOF" (vs. "eof") will not work due to conflict with ANSI lib "EOF"
      void Delete()                         {d4delete(D);}
      Bool Deleted()                        {return d4deleted(D);}
      long RecNum()                         {return d4recno(D);}
      void GetRec(long R)                   {d4go(D,R);}
      Field F(const char* FieldName)        {return d4field(D,(char*)FieldName);}
      Field F(int FieldNum)                 {return V(FieldNum);}
      int FieldNum(const char* FieldName)   {return d4field_number(D,(char*)FieldName);}
      int NumFields()                       {return d4num_fields(D);}
      long NumRecs()                        {return d4reccount(D);}
      int Seek(const char* SearchText)      {return d4seek(D,(char*)SearchText);}
      int Seek(long SearchVal)         {return d4seek(D,(char*)(const char*)Str(SearchVal));}
      Bool Skip(long Num=1)                 {return (d4skip(D,Num)==0);}
      void SetIndexTag(const char* TagName);
      void SetDefaultTag() {d4tag_default(D);}
      void AppendBlank() {d4append_blank(D);}
      void AppendStart(Bool UseMemo=True) {d4append_start(D,UseMemo);}
      void Blank(){d4blank(D);}
      double Percent() {return d4position(D);}
      void Flush(){d4flush_record(D);}
      void FlushAll(){d4flush_all(D);}  // flushes indexes too
      T4TAG* Tag(const char* TagName=NULL);
        // if NULL is passed, the default is used
  };

class DBaseTag
  {
      T4TAG* T;
    public:
      DBaseTag(DBase& DB,const char* Tag=NULL){T=DB.Tag(Tag);}
      Bool Top()                            {return (t4top(T)==0);}
      void Bottom()                         {t4bottom(T);}
      Bool eof()                            {return (t4eof(T)!=0);}
      long Skip(long Num=1)                 {return t4skip(T,Num);}
        // returns number skipped (note that eof is weird with Skip)
      double Percent()                      {return t4position(T);}
      long RecNum()                         {return t4recno(T);}
      int Seek(const char* SearchText)      {return t4seek(T,(char*)SearchText,strlen(SearchText));}
      int Seek(long SearchVal)         {return t4seek(T,&SearchVal,4);}
  };

// internal use only
CreateRefVectorClass(CDBFVector,F4FIELD_INFO);
CreateRefVectorClass(CDBTVector,T4TAG_INFO);

extern const char* NotDeleted; // =".NOT. DELETED()";

const int DBAscending=0;
const int DBDescending=r4descending;

class CreateDBaseFile // a DBase file is created and closed
  {
      CDBFVector FV;
      CDBTVector TV;
      String120 Name;
    public:
      CreateDBaseFile(const char* FileName){Name=FileName;}
      ~CreateDBaseFile(){Done();}
      void DefineField(const char* FieldName,char Type='C',int Width=20,int Decimals=0);
      void DefineTag(const char* TagName, const char* KeyExpression,
          const char* FilterExpression=NotDeleted, int Unique=0, int Descending=0);
      void Done();
  };

class CreateDBaseIndex
  {
      DBase* DB;
      CDBTVector TV;
      String120 Name;
      Bool Finished;
    public:
      CreateDBaseIndex(DBase& D,const char* IndexFileName=NULL);
      ~CreateDBaseIndex(){Done();}
      void DefineTag(const char* TagName, const char* KeyExpression,
          const char* FilterExpression=NotDeleted, int Unique=0, int Descending=0);
      void Done();
        // deletes IndexFileName (if it exists) and creates an index.
        // re-indexes on all tags.  sets active index to the first tag given
  };

void CreateADBaseIndex(DBase& DB,const char* IndexFileName,const char* TagName,
    const char* KeyExpression,const char* FilterExpression=NotDeleted,
    int Unique=0,int Descending=0);
  // deletes IndexFileName (if it exists) and creates an index.
  // re-indexes.  sets active index to TagName

#endif
