// =========================================================================
//
//      WRKDLG.CPP
//
//      STANDARD base dialog for all controls
//
// =========================================================================


#if !defined(__OWL_STATIC_H)
  #include      <owl\static.h>
#endif

#if !defined(__OWL_EDIT_H)
  #include      <owl\edit.h>
#endif

#if !defined(__OWL_CHECKBOX_H)
  #include      <owl\checkbox.h>
#endif

#include "sctrl.h"
#include "wctrl.rh"


// Construct the dialog

TWrkDialog::TWrkDialog( TWindow* parent, TResId id, RWCTLSTYLE& style, LPFNSTRTOID strtoid, LPFNIDTOSTR idtostr, TModule* module )
  : TDialog( parent, id, module ),
    lpfnStrToId( strtoid ),
    lpfnIdToStr( idtostr ),
    Style( style )
{
  EdName     = new TEdit( this, ID_EDNAME );
  EdCaption  = new TEdit( this, ID_EDCAPTION );
  StIdValue  = new TStatic( this, ID_STIDVALUE );
  CkBorder   = NULL;
  CkDisabled = NULL;
  CkGroup    = NULL;
  CkHScroll  = NULL;
  CkTabStop  = NULL;
  CkVisible  = NULL;
  CkVScroll  = NULL;
}


// Close it and transfer the identifier

BOOL TWrkDialog::CanClose()
{
  char s[81];
  EdName->GetText( s, sizeof(s) );
  LONG L = (*lpfnStrToId)(s);
  if( L )
    {
      Style.wId = HIWORD( L );
      return TRUE;
    }

  return FALSE;
}


// Init data and transfer when CmOK

void TWrkDialog::TransferData( TTransferDirection direction )
{
  switch( direction )
    {
      case tdSetData:   // Style -> Dialog
        {
          // Object's ID
          char s[81];
          (*lpfnIdToStr)( Style.wId, s, sizeof(s) );

          // Name and Caption
          EdName->SetText( s );
          EdCaption->SetText( Style.szTitle );

          // ID in a decimal form
          itoa( Style.wId, s, 10 );
          StIdValue->SetText( s );

          // Standard checkboxes
          if( CkBorder   ) CkBorder->SetCheck  ( Style.dwStyle & WS_BORDER   ? BF_CHECKED : BF_UNCHECKED );
          if( CkDisabled ) CkDisabled->SetCheck( Style.dwStyle & WS_DISABLED ? BF_CHECKED : BF_UNCHECKED );
          if( CkGroup    ) CkGroup->SetCheck   ( Style.dwStyle & WS_GROUP    ? BF_CHECKED : BF_UNCHECKED );
          if( CkHScroll  ) CkHScroll->SetCheck ( Style.dwStyle & WS_HSCROLL  ? BF_CHECKED : BF_UNCHECKED );
          if( CkTabStop  ) CkTabStop->SetCheck ( Style.dwStyle & WS_TABSTOP  ? BF_CHECKED : BF_UNCHECKED );
          if( CkVisible  ) CkVisible->SetCheck ( Style.dwStyle & WS_VISIBLE  ? BF_CHECKED : BF_UNCHECKED );
          if( CkVScroll  ) CkVScroll->SetCheck ( Style.dwStyle & WS_VSCROLL  ? BF_CHECKED : BF_UNCHECKED );
        }

      case tdGetData:   // Dialog -> Style
        {
          // Control caption
          EdCaption->GetText( Style.szTitle, CTLTITLE );

          // Standard checkboxes
          DWORD Mask = 0, Flags = 0;
          if( CkBorder   ) { Mask |= WS_BORDER;   if( CkBorder->GetCheck()   == BF_CHECKED ) Flags |= WS_BORDER; }
          if( CkDisabled ) { Mask |= WS_DISABLED; if( CkDisabled->GetCheck() == BF_CHECKED ) Flags |= WS_DISABLED; }
          if( CkGroup    ) { Mask |= WS_GROUP;    if( CkGroup->GetCheck()    == BF_CHECKED ) Flags |= WS_GROUP; }
          if( CkHScroll  ) { Mask |= WS_HSCROLL;  if( CkHScroll->GetCheck()  == BF_CHECKED ) Flags |= WS_HSCROLL; }
          if( CkTabStop  ) { Mask |= WS_TABSTOP;  if( CkTabStop->GetCheck()  == BF_CHECKED ) Flags |= WS_TABSTOP; }
          if( CkVisible  ) { Mask |= WS_VISIBLE;  if( CkVisible->GetCheck()  == BF_CHECKED ) Flags |= WS_VISIBLE; }
          if( CkVScroll  ) { Mask |= WS_VSCROLL;  if( CkVScroll->GetCheck()  == BF_CHECKED ) Flags |= WS_VSCROLL; }
          Style.dwStyle &= ~Mask;
          Style.dwStyle |= Flags;
        }
    }
}

