// =========================================================================
//
//	WRKCTRL.CPP
//
//	Gestion des contrles au sens Workshop
//
// =========================================================================


#include	"sctrl.h"
#include	"wctrl.rh"

#ifndef __SDIALOG_H
  #include "sdialog.h"
#endif



// Register all the control classes

TModule* TWrkRegister::DLLModule = NULL;

void RegisterWorkshop( TModule& module )
{
  TWrkRegister::DLLModule = &module;

  // Call window to do the job
  for( TWrkRegister* pReg=TWrkRegister::FirstItem; pReg; pReg=pReg->NextItem )
    pReg->RegisterControl( module );
}


// --- Dynamic creation of a control ----------------------------------------

static TModule WrkModule( "WrkAlias", FALSE );

// Create the C++ parent, if not already exist (for Workshop)

TWindow* CreateParent( HWND hWnd, TModule* module )
{
  // Is the parent already exist ?
  TWindow* Parent = GetWindowPtr( GetParent(hWnd) );

  // No, create it
  if( Parent == NULL )
  {
    Parent = new TWindow( ::GetParent(hWnd), module );
  }

  return Parent;
}


// Is the mother window from Workshop

static BOOL IsWorkshopWindow( HWND hWnd )
{
  HWND hParent;
  char szClassName[81];

  hParent = hWnd;
  do
    {
      hWnd = hParent;
      hParent = GetParent( hWnd );
    }
  while( hParent );

  GetClassName( hWnd, szClassName, sizeof(szClassName) );
  return (strcmpi( szClassName, "rwswnd" ) == 0 );
}


// Search for the Recorder struct of a control

static TWrkRegister* GetRegister( HWND hWnd )
{
  // get the class name
  char szClassName[81];
  GetClassName( hWnd, szClassName, sizeof(szClassName) );

  // Find the record struct
  return TWrkRegister::lookup( szClassName );
}


// Create a C++ control with a HWND parameter. The good class has to be found

static TControl* CreateControlObject( TWindow* parent, HWND hWnd, TWrkRegister*& pReg )
{
  // get the record struct for this control
  pReg = GetRegister( hWnd );
  if( pReg )
    {
      // get the ID
      WORD Id  = GetWindowWord( hWnd, GWW_ID );

      // and create it
      if( parent )
	return pReg->Create( parent, Id, NULL );
      else
	return pReg->Create( CreateParent(hWnd, &WrkModule ), Id, &WrkModule );
    }

  // The control is not registered. Perhaps fatal error will hunt your next nights !
  return NULL;
}


// prototype for OWL proc
LRESULT FAR PASCAL _export InitWndProc( HWND, UINT, WPARAM, LPARAM );


// My new WindowProc for initialing a instance of a C++ Window
// The first message *must be* WM_NCCREATE

static char StaticParams[ 255 ];
LRESULT CALLBACK _export OwlWorkshopProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
  PRECONDITION( message == WM_NCCREATE );
  CREATESTRUCT& CS = *(LPCREATESTRUCT)lParam;

  // OK. We can't access DlgCreationWindow from OWL because of _OWLDATA has
  // no meaning in Win16
  // So, I have my own Dialog class which use it's own static variable
  // To be proper, export a GetDlgCreationWindow() from OWL.DLL
  TDialog* OWLDialog = SDialog::DlgCreationWindow;

  // If the parent is a dialog box,
  if( OWLDialog && (OWLDialog->HWindow==GetParent(hWnd) || OWLDialog->HWindow==0) )
    {
      // Fix the HWindow of the parent
      if( OWLDialog->HWindow == 0 ) OWLDialog->HWindow = GetParent(hWnd);

      // Does the C++ control already exist ?
      TWindow* Ctrl = OWLDialog->ChildWithId( GetWindowWord( hWnd, GWW_ID ) );
      if( Ctrl == NULL )
	{
          // No create it if it's a user register class.
	  TWrkRegister* pReg;
	  Ctrl = CreateControlObject( OWLDialog, hWnd, pReg );
	  if( Ctrl )
	    {
              // Ensure the value of CreateParams, for CTLDATA field
	      if( CS.lpCreateParams == NULL )
	        {
                  // Default params, if it's null
	          CS.lpCreateParams = StaticParams;
	          pReg->InitialParam( StaticParams );
	        }

	      //
	      // install "DefWindowProc" as the window function BEFORE we request the
	      // subclassings; otherwise it looks like we subclassed "InitWndProc"
	      //
	      Ctrl->HWindow = hWnd;
	      Ctrl->DefaultProc = pReg->GetDefaultProc();

	      //
	      // Get the thunk
	      //
	      WNDPROC thunk = Ctrl->GetThunk();
	      SetWindowLong(hWnd, GWL_WNDPROC, DWORD(thunk));
	      LRESULT result = (*(WNDPROC)(thunk))(hWnd, message, wParam, lParam);

              // Fill the control members
	      Ctrl->GetWindowTextTitle();
	      Ctrl->GetHWndState();

              return result;
	    }

          // Impossible situation
          // Let's go to the crash
	  MessageBox( 0, "CRASH CRASH CRASH...", "C++ Control not created", MB_OK | MB_TASKMODAL );
	  return 0;
	}
      else
	{
          // Find the control register struct
	  TWrkRegister* pReg = GetRegister( hWnd );

          // The object is already in the dialog list. Just make the link with Window
	  Ctrl->HWindow = hWnd;
	  Ctrl->DefaultProc = pReg->GetDefaultProc();
	  WNDPROC thunk = Ctrl->GetThunk();
	  SetWindowLong(hWnd, GWL_WNDPROC, DWORD(thunk));
	  LRESULT result = (*(WNDPROC)(thunk))(hWnd, message, wParam, lParam);

          // Fill the control members
	  Ctrl->GetWindowTextTitle();
	  Ctrl->GetHWndState();

	  return result;
	}
    }

  // It's not a Dialog. Is it from Workshop ?
  if( IsWorkshopWindow( hWnd ) )
    {
      // Create a alias module for it
      if( WrkModule.GetInstance() == NULL )
	{
	  WrkModule.InitModule( (HINSTANCE)GetWindowWord( hWnd, GWW_HINSTANCE ), "" );
	}

      // And create C++ control
      TWrkRegister* pReg;
      TControl* Ctrl = CreateControlObject( NULL, hWnd, pReg );
      if( Ctrl )
	{
	  if( CS.lpCreateParams == NULL )
	    {
	      CS.lpCreateParams = StaticParams;
	      pReg->InitialParam( StaticParams );
	    }

	  //
	  // install "DefWindowProc" as the window function BEFORE we request the
	  // subclassings; otherwise it looks like we subclassed "InitWndProc"
	  //
	  Ctrl->HWindow = hWnd;
	  Ctrl->DefaultProc = pReg->GetDefaultProc();

	  //
	  // Get the thunk
	  //
	  WNDPROC thunk = Ctrl->GetThunk();
	  SetWindowLong(hWnd, GWL_WNDPROC, DWORD(thunk));

	  LRESULT result = (*(WNDPROC)(thunk))(hWnd, message, wParam, lParam);

	  Ctrl->GetWindowTextTitle();
	  Ctrl->GetHWndState();

          // The control is created by workshop. Indicate it.
	  Ctrl->SetFlag( wfFromWorkshop );

          return result;
	}

      // Impossible situation
      // Let's go to the crash
      MessageBox( 0, "CRASH CRASH CRASH...", "C++ Control not created", MB_OK | MB_TASKMODAL );
      return 0;
    }

  // Standard window ? Do the default JOB
  return ::CallWindowProc(InitWndProc, hWnd, message, wParam, lParam );
}


// --- TWrkRegister --------------------------------------------------------

// Workshop proc
LPFNLOADRES TWrkRegister::fnLoad = NULL;
LPFNEDITRES TWrkRegister::fnEdit = NULL;

// Internal list of registered controls
int	      TWrkRegister::nItem     = 0;
TWrkRegister* TWrkRegister::FirstItem = NULL;


// Find a specific class
TWrkRegister* TWrkRegister::lookup( const char* classname )
{
  for( TWrkRegister* pReg=FirstItem; pReg; pReg=pReg->NextItem )
    if( strcmpi( classname, pReg->GetClassName() ) == 0 )
      return pReg;

  return NULL;
}



TWrkRegister::TWrkRegister( LPFNINFO fninfo, LPFNSTYLE fnstyle, LPFNFLAGS fnflags )
{
  // save the caracteristics
  fnInfo  = fninfo;
  fnStyle = fnstyle;
  fnFlags = fnflags;

  // insert into the list
  NextItem  = FirstItem;
  FirstItem = this;
  nItem++;
}


TWrkRegister::~TWrkRegister( )
{
}


// Standard WindowClass

void TWrkRegister::GetWindowClass( WNDCLASS& wndclass, TModule& module ) const
{
  wndclass.cbClsExtra		= 0;
  wndclass.cbWndExtra		= 0;
  wndclass.hInstance		= module;
  wndclass.hIcon		= NULL;
  wndclass.hCursor		= LoadCursor(0, IDC_ARROW);
  wndclass.hbrBackground	= (HBRUSH)(COLOR_WINDOW + 1);
  wndclass.lpszMenuName		= NULL;
  wndclass.lpszClassName	= GetClassName();
  wndclass.style		= CS_HREDRAW | CS_VREDRAW | CS_GLOBALCLASS | CS_DBLCLKS;
  wndclass.lpfnWndProc 		= OwlWorkshopProc;
}

WNDPROC	TWrkRegister::GetDefaultProc() const
{
  return ::DefWindowProc;
}

int TWrkRegister::GetExtraParam( ) const
{
  return 0;
}

void TWrkRegister::InitialParam( char* param ) const
{
  memset( param, 0, GetExtraParam() );
}

void TWrkRegister::GetControlDef( TControlDef& def ) const
{
  def.Title	= GetClassName();
  def.hBitmap	= NULL;
  def.Version	= 1;
  def.Width	= 60;
  def.Height	= 20;
  def.Style	= WS_CHILD;
  def.MenuDescr = GetClassName();
  def.hDropCurs = NULL;
}

BOOL TWrkRegister::GetFlags( DWORD, LPSTR lpBuff, UINT )
{
  lpBuff[0] = 0;
  return TRUE;
}

BOOL TWrkRegister::ExecDialog( TWindow* parent, LPRWCTLSTYLE, LPFNSTRTOID, LPFNIDTOSTR )
{
  PRECONDITION( parent != NULL );
  parent->MessageBox( "No dialog defined", GetClassName(), MB_OK );
  return FALSE;
}


// Internal functions

HGLOBAL	TWrkRegister::RWInfo ( )
{
  HGLOBAL hInfo = GlobalAlloc( GHND, sizeof(RWCTLINFO) );
  if( hInfo )
    {
      LPRWCTLINFO Info = (LPRWCTLINFO)GlobalLock( hInfo );

      TControlDef Def;
      GetControlDef( Def );

      Info->wVersion  = Def.Version;
      Info->wCtlTypes = 1;
      strcpy( Info->szClass, GetClassName() );
      strcpy( Info->szTitle, Def.Title );
      Info->Type[0].wType     = 1;
      Info->Type[0].wWidth    = Def.Width;
      Info->Type[0].wHeight   = Def.Height;
      Info->Type[0].dwStyle   = Def.Style;
      strcpy( Info->Type[0].szDescr, Def.MenuDescr );
      Info->Type[0].hToolBit  = Def.hBitmap;
      Info->Type[0].hDropCurs = Def.hDropCurs;

      GlobalUnlock( hInfo );
      return hInfo;
    }

  return NULL;
}


BOOL TWrkRegister::RWStyle( HWND hWnd, HGLOBAL hCtlStyle, LPFNSTRTOID lpfnStrToId, LPFNIDTOSTR lpfnIdToStr )
{
  HWND hFocus = GetFocus();

  LPRWCTLSTYLE Style = (LPRWCTLSTYLE)GlobalLock( hCtlStyle );

  TWindow* parent = GetWindowPtr( hWnd );
  if( parent == NULL )
    parent = new TWindow( hWnd, &WrkModule );

  BOOL result = ExecDialog( parent, Style, lpfnStrToId, lpfnIdToStr );

  GlobalUnlock( hCtlStyle );
  if( hFocus )
    SetFocus( hFocus );

  return result;
}


UINT TWrkRegister::RWFlags( DWORD dwStyle, LPSTR lpBuff, UINT wBuffLength )
{
  return GetFlags( dwStyle, lpBuff, wBuffLength  );
}


BOOL TWrkRegister::RegisterControl( TModule& module )
{
  WNDCLASS WindowClass;

  if ( !GetClassInfo( 0, GetClassName(), &WindowClass) &&
       !GetClassInfo( module, GetClassName(),
	&WindowClass) )
    {
      GetWindowClass(WindowClass,module);
      return RegisterClass(&WindowClass);
    }

  return TRUE;
}


// === Workshop interface ==================================================
//
// =========================================================================


// Compose the style list

extern "C" HGLOBAL CALLBACK _export ListClasses( LPSTR szAppClass, UINT /*wVersion*/, LPFNLOADRES fnLoad, LPFNEDITRES fnEdit )
{
  TWrkRegister::fnLoad = fnLoad;
  TWrkRegister::fnEdit = fnEdit;

  if( strcmpi( szAppClass, "rwswnd" ) == 0 )
    {
      HGLOBAL hClasses = GlobalAlloc( GHND, sizeof(CTLCLASSLIST) + sizeof(RWCTLCLASS)*TWrkRegister::nItem );
      if( hClasses )
	{
	  LPCTLCLASSLIST Classes = (LPCTLCLASSLIST)GlobalLock(hClasses);
	  Classes->nClasses = TWrkRegister::nItem;

	  TWrkRegister* pReg = TWrkRegister::FirstItem;
	  for( int i=0; i<TWrkRegister::nItem; i++, pReg=pReg->NextItem )
	    {
	      Classes->Classes[i].fnRWInfo  = pReg->fnInfo;
	      Classes->Classes[i].fnRWStyle = pReg->fnStyle;
	      Classes->Classes[i].fnFlags   = pReg->fnFlags;
	      lstrcpy( Classes->Classes[i].szClass, pReg->GetClassName() );
	    }

	  GlobalUnlock( hClasses );
	  return hClasses;
	}
    }

  return NULL;
}

