// =========================================================================
//
//	SDIALOG.H
//
//	Base class for all dialogs.
//
// =========================================================================


#ifndef	__SDIALOG_H
#define	__SDIALOG_H

//// includes
#ifndef __OWL_DIALOG_H
  #include <owl\dialog.h>
#endif

class _OWLCLASS TControl;
class _OWLCLASS TEdit;
class _OWLCLASS TComboBox;
class _OWLCLASS TListBox;
class _OWLCLASS TScrollBar;
class _OWLCLASS TButton;
class _OWLCLASS TCheckBox;
class _OWLCLASS TRadioButton;
class _OWLCLASS TGroupBox;
class _OWLCLASS TStatic;



// --- Dialogue standard de la plateforme ----------------------------------
//
// -------------------------------------------------------------------------

class SDialog : public TDialog {

  public:
    static SDialog* DlgCreationWindow;	// SDialog en cours de cration

  protected:
    // Cration d'un dialogue
    // ----------------------
    virtual HWND DoCreate();
    virtual int  DoExecute();

    // Initialisation du dialogue et cration des enfants
    // --------------------------------------------------
    virtual void SetupWindow();

  public:
    // Constructeurs et destructeur
    // ----------------------------
    SDialog( TWindow* parent, TResId resId, TModule* module = 0 );

    // Accs aux contrles crs automatiquement
    // -----------------------------------------
    TControl*	  Control	( UINT id ) const;
    TEdit*	  Edit		( UINT id ) const;
    TComboBox*	  ComboBox 	( UINT id ) const;
    TListBox*	  ListBox	( UINT id ) const;
    TScrollBar*	  ScrollBar	( UINT id ) const;
    TButton*	  Button	( UINT id ) const;
    TCheckBox*	  CheckBox	( UINT id ) const;
    TRadioButton* RadioButton	( UINT id ) const;
    TGroupBox*    GroupBox	( UINT id ) const;
    TStatic*	  Static	( UINT id ) const;
};


#endif	// __SDIALOG
