// =========================================================================
//
//	SCTRL.H
//
//	User control for Resource Workshop
//
// =========================================================================


#ifndef __SCTRL_H
#define __SCTRL_H

//// includes
#ifndef	__SDIALOG_H
  #include	"sdialog.h"
#endif

#ifndef	__OWL_CONTROL_H
  #include	<owl\control.h>
#endif

#ifndef	__OWL_EDIT_H
  #include	<owl\edit.h>
#endif

#ifndef	__OWL_CHECKBOX_H
  #include	<owl\checkbox.h>
#endif

#ifndef __CUSTCNTL_H
  #include	<custcntl.h>
#endif


// You must call this function in the LibMain of th DLL
void RegisterWorkshop( TModule& module );

// New initialisation function, in replacement of InitWndProc()
LRESULT CALLBACK _export OwlWorkshopProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );


// --- Classe for registering a new control --------------------------------
//
// -------------------------------------------------------------------------

class TWrkRegister {

  public:
    // --- These methods can be overloaded ---------------------------------

    // Structure for control's properties
    struct TControlDef {
      LPCSTR		Title;		// Title
      HBITMAP		hBitmap;	// Bitmap for Workshop's toolbox
      UINT		Version;	// Control's version
      UINT		Width;		// Width suggested by default
      UINT		Height;		// Height suggested by default
      DWORD		Style;		// Creation window style
      LPCSTR		MenuDescr;	// String for help
      HCURSOR		hDropCurs;	// Cursor for Drag/Drop
    };

    // Dfinining the class of the window
    virtual LPSTR	GetClassName( ) const=0;
    virtual void       	GetWindowClass( WNDCLASS&, TModule& module ) const;

    // Get th default proc. For subclassing standard controls
    virtual WNDPROC	GetDefaultProc() const;

    // Create a new instance of the control
    virtual TControl*  	Create( TWindow* parent, int id, TModule* module=0 ) =0;

    // Defining the control's parameters for Workwhop
    virtual void	GetControlDef( TControlDef& def ) const;

    // Access the CTL_DATA field
    virtual int	       	GetExtraParam( ) const;	    		// 0
    virtual void       	InitialParam( char* param ) const;	// 0 Filled

    // Call the definition dialog
    virtual BOOL	ExecDialog( TWindow* parent, LPRWCTLSTYLE style, LPFNSTRTOID lpfnStrToId, LPFNIDTOSTR lpfnIdToStr );

    // Convert a style DWORD into a String
    virtual BOOL	GetFlags( DWORD dwStyle, LPSTR lpBuff, UINT wBuffLength );


    // --- Internal methods ------------------------------------------------

    // Module wrapper for RegisterWorkShop()
    static TModule* 		DLLModule;

    // Workshop's functions
    static LPFNLOADRES		fnLoad;
    static LPFNEDITRES		fnEdit;

    // Managing the internal list of registered classes
    static int		 nItem;		// Number of control
    static TWrkRegister* FirstItem;	// First item
	   TWrkRegister* NextItem;	// Next one
    static TWrkRegister* lookup( const char* classname ); // Find a class

    // Function for Workshop
    LPFNINFO		fnInfo;
    LPFNSTYLE		fnStyle;
    LPFNFLAGS		fnFlags;

    // Internal method for Workshop's messages
    HGLOBAL		RWInfo ( );
    BOOL		RWStyle( HWND hWnd, HGLOBAL hCtlStyle, LPFNSTRTOID lpfnStrToId, LPFNIDTOSTR lpfnIdToStr );
    UINT		RWFlags( DWORD dwStyle, LPSTR lpBuff, UINT wBuffLength );

    // Register the class for Windows
    BOOL		RegisterControl( TModule& module );

  public:
    // Constructor & destructor
    TWrkRegister( LPFNINFO fninfo, LPFNSTYLE fnstyle, LPFNFLAGS fnflags );
    ~TWrkRegister();
};


// --- Macro for registering a class ---------------------------------------
//
// -------------------------------------------------------------------------

#define	wfFromWorkshop		((TWindowFlag)0x1000)

#define	DECLARE_WORKSHOP      			\
  virtual LPSTR  GetClassName();		\
  virtual void   GetWindowClass( WNDCLASS& )


#define DEFINE_WORKSHOP(cls,creg)							\
  HGLOBAL CALLBACK _export cls##Info( );						\
  BOOL    CALLBACK _export cls##Style( HWND, HGLOBAL, LPFNSTRTOID, LPFNIDTOSTR );	\
  UINT    CALLBACK _export cls##Flags( DWORD, LPSTR, UINT );                     	\
  creg cls##Reg( cls##Info, cls##Style, cls##Flags );					\
  HGLOBAL CALLBACK _export cls##Info( )							\
      {											\
	return cls##Reg.RWInfo(); 							\
      }											\
  BOOL CALLBACK _export cls##Style( HWND a, HGLOBAL b, LPFNSTRTOID c, LPFNIDTOSTR d)	\
      {											\
	return cls##Reg.RWStyle( a, b, c, d );						\
      }											\
  UINT CALLBACK _export cls##Flags( DWORD a, LPSTR b, UINT c )                          \
      {                                                                                 \
	return cls##Reg.RWFlags( a, b, c );                                             \
      }                                                                                 \
  LPSTR cls::GetClassName( )		                                                \
      {                                                                                 \
	return cls##Reg.GetClassName();                                                 \
      }                                                                                 \
  void cls::GetWindowClass( WNDCLASS& a )                                               \
      {                                                                                 \
	cls##Reg.GetWindowClass(a, *GetModule() );                                      \
      }



// --- Standard dialog class -----------------------------------------------
//
// -------------------------------------------------------------------------

class TWrkDialog : public TDialog {

  protected:
    RWCTLSTYLE&		Style;
    LPFNIDTOSTR		lpfnIdToStr;
    LPFNSTRTOID		lpfnStrToId;

    // Edit for name, label and id
    TEdit*		EdName;
    TEdit*		EdCaption;
    TStatic*		StIdValue;

    // Checkbox for style
    TCheckBox*		CkBorder;	// WS_BORDER
    TCheckBox*		CkDisabled;	// WS_DISABLED
    TCheckBox*		CkGroup;	// WS_GROUP
    TCheckBox*		CkHScroll;	// WS_HSCROLL
    TCheckBox*		CkTabStop;	// WS_TABSTOP
    TCheckBox*		CkVisible;	// WS_VISIBLE
    TCheckBox*		CkVScroll;	// WS_VSCROLL

    // Closing and transfering
    virtual BOOL	CanClose();
    virtual void 	TransferData( TTransferDirection direction );

  public:
    // Constructor & destructor
    TWrkDialog( TWindow* parent, TResId id, RWCTLSTYLE& style, LPFNSTRTOID strtoid, LPFNIDTOSTR idtostr, TModule* module );
};



#endif	// __SCTRL_H
