// =========================================================================
//
//      GAUGE.CPP
//
// =========================================================================

#if !defined(__OWL_CHECKBOX_H)
  #include  <owl\checkbox.h>
#endif

#ifndef __SCTRL_H
  #include      "sctrl.h"
#endif

#ifndef __GAUGE_H
  #include      "gauge.h"
#endif

#include	"wctrl.rh"

extern TModule* DLLModule;

// --- Dialog box for Workshop --------------------------------------------
//
// ------------------------------------------------------------------------

class SGaugeDlg : public TWrkDialog {

    TCheckBox*  CkHorizontal;

    virtual void        TransferData( TTransferDirection direction );

  public:
    SGaugeDlg( TWindow* parent, RWCTLSTYLE& style, LPFNSTRTOID strtoid, LPFNIDTOSTR idtostr, TModule* module=0 );
};


SGaugeDlg::SGaugeDlg( TWindow* parent, RWCTLSTYLE& style, LPFNSTRTOID strtoid, LPFNIDTOSTR idtostr, TModule* module )
  : TWrkDialog( parent, DLG_GAUGE, style, strtoid, idtostr, module )
{
  // Standard CheckBoxes
  CkVisible  = new TCheckBox( this, ID_CKVISIBLE, 0 );
  CkDisabled = new TCheckBox( this, ID_CKDISABLED, 0 );
  CkBorder   = new TCheckBox( this, ID_CKBORDER, 0 );

  // Spcialized CheckBoxes
  CkHorizontal  = new TCheckBox( this, ID_CKHORIZONTAL, 0 );
}


void SGaugeDlg::TransferData( TTransferDirection direction )
{
  TWrkDialog::TransferData( direction );

  switch( direction )
    {
      case tdSetData:   // Style -> Dialog
        {
          CkHorizontal->SetCheck( (Style.dwStyle & GAS_HORIZONTAL) ? BF_CHECKED : BF_UNCHECKED );
        }

      case tdGetData:   // Dialog -> Style
        {
          Style.dwStyle &= ~( GAS_HORIZONTAL );
          if( CkHorizontal->GetCheck()  == BF_CHECKED ) Style.dwStyle |= GAS_HORIZONTAL;
        }
    }
}



// --- Register the gauge control --------------------------------------
//
// ------------------------------------------------------------------------

class SWrkGauge : public TWrkRegister {

  public:
    // Classe name
    virtual LPSTR       GetClassName( ) const;

    // Default control creating
    virtual TControl*   Create( TWindow* parent, int id, TModule* module=0 );

    // Access to ControlDef paramters
    virtual void        GetControlDef( TControlDef& def ) const;

    // Call the spcialized DialogBox
    virtual BOOL        ExecDialog( TWindow* parent, LPRWCTLSTYLE style, LPFNSTRTOID lpfnStrToId, LPFNIDTOSTR lpfnIdToStr );

  public:
    SWrkGauge( LPFNINFO fninfo, LPFNSTYLE fnstyle, LPFNFLAGS fnflags );
};

DEFINE_WORKSHOP( SGauge, SWrkGauge );


LPSTR SWrkGauge::GetClassName( ) const
{
  return "SGauge";
}


// Create a default gauge

TControl* SWrkGauge::Create( TWindow* parent, int id, TModule* module )
{
  TControl* Gauge = new SGauge( parent, id, 0, module );

  return Gauge;
}


// Fill the Workshop Structure

void SWrkGauge::GetControlDef( TControlDef& def ) const
{
  TWrkRegister::GetControlDef( def );

  def.Title     = "%d%%";
  def.Style     = WS_CHILD | WS_VISIBLE | GAS_HORIZONTAL;
  def.Width     = 200 | 0x8000;
  def.Height    = 150 | 0x8000;
  def.hBitmap   = LoadBitmap( *DLLModule, MAKEINTRESOURCE( BMP_GAUGE ) );
  def.hDropCurs = LoadCursor( *DLLModule, MAKEINTRESOURCE( CUR_GAUGE ));
}


// Call the dialog

BOOL SWrkGauge::ExecDialog( TWindow* parent, LPRWCTLSTYLE style, LPFNSTRTOID lpfnStrToId, LPFNIDTOSTR lpfnIdToStr )
{
  SGaugeDlg dlg( parent, *style, lpfnStrToId, lpfnIdToStr, DLLModule );
  if( dlg.Execute() == IDOK )
    return TRUE;

  return FALSE;
}


// Register the gauge

SWrkGauge::SWrkGauge( LPFNINFO fninfo, LPFNSTYLE fnstyle, LPFNFLAGS fnflags )
  : TWrkRegister( fninfo, fnstyle, fnflags )
{
}



// --- Gauge classe -------------------------------------------------------
//
// ------------------------------------------------------------------------

DEFINE_RESPONSE_TABLE1( SGauge, TGauge )
  EV_WM_NCCREATE,
END_RESPONSE_TABLE;


SGauge::SGauge( TWindow* parent, int resId, const char far* title, int x, int y, int w, int h, int margin, TModule* module )
  : TGauge( parent, title, resId, x, y, w, h, TRUE, margin, module )
{
  Attr.Style &= ~WS_BORDER;
}

// There is no constructor for a gauge in a resource script !
// simulate it and do the job your self
 
SGauge::SGauge( TWindow* parent, int resId, int margin, TModule* module )
  : TGauge( parent, 0, resId, 0, 0, 0, 0, TRUE, margin, module )
{
  // if parent is a dialog, it's must be a SDialog
  if( dynamic_cast<TDialog*>(parent) )
    if( dynamic_cast<SDialog*>(parent) == 0 )
      {
        throw xmsg( "SGauge must have a parent of class SDialog" );
      }

  if (HIWORD(Title))
    delete Title;     // Free memory allocated by TWindow's constructor
  Title = 0;

  SetFlag(wfFromResource);
  memset(&Attr, 0x0, sizeof(Attr));
  Attr.Id = resId;
  EnableTransfer();
}


void SGauge::SetupWindow()
{
  TGauge::SetupWindow();

  // Init a default gauge when created from Workshop
  if( IsFlagSet( wfFromWorkshop ) )
    {
      SetRange( 0, 100 );
      SetValue( 50 );
    }
}


BOOL SGauge::EvNCCreate( CREATESTRUCT& createStruct )
{
  // IsHorizontal comes from a Windows flags.
  IsHorizontal = (createStruct.style & GAS_HORIZONTAL) != 0;

  return TGauge::EvNCCreate( createStruct );
}

