// =========================================================================
//
//	SDIALOG.CPP
//
//	Base class for all dialogs.
//
// =========================================================================

#ifndef __OWL_EDIT_H
  #include <owl\edit.h>
#endif

#ifndef __OWL_COMBOBOX_H
  #include <owl\combobox.h>
#endif

#ifndef __OWL_LISTBOX_H
  #include <owl\listbox.h>
#endif

#ifndef __OWL_SCROLLBAR_H
  #include <owl\scrollbar.h>
#endif

#ifndef __OWL_BUTTON_H
  #include <owl\button.h>
#endif

#ifndef __OWL_CHECKBOX_H
  #include <owl\checkbox.h>
#endif

#ifndef __OWL_RADIOBUT_H
  #include <owl\radiobut.h>
#endif

#ifndef __OWL_GROUPBOX_H
  #include <owl\groupbox.h>
#endif

#ifndef __OWL_STATIC_H
  #include <owl\static.h>
#endif

#ifndef __SDIALOG_H
  #include "sdialog.h"
#endif



// It works only with Win3.1. No tests have been executed with Win32 & AppWare
// ---------------------------------------------------------------------------
#if !(defined _Window) && !(OWLVersion==0x0200)
  #error SDialog is only for Windows with OWL2.0
#endif


// Because standard CreationDialog is not accessible, we have to duplicate the code
// Thank's to export a function instead of _OWLDATA, mister Borland.
SDialog* SDialog::DlgCreationWindow = 0;



SDialog::SDialog( TWindow* parent, TResId resId, TModule* module  )
  : TDialog( parent, resId, module )
{
}


// Cast all the controls
// These cast are not inline because it needs to include the corresponding .h
// So, do it only in this file

TControl* SDialog::Control( UINT id ) const
{ return dynamic_cast<TControl*>(ChildWithId(id)); }

TEdit* SDialog::Edit( UINT id ) const
{ return dynamic_cast<TEdit*>(ChildWithId(id)); }

TComboBox* SDialog::ComboBox( UINT id ) const
{ return dynamic_cast<TComboBox*>(ChildWithId(id)); }

TListBox* SDialog::ListBox( UINT id ) const
{ return dynamic_cast<TListBox*>(ChildWithId(id)); }

TScrollBar* SDialog::ScrollBar( UINT id ) const
{ return dynamic_cast<TScrollBar*>(ChildWithId(id)); }

TButton* SDialog::Button( UINT id ) const
{ return dynamic_cast<TButton*>(ChildWithId(id)); }

TCheckBox* SDialog::CheckBox( UINT id ) const
{ return dynamic_cast<TCheckBox*>(ChildWithId(id)); }

TRadioButton* SDialog::RadioButton( UINT id ) const
{ return dynamic_cast<TRadioButton*>(ChildWithId(id)); }

TGroupBox* SDialog::GroupBox( UINT id ) const
{ return dynamic_cast<TGroupBox*>(ChildWithId(id)); }

TStatic* SDialog::Static( UINT id ) const
{ return dynamic_cast<TStatic*>(ChildWithId(id)); }



// Dialog creation
// These function are redefined to set DlgCreationWindow

HWND SDialog::DoCreate()
{
  SDialog* dlgCreation = DlgCreationWindow;
  DlgCreationWindow = this;
    HWND hWnd = TDialog::DoCreate();
  DlgCreationWindow = dlgCreation;
  return hWnd;
}

int SDialog::DoExecute()
{
  SDialog* dlgCreation = DlgCreationWindow;
  DlgCreationWindow = this;
    int result = TDialog::DoExecute();
  DlgCreationWindow = dlgCreation;
  return result;
}



// CALLBACK for child enumeration

BOOL CALLBACK _export EnumControl( HWND hWndChild, LPARAM LParam_Dialog )
{
  // Get the parent Dialog
  TDialog* Dialog = (TDialog*)LParam_Dialog;

  // Use only the direct childs !
  if( GetParent(hWndChild) != Dialog->HWindow )
      return TRUE;

  // Get the control if it is already created
  int idd = GetWindowWord( hWndChild, GWW_ID );
  TControl* Control = dynamic_cast<TControl*>(Dialog->ChildWithId( idd ));

  // The procedure works only for control with a positive ID
  // --> statics with ID==-1 are not handled
  if( idd > 0 )
    {
      if( Control == 0 )
	{
          // Get the control class
	  char cName[ 64 ];
	  GetClassName(hWndChild, cName, 64 );

	  // Edit creation
	  if( strcmpi( cName, "EDIT" ) == 0 )
	      Control = new TEdit( Dialog, idd, 0 );

	  // Button creation
	  else if( strcmpi( cName, "BUTTON" ) == 0 )
	    {
	      long style = ::GetWindowLong( hWndChild, GWL_STYLE ) & 0x000F;
              switch( int(style) )
                {
	          case BS_GROUPBOX:
                      Control = new TGroupBox( Dialog, idd );
                      break;
	          case BS_RADIOBUTTON:
                  case BS_AUTORADIOBUTTON:
		      Control = new TRadioButton( Dialog, idd );
                      break;
	          case BS_CHECKBOX:
                  case BS_AUTOCHECKBOX:
                  case BS_3STATE:
                  case BS_AUTO3STATE:
		      Control = new TCheckBox( Dialog, idd );
                      break;
	          default:
		       Control = new TButton( Dialog, idd );
                       break;
                }
	    }

          // BWCC's controls creation
	  else if( strcmpi( cName, "BORBTN" ) == 0 )
	      Control = new TButton( Dialog, idd );
	  else if( strcmpi( cName, "BORRADIO" ) == 0 )
	      Control = new TRadioButton( Dialog, idd );
	  else if( strcmpi( cName, "BORCHECK" ) == 0 )
	      Control = new TCheckBox( Dialog, idd );
//	  else if( strcmpi( cName, "BORSHADE" ) == 0 )
//	      Control = new TCheckBox( Dialog, idd );

	  // Listbox creation
	  else if( strcmpi( cName, "LISTBOX" ) == 0 )
	      Control = new TListBox( Dialog, idd );

	  // Combobox creation
	  else if( strcmpi( cName, "COMBOBOX" ) == 0 )
	      Control = new TComboBox( Dialog, idd );

	  // ScrollBar creation
	  else if( strcmpi( cName, "SCROLLBAR" ) == 0 )
	      Control = new TScrollBar( Dialog, idd );

	  // Static creation
	  else if( strcmpi( cName, "STATIC" ) == 0 )
	      Control = new TStatic( Dialog, idd );
	  else if( strcmpi( cName, "BORSTATIC" ) == 0 )
	      Control = new TStatic( Dialog, idd );

	  // Cannot create the control. Send a WARN to dbwin
          // This is not a normal situation
	  else
	    {
	      TRACE( "Cannot create Control in SDialog, class " << cName );
	    }

	  // Set the predefined flag
	  if( Control ) Control->SetFlag(wfPredefinedClass);
	}
      else
	{
          // Set the HWindow of an already created control to 0, to be compatible
          // with the thunk mecanism of OWL
          // This is the case of all controls created in Workshop
	  if( Control->HWindow && (idd > 0) )
	    {
	      Control->HWindow = 0;
	    }
	}
    }

  return TRUE;
}


// Create all the childs

void SDialog::SetupWindow()
{
  TProcInstance EnumProc( (FARPROC)EnumControl );
  EnumChildWindows( HWindow, (WNDENUMPROC)(FARPROC)EnumProc, (LPARAM)this )  ;

  // Do the normal setup.
  TDialog::SetupWindow();
}

