//          Warp Communications Library
//          Copyright (C) 1991 Trevor Bell, All Rights Reserved

#include <conio.h>
#include <stdio.h>
#include <process.h>
#include "warpcomm.h"

int main (void)
{
    char ch = 0, ch2 = 0;

    clrscr ();
    cputs ("A simple terminal program for the Warp Communications Library (Ctrl-C to exit)\r\n");
    cputs ("Copyright (C) 1991 Trevor Bell, All Rights Reserved\r\n\n");

    com_open (0, 2400, 4, 0x3F8, 2000, 2000);
    /* opens com port 1 at 2400 baud, IRQ 4, base address 3F8 (hex) with
     2000 byte transmit and receive buffers */

    send_modem_string (0, "ATZ|");
    /* initializes the modem */


    while (ch != 3) {
        if (kbhit ()) {            /* check the keyboard for a keypress */
            ch = getch ();         /* get the keypress */
            com_out_char (0, ch);     /* send the keypress to the modem */
        }
        if (char_waiting (0)) {
            /* check to see if the modem has a character waiting */

            ch2 = com_get_char (0); /* get the character from the com port */
            putch (ch2);           /* print the character on the screen */
        }
    }
    com_close (0);                  /* close the com port */
    exit (0);                      /* exit with errorlevel 0 */
}
